/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeFactory;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.Lexeme;
import uk.ac.manchester.cs.jfact.kernel.NameCreator;
import uk.ac.manchester.cs.jfact.kernel.NameSet;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.Taxonomy;
import uk.ac.manchester.cs.jfact.kernel.TaxonomyCreator;
import uk.ac.manchester.cs.jfact.kernel.Token;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;

@PortedFrom(file="RoleMaster.h", name="RoleMaster")
public class RoleMaster
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="RoleMaster.h", name="newRoleId")
    private int newRoleId = 1;
    @PortedFrom(file="RoleMaster.h", name="Roles")
    private final List<Role> roles = new ArrayList<Role>();
    @PortedFrom(file="RoleMaster.h", name="emptyRole")
    private final Role emptyRole;
    @PortedFrom(file="RoleMaster.h", name="universalRole")
    private final Role universalRole;
    @PortedFrom(file="RoleMaster.h", name="roleNS")
    private final NameSet<Role, IRI> roleNS;
    @PortedFrom(file="RoleMaster.h", name="pTax")
    private final Taxonomy pTax;
    @PortedFrom(file="RoleMaster.h", name="DJRolesA")
    private final List<Role> disjointRolesA = new ArrayList<Role>();
    @PortedFrom(file="RoleMaster.h", name="DJRolesB")
    private final List<Role> disjointRolesB = new ArrayList<Role>();
    @PortedFrom(file="RoleMaster.h", name="DataRoles")
    private final boolean dataRoles;
    @PortedFrom(file="RoleMaster.h", name="useUndefinedNames")
    private boolean useUndefinedNames;
    @Original
    private static final int firstRoleIndex = 2;

    @PortedFrom(file="RoleMaster.h", name="registerRole")
    private void registerRole(Role r) {
        assert (r != null && r.getInverse() == null);
        assert (r.getId() == 0);
        if (this.dataRoles) {
            r.setDataRole(true);
        }
        this.roles.add(r);
        r.setId(this.newRoleId);
        Role ri = new Role(IRI.create((String)("-" + r.getName())));
        r.setInverse(ri);
        ri.setInverse(r);
        this.roles.add(ri);
        ri.setId(-this.newRoleId);
        ++this.newRoleId;
    }

    @PortedFrom(file="RoleMaster.h", name="isRegisteredRole")
    private boolean isRegisteredRole(NamedEntry p) {
        if (!(p instanceof Role)) {
            return false;
        }
        Role R = (Role)p;
        int ind = R.getAbsoluteIndex();
        return ind >= 2 && ind < this.roles.size() && this.roles.get(ind).equals(p);
    }

    @PortedFrom(file="RoleMaster.h", name="size")
    public int size() {
        return this.roles.size() / 2 - 1;
    }

    public RoleMaster(boolean d, IRI TopRoleName, IRI BotRoleName, JFactReasonerConfiguration c) {
        this.emptyRole = new Role(BotRoleName);
        this.universalRole = new Role(TopRoleName);
        this.roleNS = new NameSet<Role, IRI>(new RoleCreator());
        this.dataRoles = d;
        this.useUndefinedNames = true;
        this.roles.add(null);
        this.roles.add(null);
        this.emptyRole.setId(0);
        this.emptyRole.setInverse(this.emptyRole);
        this.emptyRole.setDataRole(this.dataRoles);
        this.emptyRole.setBPDomain(-1);
        this.emptyRole.setBottom();
        this.universalRole.setId(0);
        this.universalRole.setInverse(this.universalRole);
        this.universalRole.setDataRole(this.dataRoles);
        this.universalRole.setBPDomain(1);
        this.universalRole.setTop();
        this.universalRole.getAutomaton().setCompleted(true);
        this.pTax = new Taxonomy(this.universalRole, this.emptyRole, c);
    }

    @PortedFrom(file="RoleMaster.h", name="ensureRoleName")
    public NamedEntry ensureRoleName(IRI name) {
        if (name.equals((Object)this.emptyRole.getName())) {
            return this.emptyRole;
        }
        if (name.equals((Object)this.universalRole.getName())) {
            return this.universalRole;
        }
        Role p = this.roleNS.insert(name);
        if (this.isRegisteredRole(p)) {
            return p;
        }
        if (p.getId() != 0 || !this.useUndefinedNames) {
            throw new OWLRuntimeException("Unable to register '" + name + "' as a " + (this.dataRoles ? "data role" : "role"));
        }
        this.registerRole(p);
        return p;
    }

    @PortedFrom(file="RoleMaster.h", name="addRoleSynonym")
    public static void addRoleSynonym(Role role, Role syn) {
        RoleMaster.addRoleParentProper(ClassifiableEntry.resolveSynonym(role), ClassifiableEntry.resolveSynonym(syn));
        RoleMaster.addRoleParentProper(ClassifiableEntry.resolveSynonym(syn), ClassifiableEntry.resolveSynonym(role));
    }

    @PortedFrom(file="RoleMaster.h", name="addRoleParentProper")
    public static void addRoleParentProper(Role role, Role parent) {
        assert (!role.isSynonym() && !parent.isSynonym());
        if (role.equals(parent)) {
            return;
        }
        if (role.isDataRole() != parent.isDataRole()) {
            throw new ReasonerInternalException("Mixed object and data roles in role subsumption axiom");
        }
        if (role.isTop() && parent.isBottom()) {
            throw new InconsistentOntologyException();
        }
        if (role.isTop()) {
            parent.setSynonym(role);
            parent.inverse().setSynonym(role);
            return;
        }
        if (parent.isBottom()) {
            role.setSynonym(parent);
            role.inverse().setSynonym(parent);
            return;
        }
        role.addParent(parent);
        role.inverse().addParent(parent.inverse());
    }

    @PortedFrom(file="RoleMaster.h", name="addDisjointRoles")
    public void addDisjointRoles(Role R, Role S) {
        if (R.isDataRole() != S.isDataRole()) {
            return;
        }
        this.disjointRolesA.add(R);
        this.disjointRolesB.add(S);
    }

    @PortedFrom(file="RoleMaster.h", name="setUndefinedNames")
    public void setUndefinedNames(boolean val) {
        this.useUndefinedNames = val;
    }

    @PortedFrom(file="RoleMaster.h", name="begin")
    public List<Role> getRoles() {
        return this.roles.subList(2, this.roles.size());
    }

    @PortedFrom(file="RoleMaster.h", name="getTaxonomy")
    public Taxonomy getTaxonomy() {
        return this.pTax;
    }

    @PortedFrom(file="RoleMaster.h", name="Print")
    public void print(LogAdapter o, String type) {
        if (this.size() == 0) {
            return;
        }
        o.print((Object)type, (Object)" Roles (").print(this.size()).print("):\n");
        o.print((Object)this.emptyRole);
        for (int i = 2; i < this.roles.size(); ++i) {
            Role p = this.roles.get(i);
            p.print(o);
        }
    }

    @PortedFrom(file="RoleMaster.h", name="hasReflexiveRoles")
    public boolean hasReflexiveRoles() {
        for (int i = 2; i < this.roles.size(); ++i) {
            Role p = this.roles.get(i);
            if (!p.isReflexive()) continue;
            return true;
        }
        return false;
    }

    @PortedFrom(file="RoleMaster.h", name="fillReflexiveRoles")
    public void fillReflexiveRoles(List<Role> RR) {
        RR.clear();
        for (int i = 2; i < this.roles.size(); ++i) {
            Role p = this.roles.get(i);
            if (p.isSynonym() || !p.isReflexive()) continue;
            RR.add(p);
        }
    }

    @PortedFrom(file="RoleMaster.h", name="addRoleParent")
    public static void addRoleParent(Role role, Role parent) {
        RoleMaster.addRoleParentProper(ClassifiableEntry.resolveSynonym(role), ClassifiableEntry.resolveSynonym(parent));
    }

    @PortedFrom(file="RoleMaster.h", name="addRoleParent")
    public static void addRoleParent(DLTree tree, Role parent) {
        if (tree == null) {
            return;
        }
        if (tree.token() == Token.RCOMPOSITION) {
            parent.addComposition(tree);
            DLTree inv = DLTreeFactory.inverseComposition(tree);
            parent.inverse().addComposition(inv);
        } else if (tree.token() == Token.PROJINTO) {
            Role R = Role.resolveRole(tree.getLeft());
            if (R.isDataRole()) {
                throw new ReasonerInternalException("Projection into not implemented for the data role");
            }
            DLTree C = tree.getRight().copy();
            DLTree InvP = DLTreeFactory.buildTree(new Lexeme(Token.RNAME, parent.inverse()));
            DLTree InvR = DLTreeFactory.buildTree(new Lexeme(Token.RNAME, R.inverse()));
            C = DLTreeFactory.buildTree(new Lexeme(Token.PROJINTO), InvP, C);
            C = DLTreeFactory.buildTree(new Lexeme(Token.PROJFROM), InvR, C);
            R.setRange(C);
        } else if (tree.token() == Token.PROJFROM) {
            Role R = Role.resolveRole(tree.getLeft());
            DLTree C = tree.getRight().copy();
            DLTree P = DLTreeFactory.buildTree(new Lexeme(Token.RNAME, parent));
            C = DLTreeFactory.buildTree(new Lexeme(Token.PROJINTO), P, C);
            C = DLTreeFactory.buildTree(new Lexeme(Token.PROJFROM), tree.getLeft().copy(), C);
            R.setDomain(C);
        } else {
            RoleMaster.addRoleParent(Role.resolveRole(tree), parent);
        }
    }

    @PortedFrom(file="RoleMaster.h", name="initAncDesc")
    public void initAncDesc() {
        Role p;
        int i;
        Role p2;
        int i2;
        int nRoles = this.roles.size();
        for (i2 = 2; i2 < this.roles.size(); ++i2) {
            p2 = this.roles.get(i2);
            p2.eliminateToldCycles();
        }
        for (i2 = 2; i2 < this.roles.size(); ++i2) {
            p2 = this.roles.get(i2);
            if (!p2.isSynonym()) continue;
            p2.canonicaliseSynonym();
            p2.addFeaturesToSynonym();
        }
        for (i2 = 2; i2 < this.roles.size(); ++i2) {
            p2 = this.roles.get(i2);
            if (p2.isSynonym()) continue;
            p2.removeSynonymsFromParents();
        }
        this.universalRole.completeAutomaton(nRoles);
        for (i2 = 2; i2 < this.roles.size(); ++i2) {
            p2 = this.roles.get(i2);
            if (p2.isSynonym() || p2.hasToldSubsumers()) continue;
            p2.addParent(this.universalRole);
        }
        TaxonomyCreator taxCreator = new TaxonomyCreator(this.pTax);
        taxCreator.setCompletelyDefined(true);
        for (i = 2; i < this.roles.size(); ++i) {
            p = this.roles.get(i);
            if (p.isClassified()) continue;
            taxCreator.classifyEntry(p);
        }
        for (i = 2; i < this.roles.size(); ++i) {
            p = this.roles.get(i);
            if (p.isSynonym()) continue;
            p.initADbyTaxonomy(this.pTax, nRoles);
        }
        for (i = 2; i < this.roles.size(); ++i) {
            p = this.roles.get(i);
            if (p.isSynonym()) continue;
            p.completeAutomaton(nRoles);
        }
        this.pTax.finalise();
        if (!this.disjointRolesA.isEmpty()) {
            for (i = 0; i < this.disjointRolesA.size(); ++i) {
                Role q = this.disjointRolesA.get(i);
                Role r = this.disjointRolesB.get(i);
                Role R = ClassifiableEntry.resolveSynonym(q);
                Role S = ClassifiableEntry.resolveSynonym(r);
                R.addDisjointRole(S);
                S.addDisjointRole(R);
                R.inverse().addDisjointRole(S.inverse());
                S.inverse().addDisjointRole(R.inverse());
            }
            for (i = 2; i < this.roles.size(); ++i) {
                p = this.roles.get(i);
                if (p.isSynonym() || !p.isDisjoint()) continue;
                p.checkHierarchicalDisjoint();
            }
        }
        for (i = 2; i < this.roles.size(); ++i) {
            p = this.roles.get(i);
            if (p.isSynonym()) continue;
            p.postProcess();
        }
        for (i = 2; i < this.roles.size(); ++i) {
            p = this.roles.get(i);
            if (p.isSynonym()) continue;
            p.consistent();
        }
    }

    @PortedFrom(file="RoleMaster.h", name="getTopRole")
    public Role getTopRole() {
        return this.universalRole;
    }

    @PortedFrom(file="RoleMaster.h", name="getBotRole")
    public Role getBotRole() {
        return this.emptyRole;
    }

    protected static class RoleCreator
    implements NameCreator<Role, IRI>,
    Serializable {
        private static final long serialVersionUID = 11000L;

        protected RoleCreator() {
        }

        @Override
        public Role makeEntry(IRI name) {
            return new Role(name);
        }
    }
}

