/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.PortedFrom;
import java.util.ArrayList;
import java.util.List;
import uk.ac.manchester.cs.jfact.dep.DepSet;
import uk.ac.manchester.cs.jfact.helpers.Pair;
import uk.ac.manchester.cs.jfact.helpers.Templates;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTreeArc;
import uk.ac.manchester.cs.jfact.kernel.DlSatTester;
import uk.ac.manchester.cs.jfact.kernel.Individual;
import uk.ac.manchester.cs.jfact.kernel.Related;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.TBox;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;

@PortedFrom(file="ReasonerNom.h", name="NominalReasoner")
public class NominalReasoner
extends DlSatTester {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="ReasonerNom.h", name="Nominals")
    protected final List<Individual> nominals = new ArrayList<Individual>();

    @Override
    @PortedFrom(file="ReasonerNom.h", name="hasNominals")
    public boolean hasNominals() {
        return true;
    }

    @PortedFrom(file="ReasonerNom.h", name="registerNominalCache")
    protected void registerNominalCache(Individual p) {
        this.dlHeap.setCache(p.getpName(), this.createModelCache(p.getNode().resolvePBlocker()));
    }

    @PortedFrom(file="ReasonerNom.h", name="initNominalNode")
    protected boolean initNominalNode(Individual nom) {
        DlCompletionTree node = this.cGraph.getNewNode();
        node.setNominalLevel();
        nom.setNode(node);
        return this.initNewNode(node, DepSet.create(), nom.getpName());
    }

    @PortedFrom(file="ReasonerNom.h", name="updateClassifiedSingleton")
    protected void updateClassifiedSingleton(Individual p) {
        this.registerNominalCache(p);
        if (p.getNode().isPBlocked()) {
            int bp = p.getNode().getBlocker().label().get_sc().get(0).getConcept();
            Individual blocker = (Individual)this.dlHeap.get(bp).getConcept();
            assert (blocker.getNode().equals(p.getNode().getBlocker()));
            this.tBox.addSameIndividuals(p, new Pair(blocker, p.getNode().getPurgeDep().isEmpty()));
        }
    }

    public NominalReasoner(TBox tbox, JFactReasonerConfiguration Options) {
        super(tbox, Options);
        for (Individual pi : this.tBox.i_begin()) {
            if (pi.isSynonym()) continue;
            this.nominals.add(pi);
        }
    }

    @Override
    @PortedFrom(file="ReasonerNom.h", name="prepareReasoner")
    protected void prepareReasoner() {
        this.options.getLog().print("\nInitNominalReasoner:");
        this.restore(1);
        if (!(this.bContext instanceof DlSatTester.BCBarrier)) {
            this.stack.pop();
            this.createBCBarrier();
        }
        this.save();
        this.resetSessionFlags();
    }

    @PortedFrom(file="ReasonerNom.h", name="consistentNominalCloud")
    public boolean consistentNominalCloud() {
        this.options.getLog().print("\n\nChecking consistency of an ontology with individuals:\n");
        boolean result = false;
        if (this.initNewNode(this.cGraph.getRoot(), DepSet.create(), 1) || this.initNominalCloud()) {
            this.options.getLog().print("\ninit done\n");
            result = false;
        } else {
            this.options.getLog().print("\nrunning sat...");
            result = this.runSat();
            this.options.getLog().print(" done: ");
            this.options.getLog().print(result);
            this.options.getLog().print("\n");
        }
        if (result && this.noBranchingOps()) {
            this.options.getLog().print("InitNominalReasoner[");
            this.curNode = null;
            this.createBCBarrier();
            this.save();
            this.nonDetShift = 1;
            this.options.getLog().print("]");
        }
        this.options.getLog().printTemplate(Templates.CONSISTENT_NOMINAL, result ? "consistent" : "INCONSISTENT");
        if (!result) {
            return false;
        }
        for (Individual p : this.nominals) {
            this.updateClassifiedSingleton(p);
        }
        return true;
    }

    @PortedFrom(file="ReasonerNom.h", name="initNominalCloud")
    private boolean initNominalCloud() {
        for (Individual p : this.nominals) {
            if (!this.initNominalNode(p)) continue;
            return true;
        }
        for (int i = 0; i < this.tBox.getRelatedI().size(); i += 2) {
            if (!this.initRelatedNominals(this.tBox.getRelatedI().get(i))) continue;
            return true;
        }
        if (this.tBox.getDifferent().isEmpty()) {
            return false;
        }
        DepSet dummy = DepSet.create();
        for (List<Individual> r : this.tBox.getDifferent()) {
            this.cGraph.initIR();
            for (Individual p : r) {
                if (!this.cGraph.setCurIR(ClassifiableEntry.resolveSynonym(p).getNode(), dummy)) continue;
                return true;
            }
            this.cGraph.finiIR();
        }
        return false;
    }

    @PortedFrom(file="ReasonerNom.h", name="initRelatedNominals")
    private boolean initRelatedNominals(Related rel) {
        DlCompletionTree from = ClassifiableEntry.resolveSynonym(rel.getA()).getNode();
        DlCompletionTree to = ClassifiableEntry.resolveSynonym(rel.getB()).getNode();
        Role R = ClassifiableEntry.resolveSynonym(rel.getRole());
        DepSet dep = DepSet.create();
        if (R.isDisjoint() && this.checkDisjointRoleClash(from, to, R, dep)) {
            return true;
        }
        DlCompletionTreeArc pA = this.cGraph.addRoleLabel(from, to, false, R, dep);
        return this.setupEdge(pA, dep, 0);
    }

    @PortedFrom(file="Reasoner.h", name="createBCBarrier")
    private void createBCBarrier() {
        this.bContext = this.stack.pushBarrier();
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="checkExtraCond")
    public boolean checkExtraCond() {
        this.prepareReasoner();
        DepSet dummy = DepSet.create();
        for (int i = 0; i < this.tBox.getIV().size(); ++i) {
            if (!this.addToDoEntry(this.tBox.getIV().get(i).getNode(), this.tBox.getConceptsForQueryAnswering().get(i), dummy, "QA")) continue;
            return true;
        }
        return !this.checkSatisfiability();
    }
}

