/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.Related;
import uk.ac.manchester.cs.jfact.kernel.Role;

@PortedFrom(file="tIndividual.h", name="TIndividual")
public class Individual
extends Concept {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="tIndividual.h", name="node")
    private DlCompletionTree node = null;
    @PortedFrom(file="tIndividual.h", name="RelatedIndex")
    private final List<Related> relatedIndex = new ArrayList<Related>();
    @PortedFrom(file="tIndividual.h", name="pRelatedMap")
    private final Map<Role, List<Individual>> pRelatedMap;

    public Individual(IRI name) {
        super(name);
        this.setSingleton(true);
        this.pRelatedMap = new HashMap<Role, List<Individual>>();
    }

    @Override
    @PortedFrom(file="tIndividual.h", name="initToldSubsumers")
    public void initToldSubsumers() {
        boolean CD;
        this.toldSubsumers.clear();
        this.setHasSP(false);
        if (this.isRelated()) {
            this.updateToldFromRelated();
        }
        if (this.isPrimitive() && this.description != null && this.description.isTOP()) {
            this.removeDescription();
        }
        boolean bl = CD = !this.hasExtraRules() && this.isPrimitive() && !this.isRelated();
        if (this.description != null || this.hasToldSubsumers()) {
            CD &= super.initToldSubsumers(this.description, new HashSet<Role>());
        }
        this.setCompletelyDefined(CD);
    }

    @PortedFrom(file="tIndividual.h", name="updateTold")
    private <T extends Related> void updateTold(List<T> begin, Set<Role> RolesProcessed) {
        for (int i = 0; i < begin.size(); ++i) {
            this.searchTSbyRoleAndSupers(((Related)begin.get(i)).getRole(), RolesProcessed);
        }
    }

    @PortedFrom(file="tIndividual.h", name="isRelated")
    private boolean isRelated() {
        return !this.relatedIndex.isEmpty();
    }

    @PortedFrom(file="tIndividual.h", name="addRelated")
    public void addRelated(Related p) {
        this.relatedIndex.add(p);
    }

    @PortedFrom(file="tIndividual.h", name="addRelated")
    public void addRelated(Individual p) {
        this.relatedIndex.addAll(p.relatedIndex);
    }

    @PortedFrom(file="tIndividual.h", name="hasRelatedCache")
    public boolean hasRelatedCache(Role R) {
        return this.pRelatedMap.containsKey(R);
    }

    @PortedFrom(file="tIndividual.h", name="getRelatedCache")
    public List<Individual> getRelatedCache(Role R) {
        assert (this.pRelatedMap.containsKey(R));
        return this.pRelatedMap.get(R);
    }

    @PortedFrom(file="tIndividual.h", name="setRelatedCache")
    public void setRelatedCache(Role R, List<Individual> v) {
        assert (!this.pRelatedMap.containsKey(R));
        this.pRelatedMap.put(R, v);
    }

    @PortedFrom(file="tIndividual.h", name="updateToldFromRelated")
    private void updateToldFromRelated() {
        HashSet<Role> RolesProcessed = new HashSet<Role>();
        this.updateTold(this.relatedIndex, RolesProcessed);
    }

    @Original
    public DlCompletionTree getNode() {
        return this.node;
    }

    @Original
    public void setNode(DlCompletionTree node) {
        this.node = node;
    }

    @Original
    public List<Related> getRelatedIndex() {
        return this.relatedIndex;
    }
}

