/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeEntry;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeExpression;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.datatypes.LiteralEntry;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeFactory;
import uk.ac.manchester.cs.jfact.kernel.Lexeme;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.RoleMaster;
import uk.ac.manchester.cs.jfact.kernel.TBox;
import uk.ac.manchester.cs.jfact.kernel.Token;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptAnd;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataExactCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataExists;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataForall;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataMaxCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataMinCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataValue;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptName;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptNot;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectExactCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectExists;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectForall;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectMaxCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectMinCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectSelf;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectValue;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptOneOf;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptOr;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptTop;
import uk.ac.manchester.cs.jfact.kernel.dl.DataAnd;
import uk.ac.manchester.cs.jfact.kernel.dl.DataBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.DataNot;
import uk.ac.manchester.cs.jfact.kernel.dl.DataOneOf;
import uk.ac.manchester.cs.jfact.kernel.dl.DataOr;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleName;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleTop;
import uk.ac.manchester.cs.jfact.kernel.dl.DataTop;
import uk.ac.manchester.cs.jfact.kernel.dl.IndividualName;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleChain;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleInverse;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleName;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleProjectionFrom;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleProjectionInto;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleTop;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.NAryExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.NamedEntity;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;
import uk.ac.manchester.cs.jfact.split.TSignature;
import uk.ac.manchester.cs.jfact.visitors.DLExpressionVisitorEx;

@PortedFrom(file="tExpressionTranslator.h", name="TExpressionTranslator")
public class ExpressionTranslator
implements DLExpressionVisitorEx<DLTree>,
Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="tExpressionTranslator.h", name="kb")
    private final TBox tbox;
    @PortedFrom(file="tExpressionTranslator.h", name="sig")
    private TSignature sig;

    @PortedFrom(file="tExpressionTranslator.h", name="nc")
    private boolean nc(NamedEntity entity) {
        return this.sig != null && !this.sig.containsNamedEntity(entity);
    }

    @PortedFrom(file="tExpressionTranslator.h", name="setSignature")
    public void setSignature(TSignature s) {
        this.sig = s;
    }

    public ExpressionTranslator(TBox kb) {
        this.tbox = kb;
    }

    @Override
    public DLTree visit(ConceptTop expr) {
        return DLTreeFactory.createTop();
    }

    @Override
    public DLTree visit(ConceptBottom expr) {
        return DLTreeFactory.createBottom();
    }

    @Override
    public DLTree visit(ConceptName expr) {
        if (this.nc(expr)) {
            return this.sig.topCLocal() ? DLTreeFactory.createTop() : DLTreeFactory.createBottom();
        }
        NamedEntry entry = expr.getEntry();
        if (entry == null) {
            entry = ExpressionTranslator.matchEntry(this.tbox.getConcept(expr.getName()), expr);
        }
        return DLTreeFactory.buildTree(new Lexeme(Token.CNAME, entry));
    }

    @PortedFrom(file="tExpressionTranslator.h", name="matchEntry")
    private static NamedEntry matchEntry(NamedEntry entry, NamedEntity entity) {
        entry.setEntity(entity);
        entity.setEntry(entry);
        return entry;
    }

    @Override
    public DLTree visit(ConceptNot expr) {
        return DLTreeFactory.createSNFNot(expr.getConcept().accept(this));
    }

    @Original
    private List<DLTree> visitArgs(NAryExpression<? extends Expression> expr) {
        ArrayList<DLTree> args = new ArrayList<DLTree>();
        List<? extends Expression> list = expr.getArguments();
        for (int i = 0; i < list.size(); ++i) {
            args.add(list.get(i).accept(this));
        }
        return args;
    }

    @Override
    public DLTree visit(ConceptAnd expr) {
        return DLTreeFactory.createSNFAnd(this.visitArgs(expr));
    }

    @Override
    public DLTree visit(ConceptOr expr) {
        return DLTreeFactory.createSNFOr(this.visitArgs(expr));
    }

    @Override
    public DLTree visit(ConceptOneOf<?> expr) {
        return DLTreeFactory.createSNFOr(this.visitArgs(expr));
    }

    @Override
    public DLTree visit(ConceptObjectSelf expr) {
        DLTree r = expr.getOR().accept(this);
        return DLTreeFactory.createSNFSelf(r);
    }

    @Override
    public DLTree visit(ConceptObjectValue expr) {
        return DLTreeFactory.createSNFExists(expr.getOR().accept(this), expr.getIndividual().accept(this));
    }

    @Override
    public DLTree visit(ConceptObjectExists expr) {
        return DLTreeFactory.createSNFExists(expr.getOR().accept(this), expr.getConcept().accept(this));
    }

    @Override
    public DLTree visit(ConceptObjectForall expr) {
        return DLTreeFactory.createSNFForall(expr.getOR().accept(this), expr.getConcept().accept(this));
    }

    @Override
    public DLTree visit(ConceptObjectMinCardinality expr) {
        return DLTreeFactory.createSNFGE(expr.getCardinality(), expr.getOR().accept(this), expr.getConcept().accept(this));
    }

    @Override
    public DLTree visit(ConceptObjectMaxCardinality expr) {
        return DLTreeFactory.createSNFLE(expr.getCardinality(), expr.getOR().accept(this), expr.getConcept().accept(this));
    }

    @Override
    public DLTree visit(ConceptObjectExactCardinality expr) {
        DLTree le = DLTreeFactory.createSNFLE(expr.getCardinality(), expr.getOR().accept(this).copy(), expr.getConcept().accept(this).copy());
        DLTree ge = DLTreeFactory.createSNFGE(expr.getCardinality(), expr.getOR().accept(this).copy(), expr.getConcept().accept(this).copy());
        return DLTreeFactory.createSNFAnd(ge, le);
    }

    @Override
    public DLTree visit(ConceptDataValue expr) {
        return DLTreeFactory.createSNFExists(expr.getDataRoleExpression().accept(this), expr.getExpr().accept(this));
    }

    @Override
    public DLTree visit(ConceptDataExists expr) {
        return DLTreeFactory.createSNFExists(expr.getDataRoleExpression().accept(this), expr.getExpr().accept(this));
    }

    @Override
    public DLTree visit(ConceptDataForall expr) {
        return DLTreeFactory.createSNFForall(expr.getDataRoleExpression().accept(this), expr.getExpr().accept(this));
    }

    @Override
    public DLTree visit(ConceptDataMinCardinality expr) {
        DLTree role = expr.getDataRoleExpression().accept(this);
        DLTree filler = expr.getExpr().accept(this);
        assert (role != null);
        assert (filler != null);
        return DLTreeFactory.createSNFGE(expr.getCardinality(), role, filler);
    }

    @Override
    public DLTree visit(ConceptDataMaxCardinality expr) {
        return DLTreeFactory.createSNFLE(expr.getCardinality(), expr.getDataRoleExpression().accept(this), expr.getExpr().accept(this));
    }

    @Override
    public DLTree visit(ConceptDataExactCardinality expr) {
        DLTree le = DLTreeFactory.createSNFLE(expr.getCardinality(), expr.getDataRoleExpression().accept(this).copy(), expr.getExpr().accept(this).copy());
        DLTree ge = DLTreeFactory.createSNFGE(expr.getCardinality(), expr.getDataRoleExpression().accept(this).copy(), expr.getExpr().accept(this).copy());
        return DLTreeFactory.createSNFAnd(ge, le);
    }

    @Override
    public DLTree visit(IndividualName expr) {
        NamedEntry entry = expr.getEntry();
        if (entry == null) {
            entry = ExpressionTranslator.matchEntry(this.tbox.getIndividual(expr.getName()), expr);
        }
        return DLTreeFactory.buildTree(new Lexeme(Token.INAME, entry));
    }

    @Override
    public DLTree visit(ObjectRoleTop expr) {
        throw new ReasonerInternalException("Unsupported expression 'top object role' in transformation");
    }

    @Override
    public DLTree visit(ObjectRoleBottom expr) {
        throw new ReasonerInternalException("Unsupported expression 'bottom object role' in transformation");
    }

    @Override
    public DLTree visit(ObjectRoleName expr) {
        NamedEntry role;
        RoleMaster RM = this.tbox.getORM();
        if (this.nc(expr)) {
            role = this.sig.topRLocal() ? RM.getTopRole() : RM.getBotRole();
        } else {
            role = expr.getEntry();
            if (role == null) {
                role = ExpressionTranslator.matchEntry(RM.ensureRoleName(expr.getName()), expr);
            }
        }
        return DLTreeFactory.buildTree(new Lexeme(Token.RNAME, role));
    }

    @Override
    public DLTree visit(ObjectRoleInverse expr) {
        return DLTreeFactory.createInverse(expr.getOR().accept(this));
    }

    @Override
    public DLTree visit(ObjectRoleChain expr) {
        ArrayList l = new ArrayList(expr.getArguments());
        if (l.isEmpty()) {
            throw new ReasonerInternalException("Unsupported expression 'empty role chain' in transformation");
        }
        ArrayList<DLTree> replacements = new ArrayList<DLTree>();
        for (ObjectRoleExpression e : l) {
            replacements.add(e.accept(this));
        }
        return DLTreeFactory.buildTree(new Lexeme(Token.RCOMPOSITION), replacements);
    }

    @Override
    public DLTree visit(ObjectRoleProjectionFrom expr) {
        return DLTreeFactory.buildTree(new Lexeme(Token.PROJFROM), expr.getOR().accept(this), expr.getConcept().accept(this));
    }

    @Override
    public DLTree visit(ObjectRoleProjectionInto expr) {
        return DLTreeFactory.buildTree(new Lexeme(Token.PROJINTO), expr.getOR().accept(this), expr.getConcept().accept(this));
    }

    @Override
    public DLTree visit(DataRoleTop expr) {
        throw new ReasonerInternalException("Unsupported expression 'top data role' in transformation");
    }

    @Override
    public DLTree visit(DataRoleBottom expr) {
        throw new ReasonerInternalException("Unsupported expression 'bottom data role' in transformation");
    }

    @Override
    public DLTree visit(DataRoleName expr) {
        NamedEntry role;
        RoleMaster RM = this.tbox.getDRM();
        if (this.nc(expr)) {
            role = this.sig.topRLocal() ? RM.getTopRole() : RM.getBotRole();
        } else {
            role = expr.getEntry();
            if (role == null) {
                role = ExpressionTranslator.matchEntry(RM.ensureRoleName(expr.getName()), expr);
            }
        }
        return DLTreeFactory.buildTree(new Lexeme(Token.DNAME, role));
    }

    @Override
    public DLTree visit(DataTop expr) {
        return DLTreeFactory.createTop();
    }

    @Override
    public DLTree visit(DataBottom expr) {
        return DLTreeFactory.createBottom();
    }

    @Override
    public DLTree visit(@Nonnull Datatype<?> expr) {
        DatatypeEntry entry = new DatatypeEntry(expr);
        return DLTreeFactory.wrap(entry);
    }

    @Override
    public DLTree visit(@Nonnull DatatypeExpression<?> expr) {
        DatatypeEntry entry = new DatatypeEntry(expr);
        return DLTreeFactory.wrap(entry);
    }

    @Override
    public DLTree visit(Literal<?> expr) {
        LiteralEntry entry = new LiteralEntry(expr.value());
        entry.setLiteral(expr);
        return DLTreeFactory.wrap(entry);
    }

    @Override
    public DLTree visit(DataNot expr) {
        return DLTreeFactory.createSNFNot(expr.getExpr().accept(this));
    }

    @Override
    public DLTree visit(DataAnd expr) {
        return DLTreeFactory.createSNFAnd(this.visitArgs(expr));
    }

    @Override
    public DLTree visit(DataOr expr) {
        return DLTreeFactory.createSNFOr(this.visitArgs(expr));
    }

    @Override
    public DLTree visit(DataOneOf expr) {
        return DLTreeFactory.createSNFOr(this.visitArgs(expr));
    }
}

