/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptAnd;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataExactCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataExists;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataForall;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataMaxCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataMinCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataValue;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptNot;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectExactCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectExists;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectForall;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectMaxCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectMinCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectSelf;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectValue;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptOr;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptTop;
import uk.ac.manchester.cs.jfact.kernel.dl.DataAnd;
import uk.ac.manchester.cs.jfact.kernel.dl.DataBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.DataNot;
import uk.ac.manchester.cs.jfact.kernel.dl.DataOneOf;
import uk.ac.manchester.cs.jfact.kernel.dl.DataOr;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleTop;
import uk.ac.manchester.cs.jfact.kernel.dl.DataTop;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleChain;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleProjectionFrom;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleProjectionInto;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleTop;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.IndividualExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleComplexExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.RoleExpression;

@PortedFrom(file="tExpressionManager.h", name="TExpressionManager")
public class ExpressionManager
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="tExpressionManager.h", name="CTop")
    @Nonnull
    private static final ConceptTop top = new ConceptTop();
    @PortedFrom(file="tExpressionManager.h", name="CBottom")
    @Nonnull
    private static final ConceptBottom bottom = new ConceptBottom();
    @PortedFrom(file="tExpressionManager.h", name="DTop")
    @Nonnull
    private static final DataTop dataTop = new DataTop();
    @PortedFrom(file="tExpressionManager.h", name="ORTop")
    @Nonnull
    private static final ObjectRoleExpression objectRoleTop = new ObjectRoleTop();
    @PortedFrom(file="tExpressionManager.h", name="ORBottom")
    @Nonnull
    private static final ObjectRoleExpression objectRoleBottom = new ObjectRoleBottom();
    @PortedFrom(file="tExpressionManager.h", name="DRTop")
    @Nonnull
    private static final DataRoleExpression dataRoleTop = new DataRoleTop();
    @PortedFrom(file="tExpressionManager.h", name="DRBottom")
    @Nonnull
    private static final DataRoleExpression dataRoleBottom = new DataRoleBottom();
    @PortedFrom(file="tExpressionManager.h", name="DBottom")
    @Nonnull
    private static final DataBottom dataBottom = new DataBottom();

    private ExpressionManager() {
    }

    @PortedFrom(file="tExpressionManager.h", name="isUniversalRole")
    public static boolean isUniversalRole(RoleExpression R) {
        return R.equals(dataRoleTop) || R.equals(objectRoleTop);
    }

    @PortedFrom(file="tExpressionManager.h", name="isEmptyRole")
    public static boolean isEmptyRole(RoleExpression R) {
        return R.equals(dataRoleBottom) || R.equals(objectRoleBottom);
    }

    @PortedFrom(file="tExpressionManager.h", name="top")
    @Nonnull
    public static ConceptTop top() {
        return top;
    }

    @PortedFrom(file="tExpressionManager.h", name="bottom")
    @Nonnull
    public static ConceptBottom bottom() {
        return bottom;
    }

    @PortedFrom(file="tExpressionManager.h", name="Not")
    @Nonnull
    public static ConceptExpression not(ConceptExpression C) {
        return new ConceptNot(C);
    }

    @PortedFrom(file="tExpressionManager.h", name="and")
    @Nonnull
    public static ConceptExpression and(List<ConceptExpression> l) {
        return new ConceptAnd(l);
    }

    @PortedFrom(file="tExpressionManager.h", name="and")
    @Nonnull
    public static ConceptExpression and(@Nonnull ConceptExpression C, @Nonnull ConceptExpression D) {
        if (C.equals(D)) {
            return C;
        }
        if (C instanceof ConceptTop) {
            return D;
        }
        if (D instanceof ConceptTop) {
            return C;
        }
        return ExpressionManager.and(Arrays.asList(C, D));
    }

    @PortedFrom(file="tExpressionManager.h", name="or")
    @Nonnull
    public static ConceptExpression or(ConceptExpression C, ConceptExpression D) {
        return ExpressionManager.or(Arrays.asList(C, D));
    }

    @PortedFrom(file="tExpressionManager.h", name="or")
    @Nonnull
    public static ConceptExpression or(List<ConceptExpression> l) {
        return new ConceptOr(l);
    }

    @PortedFrom(file="tExpressionManager.h", name="SelfReference")
    @Nonnull
    public static ConceptExpression selfReference(ObjectRoleExpression R) {
        return new ConceptObjectSelf(R);
    }

    @PortedFrom(file="tExpressionManager.h", name="value")
    @Nonnull
    public static ConceptExpression value(ObjectRoleExpression R, IndividualExpression I) {
        return new ConceptObjectValue(R, I);
    }

    @PortedFrom(file="tExpressionManager.h", name="Exists")
    @Nonnull
    public static ConceptExpression exists(ObjectRoleExpression R, ConceptExpression C) {
        return new ConceptObjectExists(R, C);
    }

    @PortedFrom(file="tExpressionManager.h", name="Forall")
    @Nonnull
    public static ConceptExpression forall(ObjectRoleExpression R, ConceptExpression C) {
        return new ConceptObjectForall(R, C);
    }

    @PortedFrom(file="tExpressionManager.h", name="MinCardinality")
    @Nonnull
    public static ConceptExpression minCardinality(int n, ObjectRoleExpression R, ConceptExpression C) {
        return new ConceptObjectMinCardinality(n, R, C);
    }

    @PortedFrom(file="tExpressionManager.h", name="MaxCardinality")
    @Nonnull
    public static ConceptExpression maxCardinality(int n, ObjectRoleExpression R, ConceptExpression C) {
        return new ConceptObjectMaxCardinality(n, R, C);
    }

    @PortedFrom(file="tExpressionManager.h", name="cardinality")
    @Nonnull
    public static ConceptExpression cardinality(int n, ObjectRoleExpression R, ConceptExpression C) {
        return new ConceptObjectExactCardinality(n, R, C);
    }

    @PortedFrom(file="tExpressionManager.h", name="value")
    @Nonnull
    public static ConceptExpression value(DataRoleExpression R, Literal<?> V) {
        return new ConceptDataValue(R, V);
    }

    @PortedFrom(file="tExpressionManager.h", name="Exists")
    @Nonnull
    public static ConceptExpression exists(DataRoleExpression R, DataExpression E) {
        return new ConceptDataExists(R, E);
    }

    @PortedFrom(file="tExpressionManager.h", name="Forall")
    @Nonnull
    public static ConceptExpression forall(DataRoleExpression R, DataExpression E) {
        return new ConceptDataForall(R, E);
    }

    @PortedFrom(file="tExpressionManager.h", name="MinCardinality")
    @Nonnull
    public static ConceptExpression minCardinality(int n, DataRoleExpression R, DataExpression E) {
        return new ConceptDataMinCardinality(n, R, E);
    }

    @PortedFrom(file="tExpressionManager.h", name="MaxCardinality")
    @Nonnull
    public static ConceptExpression maxCardinality(int n, DataRoleExpression R, DataExpression E) {
        return new ConceptDataMaxCardinality(n, R, E);
    }

    @PortedFrom(file="tExpressionManager.h", name="cardinality")
    @Nonnull
    public static ConceptExpression cardinality(int n, DataRoleExpression R, DataExpression E) {
        return new ConceptDataExactCardinality(n, R, E);
    }

    @PortedFrom(file="tExpressionManager.h", name="ObjectRoleTop")
    @Nonnull
    public static ObjectRoleExpression objectRoleTop() {
        return objectRoleTop;
    }

    @PortedFrom(file="tExpressionManager.h", name="ObjectRoleBottom")
    @Nonnull
    public static ObjectRoleExpression objectRoleBottom() {
        return objectRoleBottom;
    }

    @PortedFrom(file="tExpressionManager.h", name="Compose")
    @Nonnull
    public static ObjectRoleComplexExpression compose(List<ObjectRoleExpression> l) {
        return new ObjectRoleChain(l);
    }

    @PortedFrom(file="tExpressionManager.h", name="Compose")
    @Nonnull
    public static ObjectRoleComplexExpression compose(ObjectRoleExpression e1, ObjectRoleExpression e2) {
        return new ObjectRoleChain(Arrays.asList(e1, e2));
    }

    @PortedFrom(file="tExpressionManager.h", name="ProjectFrom")
    @Nonnull
    public static ObjectRoleComplexExpression projectFrom(ObjectRoleExpression R, ConceptExpression C) {
        return new ObjectRoleProjectionFrom(R, C);
    }

    @PortedFrom(file="tExpressionManager.h", name="ProjectInto")
    @Nonnull
    public static ObjectRoleComplexExpression projectInto(ObjectRoleExpression R, ConceptExpression C) {
        return new ObjectRoleProjectionInto(R, C);
    }

    @PortedFrom(file="tExpressionManager.h", name="DataRoleTop")
    @Nonnull
    public static DataRoleExpression dataRoleTop() {
        return dataRoleTop;
    }

    @PortedFrom(file="tExpressionManager.h", name="DataRoleBottom")
    @Nonnull
    public static DataRoleExpression dataRoleBottom() {
        return dataRoleBottom;
    }

    @PortedFrom(file="tExpressionManager.h", name="DataTop")
    @Nonnull
    public static DataExpression dataTop() {
        return dataTop;
    }

    @PortedFrom(file="tExpressionManager.h", name="DataBottom")
    @Nonnull
    public static DataBottom dataBottom() {
        return dataBottom;
    }

    @Original
    @Nonnull
    public static String getDataTop() {
        return "http://www.w3.org/2000/01/rdf-schema#Literal";
    }

    @PortedFrom(file="tExpressionManager.h", name="DataNot")
    @Nonnull
    public static DataExpression dataNot(DataExpression E) {
        return new DataNot(E);
    }

    @PortedFrom(file="tExpressionManager.h", name="DataAnd")
    @Nonnull
    public static DataExpression dataAnd(List<DataExpression> l) {
        return new DataAnd(l);
    }

    @PortedFrom(file="tExpressionManager.h", name="DataOr")
    @Nonnull
    public static DataExpression dataOr(List<DataExpression> l) {
        return new DataOr(l);
    }

    @PortedFrom(file="tExpressionManager.h", name="DataOneOf")
    @Nonnull
    public static DataExpression dataOneOf(List<Literal<?>> l) {
        return new DataOneOf(l);
    }
}

