/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.PortedFrom;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import uk.ac.manchester.cs.jfact.kernel.NameCreator;
import uk.ac.manchester.cs.jfact.kernel.NameSet;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptName;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptOneOf;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleName;
import uk.ac.manchester.cs.jfact.kernel.dl.IndividualName;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleInverse;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleName;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.IndividualExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;

public class ExpressionCache {
    @PortedFrom(file="tExpressionManager.h", name="NS_C")
    private final NameSet<ConceptName, IRI> conceptNameset = new NameSet<ConceptName, IRI>(new ConceptNameCreator());
    @PortedFrom(file="tExpressionManager.h", name="NS_I")
    private final NameSet<IndividualName, IRI> individualNameset = new NameSet<IndividualName, IRI>(new IndividualNameCreator());
    @PortedFrom(file="tExpressionManager.h", name="NS_OR")
    private final NameSet<ObjectRoleName, IRI> objectRoleNameset = new NameSet<ObjectRoleName, IRI>(new ObjectroleNameCreator());
    @PortedFrom(file="tExpressionManager.h", name="NS_DR")
    private final NameSet<DataRoleName, IRI> dataRoleNameset = new NameSet<DataRoleName, IRI>(new DataroleNameCreator());
    @PortedFrom(file="tExpressionManager.h", name="InverseRoleCache")
    @Nonnull
    private final InverseRoleCache inverseRoleCache = new InverseRoleCache();
    @PortedFrom(file="tExpressionManager.h", name="OneOfCache")
    private final Map<IndividualExpression, ConceptExpression> OneOfCache = new HashMap<IndividualExpression, ConceptExpression>();

    @PortedFrom(file="tExpressionManager.h", name="concept")
    @Nonnull
    public ConceptName concept(IRI name) {
        return this.conceptNameset.insert(name);
    }

    @PortedFrom(file="tExpressionManager.h", name="OneOf")
    @Nonnull
    public ConceptExpression oneOf(List<IndividualExpression> l) {
        if (l.size() == 1) {
            IndividualExpression i = l.get(0);
            ConceptOneOf<IndividualExpression> c = this.OneOfCache.get(i);
            if (c == null) {
                c = new ConceptOneOf<IndividualExpression>(l);
                this.OneOfCache.put(i, c);
            }
            return c;
        }
        return new ConceptOneOf<IndividualExpression>(l);
    }

    @PortedFrom(file="tExpressionManager.h", name="inverse")
    @Nonnull
    public ObjectRoleExpression inverse(ObjectRoleExpression R) {
        return this.inverseRoleCache.get(R);
    }

    @PortedFrom(file="tExpressionManager.h", name="OneOf")
    @Nonnull
    public ConceptExpression oneOf(IndividualExpression I) {
        return this.oneOf(Arrays.asList(I));
    }

    @PortedFrom(file="tExpressionManager.h", name="clearNameCache")
    public void clearNameCache() {
        this.conceptNameset.clear();
        this.objectRoleNameset.clear();
        this.dataRoleNameset.clear();
        this.individualNameset.clear();
    }

    @PortedFrom(file="tExpressionManager.h", name="clear")
    public void clear() {
        this.clearNameCache();
        this.inverseRoleCache.clear();
        this.OneOfCache.clear();
    }

    @PortedFrom(file="tExpressionManager.h", name="nConcepts")
    public int nConcepts() {
        return this.conceptNameset.size();
    }

    @PortedFrom(file="tExpressionManager.h", name="nIndividuals")
    public int nIndividuals() {
        return this.individualNameset.size();
    }

    @PortedFrom(file="tExpressionManager.h", name="nORoles")
    public int nORoles() {
        return this.objectRoleNameset.size();
    }

    @PortedFrom(file="tExpressionManager.h", name="nDRoles")
    public int nDRoles() {
        return this.dataRoleNameset.size();
    }

    @PortedFrom(file="tExpressionManager.h", name="individual")
    @Nonnull
    public IndividualName individual(IRI name) {
        return this.individualNameset.insert(name);
    }

    @PortedFrom(file="tExpressionManager.h", name="ObjectRole")
    @Nonnull
    public ObjectRoleName objectRole(IRI name) {
        return this.objectRoleNameset.insert(name);
    }

    @PortedFrom(file="tExpressionManager.h", name="DataRole")
    @Nonnull
    public DataRoleName dataRole(IRI name) {
        return this.dataRoleNameset.insert(name);
    }

    protected static class DataroleNameCreator
    implements NameCreator<DataRoleName, IRI>,
    Serializable {
        private static final long serialVersionUID = 11000L;

        protected DataroleNameCreator() {
        }

        @Override
        public DataRoleName makeEntry(IRI name) {
            return new DataRoleName(name);
        }
    }

    protected class InverseRoleCache
    implements Serializable {
        private static final long serialVersionUID = 11000L;
        private Map<ObjectRoleExpression, ObjectRoleExpression> map;

        protected InverseRoleCache() {
        }

        @Nonnull
        public ObjectRoleExpression get(ObjectRoleExpression tail) {
            ObjectRoleExpression concat = null;
            if (this.map != null) {
                concat = this.map.get(tail);
            }
            if (concat != null) {
                return concat;
            }
            concat = this.build(tail);
            if (this.map == null) {
                this.map = new HashMap<ObjectRoleExpression, ObjectRoleExpression>();
            }
            this.map.put(tail, concat);
            return concat;
        }

        public void clear() {
            if (this.map != null) {
                this.map.clear();
            }
        }

        @Nonnull
        public ObjectRoleExpression build(ObjectRoleExpression tail) {
            return new ObjectRoleInverse(tail);
        }
    }

    protected static class ConceptNameCreator
    implements NameCreator<ConceptName, IRI>,
    Serializable {
        private static final long serialVersionUID = 11000L;

        protected ConceptNameCreator() {
        }

        @Override
        public ConceptName makeEntry(IRI name) {
            return new ConceptName(name);
        }
    }

    protected static class IndividualNameCreator
    implements NameCreator<IndividualName, IRI>,
    Serializable {
        private static final long serialVersionUID = 11000L;

        protected IndividualNameCreator() {
        }

        @Override
        public IndividualName makeEntry(IRI name) {
            return new IndividualName(name);
        }
    }

    protected static class ObjectroleNameCreator
    implements NameCreator<ObjectRoleName, IRI>,
    Serializable {
        private static final long serialVersionUID = 11000L;

        protected ObjectroleNameCreator() {
        }

        @Override
        public ObjectRoleName makeEntry(IRI name) {
            return new ObjectRoleName(name);
        }
    }
}

