/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.PortedFrom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import uk.ac.manchester.cs.jfact.helpers.Templates;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.Individual;
import uk.ac.manchester.cs.jfact.kernel.KBFlags;
import uk.ac.manchester.cs.jfact.kernel.KnownSubsumers;
import uk.ac.manchester.cs.jfact.kernel.TBox;
import uk.ac.manchester.cs.jfact.kernel.Taxonomy;
import uk.ac.manchester.cs.jfact.kernel.TaxonomyCreator;
import uk.ac.manchester.cs.jfact.kernel.TaxonomyVertex;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.NamedEntity;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheInterface;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheState;
import uk.ac.manchester.cs.jfact.split.TSignature;

@PortedFrom(file="DLConceptTaxonomy.h", name="DLConceptTaxonomy")
public class DLConceptTaxonomy
extends TaxonomyCreator {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="DLConceptTaxonomy.h", name="tBox")
    private final TBox tBox;
    @PortedFrom(file="DLConceptTaxonomy.h", name="Common")
    private final List<TaxonomyVertex> common = new ArrayList<TaxonomyVertex>();
    @PortedFrom(file="DLConceptTaxonomy.h", name="nConcepts")
    private long nConcepts = 0L;
    @PortedFrom(file="DLConceptTaxonomy.h", name="nTries")
    private long nTries = 0L;
    @PortedFrom(file="DLConceptTaxonomy.h", name="nPositives")
    private long nPositives = 0L;
    @PortedFrom(file="DLConceptTaxonomy.h", name="nNegatives")
    private long nNegatives = 0L;
    @PortedFrom(file="DLConceptTaxonomy.h", name="nSearchCalls")
    private long nSearchCalls = 0L;
    @PortedFrom(file="DLConceptTaxonomy.h", name="nSubCalls")
    private long nSubCalls = 0L;
    @PortedFrom(file="DLConceptTaxonomy.h", name="nNonTrivialSubCalls")
    private long nNonTrivialSubCalls = 0L;
    @PortedFrom(file="DLConceptTaxonomy.h", name="nCachedPositive")
    private long nCachedPositive = 0L;
    @PortedFrom(file="DLConceptTaxonomy.h", name="nCachedNegative")
    private long nCachedNegative = 0L;
    @PortedFrom(file="DLConceptTaxonomy.h", name="nSortedNegative")
    private long nSortedNegative = 0L;
    @PortedFrom(file="DLConceptTaxonomy.h", name="nModuleNegative")
    private long nModuleNegative = 0L;
    @PortedFrom(file="DLConceptTaxonomy.h", name="flagNeedBottomUp")
    private boolean flagNeedBottomUp;
    @PortedFrom(file="DLConceptTaxonomy.h", name="nCommon")
    protected int nCommon = 1;
    protected final Set<TaxonomyVertex> candidates = new HashSet<TaxonomyVertex>();
    protected boolean useCandidates = false;
    protected Set<NamedEntity> MPlus;
    protected Set<NamedEntity> MMinus;

    @PortedFrom(file="DLConceptTaxonomy.h", name="curConcept")
    private Concept curConcept() {
        return (Concept)this.curEntry;
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="enhancedSubs")
    private boolean enhancedSubs(TaxonomyVertex cur) {
        ++this.nSubCalls;
        if (this.isValued(cur)) {
            return this.getValue(cur);
        }
        return this.setValue(cur, this.enhancedSubs2(cur));
    }

    @Override
    @PortedFrom(file="DLConceptTaxonomy.h", name="runTopDown")
    public void runTopDown() {
        this.searchBaader(this.pTax.getTopVertex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PortedFrom(file="DLConceptTaxonomy.h", name="runBottomUp")
    public void runBottomUp() {
        try {
            if (this.propagateUp()) {
                return;
            }
            if (this.isEqualToTop()) {
                return;
            }
            if (this.pTax.queryMode()) {
                this.searchBaader(this.pTax.getBottomVertex());
                return;
            }
            for (int i = 0; i < this.common.size(); ++i) {
                TaxonomyVertex p = this.common.get(i);
                if (!p.noNeighbours(false)) continue;
                this.searchBaader(p);
            }
        }
        finally {
            this.clearCommon();
        }
    }

    @Override
    @PortedFrom(file="DLConceptTaxonomy.h", name="preClassificationActions")
    public void preClassificationActions() {
        ++this.nConcepts;
        this.tBox.getOptions().getProgressMonitor().reasonerTaskProgressChanged((int)this.nConcepts, this.tBox.getNItems());
    }

    public DLConceptTaxonomy(Taxonomy pTax, TBox tbox) {
        super(pTax);
        this.tBox = tbox;
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="setBottomUp")
    public void setBottomUp(KBFlags GCIs) {
        this.flagNeedBottomUp = GCIs.isGCI() || GCIs.isReflexive() && GCIs.isRnD();
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="isUnsatisfiable")
    private boolean isUnsatisfiable() {
        Concept p = this.curConcept();
        if (this.tBox.isSatisfiable(p)) {
            return false;
        }
        this.pTax.addCurrentToSynonym(this.pTax.getBottomVertex());
        return true;
    }

    @Override
    @PortedFrom(file="DLConceptTaxonomy.h", name="buildSignature")
    public TSignature buildSignature(ClassifiableEntry p) {
        return this.tBox.getSignature(p);
    }

    @Override
    @PortedFrom(file="DLConceptTaxonomy.h", name="immediatelyClassified")
    protected boolean immediatelyClassified() {
        if (this.classifySynonym()) {
            return true;
        }
        if (this.curConcept().getClassTagPlain() == Concept.CTTag.cttTrueCompletelyDefined) {
            return false;
        }
        this.tBox.initCache(this.curConcept(), false);
        return this.isUnsatisfiable();
    }

    @Override
    @PortedFrom(file="DLConceptTaxonomy.h", name="needTopDown")
    protected boolean needTopDown() {
        return !this.useCompletelyDefined || !this.curEntry.isCompletelyDefined();
    }

    @Override
    @PortedFrom(file="DLConceptTaxonomy.h", name="needBottomUp")
    protected boolean needBottomUp() {
        return this.flagNeedBottomUp || !this.useCompletelyDefined || !this.curConcept().isPrimitive();
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="testSub")
    private boolean testSub(Concept p, Concept q) {
        assert (p != null);
        assert (q != null);
        if (q.isSingleton() && q.isPrimitive() && !q.isNominal()) {
            return false;
        }
        this.tBox.getOptions().getLog().printTemplate(Templates.TAX_TRYING, p.getName(), q.getName());
        if (this.tBox.testSortedNonSubsumption(p, q)) {
            this.tBox.getOptions().getLog().print("NOT holds (sorted result)");
            ++this.nSortedNegative;
            return false;
        }
        if (this.isNotInModule(q.getEntity())) {
            this.tBox.getOptions().getLog().print("NOT holds (module result)");
            ++this.nModuleNegative;
            return false;
        }
        switch (this.tBox.testCachedNonSubsumption(p, q)) {
            case csValid: {
                this.tBox.getOptions().getLog().print("NOT holds (cached result)");
                ++this.nCachedNegative;
                return false;
            }
            case csInvalid: {
                this.tBox.getOptions().getLog().print("holds (cached result)");
                ++this.nCachedPositive;
                return true;
            }
        }
        this.tBox.getOptions().getLog().print("wasted cache test");
        return this.testSubTBox(p, q);
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="isNotInModule")
    private boolean isNotInModule(NamedEntity entity) {
        if (this.upDirection) {
            return false;
        }
        TSignature sig = (TSignature)this.sigStack.peek();
        return sig != null && entity != null && !sig.containsNamedEntity(entity);
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="testSubTBox")
    private boolean testSubTBox(Concept p, Concept q) {
        boolean res = this.tBox.isSubHolds(p, q);
        ++this.nTries;
        if (res) {
            ++this.nPositives;
        } else {
            ++this.nNegatives;
        }
        return res;
    }

    @Override
    public String toString() {
        StringBuilder o = new StringBuilder();
        o.append(String.format(Templates.DLCONCEPTTAXONOMY.getTemplate(), this.nTries, this.nPositives, this.nPositives * 100L / Math.max(1L, this.nTries), this.nCachedPositive, this.nCachedNegative, this.nSortedNegative > 0L ? String.format("Sorted reasoning deals with %s non-subsumptions\n", this.nSortedNegative) : "", this.nModuleNegative > 0L ? "Modular reasoning deals with " + this.nModuleNegative + " non-subsumptions\n" : "", this.nSearchCalls, this.nSubCalls, this.nNonTrivialSubCalls, (long)(this.nEntries * (this.nEntries - 1)) / Math.max(1L, this.nTries)));
        o.append(super.toString());
        return o.toString();
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="searchBaader")
    private void searchBaader(TaxonomyVertex cur) {
        this.pTax.setVisited(cur);
        ++this.nSearchCalls;
        boolean noPosSucc = true;
        for (TaxonomyVertex p : cur.neigh(this.upDirection)) {
            if (!this.enhancedSubs(p)) continue;
            if (!this.pTax.isVisited(p)) {
                this.searchBaader(p);
            }
            noPosSucc = false;
        }
        if (!this.isValued(cur)) {
            this.setValue(cur, this.testSubsumption(cur));
        }
        if (noPosSucc && cur.getValue()) {
            this.pTax.getCurrent().addNeighbour(!this.upDirection, cur);
        }
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="enhancedSubs1")
    private boolean enhancedSubs1(TaxonomyVertex cur) {
        ++this.nNonTrivialSubCalls;
        for (TaxonomyVertex n : cur.neigh(!this.upDirection)) {
            if (this.enhancedSubs(n)) continue;
            return false;
        }
        return this.testSubsumption(cur);
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="enhancedSubs2")
    private boolean enhancedSubs2(TaxonomyVertex cur) {
        if (this.upDirection && !cur.isCommon()) {
            return false;
        }
        if (this.useCandidates && this.candidates.contains(cur)) {
            return false;
        }
        return this.enhancedSubs1(cur);
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="possibleSub")
    private boolean possibleSub(TaxonomyVertex v) {
        Concept C = (Concept)v.getPrimer();
        if (!C.isPrimitive()) {
            return true;
        }
        return ((KnownSubsumers)this.ksStack.peek()).isPossibleSub(C);
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="testSubsumption")
    private boolean testSubsumption(TaxonomyVertex cur) {
        Concept testC = (Concept)cur.getPrimer();
        if (this.upDirection) {
            return this.testSub(testC, this.curConcept());
        }
        return this.testSub(this.curConcept(), testC);
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="propagateOneCommon")
    private void propagateOneCommon(TaxonomyVertex node) {
        if (this.pTax.isVisited(node)) {
            return;
        }
        this.pTax.setVisited(node);
        node.setCommon();
        if (node.correctCommon(this.nCommon)) {
            this.common.add(node);
        }
        for (TaxonomyVertex n : node.neigh(false)) {
            this.propagateOneCommon(n);
        }
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="propagateUp")
    private boolean propagateUp() {
        this.nCommon = 1;
        Iterator<TaxonomyVertex> list = this.pTax.getCurrent().neigh(this.upDirection).iterator();
        assert (list.hasNext());
        TaxonomyVertex p = list.next();
        this.propagateOneCommon(p);
        this.pTax.clearVisited();
        while (list.hasNext()) {
            p = list.next();
            if (p.noNeighbours(!this.upDirection)) {
                return true;
            }
            if (this.common.isEmpty()) {
                return true;
            }
            ++this.nCommon;
            ArrayList<TaxonomyVertex> aux = new ArrayList<TaxonomyVertex>(this.common);
            this.common.clear();
            this.propagateOneCommon(p);
            this.pTax.clearVisited();
            int auxSize = aux.size();
            for (int j = 0; j < auxSize; ++j) {
                ((TaxonomyVertex)aux.get(j)).correctCommon(this.nCommon);
            }
        }
        return false;
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="clearCommon")
    private void clearCommon() {
        int size = this.common.size();
        for (int i = 0; i < size; ++i) {
            this.common.get(i).clearCommon();
        }
        this.common.clear();
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="isEqualToTop")
    private boolean isEqualToTop() {
        ModelCacheInterface cache = this.tBox.initCache(this.curConcept(), true);
        if (cache.getState() != ModelCacheState.csInvalid) {
            return false;
        }
        this.pTax.current.addNeighbour(false, this.pTax.getTopVertex());
        return true;
    }

    @Override
    @PortedFrom(file="DLConceptTaxonomy.h", name="classifySynonym")
    protected boolean classifySynonym() {
        Individual curI;
        if (super.classifySynonym()) {
            return true;
        }
        if (this.curConcept().isSingleton() && this.tBox.isBlockedInd(curI = (Individual)this.curConcept())) {
            Individual syn = this.tBox.getBlockingInd(curI);
            assert (syn.getTaxVertex() != null);
            if (this.tBox.isBlockingDet(curI)) {
                this.pTax.addCurrentToSynonym(syn.getTaxVertex());
                return true;
            }
            this.tBox.getOptions().getLog().print((Object)"\nTAX: trying '", (Object)curI.getName(), (Object)"' = '", (Object)syn.getName(), (Object)"'... ");
            if (this.testSubTBox(curI, syn)) {
                this.pTax.addCurrentToSynonym(syn.getTaxVertex());
                return true;
            }
        }
        return false;
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="checkExtraParents")
    private void checkExtraParents() {
        for (TaxonomyVertex p : this.pTax.current.neigh(true)) {
            this.propagateTrueUp(p);
        }
        this.pTax.current.clearLinks(true);
        this.runTopDown();
        ArrayList<TaxonomyVertex> vec = new ArrayList<TaxonomyVertex>();
        for (TaxonomyVertex p : this.pTax.current.neigh(true)) {
            if (this.isDirectParent(p)) continue;
            vec.add(p);
        }
        for (TaxonomyVertex p : vec) {
            p.removeLink(false, this.pTax.current);
            this.pTax.current.removeLink(true, p);
        }
        this.clearLabels();
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="mergeVertex")
    private void mergeVertex(TaxonomyVertex cur, TaxonomyVertex v, Set<TaxonomyVertex> excludes) {
        if (!cur.equals(v)) {
            cur.mergeIndepNode(v, excludes, this.curEntry);
            this.pTax.removeNode(v);
        }
    }

    public void fillCandidates(TaxonomyVertex cur) {
        if (this.isValued(cur)) {
            if (this.getValue(cur)) {
                return;
            }
        } else {
            this.candidates.add(cur);
        }
        for (TaxonomyVertex p : cur.neigh(true)) {
            this.fillCandidates(p);
        }
    }

    public void reclassify(Set<NamedEntity> plus, Set<NamedEntity> minus) {
        this.MPlus = plus;
        this.MMinus = minus;
        this.pTax.deFinalise();
        LinkedList<TaxonomyVertex> queue = new LinkedList<TaxonomyVertex>();
        ArrayList<ClassifiableEntry> toProcess = new ArrayList<ClassifiableEntry>();
        queue.add(this.pTax.getTopVertex());
        while (!queue.isEmpty()) {
            TaxonomyVertex cur = (TaxonomyVertex)queue.remove(0);
            if (this.pTax.isVisited(cur)) continue;
            this.pTax.setVisited(cur);
            ClassifiableEntry entry = cur.getPrimer();
            if (this.MPlus.contains(entry.getEntity()) || this.MMinus.contains(entry.getEntity())) {
                toProcess.add(entry);
            }
            for (TaxonomyVertex t : cur.neigh(false)) {
                queue.add(t);
            }
        }
        this.pTax.clearVisited();
        for (int i = 0; i < toProcess.size(); ++i) {
            ClassifiableEntry p = (ClassifiableEntry)toProcess.get(i);
            this.reclassify(p.getTaxVertex(), this.tBox.getSignature(p));
        }
        this.pTax.finalise();
    }

    public void reclassify(TaxonomyVertex node, TSignature s) {
        this.upDirection = false;
        this.sigStack.add(s);
        this.curEntry = node.getPrimer();
        TaxonomyVertex oldCur = this.pTax.getCurrent();
        this.pTax.setCurrent(node);
        boolean added = this.MPlus.contains(this.curEntry.getEntity());
        boolean removed = this.MMinus.contains(this.curEntry.getEntity());
        assert (added || removed);
        this.clearLabels();
        this.setValue(this.pTax.getTopVertex(), true);
        if (node.noNeighbours(true)) {
            node.addNeighbour(true, this.pTax.getTopVertex());
        }
        this.useCandidates = !added;
        this.candidates.clear();
        if (removed) {
            ArrayList<TaxonomyVertex> neg = new ArrayList<TaxonomyVertex>();
            for (TaxonomyVertex p : node.neigh(true)) {
                if (this.isValued(p) && this.getValue(p)) continue;
                boolean sub = this.testSubsumption(p);
                if (sub) {
                    this.propagateTrueUp(p);
                    continue;
                }
                this.setValue(p, sub);
                neg.add(p);
            }
            node.removeLinks(true);
            if (this.useCandidates) {
                for (TaxonomyVertex q : neg) {
                    this.fillCandidates(q);
                }
            }
        } else {
            for (TaxonomyVertex p : node.neigh(true)) {
                this.propagateTrueUp(p);
            }
            node.removeLinks(true);
        }
        this.setValue(node, true);
        this.searchBaader(this.pTax.getTopVertex());
        node.incorporate(this.pTax.getOptions());
        this.clearLabels();
        this.sigStack.pop();
        this.pTax.setCurrent(oldCur);
    }
}

