/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.helpers;

import uk.ac.manchester.cs.jfact.helpers.DLVertex;

public enum StatIndex {
    Depth,
    Size,
    Branch,
    Gener,
    Freq;


    public int getIndex(boolean pos) {
        return this.ordinal() * 2 + (pos ? 0 : 1);
    }

    public static int choose(char c) {
        switch (c) {
            case 'S': {
                return Size.getIndex(false);
            }
            case 'D': {
                return Depth.getIndex(false);
            }
            case 'B': {
                return Branch.getIndex(false);
            }
            case 'G': {
                return Gener.getIndex(false);
            }
        }
        return Freq.getIndex(false);
    }

    public static void updateStatValues(int d, int s, int b, int g, boolean pos, int[] stat) {
        int n = Size.getIndex(pos);
        stat[n] = stat[n] + s;
        int n2 = Branch.getIndex(pos);
        stat[n2] = stat[n2] + b;
        int n3 = Gener.getIndex(pos);
        stat[n3] = stat[n3] + g;
        if (d > stat[Depth.getIndex(pos)]) {
            stat[StatIndex.Depth.getIndex((boolean)pos)] = d;
        }
    }

    public static void updateStatValues(DLVertex v, boolean posV, boolean pos, int[] stat) {
        StatIndex.updateStatValues(StatIndex.getDepth(posV, v.stat), StatIndex.getSize(posV, v.stat), StatIndex.getBranch(posV, v.stat), StatIndex.getGener(posV, v.stat), pos, stat);
    }

    public static void incFreqValue(boolean pos, int[] stat) {
        int n = Freq.getIndex(pos);
        stat[n] = stat[n] + 1;
    }

    public static int getDepth(boolean pos, int[] stat) {
        return stat[Depth.getIndex(pos)];
    }

    protected static int getSize(boolean pos, int[] stat) {
        return stat[Size.getIndex(pos)];
    }

    protected static int getBranch(boolean pos, int[] stat) {
        return stat[Branch.getIndex(pos)];
    }

    protected static int getGener(boolean pos, int[] stat) {
        return stat[Gener.getIndex(pos)];
    }

    protected static int getFreq(boolean pos, int[] stat) {
        return stat[Freq.getIndex(pos)];
    }
}

