/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.util.Collection;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.Facet;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;

public class LiteralEntry
extends NamedEntry {
    private static final long serialVersionUID = 11000L;
    private Literal<?> literal;
    private int pName = 0;

    public LiteralEntry(IRI name) {
        super(name);
    }

    public LiteralEntry(@Nonnull String name) {
        this(IRI.create((String)name));
    }

    public void setLiteral(Literal<?> l) {
        this.literal = l;
    }

    public Literal<?> getLiteral() {
        return this.literal;
    }

    @Nonnull
    public Datatype<?> getType() {
        return this.literal.getDatatypeExpression();
    }

    public Collection<Facet> getFacet() {
        return this.literal.getDatatypeExpression().getFacets();
    }

    @Override
    public int getIndex() {
        return this.pName;
    }

    @Override
    public void setIndex(int p) {
        this.pName = p;
    }

    @Override
    @Nonnull
    public String toString() {
        return '(' + this.getClass().getSimpleName() + ' ' + this.literal.toString() + super.toString() + ')';
    }

    @Override
    public int hashCode() {
        return this.literal.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof LiteralEntry)) {
            return false;
        }
        return this.literal.equals(((LiteralEntry)obj).literal);
    }

    @Nonnull
    public LiteralEntry withLiteral(Literal<?> l) {
        this.setLiteral(l);
        return this;
    }

    @Nonnull
    public LiteralEntry withIndex(int i) {
        this.setIndex(i);
        return this;
    }
}

