/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.util.Collection;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import uk.ac.manchester.cs.jfact.datatypes.ABSTRACT_DATATYPE;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeExpression;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facet;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.datatypes.OrderedDatatype;
import uk.ac.manchester.cs.jfact.datatypes.Utils;
import uk.ac.manchester.cs.jfact.datatypes.cardinality;
import uk.ac.manchester.cs.jfact.datatypes.ordered;

class DatatypeOrderedExpressionImpl<O extends Comparable<O>>
extends ABSTRACT_DATATYPE<O>
implements DatatypeExpression<O>,
OrderedDatatype<O> {
    private static final long serialVersionUID = 11000L;
    @Nonnull
    private final Datatype<O> host;

    public DatatypeOrderedExpressionImpl(Datatype<O> b) {
        super(IRI.create((String)(b.getDatatypeIRI() + "_" + DatatypeFactory.getIndex())), b.getFacets(), Utils.generateAncestors(DatatypeOrderedExpressionImpl.host(b)));
        this.host = DatatypeOrderedExpressionImpl.host(b);
        this.knownNumericFacetValues.putAll(b.getKnownNumericFacetValues());
        this.knownNonNumericFacetValues.putAll(b.getKnownNonNumericFacetValues());
    }

    @Override
    public O parseValue(String s) {
        return this.host.parseValue(s);
    }

    @Override
    public boolean isInValueSpace(O l) {
        if (this.hasMinExclusive() && l.compareTo(this.getMin()) <= 0) {
            return false;
        }
        if (this.hasMinInclusive() && l.compareTo(this.getMin()) < 0) {
            return false;
        }
        if (this.hasMaxExclusive() && l.compareTo(this.getMax()) >= 0) {
            return false;
        }
        return !this.hasMaxInclusive() || l.compareTo(this.getMax()) <= 0;
    }

    @Override
    public boolean isCompatible(Datatype<?> type) {
        if (type.equals(DatatypeFactory.LITERAL)) {
            return true;
        }
        if (type.isOrderedDatatype()) {
            OrderedDatatype<?> wrapper = type.asOrderedDatatype();
            if (!this.hasMax() && !this.hasMin()) {
                return true;
            }
            if (!wrapper.hasMax() && !wrapper.hasMin()) {
                return true;
            }
            if (!this.hasMax() && !wrapper.hasMax()) {
                return true;
            }
            if (!this.hasMin() && !wrapper.hasMin()) {
                return true;
            }
            if (!this.hasMin()) {
                return this.overlapping(this, wrapper);
            }
            if (!this.hasMax()) {
                return this.overlapping(wrapper, this);
            }
            if (!wrapper.hasMin()) {
                return this.overlapping(wrapper, this);
            }
            if (!wrapper.hasMax()) {
                return this.overlapping(this, wrapper);
            }
            return this.overlapping(this, wrapper) || this.overlapping(wrapper, this);
        }
        return false;
    }

    @Override
    public ordered getOrdered() {
        return this.host.getOrdered();
    }

    @Override
    public boolean getNumeric() {
        return this.host.getNumeric();
    }

    @Override
    public cardinality getCardinality() {
        return this.host.getCardinality();
    }

    @Override
    public boolean getBounded() {
        return this.host.getBounded();
    }

    @Override
    public Collection<Literal<O>> listValues() {
        return this.host.listValues();
    }

    @Override
    public Datatype<O> getHostType() {
        return this.host;
    }

    @Override
    public DatatypeExpression<O> addNonNumericFacet(Facet f, Comparable<?> value) {
        if (!this.facets.contains(f)) {
            throw new IllegalArgumentException("Facet " + f + " not allowed tor datatype " + this.getHostType());
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        if (value instanceof Literal && !this.host.isCompatible((Literal)value)) {
            throw new IllegalArgumentException("Not a valid value for this expression: " + f + '\t' + value + " for: " + this);
        }
        DatatypeOrderedExpressionImpl<O> toReturn = new DatatypeOrderedExpressionImpl<O>(this.host);
        toReturn.knownNumericFacetValues.putAll(this.knownNumericFacetValues);
        toReturn.knownNonNumericFacetValues.putAll(this.knownNonNumericFacetValues);
        toReturn.knownNonNumericFacetValues.put(f, value);
        return toReturn;
    }

    @Override
    public DatatypeExpression<O> addNumericFacet(Facet f, Comparable<?> value) {
        if (!this.facets.contains(f)) {
            throw new IllegalArgumentException("Facet " + f + " not allowed tor datatype " + this.getHostType());
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        DatatypeOrderedExpressionImpl<O> toReturn = new DatatypeOrderedExpressionImpl<O>(this.host);
        toReturn.knownNumericFacetValues.putAll(this.knownNumericFacetValues);
        toReturn.knownNonNumericFacetValues.putAll(this.knownNonNumericFacetValues);
        if (f.equals(Facets.minExclusive) || f.equals(Facets.minInclusive)) {
            toReturn.knownNumericFacetValues.remove(Facets.minExclusive);
            toReturn.knownNumericFacetValues.remove(Facets.minInclusive);
        }
        if (f.equals(Facets.maxExclusive) || f.equals(Facets.maxInclusive)) {
            toReturn.knownNumericFacetValues.remove(Facets.maxExclusive);
            toReturn.knownNumericFacetValues.remove(Facets.maxInclusive);
        }
        toReturn.knownNumericFacetValues.put(f, value);
        return toReturn;
    }

    @Override
    public boolean isExpression() {
        return true;
    }

    @Override
    public boolean emptyValueSpace() {
        if (this.getNumeric()) {
            Comparable max;
            int excluded = 0;
            Comparable min = this.getNumericFacetValue(Facets.minInclusive);
            if (min == null) {
                min = this.getNumericFacetValue(Facets.minExclusive);
                ++excluded;
            }
            if ((max = this.getNumericFacetValue(Facets.maxInclusive)) == null) {
                max = this.getNumericFacetValue(Facets.maxExclusive);
                ++excluded;
            }
            return !DatatypeFactory.intervalWithValues(min, max, excluded);
        }
        return false;
    }

    @Override
    public boolean isNumericDatatype() {
        return this.host.isNumericDatatype();
    }

    @Override
    public boolean isOrderedDatatype() {
        return this.host.isOrderedDatatype();
    }

    @Override
    public OrderedDatatype<O> asOrderedDatatype() {
        return this;
    }

    @Override
    public boolean hasMinExclusive() {
        return this.knownNumericFacetValues.containsKey(Facets.minExclusive);
    }

    @Override
    public boolean hasMinInclusive() {
        return this.knownNumericFacetValues.containsKey(Facets.minInclusive);
    }

    @Override
    public boolean hasMaxExclusive() {
        return this.knownNumericFacetValues.containsKey(Facets.maxExclusive);
    }

    @Override
    public boolean hasMaxInclusive() {
        return this.knownNumericFacetValues.containsKey(Facets.maxInclusive);
    }

    @Override
    public boolean hasMin() {
        return this.hasMinInclusive() || this.hasMinExclusive();
    }

    @Override
    public boolean hasMax() {
        return this.hasMaxInclusive() || this.hasMaxExclusive();
    }

    @Override
    public O getMin() {
        if (this.hasMinInclusive()) {
            return (O)((Comparable)this.knownNumericFacetValues.get(Facets.minInclusive));
        }
        if (this.hasMinExclusive()) {
            return (O)((Comparable)this.knownNumericFacetValues.get(Facets.minExclusive));
        }
        return null;
    }

    @Override
    public O getMax() {
        if (this.hasMaxInclusive()) {
            return (O)((Comparable)this.knownNumericFacetValues.get(Facets.maxInclusive));
        }
        if (this.hasMaxExclusive()) {
            return (O)((Comparable)this.knownNumericFacetValues.get(Facets.maxExclusive));
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + '(' + this.host.toString() + "(extra facets:" + this.knownNumericFacetValues + "))";
    }
}

