/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact;

import conformance.Original;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.parameters.AxiomAnnotations;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.knowledgeexploration.OWLKnowledgeExplorerReasoner;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.Version;
import uk.ac.manchester.cs.jfact.TranslationMachinery;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.ExpressionCache;
import uk.ac.manchester.cs.jfact.kernel.Individual;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.Ontology;
import uk.ac.manchester.cs.jfact.kernel.ReasonerFreshEntityException;
import uk.ac.manchester.cs.jfact.kernel.ReasoningKernel;
import uk.ac.manchester.cs.jfact.kernel.actors.ClassPolicy;
import uk.ac.manchester.cs.jfact.kernel.actors.DataPropertyPolicy;
import uk.ac.manchester.cs.jfact.kernel.actors.IndividualPolicy;
import uk.ac.manchester.cs.jfact.kernel.actors.ObjectPropertyPolicy;
import uk.ac.manchester.cs.jfact.kernel.actors.TaxonomyActor;
import uk.ac.manchester.cs.jfact.kernel.dl.IndividualName;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.AxiomInterface;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.IndividualExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;
import uk.ac.manchester.cs.jfact.split.ModuleType;
import uk.ac.manchester.cs.jfact.split.TOntologyAtom;

public class JFactReasoner
implements OWLReasoner,
OWLOntologyChangeListener,
OWLKnowledgeExplorerReasoner,
Serializable {
    private static final long serialVersionUID = 10000L;
    protected final AtomicBoolean interrupted = new AtomicBoolean(false);
    private ReasoningKernel kernel;
    private final ExpressionCache em;
    @Nonnull
    private static final EnumSet<InferenceType> supportedInferenceTypes = EnumSet.of(InferenceType.CLASS_ASSERTIONS, InferenceType.CLASS_HIERARCHY, InferenceType.DATA_PROPERTY_HIERARCHY, InferenceType.OBJECT_PROPERTY_HIERARCHY, InferenceType.SAME_INDIVIDUAL);
    private static final Collection<AxiomType<?>> types = Arrays.asList(AxiomType.CLASS_ASSERTION, AxiomType.OBJECT_PROPERTY_ASSERTION, AxiomType.OBJECT_PROPERTY_RANGE, AxiomType.FUNCTIONAL_OBJECT_PROPERTY, AxiomType.DIFFERENT_INDIVIDUALS, AxiomType.EQUIVALENT_CLASSES, AxiomType.SYMMETRIC_OBJECT_PROPERTY, AxiomType.DATA_PROPERTY_DOMAIN, AxiomType.SUBCLASS_OF, AxiomType.DATA_PROPERTY_RANGE, AxiomType.TRANSITIVE_OBJECT_PROPERTY, AxiomType.DISJOINT_CLASSES, AxiomType.INVERSE_OBJECT_PROPERTIES, AxiomType.OBJECT_PROPERTY_DOMAIN, AxiomType.SUB_OBJECT_PROPERTY, AxiomType.DATA_PROPERTY_ASSERTION, AxiomType.DISJOINT_OBJECT_PROPERTIES, AxiomType.EQUIVALENT_OBJECT_PROPERTIES, AxiomType.SUB_PROPERTY_CHAIN_OF, AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, AxiomType.ASYMMETRIC_OBJECT_PROPERTY, AxiomType.REFLEXIVE_OBJECT_PROPERTY, AxiomType.IRREFLEXIVE_OBJECT_PROPERTY, AxiomType.DISJOINT_DATA_PROPERTIES, AxiomType.SUB_DATA_PROPERTY, AxiomType.EQUIVALENT_DATA_PROPERTIES, AxiomType.FUNCTIONAL_DATA_PROPERTY, AxiomType.DATATYPE_DEFINITION, AxiomType.DISJOINT_UNION, AxiomType.SAME_INDIVIDUAL, AxiomType.HAS_KEY, AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION, AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION, AxiomType.SUB_ANNOTATION_PROPERTY_OF, AxiomType.ANNOTATION_PROPERTY_DOMAIN, AxiomType.ANNOTATION_ASSERTION, AxiomType.ANNOTATION_PROPERTY_RANGE, AxiomType.SWRL_RULE, AxiomType.DECLARATION);
    @Nonnull
    private final OWLOntology root;
    @Nonnull
    private final BufferingMode bufferingMode;
    @Nonnull
    private final List<OWLOntologyChange> rawChanges = new ArrayList<OWLOntologyChange>();
    @Nonnull
    private final Set<OWLAxiom> reasonerAxioms = new LinkedHashSet<OWLAxiom>();
    @Original
    private final JFactReasonerConfiguration configuration;
    private final OWLDataFactory df;
    protected TranslationMachinery tr;
    private Boolean consistencyVerified = null;
    private final Set<OWLEntity> knownEntities = new HashSet<OWLEntity>();
    private final DatatypeFactory datatypeFactory;

    public JFactReasoner(@Nonnull OWLOntology o, @Nonnull OWLReasonerConfiguration c, @Nonnull BufferingMode b) {
        this(o, c instanceof JFactReasonerConfiguration ? (JFactReasonerConfiguration)c : new JFactReasonerConfiguration(c), b);
    }

    public JFactReasoner(@Nonnull OWLOntology rootOntology, @Nonnull Collection<OWLAxiom> axioms, @Nonnull JFactReasonerConfiguration config, @Nonnull BufferingMode bufferingMode) {
        this.configuration = config;
        this.root = rootOntology;
        this.df = this.root.getOWLOntologyManager().getOWLDataFactory();
        this.datatypeFactory = DatatypeFactory.getInstance();
        this.kernel = new ReasoningKernel(this.configuration, this.datatypeFactory);
        this.em = this.kernel.getExpressionManager();
        this.bufferingMode = bufferingMode;
        this.knownEntities.add((OWLEntity)this.df.getOWLThing());
        this.knownEntities.add((OWLEntity)this.df.getOWLNothing());
        for (OWLOntology o : this.root.getImportsClosure()) {
            this.knownEntities.addAll(o.getSignature());
        }
        this.kernel.setInterruptedSwitch(this.interrupted);
        this.kernel.clearKB();
        this.configuration.getProgressMonitor().reasonerTaskStarted("Loading");
        this.configuration.getProgressMonitor().reasonerTaskBusy();
        this.tr = new TranslationMachinery(this.kernel, this.df, this.datatypeFactory);
        this.reasonerAxioms.addAll(axioms);
        this.tr.loadAxioms(this.reasonerAxioms);
        this.configuration.getProgressMonitor().reasonerTaskStopped();
    }

    @Nonnull
    public static Collection<OWLAxiom> importsIncluded(OWLOntology ont) {
        ArrayList<OWLAxiom> axioms = new ArrayList<OWLAxiom>();
        for (AxiomType<?> t : types) {
            axioms.addAll(ont.getAxioms(t, Imports.INCLUDED));
        }
        return axioms;
    }

    public JFactReasoner(@Nonnull OWLOntology rootOntology, @Nonnull JFactReasonerConfiguration config, @Nonnull BufferingMode bufferingMode) {
        this(rootOntology, JFactReasoner.importsIncluded(rootOntology), config, bufferingMode);
    }

    public JFactReasonerConfiguration getConfiguration() {
        return this.configuration;
    }

    public Ontology getOntology() {
        return this.kernel.getOntology();
    }

    public synchronized Node<OWLClass> getEquivalentClasses(OWLClassExpression ce) {
        Collection<Object> pointers = Collections.emptyList();
        if (!this.isFreshName(ce)) {
            this.checkConsistency();
            pointers = this.kernel.getEquivalentConcepts(this.tr.pointer(ce), this.classActor()).getSynonyms();
        }
        return this.tr.getClassExpressionTranslator().node(pointers);
    }

    private boolean isFreshName(OWLClassExpression ce) {
        if (ce.isAnonymous()) {
            return false;
        }
        return !this.knownEntities.contains(ce.asOWLClass());
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
        this.rawChanges.addAll(changes);
        if (this.bufferingMode.equals((Object)BufferingMode.NON_BUFFERING)) {
            this.flush();
        }
    }

    public BufferingMode getBufferingMode() {
        return this.bufferingMode;
    }

    public long getTimeOut() {
        return this.configuration.getTimeOut();
    }

    public OWLOntology getRootOntology() {
        return this.root;
    }

    public synchronized List<OWLOntologyChange> getPendingChanges() {
        return new ArrayList<OWLOntologyChange>(this.rawChanges);
    }

    public synchronized Set<OWLAxiom> getPendingAxiomAdditions() {
        if (!this.rawChanges.isEmpty()) {
            HashSet<OWLAxiom> added = new HashSet<OWLAxiom>();
            this.computeDiff(added, new HashSet<OWLAxiom>());
            return added;
        }
        return Collections.emptySet();
    }

    public synchronized Set<OWLAxiom> getPendingAxiomRemovals() {
        if (!this.rawChanges.isEmpty()) {
            HashSet<OWLAxiom> removed = new HashSet<OWLAxiom>();
            this.computeDiff(new HashSet<OWLAxiom>(), removed);
            return removed;
        }
        return Collections.emptySet();
    }

    public synchronized void flush() {
        if (!this.rawChanges.isEmpty()) {
            HashSet<OWLAxiom> added = new HashSet<OWLAxiom>();
            HashSet<OWLAxiom> removed = new HashSet<OWLAxiom>();
            this.computeDiff(added, removed);
            this.rawChanges.clear();
            if (!added.isEmpty() || !removed.isEmpty()) {
                this.reasonerAxioms.removeAll(removed);
                this.reasonerAxioms.addAll(added);
                this.knownEntities.clear();
                for (OWLAxiom ax : this.reasonerAxioms) {
                    this.knownEntities.addAll(ax.getSignature());
                }
                this.consistencyVerified = null;
                this.handleChanges(added, removed);
            }
        }
    }

    private synchronized void computeDiff(Set<OWLAxiom> added, Set<OWLAxiom> removed) {
        for (OWLOntologyChange change : this.rawChanges) {
            OWLAxiom ax = change.getAxiom();
            if (change.isAddAxiom()) {
                if (this.reasonerAxioms.contains(ax) || this.reasonerAxioms.contains(ax.getAxiomWithoutAnnotations())) continue;
                added.add(ax);
                continue;
            }
            if (!change.isRemoveAxiom() || !this.reasonerAxioms.contains(ax) && !this.reasonerAxioms.contains(ax.getAxiomWithoutAnnotations())) continue;
            removed.add(change.getAxiom());
        }
        added.removeAll(removed);
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        return this.configuration.getFreshEntityPolicy();
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this.configuration.getIndividualNodeSetPolicy();
    }

    private synchronized void handleChanges(Set<OWLAxiom> addAxioms, Set<OWLAxiom> removeAxioms) {
        this.tr.loadAxioms(addAxioms);
        for (OWLAxiom ax_r : removeAxioms) {
            this.tr.retractAxiom(ax_r);
        }
    }

    public String getReasonerName() {
        return "JFact";
    }

    public Version getReasonerVersion() {
        return new Version(1, 2, 1, 0);
    }

    public void interrupt() {
        this.interrupted.set(true);
    }

    public synchronized void precomputeInferences(InferenceType ... inferenceTypes) {
        for (InferenceType it : inferenceTypes) {
            if (!supportedInferenceTypes.contains(it)) continue;
            if (!this.kernel.isKBRealised()) {
                this.kernel.realiseKB();
            }
            return;
        }
    }

    public boolean isPrecomputed(InferenceType inferenceType) {
        if (supportedInferenceTypes.contains(inferenceType)) {
            return this.kernel.isKBRealised();
        }
        return true;
    }

    public Set<InferenceType> getPrecomputableInferenceTypes() {
        return supportedInferenceTypes;
    }

    public synchronized boolean isConsistent() {
        if (this.consistencyVerified == null) {
            try {
                this.consistencyVerified = this.kernel.isKBConsistent();
            }
            catch (InconsistentOntologyException e) {
                this.consistencyVerified = Boolean.FALSE;
            }
        }
        return this.consistencyVerified;
    }

    private void checkConsistency() {
        if (this.interrupted.get()) {
            throw new ReasonerInterruptedException();
        }
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
    }

    public synchronized boolean isSatisfiable(OWLClassExpression classExpression) {
        this.checkConsistency();
        return this.kernel.isSatisfiable(this.tr.pointer(classExpression));
    }

    public Node<OWLClass> getUnsatisfiableClasses() {
        return this.getBottomClassNode();
    }

    public synchronized boolean isEntailed(OWLAxiom axiom) {
        this.checkConsistency();
        if (this.root.containsAxiom(axiom, Imports.INCLUDED, AxiomAnnotations.IGNORE_AXIOM_ANNOTATIONS)) {
            return true;
        }
        try {
            return (Boolean)axiom.accept((OWLAxiomVisitorEx)this.tr.getEntailmentChecker());
        }
        catch (ReasonerFreshEntityException e) {
            IRI iri = e.getIri();
            if (this.getFreshEntityPolicy() == FreshEntityPolicy.DISALLOW) {
                for (OWLEntity o : axiom.getSignature()) {
                    if (!o.getIRI().equals((Object)iri)) continue;
                    throw new FreshEntitiesException(o, (Throwable)((Object)e));
                }
                throw new FreshEntitiesException((Collection)axiom.getSignature(), (Throwable)((Object)e));
            }
            System.out.println("JFactReasoner.isEntailed() WARNING: fresh entity exception in the reasoner for entity: " + iri + "; defaulting to axiom not entailed");
            return false;
        }
    }

    public synchronized boolean isEntailed(Set<? extends OWLAxiom> axioms) {
        for (OWLAxiom oWLAxiom : axioms) {
            if (this.isEntailed((OWLAxiom)OWLAPIPreconditions.checkNotNull((Object)oWLAxiom))) continue;
            return false;
        }
        return true;
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        return !axiomType.equals((Object)AxiomType.SWRL_RULE);
    }

    public synchronized Set<OWLAxiom> getTrace(@Nonnull OWLAxiom axiom) {
        this.kernel.needTracing();
        if (this.isEntailed(axiom)) {
            return this.tr.translateTAxiomSet(this.kernel.getTrace());
        }
        return Collections.emptySet();
    }

    public Node<OWLClass> getTopClassNode() {
        return this.getEquivalentClasses((OWLClassExpression)this.df.getOWLThing());
    }

    public Node<OWLClass> getBottomClassNode() {
        return this.getEquivalentClasses((OWLClassExpression)this.df.getOWLNothing());
    }

    public synchronized NodeSet<OWLClass> getSubClasses(OWLClassExpression ce, boolean direct) {
        if (this.isFreshName(ce)) {
            if (this.configuration.getFreshEntityPolicy() == FreshEntityPolicy.DISALLOW) {
                throw new FreshEntitiesException((Collection)ce.getSignature());
            }
            return new OWLClassNodeSet(this.getBottomClassNode());
        }
        this.checkConsistency();
        List<Collection<ConceptExpression>> pointers = this.kernel.getConcepts(this.tr.pointer(ce), direct, this.classActor(), false).getElements();
        if (pointers.isEmpty() || pointers.get(0).isEmpty()) {
            pointers.add(this.kernel.getEquivalentConcepts(this.tr.pointer((OWLClassExpression)this.df.getOWLNothing()), this.classActor()).getSynonyms());
        }
        return this.tr.getClassExpressionTranslator().nodeSet(pointers);
    }

    public synchronized NodeSet<OWLClass> getSuperClasses(OWLClassExpression ce, boolean direct) {
        if (this.isFreshName(ce)) {
            return new OWLClassNodeSet(this.getTopClassNode());
        }
        this.checkConsistency();
        return this.tr.getClassExpressionTranslator().nodeSet(this.askSuperClasses(this.tr.pointer(ce), direct));
    }

    public synchronized NodeSet<OWLClass> getDisjointClasses(OWLClassExpression ce) {
        ConceptExpression p = this.tr.pointer(ce);
        return this.tr.getClassExpressionTranslator().nodeSet(this.kernel.getDisjointConcepts(p, this.classActor()).getElements());
    }

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        return this.getEquivalentObjectProperties((OWLObjectPropertyExpression)this.df.getOWLTopObjectProperty());
    }

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        return this.getEquivalentObjectProperties((OWLObjectPropertyExpression)this.df.getOWLBottomObjectProperty());
    }

    public synchronized NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression pe, boolean direct) {
        this.checkConsistency();
        return this.tr.getObjectPropertyTranslator().nodeSet(this.kernel.getRoles(this.tr.pointer(pe), direct, this.objectActor(), false).getElements());
    }

    public synchronized NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression pe, boolean direct) {
        this.checkConsistency();
        List<Collection<ObjectRoleExpression>> elements = this.kernel.getRoles(this.tr.pointer(pe), direct, this.objectActor(), true).getElements();
        if (elements.isEmpty() || elements.get(0).isEmpty()) {
            elements.add(this.kernel.getEquivalentRoles(this.tr.pointer((OWLObjectPropertyExpression)this.df.getOWLTopObjectProperty()), this.objectActor()).getSynonyms());
        }
        return this.tr.getObjectPropertyTranslator().nodeSet(elements);
    }

    public synchronized Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression pe) {
        this.checkConsistency();
        return this.tr.getObjectPropertyTranslator().node(this.kernel.getEquivalentRoles(this.tr.pointer(pe), this.objectActor()).getSynonyms());
    }

    public synchronized NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression pe) {
        this.checkConsistency();
        return new OWLObjectPropertyNodeSet(this.getBottomObjectPropertyNode());
    }

    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression pe) {
        return this.getEquivalentObjectProperties(pe.getInverseProperty());
    }

    public synchronized NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression pe, boolean direct) {
        this.checkConsistency();
        return this.tr.getClassExpressionTranslator().nodeSet(this.kernel.getORoleDomain(this.tr.pointer(pe), direct, this.classActor()).getElements());
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression pe, boolean direct) {
        return this.getObjectPropertyDomains(pe.getInverseProperty(), direct);
    }

    public Node<OWLDataProperty> getTopDataPropertyNode() {
        return new OWLDataPropertyNode(this.df.getOWLTopDataProperty());
    }

    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        OWLDataPropertyNode toReturn = new OWLDataPropertyNode();
        toReturn.add((OWLObject)this.df.getOWLBottomDataProperty());
        return toReturn;
    }

    public synchronized NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty pe, boolean direct) {
        this.checkConsistency();
        return this.tr.getDataPropertyTranslator().nodeSet(this.kernel.getRoles(this.tr.pointer((OWLDataPropertyExpression)pe), direct, this.dataActor(), false).getElements());
    }

    public synchronized NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty pe, boolean direct) {
        this.checkConsistency();
        List<Collection<DataRoleExpression>> elements = this.kernel.getRoles(this.tr.pointer((OWLDataPropertyExpression)pe), direct, this.dataActor(), true).getElements();
        if (elements.isEmpty() || elements.get(0).isEmpty()) {
            elements.add(this.kernel.getEquivalentRoles(this.tr.pointer((OWLDataPropertyExpression)this.df.getOWLTopDataProperty()), this.dataActor()).getSynonyms());
        }
        return this.tr.getDataPropertyTranslator().nodeSet(elements);
    }

    public synchronized Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty pe) {
        this.checkConsistency();
        DataRoleExpression p = this.tr.pointer((OWLDataPropertyExpression)pe);
        Collection<DataRoleExpression> dataPropertySynonyms = this.kernel.getEquivalentRoles(p, this.dataActor()).getSynonyms();
        return this.tr.getDataPropertyTranslator().node(dataPropertySynonyms);
    }

    public synchronized NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression pe) {
        this.checkConsistency();
        return new OWLDataPropertyNodeSet(this.getBottomDataPropertyNode());
    }

    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty pe, boolean direct) {
        return this.tr.getClassExpressionTranslator().nodeSet(this.kernel.getDRoleDomain(this.tr.pointer((OWLDataPropertyExpression)pe), direct, this.classActor()).getElements());
    }

    public synchronized NodeSet<OWLClass> getTypes(OWLNamedIndividual ind, boolean direct) {
        this.checkConsistency();
        List<Collection<ConceptExpression>> classElements = this.kernel.getTypes(this.tr.pointer((OWLIndividual)ind), direct, this.classActor()).getElements();
        return this.tr.getClassExpressionTranslator().nodeSet(classElements);
    }

    private TaxonomyActor<ConceptExpression> classActor() {
        return new TaxonomyActor<ConceptExpression>(this.em, new ClassPolicy());
    }

    private TaxonomyActor<ObjectRoleExpression> objectActor() {
        return new TaxonomyActor<ObjectRoleExpression>(this.em, new ObjectPropertyPolicy());
    }

    private TaxonomyActor<DataRoleExpression> dataActor() {
        return new TaxonomyActor<DataRoleExpression>(this.em, new DataPropertyPolicy());
    }

    private <T extends Expression> TaxonomyActor<T> individualActor(Class<T> t) {
        return new TaxonomyActor(this.em, new IndividualPolicy(true));
    }

    public synchronized NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression ce, boolean direct) {
        this.checkConsistency();
        TaxonomyActor<IndividualExpression> actor = this.kernel.getInstances(this.tr.pointer(ce), this.individualActor(IndividualExpression.class), direct);
        return this.tr.translateNodeSet((Iterable<IndividualExpression>)actor.getElements().iterator().next());
    }

    public synchronized NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual ind, OWLObjectPropertyExpression pe) {
        this.checkConsistency();
        List<Individual> fillers = this.kernel.getRoleFillers(this.tr.pointer((OWLIndividual)ind), this.tr.pointer(pe));
        ArrayList<IndividualExpression> acc = new ArrayList<IndividualExpression>();
        for (NamedEntry namedEntry : fillers) {
            acc.add(this.em.individual(namedEntry.getName()));
        }
        return this.tr.translateNodeSet(acc);
    }

    public synchronized Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual ind, OWLDataProperty pe) {
        this.checkConsistency();
        return Collections.emptySet();
    }

    public synchronized Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual ind) {
        this.checkConsistency();
        return this.tr.getIndividualTranslator().node(this.kernel.getSameAs(this.tr.pointer((OWLIndividual)ind), this.individualActor(IndividualName.class)).getSynonyms());
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual ind) {
        OWLClassExpression ce = this.df.getOWLObjectOneOf(new OWLIndividual[]{ind}).getObjectComplementOf();
        return this.getInstances(ce, false);
    }

    public synchronized void dispose() {
        this.root.getOWLOntologyManager().removeOntologyChangeListener((OWLOntologyChangeListener)this);
        this.tr = null;
        this.kernel = null;
    }

    public void dumpClassHierarchy(LogAdapter pw, boolean includeBottomNode) {
        this.dumpSubClasses(this.getTopClassNode(), pw, 0, includeBottomNode);
    }

    private void dumpSubClasses(Node<OWLClass> node, LogAdapter pw, int depth, boolean includeBottomNode) {
        if (includeBottomNode || !node.isBottomNode()) {
            for (int i = 0; i < depth; ++i) {
                pw.print("    ");
            }
            pw.print((Object)node);
            pw.println();
            for (Node sub : this.getSubClasses((OWLClassExpression)node.getRepresentativeElement(), true)) {
                this.dumpSubClasses((Node<OWLClass>)sub, pw, depth + 1, includeBottomNode);
            }
        }
    }

    private Collection<Collection<ConceptExpression>> askSuperClasses(ConceptExpression arg, boolean direct) {
        return this.kernel.getConcepts(arg, direct, this.classActor(), true).getElements();
    }

    public synchronized void writeReasoningResult(long time) {
        this.kernel.writeReasoningResult(time);
    }

    public OWLKnowledgeExplorerReasoner.RootNode getRoot(OWLClassExpression expression) {
        return new RootNodeImpl(this.kernel.buildCompletionTree(this.tr.pointer(expression)));
    }

    public Node<? extends OWLObjectPropertyExpression> getObjectNeighbours(OWLKnowledgeExplorerReasoner.RootNode object, boolean deterministicOnly) {
        return this.tr.getObjectPropertyTranslator().node(this.kernel.getObjectRoles((DlCompletionTree)object.getNode(), deterministicOnly, false));
    }

    public Node<OWLDataProperty> getDataNeighbours(OWLKnowledgeExplorerReasoner.RootNode object, boolean deterministicOnly) {
        return this.tr.getDataPropertyTranslator().node(this.kernel.getDataRoles((DlCompletionTree)object.getNode(), deterministicOnly));
    }

    public Collection<OWLKnowledgeExplorerReasoner.RootNode> getObjectNeighbours(OWLKnowledgeExplorerReasoner.RootNode n, OWLObjectProperty property) {
        ArrayList<OWLKnowledgeExplorerReasoner.RootNode> toReturn = new ArrayList<OWLKnowledgeExplorerReasoner.RootNode>();
        for (DlCompletionTree t : this.kernel.getNeighbours((DlCompletionTree)n.getNode(), this.tr.pointer((OWLObjectPropertyExpression)property))) {
            toReturn.add(new RootNodeImpl((DlCompletionTree)OWLAPIPreconditions.checkNotNull((Object)t)));
        }
        return toReturn;
    }

    public Collection<OWLKnowledgeExplorerReasoner.RootNode> getDataNeighbours(OWLKnowledgeExplorerReasoner.RootNode n, OWLDataProperty property) {
        ArrayList<OWLKnowledgeExplorerReasoner.RootNode> toReturn = new ArrayList<OWLKnowledgeExplorerReasoner.RootNode>();
        for (DlCompletionTree t : this.kernel.getNeighbours((DlCompletionTree)n.getNode(), this.tr.pointer((OWLDataPropertyExpression)property))) {
            toReturn.add(new RootNodeImpl((DlCompletionTree)OWLAPIPreconditions.checkNotNull((Object)t)));
        }
        return toReturn;
    }

    public Node<? extends OWLClassExpression> getObjectLabel(OWLKnowledgeExplorerReasoner.RootNode object, boolean deterministicOnly) {
        Node nodeFromPointers = this.tr.getClassExpressionTranslator().node(this.kernel.getObjectLabel((DlCompletionTree)object.getNode(), deterministicOnly));
        return nodeFromPointers;
    }

    public Node<? extends OWLDataRange> getDataLabel(OWLKnowledgeExplorerReasoner.RootNode object, boolean deterministicOnly) {
        return this.tr.getDataRangeTranslator().node(this.kernel.getDataLabel((DlCompletionTree)object.getNode(), deterministicOnly));
    }

    public OWLKnowledgeExplorerReasoner.RootNode getBlocker(OWLKnowledgeExplorerReasoner.RootNode object) {
        return new RootNodeImpl(this.kernel.getBlocker((DlCompletionTree)object.getNode()));
    }

    public int getAtomicDecompositionSize(boolean useSemantics, ModuleType type) {
        return this.kernel.getAtomicDecompositionSize(useSemantics, type);
    }

    public Set<OWLAxiom> getTautologies() {
        return JFactReasoner.axiomsToSet(this.kernel.getTautologies());
    }

    public Set<OWLAxiom> getAtomAxioms(int index) {
        return JFactReasoner.axiomsToSet(this.kernel.getAtomAxioms(index));
    }

    private static Set<OWLAxiom> axiomsToSet(Collection<AxiomInterface> index) {
        HashSet<OWLAxiom> toReturn = new HashSet<OWLAxiom>();
        for (AxiomInterface ax : index) {
            OWLAxiom owlAxiom = ax.getOWLAxiom();
            if (owlAxiom == null) continue;
            toReturn.add(owlAxiom);
        }
        return toReturn;
    }

    public Set<OWLAxiom> getAtomModule(int index) {
        return JFactReasoner.axiomsToSet(this.kernel.getAtomModule(index));
    }

    public long getLocCheckNumber() {
        return this.kernel.getLocCheckNumber();
    }

    public Set<TOntologyAtom> getAtomDependents(int index) {
        return this.kernel.getAtomDependents(index);
    }

    public Set<OWLAxiom> getModule(Set<OWLEntity> signature, boolean useSemantic, ModuleType moduletype) {
        List<Expression> list = this.tr.translateExpressions(signature);
        List<AxiomInterface> axioms = this.kernel.getModule(list, useSemantic, moduletype);
        return JFactReasoner.axiomsToSet(axioms);
    }

    public Set<OWLAxiom> getNonLocal(Set<OWLEntity> signature, boolean useSemantic, ModuleType moduletype) {
        List<Expression> list = this.tr.translateExpressions(signature);
        Set<AxiomInterface> axioms = this.kernel.getNonLocal(list, useSemantic, moduletype);
        return JFactReasoner.axiomsToSet(axioms);
    }

    public synchronized Node<OWLNamedIndividual> getDataRelatedIndividuals(Set<OWLIndividual> individuals, OWLDataProperty r, OWLDataProperty s, int op) {
        this.checkConsistency();
        return this.tr.getIndividualTranslator().node(this.kernel.getDataRelatedIndividuals(this.tr.pointer((OWLDataPropertyExpression)r), this.tr.pointer((OWLDataPropertyExpression)s), op, this.tr.translate(individuals)));
    }

    private class RootNodeImpl
    implements OWLKnowledgeExplorerReasoner.RootNode,
    Serializable {
        private static final long serialVersionUID = 11000L;
        @Nonnull
        private final DlCompletionTree pointer;

        public RootNodeImpl(DlCompletionTree p) {
            this.pointer = p;
        }

        public <T> T getNode() {
            return (T)this.pointer;
        }
    }
}

