/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact;

import java.io.Serializable;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.IllegalConfigurationException;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.reasoner.SimpleConfiguration;
import uk.ac.manchester.cs.jfact.JFactReasoner;

public class JFactFactory
implements OWLReasonerFactory,
Serializable {
    private static final long serialVersionUID = 11000L;

    public String getReasonerName() {
        return "JFact";
    }

    public OWLReasoner createReasoner(OWLOntology ontology) {
        JFactReasoner toReturn = new JFactReasoner(ontology, (OWLReasonerConfiguration)new SimpleConfiguration(), BufferingMode.BUFFERING);
        return JFactFactory.verify(toReturn);
    }

    @Nonnull
    private static OWLReasoner verify(JFactReasoner toReturn) {
        OWLOntologyManager m = toReturn.getRootOntology().getOWLOntologyManager();
        m.addOntologyChangeListener((OWLOntologyChangeListener)toReturn);
        return toReturn;
    }

    public OWLReasoner createNonBufferingReasoner(OWLOntology ontology) {
        JFactReasoner toReturn = new JFactReasoner(ontology, (OWLReasonerConfiguration)new SimpleConfiguration(), BufferingMode.NON_BUFFERING);
        return JFactFactory.verify(toReturn);
    }

    public OWLReasoner createReasoner(OWLOntology ontology, OWLReasonerConfiguration config) throws IllegalConfigurationException {
        JFactReasoner toReturn = new JFactReasoner(ontology, config, BufferingMode.BUFFERING);
        return JFactFactory.verify(toReturn);
    }

    public OWLReasoner createNonBufferingReasoner(OWLOntology ontology, OWLReasonerConfiguration config) throws IllegalConfigurationException {
        JFactReasoner toReturn = new JFactReasoner(ontology, config, BufferingMode.NON_BUFFERING);
        return JFactFactory.verify(toReturn);
    }
}

