/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.split;

import conformance.PortedFrom;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.datatypes.cardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptAnd;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataExactCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataExists;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataForall;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataMaxCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataMinCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataValue;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptName;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptNot;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectExactCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectExists;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectForall;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectMaxCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectMinCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectSelf;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectValue;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptOneOf;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptOr;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptTop;
import uk.ac.manchester.cs.jfact.kernel.dl.DataAnd;
import uk.ac.manchester.cs.jfact.kernel.dl.DataBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.DataNot;
import uk.ac.manchester.cs.jfact.kernel.dl.DataOneOf;
import uk.ac.manchester.cs.jfact.kernel.dl.DataOr;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleName;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleTop;
import uk.ac.manchester.cs.jfact.kernel.dl.DataTop;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleChain;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleInverse;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleName;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleProjectionFrom;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleProjectionInto;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleTop;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.RoleExpression;
import uk.ac.manchester.cs.jfact.split.BotEquivalenceEvaluator;
import uk.ac.manchester.cs.jfact.split.SigAccessor;
import uk.ac.manchester.cs.jfact.visitors.DLExpressionVisitor;

@PortedFrom(file="SyntacticLocalityChecker.h", name="TopEquivalenceEvaluator")
public class TopEquivalenceEvaluator
extends SigAccessor
implements DLExpressionVisitor {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="SyntacticLocalityChecker.h", name="BotEval")
    private BotEquivalenceEvaluator BotEval = null;
    @PortedFrom(file="SyntacticLocalityChecker.h", name="isTopEq")
    private boolean isTopEq = false;

    @PortedFrom(file="SyntacticLocalityChecker.h", name="isBotEquivalent")
    private boolean isBotEquivalent(Expression expr) {
        return this.BotEval.isBotEquivalent(expr);
    }

    @Override
    public void visit(ObjectRoleProjectionFrom expr) {
        this.isTopEq = this.isMinTopEquivalent(1, expr.getOR(), expr.getConcept());
    }

    @Override
    public void visit(ObjectRoleProjectionInto expr) {
        this.isTopEq = this.isMinTopEquivalent(1, expr.getOR(), expr.getConcept());
    }

    @PortedFrom(file="SyntacticLocalityChecker.h", name="isREquivalent")
    private boolean isREquivalent(Expression expr) {
        return this.topRLocal() ? this.isTopEquivalent(expr) : this.isBotEquivalent(expr);
    }

    private boolean isBotDistinct(Expression C) {
        if (this.isTopEquivalent(C)) {
            return true;
        }
        return C instanceof Datatype;
    }

    private boolean isCardLargerThan(Expression C, int n) {
        if (n == 0) {
            return this.isBotDistinct(C);
        }
        if (C instanceof DataExpression && this.isTopEquivalent(C)) {
            return true;
        }
        if (C instanceof Datatype) {
            return ((Datatype)C).getCardinality() == cardinality.COUNTABLYINFINITE;
        }
        return false;
    }

    private boolean isMinTopEquivalent(int n, RoleExpression R, Expression C) {
        return n == 0 || this.isTopEquivalent(R) && this.isCardLargerThan(C, n - 1);
    }

    private boolean isMaxTopEquivalent(int n, RoleExpression R, Expression C) {
        return this.isBotEquivalent(R) || this.isBotEquivalent(C);
    }

    @PortedFrom(file="SyntacticLocalityChecker.h", name="setBotEval")
    public void setBotEval(BotEquivalenceEvaluator eval) {
        this.BotEval = eval;
    }

    @PortedFrom(file="SyntacticLocalityChecker.h", name="isTopEquivalent")
    public boolean isTopEquivalent(Expression expr) {
        expr.accept(this);
        return this.isTopEq;
    }

    @Override
    public void visit(ConceptTop expr) {
        this.isTopEq = true;
    }

    @Override
    public void visit(ConceptBottom expr) {
        this.isTopEq = false;
    }

    @Override
    public void visit(ConceptName expr) {
        this.isTopEq = this.sig.topCLocal() && !this.sig.contains(expr);
    }

    @Override
    public void visit(ConceptNot expr) {
        this.isTopEq = this.isBotEquivalent(expr.getConcept());
    }

    @Override
    public void visit(ConceptAnd expr) {
        for (ConceptExpression p : expr.getArguments()) {
            if (this.isTopEquivalent(p)) continue;
            return;
        }
        this.isTopEq = true;
    }

    @Override
    public void visit(ConceptOr expr) {
        for (ConceptExpression p : expr.getArguments()) {
            if (!this.isTopEquivalent(p)) continue;
            return;
        }
        this.isTopEq = false;
    }

    @Override
    public void visit(ConceptOneOf<?> expr) {
        this.isTopEq = false;
    }

    @Override
    public void visit(ConceptObjectSelf expr) {
        this.isTopEq = this.isTopEquivalent(expr.getOR());
    }

    @Override
    public void visit(ConceptObjectValue expr) {
        this.isTopEq = this.isTopEquivalent(expr.getOR());
    }

    @Override
    public void visit(ConceptObjectExists expr) {
        this.isTopEq = this.isMinTopEquivalent(1, expr.getOR(), expr.getConcept());
    }

    @Override
    public void visit(ConceptObjectForall expr) {
        this.isTopEq = this.isTopEquivalent(expr.getConcept()) || this.isBotEquivalent(expr.getOR());
    }

    @Override
    public void visit(ConceptObjectMinCardinality expr) {
        this.isTopEq = expr.getCardinality() == 0 || expr.getCardinality() == 1 && this.sig.topRLocal() && this.isTopEquivalent(expr.getOR()) && this.isTopEquivalent(expr.getConcept());
    }

    @Override
    public void visit(ConceptObjectMaxCardinality expr) {
        this.isTopEq = this.isBotEquivalent(expr.getConcept()) || !this.sig.topRLocal() && this.isBotEquivalent(expr.getOR());
    }

    @Override
    public void visit(ConceptObjectExactCardinality expr) {
        this.isTopEq = expr.getCardinality() == 0 && (this.isBotEquivalent(expr.getConcept()) || !this.sig.topRLocal() && this.isBotEquivalent(expr.getOR()));
    }

    @Override
    public void visit(ConceptDataValue expr) {
        this.isTopEq = this.isTopEquivalent(expr.getDataRoleExpression());
    }

    @Override
    public void visit(ConceptDataExists expr) {
        this.isTopEq = this.isMinTopEquivalent(1, expr.getDataRoleExpression(), expr.getExpr());
    }

    @Override
    public void visit(ConceptDataForall expr) {
        this.isTopEq = this.isTopEquivalent(expr.getExpr()) || this.isBotEquivalent(expr.getDataRoleExpression());
    }

    @Override
    public void visit(ConceptDataMinCardinality expr) {
        boolean bl = this.isTopEq = expr.getCardinality() == 0;
        if (this.sig.topRLocal()) {
            this.isTopEq |= this.isTopEquivalent(expr.getDataRoleExpression()) && (expr.getCardinality() == 1 ? this.isTopOrBuiltInDataType(expr.getExpr()) : this.isTopOrBuiltInDataType(expr.getExpr()));
        }
    }

    @Override
    public void visit(ConceptDataMaxCardinality expr) {
        this.isTopEq = !this.sig.topRLocal() && this.isBotEquivalent(expr.getDataRoleExpression());
    }

    @Override
    public void visit(ConceptDataExactCardinality expr) {
        this.isTopEq = !this.sig.topRLocal() && expr.getCardinality() == 0 && this.isBotEquivalent(expr.getDataRoleExpression());
    }

    @Override
    public void visit(ObjectRoleTop expr) {
        this.isTopEq = true;
    }

    @Override
    public void visit(ObjectRoleBottom expr) {
        this.isTopEq = false;
    }

    @Override
    public void visit(ObjectRoleName expr) {
        this.isTopEq = this.sig.topRLocal() && !this.sig.contains(expr);
    }

    @Override
    public void visit(ObjectRoleInverse expr) {
        this.isTopEq = this.isTopEquivalent(expr.getOR());
    }

    @Override
    public void visit(ObjectRoleChain expr) {
        this.isTopEq = false;
        for (ObjectRoleExpression p : expr.getArguments()) {
            if (this.isTopEquivalent(p)) continue;
            return;
        }
        this.isTopEq = true;
    }

    @Override
    public void visit(DataRoleTop expr) {
        this.isTopEq = true;
    }

    @Override
    public void visit(DataRoleBottom expr) {
        this.isTopEq = false;
    }

    @Override
    public void visit(DataRoleName expr) {
        this.isTopEq = this.sig.topRLocal() && !this.sig.contains(expr);
    }

    @Override
    public void visit(DataTop arg) {
        this.isTopEq = true;
    }

    @Override
    public void visit(DataBottom arg) {
        this.isTopEq = false;
    }

    @Override
    public void visit(Datatype<?> arg) {
        this.isTopEq = false;
    }

    @Override
    public void visit(Literal<?> arg) {
        this.isTopEq = false;
    }

    @Override
    public void visit(DataNot expr) {
        this.isTopEq = this.isBotEquivalent(expr.getExpr());
    }

    @Override
    public void visit(DataAnd expr) {
        for (DataExpression p : expr.getArguments()) {
            if (this.isTopEquivalent(p)) continue;
            return;
        }
        this.isTopEq = true;
    }

    @Override
    public void visit(DataOr expr) {
        for (DataExpression p : expr.getArguments()) {
            if (!this.isTopEquivalent(p)) continue;
            return;
        }
        this.isTopEq = false;
    }

    @Override
    public void visit(DataOneOf arg) {
        this.isTopEq = false;
    }
}

