/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.split;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.manchester.cs.jfact.dep.DepSet;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.kernel.DLDag;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptName;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomConceptInclusion;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomEquivalentConcepts;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.AxiomInterface;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.NamedEntity;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;
import uk.ac.manchester.cs.jfact.split.ModuleType;
import uk.ac.manchester.cs.jfact.split.SplitVarEntry;
import uk.ac.manchester.cs.jfact.split.SyntacticLocalityChecker;
import uk.ac.manchester.cs.jfact.split.TModularizer;
import uk.ac.manchester.cs.jfact.split.TSignature;
import uk.ac.manchester.cs.jfact.split.TSplitVar;
import uk.ac.manchester.cs.jfact.split.TSplitVars;

@PortedFrom(file="tSplitExpansionRules.h", name="TSplitRules")
public class TSplitRules
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="tSplitExpansionRules.h", name="Base")
    private final List<TSplitRule> Base = new ArrayList<TSplitRule>();
    @PortedFrom(file="tSplitExpansionRules.h", name="PossibleSignature")
    private final Set<NamedEntity> PossibleSignature = new HashSet<NamedEntity>();
    @PortedFrom(file="tSplitExpansionRules.h", name="EntityMap")
    private final List<NamedEntity> EntityMap = new ArrayList<NamedEntity>();
    @Original
    private final JFactReasonerConfiguration config;

    public TSplitRules(JFactReasonerConfiguration options) {
        this.config = options;
    }

    @PortedFrom(file="tSplitExpansionRules.h", name="begin")
    public List<TSplitRule> getRules() {
        return this.Base;
    }

    @PortedFrom(file="tSplitExpansionRules.h", name="addSplitRule")
    private void addSplitRule(Set<NamedEntity> eqSig, Set<NamedEntity> impSig, int bp) {
        this.Base.add(new TSplitRule(eqSig, impSig, bp));
    }

    @PortedFrom(file="tSplitExpansionRules.h", name="getSingleEntity")
    private NamedEntity getSingleEntity(NamedEntry entry) {
        if (entry == null) {
            return null;
        }
        NamedEntity ret = entry.getEntity();
        return this.PossibleSignature.contains(ret) ? ret : null;
    }

    @PortedFrom(file="tSplitExpansionRules.h", name="createSplitRules")
    public void createSplitRules(TSplitVars Splits) {
        for (TSplitVar p : Splits.getEntries()) {
            this.initSplit(p);
        }
    }

    @PortedFrom(file="tSplitExpansionRules.h", name="ensureDagSize")
    public void ensureDagSize(int dagSize) {
        Helper.resize(this.EntityMap, dagSize);
    }

    @PortedFrom(file="tSplitExpansionRules.h", name="getEntity")
    public NamedEntity getEntity(int bp) {
        return this.EntityMap.get(bp > 0 ? bp : -bp);
    }

    @PortedFrom(file="tSplitExpansionRules.h", name="initEntityMap")
    public void initEntityMap(DLDag Dag) {
        int size = Dag.size();
        Helper.resize(this.EntityMap, size);
        this.EntityMap.set(0, null);
        this.EntityMap.set(1, null);
        for (int i = 2; i < size - 1; ++i) {
            this.EntityMap.set(i, this.getSingleEntity(Dag.get(i).getConcept()));
        }
    }

    @PortedFrom(file="tSplitExpansionRules.h", name="buildSet")
    private Set<NamedEntity> buildSet(TSignature sig, NamedEntity entity) {
        HashSet<NamedEntity> set = new HashSet<NamedEntity>();
        for (NamedEntity p : sig.begin()) {
            if (p == entity || !(p instanceof ConceptName)) continue;
            set.add(p);
        }
        this.PossibleSignature.addAll(set);
        return set;
    }

    @PortedFrom(file="tSplitExpansionRules.h", name="initSplit")
    private void initSplit(TSplitVar split) {
        SplitVarEntry p = split.getEntries().get(0);
        Set<NamedEntity> impSet = this.buildSet(p.sig, p.name);
        int bp = split.getC().getpBody() + 1;
        for (int i = 1; i < split.getEntries().size(); ++i) {
            p = split.getEntries().get(i);
            if (p.Module.size() == 1) {
                this.addSplitRule(this.buildSet(p.sig, p.name), impSet, bp);
                continue;
            }
            HashSet<TSignature> Out = new HashSet<TSignature>();
            ArrayList<NamedEntity> Allowed = new ArrayList<NamedEntity>();
            ArrayList<AxiomInterface> Module2 = new ArrayList<AxiomInterface>(p.Module);
            TSignature sig = p.sig;
            this.prepareStartSig(Module2, sig, Allowed);
            this.BuildAllSeedSigs(Allowed, sig, Module2, Out);
            for (TSignature q : Out) {
                this.addSplitRule(this.buildSet(q, p.name), impSet, bp);
            }
        }
    }

    @PortedFrom(file="tSplitExpansionRules.h", name="prepareStartSig")
    private void prepareStartSig(List<AxiomInterface> Module2, TSignature sig, List<NamedEntity> Allowed) {
        for (AxiomInterface p : Module2) {
            ConceptExpression c;
            if (p instanceof AxiomEquivalentConcepts) {
                for (ConceptExpression q : ((AxiomEquivalentConcepts)p).getArguments()) {
                    if (!(q instanceof ConceptName)) continue;
                    sig.remove((ConceptName)q);
                }
                continue;
            }
            if (!(p instanceof AxiomConceptInclusion) || !((c = ((AxiomConceptInclusion)p).getSubConcept()) instanceof ConceptName)) continue;
            sig.remove((ConceptName)c);
        }
        for (NamedEntity r : sig.begin()) {
            if (!(r instanceof ConceptName)) continue;
            Allowed.add(r);
        }
    }

    @PortedFrom(file="tSplitExpansionRules.h", name="BuildAllSeedSigs")
    private void BuildAllSeedSigs(List<NamedEntity> Allowed, TSignature StartSig, List<AxiomInterface> Module2, Set<TSignature> Out) {
        TSignature sig = StartSig;
        ArrayList<NamedEntity> RecAllowed = new ArrayList<NamedEntity>();
        ArrayList<NamedEntity> Keepers = new ArrayList<NamedEntity>();
        HashSet<AxiomInterface> outModule = new HashSet<AxiomInterface>();
        TModularizer mod = new TModularizer(this.config, new SyntacticLocalityChecker());
        for (NamedEntity p : Allowed) {
            if (!sig.containsNamedEntity(p)) continue;
            sig.remove(p);
            outModule.addAll(mod.extractModule(Module2, sig, ModuleType.M_STAR));
            if (mod.getModule().size() == Module2.size()) {
                RecAllowed.add(p);
            } else {
                Keepers.add(p);
            }
            sig.add(p);
        }
        if (RecAllowed.isEmpty()) {
            Out.add(StartSig);
            return;
        }
        if (!Keepers.isEmpty()) {
            for (NamedEntity p : RecAllowed) {
                sig.remove(p);
            }
            outModule.addAll(mod.extractModule(Module2, sig, ModuleType.M_STAR));
            if (mod.getModule().size() == Module2.size()) {
                Out.add(sig);
                return;
            }
        }
        sig = StartSig;
        for (NamedEntity p : RecAllowed) {
            sig.remove(p);
            this.BuildAllSeedSigs(RecAllowed, sig, Module2, Out);
            sig.add(p);
        }
    }

    public class TSplitRule
    implements Serializable {
        private static final long serialVersionUID = 11000L;
        private final Set<NamedEntity> eqSig;
        private final Set<NamedEntity> impSig;
        private final int bpSplit;

        TSplitRule(Set<NamedEntity> es, Set<NamedEntity> is, int p) {
            this.eqSig = new HashSet<NamedEntity>(es);
            this.impSig = new HashSet<NamedEntity>(is);
            this.bpSplit = p;
        }

        TSplitRule(TSplitRule copy) {
            this(copy.eqSig, copy.impSig, copy.bpSplit);
        }

        public int bp() {
            return this.bpSplit;
        }

        public boolean canFire(Set<NamedEntity> CurrentSig) {
            return CurrentSig.containsAll(this.eqSig) && Helper.intersectsWith(this.impSig, CurrentSig);
        }

        public DepSet fireDep(Set<NamedEntity> CurrentSig, Map<NamedEntity, DepSet> SigDep) {
            DepSet dep = DepSet.create();
            for (NamedEntity p : this.eqSig) {
                dep = DepSet.plus(dep, SigDep.get(p));
            }
            for (NamedEntity p : this.impSig) {
                if (!CurrentSig.contains(p)) continue;
                dep = DepSet.plus(dep, SigDep.get(p));
                break;
            }
            return dep;
        }
    }
}

