/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.split;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleInverse;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.NamedEntity;

@PortedFrom(file="tSignature.h", name="TSignature")
public class TSignature
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="tSignature.h", name="Set")
    private final Set<NamedEntity> set = new HashSet<NamedEntity>();
    @PortedFrom(file="tSignature.h", name="topCLocality")
    private boolean topCLocality = false;
    @PortedFrom(file="tSignature.h", name="topRLocality")
    private boolean topRLocality = false;

    public TSignature() {
    }

    public TSignature(TSignature copy) {
        this.set.addAll(copy.set);
        this.topCLocality = copy.topCLocality;
        this.topRLocality = copy.topRLocality;
    }

    @PortedFrom(file="tSignature.h", name="add")
    public void add(NamedEntity p) {
        this.set.add(p);
    }

    @PortedFrom(file="tSignature.h", name="remove")
    public void remove(NamedEntity p) {
        this.set.remove(p);
    }

    @PortedFrom(file="tSignature.h", name="add")
    public void add(TSignature Sig) {
        this.set.addAll(Sig.set);
    }

    @PortedFrom(file="tSignature.h", name="setLocality")
    public void setLocality(boolean top) {
        this.setLocality(top, top);
    }

    @PortedFrom(file="tSignature.h", name="setLocality")
    public void setLocality(boolean topC, boolean topR) {
        this.topCLocality = topC;
        this.topRLocality = topR;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof TSignature) {
            return this.set.equals(((TSignature)obj).set);
        }
        return false;
    }

    public int hashCode() {
        return this.set.hashCode();
    }

    @PortedFrom(file="LocalityChecker.h", name="nc")
    public boolean nc(NamedEntity entity) {
        return !this.containsNamedEntity(entity);
    }

    @Original
    public boolean containsNamedEntity(NamedEntity p) {
        return this.set.contains(p);
    }

    @PortedFrom(file="tSignature.h", name="contains")
    public boolean contains(Expression p) {
        if (p instanceof NamedEntity) {
            return this.containsNamedEntity((NamedEntity)((Object)p));
        }
        if (p instanceof ObjectRoleInverse) {
            return this.contains(((ObjectRoleInverse)p).getOR());
        }
        return false;
    }

    @PortedFrom(file="tSignature.h", name="size")
    public int size() {
        return this.set.size();
    }

    @PortedFrom(file="tSignature.h", name="clear")
    public void clear() {
        this.set.clear();
    }

    @PortedFrom(file="tSignature.h", name="begin")
    public Set<NamedEntity> begin() {
        return this.set;
    }

    @PortedFrom(file="tSignature.h", name="topCLocal")
    public boolean topCLocal() {
        return this.topCLocality;
    }

    @PortedFrom(file="tSignature.h", name="topRLocal")
    public boolean topRLocal() {
        return this.topRLocality;
    }

    @PortedFrom(file="tSignature.h", name="botCLocal")
    public boolean botCLocal() {
        return !this.topCLocal();
    }

    @PortedFrom(file="tSignature.h", name="botRLocal")
    public boolean botRLocal() {
        return !this.topRLocal();
    }

    @Original
    public List<NamedEntity> intersect(TSignature s2) {
        ArrayList<NamedEntity> ret = new ArrayList<NamedEntity>();
        HashSet<NamedEntity> s = new HashSet<NamedEntity>(this.set);
        s.retainAll(s2.set);
        ret.addAll(s);
        return ret;
    }

    @PortedFrom(file="tSignature.h", name="subset")
    public boolean subset(TSignature sig, boolean improper) {
        boolean subset = sig.set.containsAll(this.set);
        if (improper) {
            return subset && sig.set.size() != this.set.size();
        }
        return subset;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("[");
        for (NamedEntity p : this.set) {
            b.append((CharSequence)p.getName()).append(" ");
        }
        b.append("]");
        return b.toString();
    }
}

