/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.split;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.AxiomInterface;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.NamedEntity;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;
import uk.ac.manchester.cs.jfact.split.LocalityChecker;
import uk.ac.manchester.cs.jfact.split.ModuleType;
import uk.ac.manchester.cs.jfact.split.SigIndex;
import uk.ac.manchester.cs.jfact.split.TSignature;

@PortedFrom(file="Modularity.h", name="TModularizer")
public class TModularizer
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="Modularity.h", name="sig")
    private TSignature sig;
    @PortedFrom(file="Modularity.h", name="Checker")
    private final LocalityChecker Checker;
    @PortedFrom(file="Modularity.h", name="Module")
    private final List<AxiomInterface> Module = new ArrayList<AxiomInterface>();
    @PortedFrom(file="Modularity.h", name="sigIndex")
    private final SigIndex sigIndex;
    @PortedFrom(file="Modularity.h", name="noAtomsProcessing")
    private boolean noAtomsProcessing;
    @PortedFrom(file="Modularity.h", name="WorkQueue")
    private final List<NamedEntity> WorkQueue = new ArrayList<NamedEntity>();
    @PortedFrom(file="Modularity.h", name="nChecks")
    private long nChecks;
    @PortedFrom(file="Modularity.h", name="nNonLocal")
    private long nNonLocal;
    @Original
    private final JFactReasonerConfiguration config;

    @PortedFrom(file="Modularity.h", name="addAxiomSig")
    private void addAxiomSig(AxiomInterface axiom) {
        TSignature axiomSig = axiom.getSignature();
        if (this.sigIndex != null) {
            for (NamedEntity p : axiomSig.begin()) {
                if (this.sig.containsNamedEntity(p)) continue;
                this.WorkQueue.add(p);
                this.sig.add(p);
            }
        }
    }

    @PortedFrom(file="Modularity.h", name="addAxiomToModule")
    private void addAxiomToModule(AxiomInterface axiom) {
        axiom.setInModule(true);
        this.Module.add(axiom);
        this.addAxiomSig(axiom);
    }

    @PortedFrom(file="Modularity.h", name="isNonLocal")
    private boolean isNonLocal(AxiomInterface ax) {
        ++this.nChecks;
        if (this.Checker.local(ax)) {
            return false;
        }
        ++this.nNonLocal;
        return true;
    }

    @PortedFrom(file="Modularity.h", name="addNonLocal")
    private void addNonLocal(AxiomInterface ax, boolean noCheck) {
        if (noCheck || this.isNonLocal(ax)) {
            this.addAxiomToModule(ax);
            if (this.config.isRKG_USE_AD_IN_MODULE_EXTRACTION() && this.noAtomsProcessing && ax.getAtom() != null) {
                this.noAtomsProcessing = false;
                this.addNonLocal(ax.getAtom().getModule(), true);
                this.noAtomsProcessing = true;
            }
        }
    }

    @PortedFrom(file="Modularity.h", name="addNonLocal")
    private void addNonLocal(Collection<AxiomInterface> AxSet, boolean noCheck) {
        for (AxiomInterface q : AxSet) {
            if (q.isInModule() || !q.isInSS()) continue;
            this.addNonLocal(q, noCheck);
        }
    }

    @PortedFrom(file="Modularity.h", name="extractModuleQueue")
    private void extractModuleQueue() {
        for (NamedEntity p : this.sig.begin()) {
            this.WorkQueue.add(p);
        }
        this.addNonLocal(this.sigIndex.getNonLocal(this.sig.topCLocal()), true);
        while (!this.WorkQueue.isEmpty()) {
            NamedEntity entity = this.WorkQueue.remove(0);
            this.addNonLocal(this.sigIndex.getAxioms(entity), false);
        }
    }

    @PortedFrom(file="Modularity.h", name="extractModule")
    private void extractModule(Collection<AxiomInterface> args) {
        this.Module.clear();
        for (AxiomInterface p : args) {
            p.setInModule(false);
        }
        for (AxiomInterface p : args) {
            if (!p.isUsed()) continue;
            p.setInSS(true);
        }
        this.extractModuleQueue();
        for (AxiomInterface p : args) {
            p.setInSS(false);
        }
    }

    public TModularizer(JFactReasonerConfiguration config, LocalityChecker c) {
        this.config = config;
        this.Checker = c;
        this.sig = c.getSignature();
        this.sigIndex = new SigIndex(this.Checker);
        this.nChecks = 0L;
        this.nNonLocal = 0L;
    }

    @PortedFrom(file="Modularity.h", name="preprocessOntology")
    public void preprocessOntology(Collection<AxiomInterface> vec) {
        this.Checker.preprocessOntology(vec);
        this.sigIndex.clear();
        this.sigIndex.preprocessOntology(vec);
        this.nChecks += (long)(2 * vec.size());
    }

    @PortedFrom(file="Modularity.h", name="isTautology")
    public boolean isTautology(AxiomInterface ax, ModuleType type) {
        boolean topLocality = type == ModuleType.M_TOP;
        this.sig = ax.getSignature();
        this.sig.setLocality(topLocality);
        boolean toReturn = this.Checker.local(ax);
        if (type != ModuleType.M_STAR || !toReturn) {
            return toReturn;
        }
        this.sig.setLocality(!topLocality);
        return this.Checker.local(ax);
    }

    @PortedFrom(file="Modularity.h", name="getSigIndex")
    public SigIndex getSigIndex() {
        return this.sigIndex;
    }

    @PortedFrom(file="Modularity.h", name="getLocalityChecker")
    public LocalityChecker getLocalityChecker() {
        return this.Checker;
    }

    @PortedFrom(file="Modularity.h", name="extract")
    public void extract(AxiomInterface begin, TSignature signature, ModuleType type) {
        this.extract(Collections.singletonList(begin), signature, type);
    }

    @PortedFrom(file="Modularity.h", name="extract")
    public void extract(Collection<AxiomInterface> begin, TSignature signature, ModuleType type) {
        int size;
        boolean topLocality = type == ModuleType.M_TOP;
        this.sig = signature;
        this.Checker.setSignatureValue(this.sig);
        this.sig.setLocality(topLocality);
        this.extractModule(begin);
        if (type != ModuleType.M_STAR) {
            return;
        }
        ArrayList<AxiomInterface> oldModule = new ArrayList<AxiomInterface>();
        do {
            size = this.Module.size();
            oldModule.clear();
            oldModule.addAll(this.Module);
            topLocality = !topLocality;
            this.sig = signature;
            this.sig.setLocality(topLocality);
            this.extractModule(oldModule);
        } while (size != this.Module.size());
    }

    @PortedFrom(file="Modularity.h", name="getNChecks")
    public long getNChecks() {
        return this.nChecks;
    }

    @PortedFrom(file="Modularity.h", name="extractModule")
    public List<AxiomInterface> extractModule(List<AxiomInterface> list, TSignature signature, ModuleType type) {
        this.extract(list, signature, type);
        return this.Module;
    }

    @PortedFrom(file="Modularity.h", name="getModule")
    public List<AxiomInterface> getModule() {
        return this.Module;
    }

    @PortedFrom(file="Modularity.h", name="getSignature")
    public TSignature getSignature() {
        return this.sig;
    }
}

