/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.split;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.util.MultiMap;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.AxiomInterface;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.NamedEntity;
import uk.ac.manchester.cs.jfact.split.LocalityChecker;
import uk.ac.manchester.cs.jfact.split.TSignature;

@PortedFrom(file="SigIndex.h", name="SigIndex")
public class SigIndex
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="SigIndex.h", name="Base")
    private final MultiMap<NamedEntity, AxiomInterface> Base = new MultiMap();
    @PortedFrom(file="SigIndex.h", name="Checker")
    private final LocalityChecker Checker;
    @Original
    private final Set<AxiomInterface> NonLocalTrue = new HashSet<AxiomInterface>();
    @Original
    private final Set<AxiomInterface> NonLocalFalse = new HashSet<AxiomInterface>();
    @PortedFrom(file="SigIndex.h", name="emptySig")
    private final TSignature emptySig = new TSignature();
    @PortedFrom(file="SigIndex.h", name="nRegistered")
    private int nRegistered = 0;
    @PortedFrom(file="SigIndex.h", name="nUnregistered")
    private int nUnregistered = 0;

    @PortedFrom(file="SigIndex.h", name="nProcessedAx")
    public int nProcessedAx() {
        return this.nRegistered;
    }

    @PortedFrom(file="SigIndex.h", name="checkNonLocal")
    private void checkNonLocal(AxiomInterface ax, boolean top) {
        this.emptySig.setLocality(top);
        this.Checker.setSignatureValue(this.emptySig);
        if (!this.Checker.local(ax)) {
            if (top) {
                this.NonLocalFalse.add(ax);
            } else {
                this.NonLocalTrue.add(ax);
            }
        }
    }

    public SigIndex(LocalityChecker c) {
        this.Checker = c;
    }

    @PortedFrom(file="SigIndex.h", name="registerAx")
    private void registerAx(AxiomInterface ax) {
        for (NamedEntity p : ax.getSignature().begin()) {
            this.Base.put((Object)p, (Object)ax);
        }
        this.checkNonLocal(ax, false);
        this.checkNonLocal(ax, true);
        ++this.nRegistered;
    }

    @PortedFrom(file="SigIndex.h", name="unregisterAx")
    private void unregisterAx(AxiomInterface ax) {
        for (NamedEntity p : ax.getSignature().begin()) {
            this.Base.get((Object)p).remove(ax);
        }
        this.NonLocalFalse.remove(ax);
        this.NonLocalTrue.remove(ax);
        ++this.nUnregistered;
    }

    @PortedFrom(file="SigIndex.h", name="processAx")
    public void processAx(AxiomInterface ax) {
        if (ax.isUsed()) {
            this.registerAx(ax);
        } else {
            this.unregisterAx(ax);
        }
    }

    @PortedFrom(file="SigIndex.h", name="preprocessOntology")
    public void preprocessOntology(Collection<AxiomInterface> axioms) {
        for (AxiomInterface ax : axioms) {
            this.processAx(ax);
        }
    }

    @PortedFrom(file="SigIndex.h", name="clear")
    public void clear() {
        this.Base.clear();
        this.NonLocalFalse.clear();
        this.NonLocalTrue.clear();
    }

    @PortedFrom(file="SigIndex.h", name="getAxioms")
    public Collection<AxiomInterface> getAxioms(NamedEntity entity) {
        return this.Base.get((Object)entity);
    }

    @PortedFrom(file="SigIndex.h", name="getNonLocal")
    public Set<AxiomInterface> getNonLocal(boolean top) {
        return top ? this.NonLocalFalse : this.NonLocalTrue;
    }
}

