/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.split;

import conformance.PortedFrom;
import java.io.Serializable;

@PortedFrom(file="ProgressIndicatorInterface.h", name="ProgressIndicatorInterface")
abstract class ProgressIndicatorInterface
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="ProgressIndicatorInterface.h", name="uLimit")
    private long uLimit;
    @PortedFrom(file="ProgressIndicatorInterface.h", name="uCurrent")
    private long uCurrent;

    @PortedFrom(file="ProgressIndicatorInterface.h", name="initExposure")
    private void initExposure() {
    }

    @PortedFrom(file="ProgressIndicatorInterface.h", name="expose")
    protected abstract void expose();

    @PortedFrom(file="ProgressIndicatorInterface.h", name="checkMax")
    private boolean checkMax() {
        if (this.uCurrent > this.uLimit) {
            this.uCurrent = this.uLimit;
            return true;
        }
        return false;
    }

    protected ProgressIndicatorInterface() {
        this.uLimit = 0L;
        this.uCurrent = 0L;
    }

    protected ProgressIndicatorInterface(long limit) {
        this.uCurrent = 0L;
        this.setLimit(limit);
    }

    @PortedFrom(file="ProgressIndicatorInterface.h", name="setIndicator")
    protected void setIndicator(long value) {
        if (this.uCurrent != value) {
            this.uCurrent = value;
            this.checkMax();
            this.expose();
        }
    }

    @PortedFrom(file="ProgressIndicatorInterface.h", name="incIndicator")
    protected void incIndicator(long delta) {
        this.setIndicator(this.uCurrent + delta);
    }

    @PortedFrom(file="ProgressIndicatorInterface.h", name="incIndicator")
    protected void incIndicator() {
        this.setIndicator(this.uCurrent + 1L);
    }

    @PortedFrom(file="ProgressIndicatorInterface.h", name="reset")
    protected void reset() {
        this.setIndicator(0L);
    }

    @PortedFrom(file="ProgressIndicatorInterface.h", name="setLimit")
    protected void setLimit(long limit) {
        this.uLimit = limit;
        this.reset();
        this.initExposure();
    }
}

