/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.split;

import conformance.Original;
import conformance.PortedFrom;
import java.util.Collection;
import java.util.List;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomConceptInclusion;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDRoleDomain;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDRoleFunctional;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDRoleRange;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDRoleSubsumption;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDeclaration;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDifferentIndividuals;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDisjointConcepts;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDisjointDRoles;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDisjointORoles;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDisjointUnion;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomEquivalentConcepts;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomEquivalentDRoles;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomEquivalentORoles;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomFairnessConstraint;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomInstanceOf;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomORoleDomain;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomORoleFunctional;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomORoleRange;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomORoleSubsumption;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRelatedTo;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRelatedToNot;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleAsymmetric;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleInverse;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleInverseFunctional;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleIrreflexive;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleReflexive;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleSymmetric;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleTransitive;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomSameIndividuals;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomValueOf;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomValueOfNot;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.AxiomInterface;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.split.BotEquivalenceEvaluator;
import uk.ac.manchester.cs.jfact.split.LocalityChecker;
import uk.ac.manchester.cs.jfact.split.SigAccessor;
import uk.ac.manchester.cs.jfact.split.TSignature;
import uk.ac.manchester.cs.jfact.split.TopEquivalenceEvaluator;
import uk.ac.manchester.cs.jfact.visitors.DLAxiomVisitor;

@PortedFrom(file="GeneralSyntacticLocalityChecker.h", name="GeneralSyntacticLocalityChecker")
public abstract class GeneralSyntacticLocalityChecker
extends SigAccessor
implements DLAxiomVisitor,
LocalityChecker {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="SyntacticLocalityChecker.h", name="TopEval")
    protected final TopEquivalenceEvaluator TopEval;
    @PortedFrom(file="SyntacticLocalityChecker.h", name="BotEval")
    protected final BotEquivalenceEvaluator BotEval;
    @PortedFrom(file="SyntacticLocalityChecker.h", name="isLocal")
    protected boolean isLocal;

    @PortedFrom(file="SyntacticLocalityChecker.h", name="isTopEquivalent")
    protected boolean isTopEquivalent(Expression expr) {
        return this.TopEval.isTopEquivalent(expr);
    }

    @PortedFrom(file="SyntacticLocalityChecker.h", name="isBotEquivalent")
    protected boolean isBotEquivalent(Expression expr) {
        return this.BotEval.isBotEquivalent(expr);
    }

    @PortedFrom(file="SyntacticLocalityChecker.h", name="isREquivalent")
    private boolean isREquivalent(Expression expr) {
        return this.sig.topRLocal() ? this.isTopEquivalent(expr) : this.isBotEquivalent(expr);
    }

    @Override
    @PortedFrom(file="SyntacticLocalityChecker.h", name="local")
    public boolean local(AxiomInterface axiom) {
        axiom.accept(this);
        return this.isLocal;
    }

    @Override
    @Original
    public void setSignatureValue(TSignature Sig) {
        this.TopEval.sig = this.sig = Sig;
        this.BotEval.sig = this.sig;
    }

    @Override
    @Original
    public void preprocessOntology(Collection<AxiomInterface> s) {
        this.sig = new TSignature();
        for (AxiomInterface ax : s) {
            this.sig.add(ax.getSignature());
        }
    }

    public GeneralSyntacticLocalityChecker(TSignature sig) {
        this.sig = sig;
        this.TopEval = new TopEquivalenceEvaluator();
        this.BotEval = new BotEquivalenceEvaluator();
        this.TopEval.setBotEval(this.BotEval);
        this.BotEval.setTopEval(this.TopEval);
    }

    public GeneralSyntacticLocalityChecker() {
        this(null);
    }

    @Override
    @Original
    public TSignature getSignature() {
        return this.sig;
    }

    @Override
    public void visit(AxiomDeclaration axiom) {
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomEquivalentConcepts axiom) {
        if (axiom.size() <= 1) {
            this.isLocal = true;
            return;
        }
        this.isLocal = false;
        List args = axiom.getArguments();
        if (!args.isEmpty()) {
            if (this.isBotEquivalent((Expression)args.get(0))) {
                for (int i = 1; i < args.size(); ++i) {
                    if (this.isBotEquivalent((Expression)args.get(i))) continue;
                    return;
                }
            } else {
                for (int i = 0; i < args.size(); ++i) {
                    if (this.isTopEquivalent((Expression)args.get(i))) continue;
                    return;
                }
            }
        }
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomDisjointConcepts axiom) {
        boolean hasNBE = false;
        this.isLocal = false;
        for (ConceptExpression p : axiom.getArguments()) {
            if (this.isBotEquivalent(p)) continue;
            if (hasNBE) {
                return;
            }
            hasNBE = true;
        }
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomDisjointUnion axiom) {
        boolean lhsIsTopEq;
        this.isLocal = false;
        if (this.isTopEquivalent(axiom.getConcept())) {
            lhsIsTopEq = true;
        } else if (this.isBotEquivalent(axiom.getConcept())) {
            lhsIsTopEq = false;
        } else {
            return;
        }
        boolean topEqDesc = false;
        for (ConceptExpression p : axiom.getArguments()) {
            if (this.isBotEquivalent(p)) continue;
            if (lhsIsTopEq && this.isTopEquivalent(p)) {
                if (topEqDesc) {
                    return;
                }
                topEqDesc = true;
                continue;
            }
            return;
        }
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomEquivalentORoles axiom) {
        if (axiom.size() <= 1) {
            this.isLocal = true;
            return;
        }
        if (this.isBotEquivalent((Expression)axiom.getArguments().get(0))) {
            for (int i = 1; i < axiom.getArguments().size(); ++i) {
                if (this.isBotEquivalent((Expression)axiom.getArguments().get(i))) continue;
                return;
            }
        } else {
            for (int i = 0; i < axiom.getArguments().size(); ++i) {
                if (this.isTopEquivalent((Expression)axiom.getArguments().get(i))) continue;
                return;
            }
        }
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomEquivalentDRoles axiom) {
        if (axiom.size() <= 1) {
            this.isLocal = true;
            return;
        }
        if (this.isBotEquivalent((Expression)axiom.getArguments().get(0))) {
            for (int i = 1; i < axiom.getArguments().size(); ++i) {
                if (this.isBotEquivalent((Expression)axiom.getArguments().get(i))) continue;
                return;
            }
        } else {
            for (int i = 0; i < axiom.getArguments().size(); ++i) {
                if (this.isTopEquivalent((Expression)axiom.getArguments().get(i))) continue;
                return;
            }
        }
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomDisjointORoles axiom) {
        boolean hasNBE = false;
        this.isLocal = false;
        for (int i = 0; i < axiom.getArguments().size(); ++i) {
            if (this.isBotEquivalent((Expression)axiom.getArguments().get(i))) continue;
            if (hasNBE) {
                return;
            }
            hasNBE = true;
        }
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomDisjointDRoles axiom) {
        boolean hasNBE = false;
        this.isLocal = false;
        for (int i = 0; i < axiom.getArguments().size(); ++i) {
            if (this.isBotEquivalent((Expression)axiom.getArguments().get(i))) continue;
            if (hasNBE) {
                return;
            }
            hasNBE = true;
        }
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomSameIndividuals axiom) {
        this.isLocal = false;
    }

    @Override
    public void visit(AxiomDifferentIndividuals axiom) {
        this.isLocal = false;
    }

    @Override
    public void visit(AxiomFairnessConstraint axiom) {
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomRoleInverse axiom) {
        this.isLocal = this.isBotEquivalent(axiom.getRole()) && this.isBotEquivalent(axiom.getInvRole()) || this.isTopEquivalent(axiom.getRole()) && this.isTopEquivalent(axiom.getInvRole());
    }

    @Override
    public void visit(AxiomORoleSubsumption axiom) {
        this.isLocal = this.isTopEquivalent(axiom.getRole()) || this.isBotEquivalent(axiom.getSubRole());
    }

    @Override
    public void visit(AxiomDRoleSubsumption axiom) {
        this.isLocal = this.isTopEquivalent(axiom.getRole()) || this.isBotEquivalent(axiom.getSubRole());
    }

    @Override
    public void visit(AxiomORoleDomain axiom) {
        this.isLocal = this.isTopEquivalent(axiom.getDomain()) || this.isBotEquivalent(axiom.getRole());
    }

    @Override
    public void visit(AxiomDRoleDomain axiom) {
        this.isLocal = this.isTopEquivalent(axiom.getDomain()) || this.isBotEquivalent(axiom.getRole());
    }

    @Override
    public void visit(AxiomORoleRange axiom) {
        this.isLocal = this.isTopEquivalent(axiom.getRange()) || this.isBotEquivalent(axiom.getRole());
    }

    @Override
    public void visit(AxiomDRoleRange axiom) {
        this.isLocal = this.isTopEquivalent(axiom.getRange()) || this.isBotEquivalent(axiom.getRole());
    }

    @Override
    public void visit(AxiomRoleTransitive axiom) {
        this.isLocal = this.isBotEquivalent(axiom.getRole()) || this.isTopEquivalent(axiom.getRole());
    }

    @Override
    public void visit(AxiomRoleReflexive axiom) {
        this.isLocal = this.isTopEquivalent(axiom.getRole());
    }

    @Override
    public void visit(AxiomRoleIrreflexive axiom) {
        this.isLocal = this.isBotEquivalent(axiom.getRole());
    }

    @Override
    public void visit(AxiomRoleSymmetric axiom) {
        this.isLocal = this.isBotEquivalent(axiom.getRole()) || this.isTopEquivalent(axiom.getRole());
    }

    @Override
    public void visit(AxiomRoleAsymmetric axiom) {
        this.isLocal = false;
    }

    @Override
    public void visit(AxiomORoleFunctional axiom) {
        this.isLocal = this.isBotEquivalent(axiom.getRole());
    }

    @Override
    public void visit(AxiomDRoleFunctional axiom) {
        this.isLocal = this.isBotEquivalent(axiom.getRole());
    }

    @Override
    public void visit(AxiomRoleInverseFunctional axiom) {
        this.isLocal = this.isBotEquivalent(axiom.getRole());
    }

    @Override
    public void visit(AxiomConceptInclusion axiom) {
        this.isLocal = this.isBotEquivalent(axiom.getSubConcept()) || this.isTopEquivalent(axiom.getSupConcept());
    }

    @Override
    public void visit(AxiomInstanceOf axiom) {
        this.isLocal = this.isTopEquivalent(axiom.getC());
    }

    @Override
    public void visit(AxiomRelatedTo axiom) {
        this.isLocal = this.isTopEquivalent(axiom.getRelation());
    }

    @Override
    public void visit(AxiomRelatedToNot axiom) {
        this.isLocal = this.isBotEquivalent(axiom.getRelation());
    }

    @Override
    public void visit(AxiomValueOf axiom) {
        this.isLocal = this.isTopEquivalent(axiom.getAttribute());
    }

    @Override
    public void visit(AxiomValueOfNot axiom) {
        this.isLocal = this.isBotEquivalent(axiom.getAttribute());
    }
}

