/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.todolist;

import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.kernel.ConceptWDep;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.todolist.TODOListSaveState;
import uk.ac.manchester.cs.jfact.kernel.todolist.ToDoEntry;

public class QueueQueue
implements Serializable {
    private static final long serialVersionUID = 11000L;
    private List<ToDoEntry> _Wait = new ArrayList<ToDoEntry>();
    private int sPointer = 0;
    private boolean queueBroken = false;
    private int size = 0;

    protected void add(DlCompletionTree Node2, ConceptWDep offset) {
        int n;
        ToDoEntry e = new ToDoEntry(Node2, offset);
        if (this.isEmpty() || this._Wait.get(this.size - 1).getNode().getNominalLevel() <= Node2.getNominalLevel()) {
            this._Wait.add(e);
            ++this.size;
            return;
        }
        for (n = this.size; n > this.sPointer && this._Wait.get(n - 1).getNode().getNominalLevel() > Node2.getNominalLevel(); --n) {
        }
        this._Wait.add(n, e);
        this.queueBroken = true;
        ++this.size;
    }

    @PortedFrom(file="ToDoList.h", name="clear")
    protected void clear() {
        this.sPointer = 0;
        this.queueBroken = false;
        this._Wait.clear();
        this.size = 0;
    }

    protected boolean isEmpty() {
        return this.sPointer == this.size;
    }

    protected ToDoEntry get() {
        return this._Wait.get(this.sPointer++);
    }

    @PortedFrom(file="ToDoList.h", name="save")
    protected void save(TODOListSaveState tss) {
        tss.queueBroken = this.queueBroken;
        tss.sp = this.sPointer;
        if (this.queueBroken) {
            tss.waitingQueue = new ArrayList<ToDoEntry>(this._Wait);
        } else {
            tss.ep = this.size;
        }
        this.queueBroken = false;
    }

    @PortedFrom(file="ToDoList.h", name="restore")
    protected void restore(TODOListSaveState tss) {
        this.queueBroken = tss.queueBroken;
        this.sPointer = tss.sp;
        if (this.queueBroken) {
            this._Wait = tss.waitingQueue;
            this.size = this._Wait.size();
        } else {
            Helper.resize(this._Wait, tss.ep);
            this.size = tss.ep;
        }
    }

    public String toString() {
        return "{" + (!this.isEmpty() ? (Serializable)this._Wait.get(this.sPointer) : "empty") + " sPointer: " + this.sPointer + " size: " + this.size + " Wait: " + this._Wait + "}";
    }
}

