/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.queryobjects;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.Set;
import java.util.TreeSet;
import uk.ac.manchester.cs.jfact.kernel.queryobjects.QRAtom;
import uk.ac.manchester.cs.jfact.kernel.queryobjects.QRSetAtoms;
import uk.ac.manchester.cs.jfact.kernel.queryobjects.QRVariable;

@PortedFrom(file="QR.h", name="QRQuery")
public class QRQuery
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="QR.h", name="Body")
    private QRSetAtoms Body = new QRSetAtoms();
    @PortedFrom(file="QR.h", name="FreeVars")
    private Set<QRVariable> FreeVars = new TreeSet<QRVariable>();

    public QRQuery() {
    }

    public QRQuery(QRQuery q) {
        this.Body = new QRSetAtoms(q.Body);
        for (QRVariable v : q.getFreeVars()) {
            this.getFreeVars().add(new QRVariable(v));
        }
    }

    public boolean isFreeVar(QRVariable var) {
        return var != null && this.getFreeVars().contains(var);
    }

    @PortedFrom(file="QR.h", name="addAtom")
    public void addAtom(QRAtom atom) {
        this.Body.addAtom(atom);
    }

    @PortedFrom(file="QR.h", name="setVarFree")
    public void setVarFree(QRVariable var) {
        this.getFreeVars().add(var);
    }

    @Original
    public QRSetAtoms getBody() {
        return this.Body;
    }

    public Set<QRVariable> getFreeVars() {
        return this.FreeVars;
    }

    public void setFreeVars(Set<QRVariable> freeVars) {
        this.FreeVars = freeVars;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("FreeVars = {");
        for (QRVariable v : this.FreeVars) {
            b.append('\n').append((CharSequence)v.getName());
        }
        b.append("}\nQuery = {");
        for (QRAtom p : this.Body.begin()) {
            b.append('\n').append(p);
        }
        b.append(" }\n");
        return b.toString();
    }
}

