/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.modelcaches;

import conformance.PortedFrom;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheInterface;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheState;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheType;

@PortedFrom(file="modelCacheSingleton.h", name="modelCacheSingleton")
public class ModelCacheSingleton
extends ModelCacheInterface {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="modelCacheSingleton.h", name="Singleton")
    private final int singleton;

    public ModelCacheSingleton(int bp) {
        super(false);
        this.singleton = bp;
    }

    @Override
    @PortedFrom(file="modelCacheSingleton.h", name="getState")
    public ModelCacheState getState() {
        return ModelCacheState.csValid;
    }

    @PortedFrom(file="modelCacheSingleton.h", name="getValue")
    public int getValue() {
        return this.singleton;
    }

    @Override
    @PortedFrom(file="modelCacheSingleton.h", name="canMerge")
    public ModelCacheState canMerge(ModelCacheInterface p) {
        switch (p.getCacheType()) {
            case mctConst: {
                return p.getState();
            }
            case mctSingleton: {
                return ((ModelCacheSingleton)p).singleton == -this.singleton ? ModelCacheState.csInvalid : ModelCacheState.csValid;
            }
            case mctIan: {
                return p.canMerge(this);
            }
        }
        return ModelCacheState.csUnknown;
    }

    @Override
    @PortedFrom(file="modelCacheSingleton.h", name="getCacheType")
    public ModelCacheType getCacheType() {
        return ModelCacheType.mctSingleton;
    }

    @Override
    @PortedFrom(file="modelCacheSingleton.h", name="logCacheEntry")
    public void logCacheEntry(int level, LogAdapter l) {
        l.print("\nSingleton cache: element ").print(this.singleton);
    }
}

