/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import uk.ac.manchester.cs.jfact.helpers.Templates;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.KnownSubsumers;
import uk.ac.manchester.cs.jfact.kernel.Taxonomy;
import uk.ac.manchester.cs.jfact.kernel.TaxonomyVertex;
import uk.ac.manchester.cs.jfact.kernel.ToldSubsumers;
import uk.ac.manchester.cs.jfact.split.TSignature;

@PortedFrom(file="TaxonomyCreator.h", name="TaxonomyCreator")
public class TaxonomyCreator
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="TaxonomyCreator.h", name="pTax")
    protected final Taxonomy pTax;
    @PortedFrom(file="TaxonomyCreator.h", name="Syns")
    protected final List<ClassifiableEntry> Syns = new ArrayList<ClassifiableEntry>();
    @PortedFrom(file="TaxonomyCreator.h", name="valueLabel")
    protected long valueLabel = 1L;
    @PortedFrom(file="TaxonomyCreator.h", name="curEntry")
    protected ClassifiableEntry curEntry = null;
    @PortedFrom(file="TaxonomyCreator.h", name="nEntries")
    protected int nEntries = 0;
    @PortedFrom(file="TaxonomyCreator.h", name="nCDEntries")
    protected long nCDEntries = 0L;
    @PortedFrom(file="TaxonomyCreator.h", name="useCompletelyDefined")
    protected boolean useCompletelyDefined = false;
    @PortedFrom(file="TaxonomyCreator.h", name="upDirection")
    protected boolean upDirection;
    @PortedFrom(file="TaxonomyCreator.h", name="waitStack")
    private final LinkedList<ClassifiableEntry> waitStack = new LinkedList();
    @PortedFrom(file="TaxonomyCreator.h", name="ksStack")
    protected final LinkedList<KnownSubsumers> ksStack = new LinkedList();
    @PortedFrom(file="TaxonomyCreator.h", name="sigStack")
    protected final LinkedList<TSignature> sigStack = new LinkedList();

    public TaxonomyCreator(Taxonomy pTax2) {
        this.pTax = pTax2;
    }

    @PortedFrom(file="TaxonomyCreator.h", name="setCurrentEntry")
    protected void setCurrentEntry(ClassifiableEntry p) {
        this.pTax.getCurrent().clear();
        this.pTax.getCurrent().setSample(p, true);
        this.curEntry = p;
    }

    @PortedFrom(file="TaxonomyCreator.h", name="classifySynonym")
    protected boolean classifySynonym() {
        return this.pTax.processSynonym();
    }

    @PortedFrom(file="TaxonomyCreator.cpp", name="setToldSubsumers")
    private void setToldSubsumers() {
        List<ClassifiableEntry> top = this.ksStack.peek().s_begin();
        if (this.needLogging() && !top.isEmpty()) {
            this.pTax.getOptions().getLog().print("\nTAX: told subsumers");
        }
        for (ClassifiableEntry p : top) {
            if (!p.isClassified()) continue;
            if (this.needLogging()) {
                this.pTax.getOptions().getLog().printTemplate(Templates.TOLD_SUBSUMERS, p.getName());
            }
            this.propagateTrueUp(p.getTaxVertex());
        }
    }

    @PortedFrom(file="TaxonomyCreator.cpp", name="setNonRedundantCandidates")
    private void setNonRedundantCandidates() {
        if (!this.curEntry.hasToldSubsumers()) {
            this.pTax.getOptions().getLog().print("\nTAX: TOP");
        }
        this.pTax.getOptions().getLog().print(" completely defines concept ");
        this.pTax.getOptions().getLog().print((Object)this.curEntry.getName());
        for (ClassifiableEntry p : this.ksStack.peek().s_begin()) {
            this.addPossibleParent(p.getTaxVertex());
        }
    }

    @PortedFrom(file="TaxonomyCreator.h", name="immediatelyClassified")
    protected boolean immediatelyClassified() {
        return this.classifySynonym();
    }

    @PortedFrom(file="TaxonomyCreator.cpp", name="setupTopDown")
    private void setupTopDown() {
        this.setToldSubsumers();
        if (!this.needTopDown()) {
            ++this.nCDEntries;
            this.setNonRedundantCandidates();
        }
    }

    @PortedFrom(file="TaxonomyCreator.h", name="needTopDown")
    protected boolean needTopDown() {
        return false;
    }

    @PortedFrom(file="TaxonomyCreator.h", name="runTopDown")
    protected void runTopDown() {
    }

    @PortedFrom(file="TaxonomyCreator.h", name="needBottomUp")
    protected boolean needBottomUp() {
        return false;
    }

    @PortedFrom(file="TaxonomyCreator.h", name="runBottomUp")
    protected void runBottomUp() {
    }

    @PortedFrom(file="TaxonomyCreator.cpp", name="preClassificationActions")
    protected void preClassificationActions() {
    }

    @PortedFrom(file="TaxonomyCreator.cpp", name="performClassification")
    private void performClassification() {
        this.preClassificationActions();
        ++this.nEntries;
        this.pTax.getOptions().getLog().print("\n\nTAX: start classifying entry ");
        this.pTax.getOptions().getLog().print((Object)this.curEntry.getName());
        if (this.immediatelyClassified()) {
            return;
        }
        this.generalTwoPhaseClassification();
        this.pTax.finishCurrentNode();
        this.clearLabels();
    }

    @PortedFrom(file="TaxonomyCreator.cpp", name="generalTwoPhaseClassification")
    private void generalTwoPhaseClassification() {
        this.setupTopDown();
        if (this.needTopDown()) {
            this.setValue(this.pTax.getTopVertex(), true);
            this.setValue(this.pTax.getBottomVertex(), false);
            this.upDirection = false;
            this.runTopDown();
        }
        this.clearLabels();
        if (this.needBottomUp()) {
            this.setValue(this.pTax.getBottomVertex(), true);
            this.upDirection = true;
            this.runBottomUp();
        }
        this.clearLabels();
    }

    @PortedFrom(file="TaxonomyCreator.cpp", name="isDirectParent")
    public boolean isDirectParent(TaxonomyVertex v) {
        for (TaxonomyVertex q : v.neigh(false)) {
            if (!this.isValued(q) || !this.getValue(q)) continue;
            return false;
        }
        return true;
    }

    @PortedFrom(file="TaxonomyCreator.h", name="addTop")
    private void addTop(ClassifiableEntry p) {
        this.waitStack.push(p);
        this.ksStack.push(new ToldSubsumers(p.getToldSubsumers()));
        this.sigStack.push(this.buildSignature(p));
    }

    @PortedFrom(file="TaxonomyCreator.h", name="removeTop")
    protected void removeTop() {
        this.waitStack.pop();
        this.ksStack.pop();
        this.sigStack.pop();
    }

    @PortedFrom(file="TaxonomyCreator.cpp", name="classifyTop")
    private void classifyTop() {
        assert (!this.waitStack.isEmpty());
        this.setCurrentEntry(this.waitStack.peek());
        if (this.pTax.getOptions().isTMP_PRINT_TAXONOMY_INFO()) {
            this.pTax.getOptions().getLog().print((Object)"\nTrying classify", (Object)(this.curEntry.isCompletelyDefined() ? " CD " : " "), (Object)this.curEntry.getName(), (Object)"... ");
        }
        this.performClassification();
        if (this.pTax.getOptions().isTMP_PRINT_TAXONOMY_INFO()) {
            this.pTax.getOptions().getLog().print("done");
        }
        this.removeTop();
    }

    @PortedFrom(file="TaxonomyCreator.cpp", name="propagateTrueUp")
    protected void propagateTrueUp(TaxonomyVertex node) {
        if (this.isValued(node)) {
            assert (this.getValue(node));
            return;
        }
        this.setValue(node, true);
        List<TaxonomyVertex> list = node.neigh(true);
        for (int i = 0; i < list.size(); ++i) {
            this.propagateTrueUp(list.get(i));
        }
    }

    @PortedFrom(file="TaxonomyCreator.cpp", name="propagateFalseDown")
    protected void propagateFalseDown(TaxonomyVertex node) {
        if (this.isValued(node)) {
            assert (!this.getValue(node));
            return;
        }
        this.setValue(node, false);
        for (TaxonomyVertex p : node.neigh(false)) {
            this.propagateFalseDown(p);
        }
    }

    @PortedFrom(file="TaxonomyCreator.cpp", name="setAndPropagate")
    protected boolean setAndPropagate(TaxonomyVertex node, boolean value) {
        if (value) {
            this.propagateTrueUp(node);
        } else {
            this.propagateFalseDown(node);
        }
        return value;
    }

    @PortedFrom(file="TaxonomyCreator.h", name="needLogging")
    protected boolean needLogging() {
        return true;
    }

    @PortedFrom(file="TaxonomyCreator.h", name="addPossibleParent")
    public void addPossibleParent(TaxonomyVertex parent) {
        if (parent != null && this.isDirectParent(parent)) {
            this.pTax.getCurrent().addNeighbour(true, parent);
        }
    }

    @PortedFrom(file="TaxonomyCreator.h", name="clearLabels")
    protected void clearLabels() {
        this.pTax.clearLabels();
        ++this.valueLabel;
    }

    @PortedFrom(file="TaxonomyCreator.h", name="setCompletelyDefined")
    public void setCompletelyDefined(boolean use) {
        this.useCompletelyDefined = use;
    }

    @PortedFrom(file="TaxonomyCreator.h", name="classifyEntry")
    public void classifyEntry(ClassifiableEntry p) {
        assert (this.waitStack.isEmpty());
        if (p.isNonClassifiable()) {
            return;
        }
        this.prepareTS(p);
    }

    public String toString() {
        StringBuilder o = new StringBuilder();
        o.append("Taxonomy consists of ");
        o.append(this.nEntries);
        o.append(" entries\n            of which ");
        o.append(this.nCDEntries);
        o.append(" are completely defined\n\n");
        return o.toString();
    }

    @PortedFrom(file="TaxonomyCreator.cpp", name="prepareTS")
    private ClassifiableEntry prepareTS(ClassifiableEntry cur) {
        if (this.waitStack.contains(cur)) {
            return cur;
        }
        this.addTop(cur);
        boolean cycleFound = false;
        for (ClassifiableEntry p : this.ksStack.peek().s_begin()) {
            ClassifiableEntry v;
            if (p.isClassified() || p.isNonClassifiable() || (v = this.prepareTS(p)) == null) continue;
            if (v.equals(cur)) {
                cycleFound = true;
                continue;
            }
            this.Syns.add(cur);
            this.removeTop();
            return v;
        }
        this.classifyTop();
        if (cycleFound) {
            TaxonomyVertex syn = cur.getTaxVertex();
            for (ClassifiableEntry q : this.Syns) {
                syn.addSynonym(q);
            }
            this.Syns.clear();
        }
        return null;
    }

    @PortedFrom(file="TaxonomyCreator.h", name="isValued")
    public boolean isValued(TaxonomyVertex node) {
        return node.isValued(this.valueLabel);
    }

    @PortedFrom(file="TaxonomyCreator.h", name="getValue")
    public boolean getValue(TaxonomyVertex node) {
        return node.getValue();
    }

    @PortedFrom(file="TaxonomyCreator.h", name="setValue")
    public boolean setValue(TaxonomyVertex node, boolean value) {
        return node.setValued(value, this.valueLabel);
    }

    @PortedFrom(file="TaxonomyCreator.h", name="buildSignature")
    protected TSignature buildSignature(ClassifiableEntry p) {
        return null;
    }
}

