/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.PortedFrom;
import java.util.HashMap;
import java.util.Map;
import org.semanticweb.owlapi.model.IRI;
import uk.ac.manchester.cs.jfact.kernel.ConjunctiveQueryFolding;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptAnd;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptName;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectExists;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptTop;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;
import uk.ac.manchester.cs.jfact.visitors.DLExpressionVisitorAdapter;

@PortedFrom(file="ConjunctiveQueryFolding.cpp", name="TReplacer")
class TReplacer
extends DLExpressionVisitorAdapter {
    private static final long serialVersionUID = 11000L;
    private final ConjunctiveQueryFolding conjunctiveQueryFolding;
    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="ReplaceResult")
    private final Map<ConceptExpression, ConceptExpression> ReplaceResult = new HashMap<ConceptExpression, ConceptExpression>();
    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="ExpressionToReplace")
    private final ConceptExpression ExpressionToReplace;
    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="PropositionalVariable")
    private final ConceptExpression PropositionalVariable;

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="TReplacer")
    public TReplacer(ConjunctiveQueryFolding conjunctiveQueryFolding, ConceptExpression expression, IRI propositionalVariable) {
        this.conjunctiveQueryFolding = conjunctiveQueryFolding;
        this.ExpressionToReplace = expression;
        this.PropositionalVariable = this.conjunctiveQueryFolding.getpEM().concept(propositionalVariable);
    }

    @Override
    public void visit(ConceptTop expr) {
        this.ReplaceResult.put(expr, expr);
    }

    @Override
    public void visit(ConceptName expr) {
        if (expr.equals(this.ExpressionToReplace)) {
            this.ReplaceResult.put(expr, this.PropositionalVariable);
        } else {
            this.ReplaceResult.put(expr, expr);
        }
    }

    @Override
    public void visit(ConceptAnd expr) {
        if (expr.equals(this.ExpressionToReplace)) {
            this.ReplaceResult.put(expr, this.PropositionalVariable);
        } else {
            ConceptExpression s = null;
            for (ConceptExpression p : expr.getArguments()) {
                p.accept(this);
                if (p == expr.getArguments().get(0)) {
                    s = this.ReplaceResult.get(p);
                    continue;
                }
                s = this.conjunctiveQueryFolding.getpEM().and(s, this.ReplaceResult.get(p));
            }
            this.ReplaceResult.put(expr, s);
        }
    }

    @Override
    public void visit(ConceptObjectExists expr) {
        if (expr.equals(this.ExpressionToReplace)) {
            this.ReplaceResult.put(expr, this.PropositionalVariable);
        } else {
            ObjectRoleExpression role = expr.getOR();
            expr.getConcept().accept(this);
            this.ReplaceResult.put(expr, this.conjunctiveQueryFolding.getpEM().exists(role, this.ReplaceResult.get(expr.getConcept())));
        }
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="getReplaceResult")
    public ConceptExpression getReplaceResult(ConceptExpression c) {
        return this.ReplaceResult.get(c);
    }
}

