/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.PortedFrom;
import java.io.Serializable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.MultiMap;
import uk.ac.manchester.cs.jfact.kernel.ConjunctiveQueryFolding;
import uk.ac.manchester.cs.jfact.kernel.TDepthMeasurer;
import uk.ac.manchester.cs.jfact.kernel.TEquationSolver;
import uk.ac.manchester.cs.jfact.kernel.TExpressionMarker;
import uk.ac.manchester.cs.jfact.kernel.TReplacer;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.queryobjects.QRQuery;

@PortedFrom(file="ConjunctiveQueryFolding.cpp", name="TQueryToConceptsTransformer")
class TQueryToConceptsTransformer
implements Serializable {
    private static final long serialVersionUID = 11000L;
    private final ConjunctiveQueryFolding conjunctiveQueryFolding;
    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="Query")
    private QRQuery Query;
    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="Result")
    private final MultiMap<String, ConceptExpression> Result = new MultiMap();

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="TQueryToConceptsTransformer")
    public TQueryToConceptsTransformer(ConjunctiveQueryFolding conjunctiveQueryFolding, QRQuery query) {
        this.conjunctiveQueryFolding = conjunctiveQueryFolding;
        this.Query = new QRQuery(query);
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="Run")
    public void Run() {
        this.Query = this.conjunctiveQueryFolding.transformQueryPhase1(this.Query);
        ConceptExpression term = this.conjunctiveQueryFolding.transformQueryPhase2(this.Query);
        this.conjunctiveQueryFolding.buildApproximation(this.Query);
        IRI propositionalVariable = null;
        String lastNominal = null;
        int i = 1;
        while (true) {
            TDepthMeasurer depthMeasurer = new TDepthMeasurer(this.conjunctiveQueryFolding);
            term.accept(depthMeasurer);
            if (depthMeasurer.getMaxDepth() == -1) break;
            ConceptExpression nominal = depthMeasurer.getNominalWithMaxDepth();
            TExpressionMarker expressionMarker = new TExpressionMarker(this.conjunctiveQueryFolding, nominal);
            term.accept(expressionMarker);
            expressionMarker.PrintPath();
            propositionalVariable = IRI.create((String)("urn:P" + i));
            TReplacer replacer = new TReplacer(this.conjunctiveQueryFolding, expressionMarker.getSubterm(), propositionalVariable);
            term.accept(replacer);
            TEquationSolver equationSolver = new TEquationSolver(this.conjunctiveQueryFolding, expressionMarker.getSubterm(), propositionalVariable, expressionMarker);
            equationSolver.Solve();
            this.Result.put((Object)equationSolver.getNominal(), (Object)equationSolver.getPhi());
            lastNominal = equationSolver.getNominal();
            term = replacer.getReplaceResult(term);
            ++i;
        }
        this.Result.put(lastNominal, (Object)this.conjunctiveQueryFolding.getpEM().not(this.conjunctiveQueryFolding.getpEM().concept(propositionalVariable)));
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="getResult")
    public MultiMap<String, ConceptExpression> getResult() {
        return this.Result;
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="printResult")
    public void printResult() {
        int i = 0;
        for (ConceptExpression e : this.Result.getAllValues()) {
            System.err.println(i + ": ");
            ++i;
            System.err.println(e);
        }
    }
}

