/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.PortedFrom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.ConjunctiveQueryFolding;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptAnd;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptName;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectExists;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptTop;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleInverse;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleName;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;
import uk.ac.manchester.cs.jfact.visitors.DLExpressionVisitorAdapter;

@PortedFrom(file="ConjunctiveQueryFolding.cpp", name="TExpressionMarker")
class TExpressionMarker
extends DLExpressionVisitorAdapter {
    private static final long serialVersionUID = 11000L;
    private final ConjunctiveQueryFolding conjunctiveQueryFolding;
    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="GoodTerms")
    private final Map<ConceptExpression, Boolean> GoodTerms = new HashMap<ConceptExpression, Boolean>();
    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="SimpleTerms")
    private final Map<ConceptExpression, Boolean> SimpleTerms = new HashMap<ConceptExpression, Boolean>();
    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="Path")
    private final List<ConceptExpression> Path = new ArrayList<ConceptExpression>();
    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="Nominal")
    private final ConceptExpression Nominal;

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="TExpressionMarker")
    public TExpressionMarker(ConjunctiveQueryFolding conjunctiveQueryFolding, ConceptExpression nominal) {
        this.conjunctiveQueryFolding = conjunctiveQueryFolding;
        this.Nominal = nominal;
    }

    @Override
    public void visit(ConceptTop expr) {
        this.SimpleTerms.put(expr, false);
        this.GoodTerms.put(expr, true);
    }

    @Override
    public void visit(ConceptName expr) {
        this.SimpleTerms.put(expr, this.conjunctiveQueryFolding.isNominal(expr));
        if (expr.equals(this.Nominal)) {
            this.GoodTerms.put(expr, true);
            this.Path.add(expr);
        } else {
            this.GoodTerms.put(expr, !this.conjunctiveQueryFolding.isNominal(expr));
        }
    }

    @Override
    public void visit(ConceptAnd expr) {
        boolean simple = false;
        boolean good = true;
        boolean onPath = false;
        for (ConceptExpression p : expr.getArguments()) {
            p.accept(this);
            if (this.KnownToBeSimple(p)) {
                simple = true;
            }
            if (!this.KnownToBeGood(p)) {
                good = false;
            }
            if (!this.KnownToBeOnPath(p)) continue;
            onPath = true;
        }
        this.SimpleTerms.put(expr, simple);
        this.GoodTerms.put(expr, good);
        if (onPath && good && simple) {
            this.Path.add(expr);
        }
    }

    @Override
    public void visit(ConceptObjectExists expr) {
        ObjectRoleExpression role1 = expr.getOR();
        if (role1 instanceof ObjectRoleName) {
            expr.getConcept().accept(this);
            this.SimpleTerms.put(expr, false);
        } else if (role1 instanceof ObjectRoleInverse) {
            expr.getConcept().accept(this);
            if (this.KnownToBeSimple(expr.getConcept())) {
                this.SimpleTerms.put(expr, true);
            } else {
                this.SimpleTerms.put(expr, false);
            }
        } else {
            throw new UnreachableSituationException();
        }
        this.GoodTerms.put(expr, this.KnownToBeGood(expr.getConcept()));
        if (this.KnownToBeOnPath(expr.getConcept()) && this.KnownToBeGood(expr) && this.KnownToBeSimple(expr)) {
            this.Path.add(expr);
        }
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="KnownToBeSimple")
    public boolean KnownToBeSimple(ConceptExpression expr) {
        return this.SimpleTerms.containsKey(expr);
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="KnownToBeGood")
    public boolean KnownToBeGood(ConceptExpression expr) {
        return this.GoodTerms.containsKey(expr);
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="KnownToBeOnPath")
    public boolean KnownToBeOnPath(ConceptExpression expr) {
        return this.Path.size() >= 1 && this.Path.get(this.Path.size() - 1).equals(expr);
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="PrintPath")
    public void PrintPath() {
        for (int i = 0; i < this.Path.size(); ++i) {
            System.out.println("Expression on depth " + i + " :\n");
            System.out.println(this.Path.get(i));
        }
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="getSubterm")
    public ConceptExpression getSubterm() {
        if (this.Path.size() >= 1) {
            return this.Path.get(this.Path.size() - 1);
        }
        return null;
    }
}

