/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.PortedFrom;
import java.io.Serializable;
import org.semanticweb.owlapi.model.IRI;
import uk.ac.manchester.cs.jfact.kernel.ConjunctiveQueryFolding;
import uk.ac.manchester.cs.jfact.kernel.TExpressionMarker;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptAnd;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptName;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectExists;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptTop;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleInverse;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;

@PortedFrom(file="ConjunctiveQueryFolding.cpp", name="TEquationSolver")
class TEquationSolver
implements Serializable {
    private static final long serialVersionUID = 11000L;
    private final ConjunctiveQueryFolding conjunctiveQueryFolding;
    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="LeftPart")
    private ConceptExpression LeftPart;
    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="RightPart")
    private ConceptExpression RightPart;
    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="ExpressionMarker")
    private final TExpressionMarker ExpressionMarker;

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="TEquationSolver")
    public TEquationSolver(ConjunctiveQueryFolding conjunctiveQueryFolding, ConceptExpression leftPart, IRI propositionalVariable, TExpressionMarker expressionMarker) {
        this.conjunctiveQueryFolding = conjunctiveQueryFolding;
        this.LeftPart = leftPart;
        this.RightPart = this.conjunctiveQueryFolding.getpEM().concept(propositionalVariable);
        this.ExpressionMarker = expressionMarker;
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="Solve")
    public void Solve() {
        while (!this.conjunctiveQueryFolding.isNominal(this.LeftPart)) {
            ConceptExpression newRightPart;
            ConceptExpression newLeftPart;
            if (this.LeftPart instanceof ConceptObjectExists) {
                ConceptObjectExists leftDiamond = (ConceptObjectExists)this.LeftPart;
                ObjectRoleInverse invRole = (ObjectRoleInverse)leftDiamond.getOR();
                ObjectRoleExpression role = invRole.getOR();
                newLeftPart = leftDiamond.getConcept();
                newRightPart = this.conjunctiveQueryFolding.getpEM().forall(role, this.RightPart);
                this.LeftPart = newLeftPart;
                this.RightPart = newRightPart;
                continue;
            }
            if (!(this.LeftPart instanceof ConceptAnd)) continue;
            ConceptAnd leftAnd = (ConceptAnd)this.LeftPart;
            ConceptExpression arg1 = (ConceptExpression)leftAnd.getArguments().get(0);
            ConceptExpression arg2 = (ConceptExpression)leftAnd.getArguments().get(1);
            if (!this.ExpressionMarker.KnownToBeSimple(arg1)) {
                ConceptExpression t = arg1;
                arg1 = arg2;
                arg2 = t;
            }
            newLeftPart = arg1;
            newRightPart = arg2 instanceof ConceptTop ? this.RightPart : this.conjunctiveQueryFolding.getpEM().or(this.conjunctiveQueryFolding.getpEM().not(arg2), this.RightPart);
            this.LeftPart = newLeftPart;
            this.RightPart = newRightPart;
        }
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="getNominal")
    public String getNominal() {
        IRI longNominal = ((ConceptName)this.LeftPart).getName();
        int colon = longNominal.toString().lastIndexOf(58);
        return longNominal.toString().substring(0, colon);
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="getPhi")
    public ConceptExpression getPhi() {
        return this.RightPart;
    }
}

