/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.PortedFrom;
import java.util.HashMap;
import java.util.Map;
import uk.ac.manchester.cs.jfact.kernel.ConjunctiveQueryFolding;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptAnd;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptName;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectExists;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptTop;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleInverse;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleName;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;
import uk.ac.manchester.cs.jfact.visitors.DLExpressionVisitorAdapter;

@PortedFrom(file="ConjunctiveQueryFolding.cpp", name="TDepthMeasurer")
public class TDepthMeasurer
extends DLExpressionVisitorAdapter {
    private static final long serialVersionUID = 11000L;
    private final ConjunctiveQueryFolding conjunctiveQueryFolding;
    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="DepthOfNominalOccurences")
    private final Map<ConceptExpression, Integer> DepthOfNominalOccurences = new HashMap<ConceptExpression, Integer>();
    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="CurrentDepth")
    private int CurrentDepth = 0;
    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="TotalNominalOccurences")
    private int TotalNominalOccurences = 0;

    public TDepthMeasurer(ConjunctiveQueryFolding conjunctiveQueryFolding) {
        this.conjunctiveQueryFolding = conjunctiveQueryFolding;
    }

    @Override
    public void visit(ConceptTop expr) {
    }

    @Override
    public void visit(ConceptName expr) {
        if (this.conjunctiveQueryFolding.isNominal(expr)) {
            this.DepthOfNominalOccurences.put(expr, this.CurrentDepth);
            ++this.TotalNominalOccurences;
        }
    }

    @Override
    public void visit(ConceptAnd expr) {
        for (ConceptExpression p : expr.getArguments()) {
            p.accept(this);
        }
    }

    @Override
    public void visit(ConceptObjectExists expr) {
        ObjectRoleExpression role1 = expr.getOR();
        if (role1 instanceof ObjectRoleName) {
            ++this.CurrentDepth;
            expr.getConcept().accept(this);
            --this.CurrentDepth;
        } else if (role1 instanceof ObjectRoleInverse) {
            expr.getConcept().accept(this);
        }
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="getMaxDepth")
    public int getMaxDepth() {
        int max = -1;
        for (Integer i : this.DepthOfNominalOccurences.values()) {
            if (i <= max) continue;
            max = i;
        }
        return max;
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="getNominalWithMaxDepth")
    public ConceptExpression getNominalWithMaxDepth() {
        ConceptExpression max = null;
        int maxvalue = -1;
        for (Map.Entry<ConceptExpression, Integer> e : this.DepthOfNominalOccurences.entrySet()) {
            if (e.getValue() < maxvalue) continue;
            max = e.getKey();
            maxvalue = e.getValue();
        }
        return max;
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="PrintDepthTable")
    public void PrintDepthTable() {
        System.out.println("Total nominal occurrences: " + this.TotalNominalOccurences + "\n");
        for (Map.Entry<ConceptExpression, Integer> e : this.DepthOfNominalOccurences.entrySet()) {
            System.out.print(e.getKey());
            System.out.println(" has depth " + e.getValue() + "\n");
        }
    }
}

