/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeEntry;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeExpression;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.LiteralEntry;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeFactory;
import uk.ac.manchester.cs.jfact.helpers.DLVertex;
import uk.ac.manchester.cs.jfact.helpers.FastSet;
import uk.ac.manchester.cs.jfact.helpers.FastSetFactory;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.helpers.Pair;
import uk.ac.manchester.cs.jfact.helpers.Templates;
import uk.ac.manchester.cs.jfact.helpers.Timer;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.AxiomSet;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.ConceptCreator;
import uk.ac.manchester.cs.jfact.kernel.DIOp;
import uk.ac.manchester.cs.jfact.kernel.DLConceptTaxonomy;
import uk.ac.manchester.cs.jfact.kernel.DLDag;
import uk.ac.manchester.cs.jfact.kernel.DagTag;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.DlSatTester;
import uk.ac.manchester.cs.jfact.kernel.DumpInterface;
import uk.ac.manchester.cs.jfact.kernel.DumpLisp;
import uk.ac.manchester.cs.jfact.kernel.Individual;
import uk.ac.manchester.cs.jfact.kernel.IndividualCreator;
import uk.ac.manchester.cs.jfact.kernel.KBFlags;
import uk.ac.manchester.cs.jfact.kernel.KBStatus;
import uk.ac.manchester.cs.jfact.kernel.Lexeme;
import uk.ac.manchester.cs.jfact.kernel.LogicFeatures;
import uk.ac.manchester.cs.jfact.kernel.MergableLabel;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.NamedEntryCollection;
import uk.ac.manchester.cs.jfact.kernel.NominalReasoner;
import uk.ac.manchester.cs.jfact.kernel.Related;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.RoleMaster;
import uk.ac.manchester.cs.jfact.kernel.SimpleRule;
import uk.ac.manchester.cs.jfact.kernel.Taxonomy;
import uk.ac.manchester.cs.jfact.kernel.Token;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.NamedEntity;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheConst;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheInterface;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheSingleton;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheState;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;
import uk.ac.manchester.cs.jfact.split.SplitVarEntry;
import uk.ac.manchester.cs.jfact.split.TSignature;
import uk.ac.manchester.cs.jfact.split.TSplitRules;
import uk.ac.manchester.cs.jfact.split.TSplitVar;
import uk.ac.manchester.cs.jfact.split.TSplitVars;

@PortedFrom(file="dlTBox.h", name="TBox")
public class TBox
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="dlTBox.h", name="relevance")
    private long relevance = 1L;
    @PortedFrom(file="dlTBox.h", name="DLHeap")
    private final DLDag dlHeap;
    @PortedFrom(file="dlTBox.h", name="stdReasoner")
    private DlSatTester stdReasoner = null;
    @PortedFrom(file="dlTBox.h", name="nomReasoner")
    private NominalReasoner nomReasoner;
    @PortedFrom(file="dlTBox.h", name="pTax")
    private Taxonomy pTax;
    @PortedFrom(file="dlTBox.h", name="pTaxCreator")
    private DLConceptTaxonomy pTaxCreator;
    @PortedFrom(file="dlTBox.h", name="pName2Sig")
    private Map<NamedEntity, TSignature> pName2Sig;
    @Original
    private final JFactReasonerConfiguration config;
    @PortedFrom(file="dlTBox.h", name="Status")
    private KBStatus kbStatus;
    @PortedFrom(file="dlTBox.h", name="KBFeatures")
    private final LogicFeatures KBFeatures = new LogicFeatures();
    @PortedFrom(file="dlTBox.h", name="GCIFeatures")
    private final LogicFeatures GCIFeatures = new LogicFeatures();
    @PortedFrom(file="dlTBox.h", name="NCFeatures")
    private LogicFeatures nominalCloudFeatures = new LogicFeatures();
    @PortedFrom(file="dlTBox.h", name="auxFeatures")
    private LogicFeatures auxFeatures = new LogicFeatures();
    @PortedFrom(file="dlTBox.h", name="curFeature")
    private LogicFeatures curFeature = null;
    @PortedFrom(file="dlTBox.h", name="pTemp")
    private Concept pTemp;
    @PortedFrom(file="dlTBox.h", name="pQuery")
    private Concept pQuery;
    @PortedFrom(file="dlTBox.h", name="concepts")
    private final NamedEntryCollection<Concept> concepts;
    @PortedFrom(file="dlTBox.h", name="individuals")
    private final NamedEntryCollection<Individual> individuals;
    @PortedFrom(file="dlTBox.h", name="ORM")
    private final RoleMaster objectRoleMaster;
    @PortedFrom(file="dlTBox.h", name="DRM")
    private final RoleMaster dataRoleMaster;
    @PortedFrom(file="dlTBox.h", name="Axioms")
    private AxiomSet axioms;
    @PortedFrom(file="dlTBox.h", name="RelatedI")
    private final List<Related> relatedIndividuals = new ArrayList<Related>();
    @PortedFrom(file="dlTBox.h", name="DifferentIndividuals")
    private final List<List<Individual>> differentIndividuals = new ArrayList<List<Individual>>();
    @PortedFrom(file="dlTBox.h", name="SimpleRules")
    private final List<SimpleRule> simpleRules = new ArrayList<SimpleRule>();
    @PortedFrom(file="dlTBox.h", name="SplitRules")
    private final TSplitRules SplitRules;
    @PortedFrom(file="dlTBox.h", name="T_G")
    private int internalisedGeneralAxiom;
    @PortedFrom(file="dlTBox.h", name="GCIs")
    private final KBFlags GCIs = new KBFlags();
    @PortedFrom(file="dlTBox.h", name="RCCache")
    private final Map<DLTree, Concept> forall_R_C_Cache = new HashMap<DLTree, Concept>();
    @PortedFrom(file="dlTBox.h", name="auxConceptID")
    private int auxConceptID = 0;
    @PortedFrom(file="dlTBox.h", name="nNominalReferences")
    private int nNominalReferences;
    @PortedFrom(file="dlTBox.h", name="CInProcess")
    private final Set<Concept> conceptInProcess = new HashSet<Concept>();
    @PortedFrom(file="dlTBox.h", name="Fairness")
    private final List<Concept> fairness = new ArrayList<Concept>();
    @PortedFrom(file="dlTBox.h", name="duringClassification")
    private boolean duringClassification;
    @PortedFrom(file="dlTBox.h", name="nSkipBeforeBlock")
    private int nSkipBeforeBlock;
    @PortedFrom(file="dlTBox.h", name="isLikeGALEN")
    private boolean isLikeGALEN;
    @PortedFrom(file="dlTBox.h", name="isLikeWINE")
    private boolean isLikeWINE;
    @PortedFrom(file="dlTBox.h", name="consistent")
    private boolean consistent;
    @PortedFrom(file="dlTBox.h", name="preprocTime")
    private long preprocTime;
    @PortedFrom(file="dlTBox.h", name="consistTime")
    private long consistTime;
    @PortedFrom(file="dlTBox.h", name="nC")
    protected int nC = 0;
    @PortedFrom(file="dlTBox.h", name="nR")
    protected int nR = 0;
    @PortedFrom(file="dlTBox.h", name="ConceptMap")
    private final List<Concept> ConceptMap = new ArrayList<Concept>();
    @PortedFrom(file="dlTBox.h", name="SameI")
    private final Map<Concept, Pair> sameIndividuals = new HashMap<Concept, Pair>();
    @PortedFrom(file="dlTBox.h", name="ToldSynonyms")
    private final Set<Concept> toldSynonyms = new HashSet<Concept>();
    @PortedFrom(file="dlTBox.h", name="Splits")
    private TSplitVars Splits;
    @PortedFrom(file="dlTBox.h", name="Status")
    private KBStatus status;
    @PortedFrom(file="dlTBox.h", name="arrayCD")
    private final List<Concept> arrayCD = new ArrayList<Concept>();
    @PortedFrom(file="dlTBox.h", name="arrayNoCD")
    private final List<Concept> arrayNoCD = new ArrayList<Concept>();
    @PortedFrom(file="dlTBox.h", name="arrayNP")
    private final List<Concept> arrayNP = new ArrayList<Concept>();
    @Original
    private int nItems = 0;
    @Original
    private final AtomicBoolean interrupted;
    @Original
    private final DatatypeFactory datatypeFactory;
    @PortedFrom(file="dlTBox.h", name="top")
    private Concept top;
    @PortedFrom(file="dlTBox.h", name="bottom")
    private Concept bottom;
    @PortedFrom(file="dlTBox.h", name="nRelevantCCalls")
    private long nRelevantCCalls;
    @PortedFrom(file="dlTBox.h", name="nRelevantBCalls")
    private long nRelevantBCalls;
    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="IV")
    private final IterableVec<Individual> IV = new IterableVec();
    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="concepts")
    private final List<Integer> conceptsForQueryAnswering = new ArrayList<Integer>();

    @PortedFrom(file="dlTBox.h", name="setSplitVars")
    public void setSplitVars(TSplitVars s) {
        this.Splits = s;
    }

    @PortedFrom(file="dlTBox.h", name="getSplitVars")
    public TSplitVars getSplits() {
        return this.Splits;
    }

    @PortedFrom(file="dlTBox.h", name="i_begin")
    public List<Individual> i_begin() {
        return this.individuals.getList();
    }

    @PortedFrom(file="dlTBox.h", name="c_begin")
    public List<Concept> getConcepts() {
        return this.concepts.getList();
    }

    @Original
    public JFactReasonerConfiguration getOptions() {
        return this.config;
    }

    @PortedFrom(file="dlTBox.h", name="getDataEntryByBP")
    public String getDataEntryByBP(int bp) {
        NamedEntry p = this.dlHeap.get(bp).getConcept();
        if (p instanceof DatatypeEntry) {
            return ((DatatypeEntry)p).getFacet().toString();
        }
        if (p instanceof LiteralEntry) {
            return ((LiteralEntry)p).getFacet().toString();
        }
        return "";
    }

    @PortedFrom(file="dlTBox.h", name="initNonPrimitive")
    public boolean initNonPrimitive(Concept p, DLTree desc) {
        if (!p.canInitNonPrim(desc)) {
            return true;
        }
        this.makeNonPrimitive(p, desc);
        return false;
    }

    @PortedFrom(file="dlTBox.h", name="makeNonPrimitive")
    public DLTree makeNonPrimitive(Concept p, DLTree desc) {
        DLTree ret = p.makeNonPrimitive(desc);
        this.checkEarlySynonym(p);
        return ret;
    }

    @PortedFrom(file="dlTBox.h", name="checkEarlySynonym")
    public void checkEarlySynonym(Concept p) {
        if (p.isSynonym()) {
            return;
        }
        if (p.isPrimitive()) {
            return;
        }
        if (!p.getDescription().isCN()) {
            return;
        }
        p.setSynonym(this.getCI(p.getDescription()));
        p.initToldSubsumers();
    }

    @PortedFrom(file="dlTBox.h", name="processDisjoint")
    public void processDisjoint(List<DLTree> beg) {
        while (!beg.isEmpty()) {
            DLTree r = beg.remove(0);
            this.addSubsumeAxiom(r, DLTreeFactory.buildDisjAux(beg));
        }
    }

    @PortedFrom(file="dlTBox.h", name="reflexive2dag")
    public int reflexive2dag(Role R) {
        if (!R.isSimple()) {
            throw new ReasonerInternalException("Non simple role used as simple: " + R.getName());
        }
        return -this.dlHeap.add(new DLVertex(DagTag.dtIrr, 0, R, 0, null));
    }

    @PortedFrom(file="dlTBox.h", name="dataForall2dag")
    public int dataForall2dag(Role R, int C) {
        return this.dlHeap.add(new DLVertex(DagTag.dtForall, 0, R, C, null));
    }

    @PortedFrom(file="dlTBox.h", name="dataAtMost2dag")
    public int dataAtMost2dag(int n, Role R, int C) {
        return this.dlHeap.add(new DLVertex(DagTag.dtLE, n, R, C, null));
    }

    @PortedFrom(file="dlTBox.h", name="concept2dag")
    public int concept2dag(Concept p) {
        if (p == null) {
            return 0;
        }
        if (!Helper.isValid(p.getpName())) {
            this.addConceptToHeap(p);
        }
        return p.resolveId();
    }

    @PortedFrom(file="dlTBox.h", name="processGCI")
    public void processGCI(DLTree C, DLTree D) {
        this.axioms.addAxiom(C, D);
    }

    @PortedFrom(file="dlTBox.h", name="AbsorbAxioms")
    public void absorbAxioms() {
        int nSynonyms = this.countSynonyms();
        this.axioms.absorb();
        if (this.countSynonyms() > nSynonyms) {
            this.replaceAllSynonyms();
        }
        if (this.axioms.wasRoleAbsorptionApplied()) {
            this.initToldSubsumers();
        }
    }

    @PortedFrom(file="dlTBox.h", name="initToldSubsumers")
    public void initToldSubsumers() {
        for (Concept pc : this.concepts.getList()) {
            if (pc.isSynonym()) continue;
            pc.initToldSubsumers();
        }
        for (Individual pi : this.individuals.getList()) {
            if (pi.isSynonym()) continue;
            pi.initToldSubsumers();
        }
    }

    @PortedFrom(file="dlTBox.h", name="setToldTop")
    public void setToldTop() {
        for (Concept pc : this.concepts.getList()) {
            pc.setToldTop(this.top);
        }
        for (Individual pi : this.individuals.getList()) {
            pi.setToldTop(this.top);
        }
    }

    @PortedFrom(file="dlTBox.h", name="calculateTSDepth")
    public void calculateTSDepth() {
        for (Concept pc : this.concepts.getList()) {
            pc.calculateTSDepth();
        }
        for (Individual pi : this.individuals.getList()) {
            pi.calculateTSDepth();
        }
    }

    @PortedFrom(file="dlTBox.h", name="countSynonyms")
    public int countSynonyms() {
        int nSynonyms = 0;
        for (Concept pc : this.concepts.getList()) {
            if (!pc.isSynonym()) continue;
            ++nSynonyms;
        }
        for (Individual pi : this.individuals.getList()) {
            if (!pi.isSynonym()) continue;
            ++nSynonyms;
        }
        return nSynonyms;
    }

    @PortedFrom(file="dlTBox.h", name="initRuleFields")
    public void initRuleFields(List<Concept> v, int index) {
        for (Concept q : v) {
            q.addExtraRule(index);
        }
    }

    @PortedFrom(file="dlTBox.h", name="fillsClassificationTag")
    public void fillsClassificationTag() {
        for (Concept pc : this.concepts.getList()) {
            pc.getClassTag();
        }
        for (Individual pi : this.individuals.getList()) {
            pi.getClassTag();
        }
    }

    @PortedFrom(file="dlTBox.h", name="setConceptIndex")
    public void setConceptIndex(Concept C) {
        C.setIndex(this.nC);
        this.ConceptMap.add(C);
        ++this.nC;
    }

    @PortedFrom(file="dlTBox.h", name="reasonersInited")
    private boolean reasonersInited() {
        return this.stdReasoner != null;
    }

    @PortedFrom(file="dlTBox.h", name="getReasoner")
    public DlSatTester getReasoner() {
        assert (this.curFeature != null);
        if (this.curFeature.hasSingletons()) {
            return this.nomReasoner;
        }
        return this.stdReasoner;
    }

    @PortedFrom(file="dlTBox.h", name="PrintConcepts")
    public void printConcepts(LogAdapter o) {
        if (this.concepts.size() == 0) {
            return;
        }
        o.print((Object)"Concepts (", (Object)this.concepts.size(), (Object)"):\n");
        for (Concept pc : this.concepts.getList()) {
            this.printConcept(o, pc);
        }
    }

    @PortedFrom(file="dlTBox.h", name="PrintIndividuals")
    public void printIndividuals(LogAdapter o) {
        if (this.individuals.size() == 0) {
            return;
        }
        o.print((Object)"Individuals (", (Object)this.individuals.size(), (Object)"):\n");
        for (Individual pi : this.individuals.getList()) {
            this.printConcept(o, pi);
        }
    }

    @PortedFrom(file="dlTBox.h", name="PrintSimpleRules")
    public void printSimpleRules(LogAdapter o) {
        if (this.simpleRules.isEmpty()) {
            return;
        }
        o.print((Object)"Simple rules (", (Object)this.simpleRules.size(), (Object)"):\n");
        for (SimpleRule p : this.simpleRules) {
            o.print("(");
            for (int i = 0; i < p.getBody().size(); ++i) {
                if (i > 0) {
                    o.print(", ");
                }
                o.print((Object)p.getBody().get(i).getName());
            }
            o.print((Object)") => ", (Object)p.tHead, (Object)"\n");
        }
    }

    @PortedFrom(file="dlTBox.h", name="PrintAxioms")
    public void printAxioms(LogAdapter o) {
        if (this.internalisedGeneralAxiom == 1) {
            return;
        }
        o.print("Axioms:\nT [=");
        this.printDagEntry(o, this.internalisedGeneralAxiom);
    }

    @PortedFrom(file="dlTBox.h", name="isIrreflexive")
    public boolean isIrreflexive(Role R) {
        assert (R != null);
        if (R.isDataRole()) {
            return true;
        }
        this.curFeature = this.KBFeatures;
        this.getReasoner().setBlockingMethod(this.isIRinQuery(), this.isNRinQuery());
        boolean result = this.getReasoner().checkIrreflexivity(R);
        this.clearFeatures();
        return result;
    }

    @PortedFrom(file="dlTBox.h", name="collectLogicFeature")
    private void collectLogicFeature(Concept p) {
        if (this.curFeature != null) {
            this.curFeature.fillConceptData(p);
        }
    }

    @PortedFrom(file="dlTBox.h", name="collectLogicFeature")
    private void collectLogicFeature(Role p) {
        if (this.curFeature != null) {
            this.curFeature.fillRoleData(p, p.inverse().isRelevant(this.relevance));
        }
    }

    @PortedFrom(file="dlTBox.h", name="collectLogicFeature")
    private void collectLogicFeature(DLVertex v, boolean pos) {
        if (this.curFeature != null) {
            this.curFeature.fillDAGData(v, pos);
        }
    }

    @PortedFrom(file="dlTBox.h", name="markGCIsRelevant")
    private void markGCIsRelevant() {
        this.setRelevant(this.internalisedGeneralAxiom);
    }

    @PortedFrom(file="dlTBox.h", name="markAllRelevant")
    private void markAllRelevant() {
        for (Concept pc : this.concepts.getList()) {
            if (pc.isRelevant(this.relevance)) continue;
            ++this.nRelevantCCalls;
            pc.setRelevant(this.relevance);
            this.collectLogicFeature(pc);
            this.setRelevant(pc.getpBody());
        }
        for (Individual pi : this.individuals.getList()) {
            if (pi.isRelevant(this.relevance)) continue;
            ++this.nRelevantCCalls;
            pi.setRelevant(this.relevance);
            this.collectLogicFeature(pi);
            this.setRelevant(pi.getpBody());
        }
        this.markGCIsRelevant();
    }

    @PortedFrom(file="dlTBox.h", name="clearRelevanceInfo")
    public void clearRelevanceInfo() {
        ++this.relevance;
    }

    @PortedFrom(file="dlTBox.h", name="getFreshConcept")
    public DLTree getFreshConcept() {
        return DLTreeFactory.buildTree(new Lexeme(Token.CNAME, this.pTemp));
    }

    @PortedFrom(file="dlTBox.h", name="setConceptRelevant")
    private void setConceptRelevant(Concept p) {
        this.curFeature = p.getPosFeatures();
        this.setRelevant(p.getpBody());
        this.KBFeatures.or(p.getPosFeatures());
        this.collectLogicFeature(p);
        this.clearRelevanceInfo();
        if (p.isPrimitive()) {
            return;
        }
        this.curFeature = p.getNegFeatures();
        this.setRelevant(-p.getpBody());
        this.KBFeatures.or(p.getNegFeatures());
        this.clearRelevanceInfo();
    }

    @PortedFrom(file="dlTBox.h", name="updateAuxFeatures")
    private void updateAuxFeatures(LogicFeatures lf) {
        if (!lf.isEmpty()) {
            this.auxFeatures.or(lf);
            this.auxFeatures.mergeRoles();
        }
    }

    @PortedFrom(file="dlTBox.h", name="clearFeatures")
    public void clearFeatures() {
        this.curFeature = null;
    }

    @PortedFrom(file="dlTBox.h", name="getORM")
    public RoleMaster getORM() {
        return this.objectRoleMaster;
    }

    @PortedFrom(file="dlTBox.h", name="getDRM")
    public RoleMaster getDRM() {
        return this.dataRoleMaster;
    }

    @PortedFrom(file="dlTBox.h", name="getRM")
    public RoleMaster getRM(Role R) {
        return R.isDataRole() ? this.dataRoleMaster : this.objectRoleMaster;
    }

    @PortedFrom(file="dlTBox.h", name="getDag")
    public DLDag getDag() {
        return this.dlHeap;
    }

    @PortedFrom(file="dlTBox.h", name="getConcept")
    public Concept getConcept(IRI name) {
        return this.concepts.get(name);
    }

    @PortedFrom(file="dlTBox.h", name="getIndividual")
    public Individual getIndividual(IRI name) {
        return this.individuals.get(name);
    }

    @PortedFrom(file="dlTBox.h", name="isIndividual")
    private boolean isIndividual(IRI name) {
        return this.individuals.isRegistered(name);
    }

    @PortedFrom(file="dlTBox.h", name="isIndividual")
    public boolean isIndividual(DLTree tree) {
        return tree.token() == Token.INAME && this.isIndividual(tree.elem().getNE().getName());
    }

    @PortedFrom(file="dlTBox.h", name="getCI")
    public Concept getCI(DLTree name) {
        if (name.isTOP()) {
            return this.top;
        }
        if (name.isBOTTOM()) {
            return this.bottom;
        }
        if (!name.isName()) {
            return null;
        }
        if (name.token() == Token.CNAME) {
            return (Concept)name.elem().getNE();
        }
        return (Individual)name.elem().getNE();
    }

    @PortedFrom(file="dlTBox.h", name="getTree")
    public DLTree getTree(Concept C) {
        if (C == null) {
            return null;
        }
        if (C.isTop()) {
            return DLTreeFactory.createTop();
        }
        if (C.isBottom()) {
            return DLTreeFactory.createBottom();
        }
        return DLTreeFactory.buildTree(new Lexeme(this.isIndividual(C.getName()) ? Token.INAME : Token.CNAME, C));
    }

    @PortedFrom(file="dlTBox.h", name="setForbidUndefinedNames")
    public boolean setForbidUndefinedNames(boolean val) {
        this.objectRoleMaster.setUndefinedNames(!val);
        this.dataRoleMaster.setUndefinedNames(!val);
        this.individuals.setLocked(val);
        return this.concepts.setLocked(val);
    }

    @PortedFrom(file="dlTBox.h", name="RegisterIndividualRelation")
    public void registerIndividualRelation(NamedEntry a, NamedEntry R, NamedEntry b) {
        if (!this.isIndividual(a.getName()) || !this.isIndividual(b.getName())) {
            throw new ReasonerInternalException("Individual expected in related()");
        }
        this.relatedIndividuals.add(new Related((Individual)a, (Individual)b, (Role)R));
        this.relatedIndividuals.add(new Related((Individual)b, (Individual)a, ((Role)R).inverse()));
    }

    @PortedFrom(file="dlTBox.h", name="addSubsumeAxiom")
    public void addSubsumeAxiom(Concept C, DLTree D) {
        this.addSubsumeAxiom(this.getTree(C), D);
    }

    @PortedFrom(file="dlTBox.h", name="addSimpleRule")
    private void addSimpleRule(SimpleRule Rule) {
        this.initRuleFields(Rule.getBody(), this.simpleRules.size());
        this.simpleRules.add(Rule);
    }

    @PortedFrom(file="dlTBox.h", name="finishLoading")
    public void finishLoading() {
        this.setForbidUndefinedNames(true);
    }

    @PortedFrom(file="dlTBox.h", name="hasFC")
    public boolean hasFC() {
        return !this.fairness.isEmpty();
    }

    @PortedFrom(file="dlTBox.h", name="setFairnessConstraint")
    private void setFairnessConstraint(Collection<DLTree> c) {
        for (DLTree beg : c) {
            if (beg.isName()) {
                this.fairness.add(this.getCI(beg));
                continue;
            }
            Concept fc = this.getAuxConcept(null);
            this.fairness.add(fc);
            this.addEqualityAxiom(this.getTree(fc), beg);
        }
        if (this.config.getuseAnywhereBlocking() && this.hasFC()) {
            this.config.setuseAnywhereBlocking(false);
            this.config.getLog().print("\nFairness constraints: set useAnywhereBlocking = 0");
        }
    }

    @PortedFrom(file="dlTBox.h", name="setFairnessConstraint")
    public void setFairnessConstraintDLTrees(List<DLTree> l) {
        for (int i = 0; i < l.size(); ++i) {
            Concept fc = this.getAuxConcept(null);
            this.fairness.add(fc);
            this.addSubsumeAxiom(l.get(i), this.getTree(fc));
        }
    }

    @PortedFrom(file="dlTBox.h", name="getTG")
    public int getTG() {
        return this.internalisedGeneralAxiom;
    }

    @PortedFrom(file="dlTBox.h", name="getSimpleRule")
    public SimpleRule getSimpleRule(int index) {
        return this.simpleRules.get(index);
    }

    @PortedFrom(file="dlTBox.h", name="isIRinQuery")
    public boolean isIRinQuery() {
        if (this.curFeature != null) {
            return this.curFeature.hasInverseRole();
        }
        return this.KBFeatures.hasInverseRole();
    }

    @PortedFrom(file="dlTBox.h", name="isNRinQuery")
    public boolean isNRinQuery() {
        LogicFeatures p = this.curFeature != null ? this.curFeature : this.KBFeatures;
        return p.hasFunctionalRestriction() || p.hasNumberRestriction() || p.hasQNumberRestriction();
    }

    @PortedFrom(file="dlTBox.h", name="testHasNominals")
    public boolean testHasNominals() {
        if (this.curFeature != null) {
            return this.curFeature.hasSingletons();
        }
        return this.KBFeatures.hasSingletons();
    }

    @PortedFrom(file="dlTBox.h", name="testHasTopRole")
    public boolean testHasTopRole() {
        if (this.curFeature != null) {
            return this.curFeature.hasTopRole();
        }
        return this.KBFeatures.hasTopRole();
    }

    @PortedFrom(file="dlTBox.h", name="canUseSortedReasoning")
    public boolean canUseSortedReasoning() {
        return this.config.isUseSortedReasoning() && !this.GCIs.isGCI() && !this.GCIs.isReflexive();
    }

    @PortedFrom(file="dlTBox.h", name="performClassification")
    public void performClassification() {
        this.createTaxonomy(false);
    }

    @PortedFrom(file="dlTBox.h", name="performRealisation")
    public void performRealisation() {
        this.createTaxonomy(true);
    }

    @PortedFrom(file="dlTBox.h", name="getTaxonomy")
    public Taxonomy getTaxonomy() {
        return this.pTax;
    }

    @PortedFrom(file="dlTBox.h", name="getStatus")
    public KBStatus getStatus() {
        return this.kbStatus;
    }

    @PortedFrom(file="dlTBox.h", name="setConsistency")
    public void setConsistency(boolean val) {
        this.kbStatus = KBStatus.kbCChecked;
        this.consistent = val;
    }

    @PortedFrom(file="dlTBox.h", name="isConsistent")
    public boolean isConsistent() {
        if (this.kbStatus.ordinal() < KBStatus.kbCChecked.ordinal()) {
            this.prepareReasoning();
            if (this.kbStatus.ordinal() < KBStatus.kbCChecked.ordinal() && this.consistent) {
                this.setConsistency(this.performConsistencyCheck());
            }
        }
        return this.consistent;
    }

    @PortedFrom(file="dlTBox.h", name="testSortedNonSubsumption")
    public boolean testSortedNonSubsumption(Concept p, Concept q) {
        if (!this.canUseSortedReasoning()) {
            return false;
        }
        if (q == null) {
            return false;
        }
        return !this.dlHeap.haveSameSort(p.getpName(), q.getpName());
    }

    @PortedFrom(file="dlTBox.h", name="print")
    public void print() {
        this.dlHeap.printStat(this.config.getLog());
        this.objectRoleMaster.print(this.config.getLog(), "Object");
        this.dataRoleMaster.print(this.config.getLog(), "Data");
        this.printConcepts(this.config.getLog());
        this.printIndividuals(this.config.getLog());
        this.printSimpleRules(this.config.getLog());
        this.printAxioms(this.config.getLog());
        this.config.getLog().print((Object)this.dlHeap);
    }

    @PortedFrom(file="dlTBox.h", name="buildDAG")
    public void buildDAG() {
        int nInd;
        this.nNominalReferences = 0;
        this.nC = 1;
        this.ConceptMap.add(null);
        this.concept2dag(this.pTemp);
        for (Concept pc : this.concepts.getList()) {
            this.concept2dag(pc);
        }
        for (Individual pi : this.individuals.getList()) {
            this.concept2dag(pi);
        }
        for (SimpleRule q : this.simpleRules) {
            q.setBpHead(this.tree2dag(q.tHead));
        }
        this.initRangeDomain(this.objectRoleMaster);
        this.initRangeDomain(this.dataRoleMaster);
        for (TSplitVar s : this.getSplits().getEntries()) {
            this.split2dag(s);
        }
        DLTree GCI = this.axioms.getGCI();
        ArrayList<DLTree> list = new ArrayList<DLTree>();
        if (this.config.isUseSpecialDomains()) {
            for (Role p : this.objectRoleMaster.getRoles()) {
                if (p.isSynonym() || !p.hasSpecialDomain()) continue;
                list.add(p.getTSpecialDomain().copy());
            }
        }
        if (!this.objectRoleMaster.getBotRole().isSimple()) {
            list.add(DLTreeFactory.createSNFForall(DLTreeFactory.createRole(this.objectRoleMaster.getBotRole()), DLTreeFactory.createBottom()));
        }
        if (!list.isEmpty()) {
            list.add(GCI);
            GCI = DLTreeFactory.createSNFAnd(list);
        }
        this.internalisedGeneralAxiom = this.tree2dag(GCI);
        GCI = null;
        this.GCIs.setGCI(this.internalisedGeneralAxiom != 1);
        this.GCIs.setReflexive(this.objectRoleMaster.hasReflexiveRoles());
        for (Role p : this.objectRoleMaster.getRoles()) {
            if (p.isSynonym() || !p.isTopFunc()) continue;
            p.setFunctional(this.atmost2dag(1, p, 1));
        }
        for (Role p : this.dataRoleMaster.getRoles()) {
            if (p.isSynonym() || !p.isTopFunc()) continue;
            p.setFunctional(this.atmost2dag(1, p, 1));
        }
        if (this.nNominalReferences > 0 && (nInd = this.individuals.getList().size()) > 100 && this.nNominalReferences > nInd) {
            this.isLikeWINE = true;
        }
        this.dlHeap.setFinalSize();
    }

    @PortedFrom(file="dlTBox.h", name="initRangeDomain")
    public void initRangeDomain(RoleMaster RM) {
        for (Role p : RM.getRoles()) {
            if (p.isSynonym()) continue;
            Role R = p;
            if (this.config.isRKG_UPDATE_RND_FROM_SUPERROLES()) {
                R.collectDomainFromSupers();
            }
            DLTree dom = R.getTDomain();
            int bp = 1;
            if (dom != null) {
                bp = this.tree2dag(dom);
                this.GCIs.setRnD(true);
            }
            R.setBPDomain(bp);
            R.initSpecialDomain();
            if (!R.hasSpecialDomain()) continue;
            R.setSpecialDomain(this.tree2dag(R.getTSpecialDomain()));
        }
    }

    @PortedFrom(file="dlTBox.h", name="buildSplitRules")
    private void buildSplitRules() {
        if (!this.getSplits().empty()) {
            this.getSplitRules().createSplitRules(this.getSplits());
            this.getSplitRules().initEntityMap(this.dlHeap);
        }
    }

    @PortedFrom(file="dlTBox.h", name="addDataExprToHeap")
    public int addDataExprToHeap(LiteralEntry p) {
        int toReturn = 0;
        if (Helper.isValid(p.getIndex())) {
            toReturn = p.getIndex();
        } else {
            DagTag dt = DagTag.dtDataValue;
            int hostBP = 1;
            if (p.getType() != null) {
                hostBP = this.addDatatypeExpressionToHeap(p.getType());
            }
            DLVertex ver = new DLVertex(dt, 0, null, hostBP, null);
            ver.setConcept(p);
            p.setIndex(this.dlHeap.directAdd(ver));
            toReturn = p.getIndex();
        }
        return toReturn;
    }

    @PortedFrom(file="dlTBox.h", name="addDataExprToHeap")
    public int addDataExprToHeap(DatatypeEntry p) {
        int toReturn = 0;
        if (Helper.isValid(p.getIndex())) {
            toReturn = p.getIndex();
        } else {
            DagTag dt = p.isBasicDataType() ? DagTag.dtDataType : DagTag.dtDataExpr;
            int hostBP = 1;
            if (!p.isBasicDataType()) {
                Datatype baseType = ((DatatypeExpression)p.getDatatype()).getHostType();
                hostBP = this.addDatatypeExpressionToHeap(baseType);
            }
            DLVertex ver = new DLVertex(dt, 0, null, hostBP, null);
            ver.setConcept(p);
            p.setIndex(this.dlHeap.directAdd(ver));
            toReturn = p.getIndex();
        }
        return toReturn;
    }

    @Original
    public int addDatatypeExpressionToHeap(Datatype<?> p) {
        int hostBP = 0;
        DatatypeEntry concept = new DatatypeEntry(p);
        int index = this.dlHeap.index(concept);
        if (index != 0) {
            hostBP = index;
        } else {
            int directAdd;
            DLVertex ver = new DLVertex(DagTag.dtDataType, 0, null, 1, null);
            ver.setConcept(concept);
            hostBP = directAdd = this.dlHeap.directAdd(ver);
        }
        return hostBP;
    }

    @PortedFrom(file="dlTBox.h", name="addConceptToHeap")
    public void addConceptToHeap(Concept pConcept) {
        DagTag tag;
        DagTag dagTag = pConcept.isPrimitive() ? (pConcept.isSingleton() ? DagTag.dtPSingleton : DagTag.dtPConcept) : (tag = pConcept.isSingleton() ? DagTag.dtNSingleton : DagTag.dtNConcept);
        if (tag == DagTag.dtNSingleton && !pConcept.isSynonym()) {
            ((Individual)pConcept).setNominal(true);
        }
        DLVertex ver = new DLVertex(tag);
        ver.setConcept(pConcept);
        pConcept.setpName(this.dlHeap.directAdd(ver));
        int desc = 1;
        if (pConcept.getDescription() != null) {
            desc = this.tree2dag(pConcept.getDescription());
        } else assert (pConcept.isPrimitive());
        pConcept.setpBody(desc);
        ver.setChild(desc);
        if (!pConcept.isSynonym() && pConcept.getIndex() == 0) {
            this.setConceptIndex(pConcept);
        }
    }

    @PortedFrom(file="dlTBox.h", name="tree2dag")
    public int tree2dag(DLTree t) {
        if (t == null) {
            return 0;
        }
        Lexeme cur = t.elem();
        int ret = 0;
        switch (cur.getToken()) {
            case BOTTOM: {
                ret = -1;
                break;
            }
            case TOP: {
                ret = 1;
                break;
            }
            case DATAEXPR: {
                if (cur.getNE() instanceof DatatypeEntry) {
                    ret = this.addDataExprToHeap((DatatypeEntry)cur.getNE());
                    break;
                }
                ret = this.addDataExprToHeap((LiteralEntry)cur.getNE());
                break;
            }
            case CNAME: {
                ret = this.concept2dag((Concept)cur.getNE());
                break;
            }
            case INAME: {
                ++this.nNominalReferences;
                Individual ind = (Individual)cur.getNE();
                ind.setNominal(true);
                ret = this.concept2dag(ind);
                break;
            }
            case NOT: {
                ret = -this.tree2dag(t.getChild());
                break;
            }
            case AND: {
                ret = this.and2dag(new DLVertex(DagTag.dtAnd), t);
                break;
            }
            case FORALL: {
                ret = this.forall2dag(Role.resolveRole(t.getLeft()), this.tree2dag(t.getRight()));
                break;
            }
            case SELF: {
                ret = this.reflexive2dag(Role.resolveRole(t.getChild()));
                break;
            }
            case LE: {
                ret = this.atmost2dag(cur.getData(), Role.resolveRole(t.getLeft()), this.tree2dag(t.getRight()));
                break;
            }
            case PROJFROM: {
                ret = this.dlHeap.directAdd(new DLVertex(DagTag.dtProj, 0, Role.resolveRole(t.getLeft()), this.tree2dag(t.getRight().getRight()), Role.resolveRole(t.getRight().getLeft())));
                break;
            }
            default: {
                assert (DLTreeFactory.isSNF(t));
                throw new UnreachableSituationException();
            }
        }
        return ret;
    }

    @PortedFrom(file="dlTBox.h", name="and2dag")
    public int and2dag(DLVertex v, DLTree t) {
        int ret = -1;
        if (!this.fillANDVertex(v, t)) {
            int value = v.getAndToDagValue();
            if (value != 0) {
                return value;
            }
            return this.dlHeap.add(v);
        }
        return ret;
    }

    @PortedFrom(file="dlTBox.h", name="forall2dag")
    public int forall2dag(Role R, int C) {
        if (R.isDataRole()) {
            return this.dataForall2dag(R, C);
        }
        int ret = this.dlHeap.add(new DLVertex(DagTag.dtForall, 0, R, C, null));
        if (R.isSimple()) {
            return ret;
        }
        if (!this.dlHeap.isLast(ret)) {
            return ret;
        }
        for (int i = 1; i < R.getAutomaton().size(); ++i) {
            this.dlHeap.directAddAndCache(new DLVertex(DagTag.dtForall, i, R, C, null));
        }
        return ret;
    }

    @PortedFrom(file="dlTBox.h", name="atmost2dag")
    public int atmost2dag(int n, Role R, int C) {
        if (!R.isSimple()) {
            throw new ReasonerInternalException("Non simple role used as simple: " + R.getName());
        }
        if (R.isDataRole()) {
            return this.dataAtMost2dag(n, R, C);
        }
        if (C == -1) {
            return 1;
        }
        int ret = this.dlHeap.add(new DLVertex(DagTag.dtLE, n, R, C, null));
        if (!this.dlHeap.isLast(ret)) {
            return ret;
        }
        for (int m = n - 1; m > 0; --m) {
            this.dlHeap.directAddAndCache(new DLVertex(DagTag.dtLE, m, R, C, null));
        }
        this.dlHeap.directAddAndCache(new DLVertex(DagTag.dtNN));
        return ret;
    }

    @PortedFrom(file="dlTBox.h", name="split2dag")
    private void split2dag(TSplitVar split) {
        DLVertex v = new DLVertex(DagTag.dtSplitConcept);
        for (SplitVarEntry p : split.getEntries()) {
            v.addChild(p.concept.getpName());
        }
        split.getC().setpBody(this.dlHeap.directAdd(v));
        split.getC().setPrimitive(false);
        this.dlHeap.replaceVertex(split.getC().getpName(), new DLVertex(DagTag.dtNConcept, 0, null, split.getC().getpBody(), null), split.getC());
        this.dlHeap.directAdd(new DLVertex(DagTag.dtChoose, 0, null, split.getC().getpName(), null));
    }

    @PortedFrom(file="dlTBox.h", name="fillANDVertex")
    private boolean fillANDVertex(DLVertex v, DLTree t) {
        if (t.isAND()) {
            boolean ret = false;
            List<DLTree> children = t.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                ret |= this.fillANDVertex(v, children.get(i));
            }
            return ret;
        }
        return v.addChild(this.tree2dag(t));
    }

    @PortedFrom(file="dlTBox.h", name="fillArrays")
    public <T extends Concept> int fillArrays(List<T> begin) {
        int n = 0;
        block4: for (Concept p : begin) {
            if (p.isNonClassifiable()) continue;
            ++n;
            switch (p.getClassTag()) {
                case cttTrueCompletelyDefined: {
                    this.arrayCD.add(p);
                    continue block4;
                }
                case cttNonPrimitive: 
                case cttHasNonPrimitiveTS: {
                    this.arrayNP.add(p);
                    continue block4;
                }
            }
            this.arrayNoCD.add(p);
        }
        return n;
    }

    @Original
    public int getNItems() {
        return this.nItems;
    }

    @PortedFrom(file="dlTBox.h", name="createTaxonomy")
    public void createTaxonomy(boolean needIndividual) {
        boolean needConcept = !needIndividual;
        this.clearQueryConcept();
        this.dlHeap.setSubOrder();
        this.pTaxCreator.setBottomUp(this.GCIs);
        needConcept |= needIndividual;
        if (this.config.getverboseOutput()) {
            this.config.getLog().print("Processing query...\n");
        }
        Timer locTimer = new Timer();
        locTimer.start();
        this.nItems = 0;
        this.arrayCD.clear();
        this.arrayNoCD.clear();
        this.arrayNP.clear();
        this.nItems += this.fillArrays(this.concepts.getList());
        this.nItems += this.fillArrays(this.individuals.getList());
        if (this.config.getProgressMonitor() != null) {
            this.config.getProgressMonitor().reasonerTaskStarted("Classifying");
        }
        this.duringClassification = true;
        this.classifyConcepts(this.arrayCD, true, "completely defined");
        this.classifyConcepts(this.arrayNoCD, false, "regular");
        this.classifyConcepts(this.arrayNP, false, "non-primitive");
        this.duringClassification = false;
        this.pTaxCreator.processSplits();
        if (this.config.getProgressMonitor() != null) {
            this.config.getProgressMonitor().reasonerTaskStopped();
        }
        this.pTax.finalise();
        locTimer.stop();
        if (this.config.getverboseOutput()) {
            this.config.getLog().print(" done in ").print(locTimer.calcDelta()).print(" seconds\n\n");
        }
        if (needConcept && this.kbStatus.ordinal() < KBStatus.kbClassified.ordinal()) {
            this.kbStatus = KBStatus.kbClassified;
        }
        if (needIndividual) {
            this.kbStatus = KBStatus.kbRealised;
        }
        if (this.config.getverboseOutput()) {
            this.config.getLog().print((Object)this.pTax);
        }
    }

    @PortedFrom(file="dlTBox.h", name="classifyConcepts")
    public void classifyConcepts(List<Concept> collection, boolean curCompletelyDefined, String type) {
        this.pTaxCreator.setCompletelyDefined(curCompletelyDefined);
        this.config.getLog().printTemplate(Templates.CLASSIFY_CONCEPTS, type);
        int n = 0;
        for (Concept q : collection) {
            if (this.interrupted.get() || q.isClassified()) continue;
            this.classifyEntry(q);
            if (!q.isClassified()) continue;
            ++n;
        }
        this.config.getLog().printTemplate(Templates.CLASSIFY_CONCEPTS2, n, type);
    }

    @PortedFrom(file="dlTBox.h", name="classifyEntry")
    private void classifyEntry(Concept entry) {
        if (this.isBlockedInd(entry)) {
            this.classifyEntry(this.getBlockingInd(entry));
        }
        if (!entry.isClassified()) {
            this.pTaxCreator.classifyEntry(entry);
        }
    }

    public TBox(DatatypeFactory datatypeFactory, JFactReasonerConfiguration configuration, IRI topObjectRoleName, IRI botObjectRoleName, IRI topDataRoleName, IRI botDataRoleName, AtomicBoolean interrupted) {
        this.datatypeFactory = datatypeFactory;
        this.interrupted = interrupted;
        this.config = configuration;
        this.SplitRules = new TSplitRules(configuration);
        this.axioms = new AxiomSet(this);
        this.dlHeap = new DLDag(configuration);
        this.kbStatus = KBStatus.kbLoading;
        this.pQuery = null;
        this.concepts = new NamedEntryCollection<Concept>("concept", new ConceptCreator(), this.config);
        this.individuals = new NamedEntryCollection<Individual>("individual", new IndividualCreator(), this.config);
        this.objectRoleMaster = new RoleMaster(false, topObjectRoleName, botObjectRoleName, this.config);
        this.dataRoleMaster = new RoleMaster(true, topDataRoleName, botDataRoleName, this.config);
        this.axioms = new AxiomSet(this);
        this.internalisedGeneralAxiom = 1;
        this.duringClassification = false;
        this.isLikeGALEN = false;
        this.isLikeWINE = false;
        this.consistent = true;
        this.preprocTime = 0L;
        this.consistTime = 0L;
        this.config.getLog().printTemplate(Templates.READ_CONFIG, this.config.getuseCompletelyDefined(), "useRelevantOnly(obsolete)", this.config.getdumpQuery(), this.config.getalwaysPreferEquals());
        this.axioms.initAbsorptionFlags(this.config.getabsorptionFlags());
        this.initTopBottom();
        this.setForbidUndefinedNames(false);
        this.initTaxonomy();
    }

    @PortedFrom(file="dlTBox.h", name="getAuxConcept")
    public Concept getAuxConcept(DLTree desc) {
        boolean old = this.setForbidUndefinedNames(false);
        Concept C = this.getConcept(IRI.create((String)("urn:aux" + ++this.auxConceptID)));
        this.setForbidUndefinedNames(old);
        C.setSystem();
        C.setNonClassifiable(true);
        C.setPrimitive(true);
        C.addDesc(desc);
        C.initToldSubsumers();
        return C;
    }

    @PortedFrom(file="dlTBox.h", name="initTopBottom")
    private void initTopBottom() {
        this.top = Concept.getTOP();
        this.bottom = Concept.getBOTTOM();
        this.pTemp = Concept.getTEMP();
        this.pQuery = Concept.getQuery();
    }

    @PortedFrom(file="dlTBox.h", name="prepareReasoning")
    public void prepareReasoning() {
        this.preprocess();
        this.initReasoner();
        this.dumpQuery();
        this.dlHeap.setSatOrder();
    }

    @Original
    private void dumpQuery() {
        if (this.config.getdumpQuery()) {
            this.markAllRelevant();
            DumpLisp lDump = new DumpLisp(this.config.getLog());
            this.dump(lDump);
            this.clearRelevanceInfo();
        }
    }

    @PortedFrom(file="dlTBox.h", name="prepareFeatures")
    public void prepareFeatures(Concept pConcept, Concept qConcept) {
        this.auxFeatures = new LogicFeatures(this.GCIFeatures);
        if (pConcept != null) {
            this.updateAuxFeatures(pConcept.getPosFeatures());
        }
        if (qConcept != null) {
            this.updateAuxFeatures(qConcept.getNegFeatures());
        }
        if (this.auxFeatures.hasSingletons()) {
            this.updateAuxFeatures(this.nominalCloudFeatures);
        }
        this.curFeature = this.auxFeatures;
        this.getReasoner().setBlockingMethod(this.isIRinQuery(), this.isNRinQuery());
    }

    @PortedFrom(file="dlTBox.h", name="buildSimpleCache")
    public void buildSimpleCache() {
        this.initConstCache(-1);
        this.initSingletonCache(this.pTemp, true);
        this.initSingletonCache(this.pTemp, false);
        if (this.GCIs.isGCI() || this.GCIs.isReflexive()) {
            return;
        }
        this.initConstCache(1);
        for (Concept pc : this.concepts.getList()) {
            if (!pc.isPrimitive()) continue;
            this.initSingletonCache(pc, false);
        }
        for (Individual pi : this.individuals.getList()) {
            if (!pi.isPrimitive()) continue;
            this.initSingletonCache(pi, false);
        }
    }

    @PortedFrom(file="dlTBox.h", name="performConsistencyCheck")
    public boolean performConsistencyCheck() {
        if (this.config.getverboseOutput()) {
            this.config.getLog().print("Consistency checking...\n");
        }
        Timer pt = new Timer();
        pt.start();
        this.buildSimpleCache();
        Individual test = this.nominalCloudFeatures.hasSingletons() && this.individuals.getList().size() > 0 ? this.individuals.getList().get(0) : null;
        this.prepareFeatures(test, null);
        boolean ret = false;
        if (test != null) {
            if (this.dlHeap.getCache(1) == null) {
                this.initConstCache(1);
            }
            ret = this.nomReasoner.consistentNominalCloud();
        } else {
            ret = this.isSatisfiable(this.top);
            if (this.GCIs.isGCI()) {
                this.dlHeap.setCache(-this.internalisedGeneralAxiom, new ModelCacheConst(false));
            }
        }
        pt.stop();
        this.consistTime = pt.calcDelta();
        if (this.config.getverboseOutput()) {
            this.config.getLog().print(" done in ").print(this.consistTime).print(" seconds\n\n");
        }
        return ret;
    }

    @PortedFrom(file="dlTBox.h", name="isSatisfiable")
    public boolean isSatisfiable(Concept pConcept) {
        assert (pConcept != null);
        ModelCacheInterface cache = this.dlHeap.getCache(pConcept.getpName());
        if (cache != null) {
            return cache.getState() != ModelCacheState.csInvalid;
        }
        this.config.getLog().printTemplate(Templates.IS_SATISFIABLE, pConcept.getName());
        this.prepareFeatures(pConcept, null);
        boolean result = this.getReasoner().runSat(pConcept.resolveId(), 1);
        cache = this.getReasoner().buildCacheByCGraph(result);
        this.dlHeap.setCache(pConcept.getpName(), cache);
        this.clearFeatures();
        this.config.getLog().printTemplate(Templates.IS_SATISFIABLE1, pConcept.getName(), !result ? "un" : "");
        return result;
    }

    @PortedFrom(file="dlTBox.h", name="isSubHolds")
    public boolean isSubHolds(Concept pConcept, Concept qConcept) {
        assert (pConcept != null && qConcept != null);
        this.config.getLog().printTemplate(Templates.ISSUBHOLDS1, pConcept.getName(), qConcept.getName());
        this.prepareFeatures(pConcept, qConcept);
        boolean result = !this.getReasoner().runSat(pConcept.resolveId(), -qConcept.resolveId());
        this.clearFeatures();
        this.config.getLog().printTemplate(Templates.ISSUBHOLDS2, pConcept.getName(), qConcept.getName(), !result ? " NOT" : "");
        return result;
    }

    @PortedFrom(file="dlTBox.h", name="isSameIndividuals")
    public boolean isSameIndividuals(Individual _a, Individual _b) {
        Individual b;
        Individual a = ClassifiableEntry.resolveSynonym(_a);
        if (a.equals(b = ClassifiableEntry.resolveSynonym(_b))) {
            return true;
        }
        if (!this.isIndividual(a.getName()) || !this.isIndividual(b.getName())) {
            throw new ReasonerInternalException("Individuals are expected in the isSameIndividuals() query");
        }
        if (a.getNode() == null || b.getNode() == null) {
            if (a.isSynonym()) {
                return this.isSameIndividuals((Individual)a.getSynonym(), b);
            }
            if (b.isSynonym()) {
                return this.isSameIndividuals(a, (Individual)b.getSynonym());
            }
            return false;
        }
        return a.getTaxVertex().equals(b.getTaxVertex());
    }

    @PortedFrom(file="dlTBox.h", name="isDisjointRoles")
    public boolean isDisjointRoles(Role R, Role S) {
        assert (R != null && S != null);
        if (R.isDataRole() != S.isDataRole()) {
            return true;
        }
        this.curFeature = this.KBFeatures;
        this.getReasoner().setBlockingMethod(this.isIRinQuery(), this.isNRinQuery());
        boolean result = this.getReasoner().checkDisjointRoles(R, S);
        this.clearFeatures();
        return result;
    }

    @PortedFrom(file="dlTBox.h", name="createQueryConcept")
    public Concept createQueryConcept(DLTree desc) {
        assert (desc != null);
        this.clearQueryConcept();
        this.makeNonPrimitive(this.pQuery, desc.copy());
        this.pQuery.setIndex(this.nC - 1);
        return this.pQuery;
    }

    @PortedFrom(file="dlTBox.h", name="preprocessQueryConcept")
    public void preprocessQueryConcept(Concept query) {
        this.addConceptToHeap(query);
        this.setConceptRelevant(query);
        this.initCache(query, false);
    }

    @PortedFrom(file="dlTBox.h", name="clearQueryConcept")
    public void clearQueryConcept() {
        this.dlHeap.removeQuery();
    }

    @PortedFrom(file="dlTBox.h", name="classifyQueryConcept")
    public void classifyQueryConcept() {
        this.pQuery.initToldSubsumers();
        assert (this.pTax != null);
        this.pTaxCreator.setCompletelyDefined(false);
        this.pTaxCreator.classifyEntry(this.pQuery);
    }

    @PortedFrom(file="dlTBox.h", name="buildCompletionTree")
    public DlCompletionTree buildCompletionTree(Concept pConcept) {
        DlCompletionTree ret = null;
        this.prepareFeatures(pConcept, null);
        this.config.setUseNodeCache(false);
        if (this.getReasoner().runSat(pConcept.resolveId(), 1)) {
            ret = this.getReasoner().getRootNode();
        }
        this.config.setUseNodeCache(true);
        this.clearFeatures();
        return ret;
    }

    @PortedFrom(file="dlTBox.h", name="writeReasoningResult")
    public void writeReasoningResult(long time) {
        LogAdapter o = this.config.getLog();
        if (this.nomReasoner != null) {
            o.print("Query processing reasoning statistic: Nominals");
            this.nomReasoner.writeTotalStatistic(o);
        }
        o.print("Query processing reasoning statistic: Standard");
        this.stdReasoner.writeTotalStatistic(o);
        assert (this.kbStatus.ordinal() >= KBStatus.kbCChecked.ordinal());
        if (this.consistent) {
            o.print("Required");
        } else {
            o.print("KB is inconsistent. Query is NOT processed\nConsistency");
        }
        long sum = this.preprocTime + this.consistTime;
        o.print(" check done in ").print(time).print(" seconds\nof which:\nPreproc. takes ").print(this.preprocTime).print(" seconds\nConsist. takes ").print(this.consistTime).print(" seconds");
        if (this.nomReasoner != null) {
            o.print("\nReasoning NOM:");
            sum = (long)((float)sum + this.nomReasoner.printReasoningTime(o));
        }
        o.print("\nReasoning STD:");
        sum = (long)((float)sum + this.stdReasoner.printReasoningTime(o));
        o.print("\nThe rest takes ");
        long f = time - sum;
        if (f < 0L) {
            f = 0L;
        }
        o.print((float)f / 1000.0f);
        o.print(" seconds\n");
        this.print();
    }

    @PortedFrom(file="dlTBox.h", name="PrintDagEntry")
    public void printDagEntry(LogAdapter o, int p) {
        assert (Helper.isValid(p));
        if (p == 1) {
            o.print(" *TOP*");
            return;
        }
        if (p == -1) {
            o.print(" *BOTTOM*");
            return;
        }
        if (p < 0) {
            o.print(" (not");
            this.printDagEntry(o, -p);
            o.print(")");
            return;
        }
        DLVertex v = this.dlHeap.get(Math.abs(p));
        DagTag type = v.getType();
        switch (type) {
            case dtTop: {
                o.print(" *TOP*");
                return;
            }
            case dtPConcept: 
            case dtNConcept: 
            case dtPSingleton: 
            case dtNSingleton: 
            case dtDataType: 
            case dtDataValue: {
                o.print(" ");
                o.print((Object)v.getConcept().getName());
                return;
            }
            case dtDataExpr: {
                o.print(" ");
                o.print(this.getDataEntryByBP(p));
                return;
            }
            case dtIrr: {
                o.print((Object)" (", (Object)type.getName(), (Object)" ", (Object)v.getRole().getName(), (Object)")");
                return;
            }
            case dtCollection: 
            case dtAnd: 
            case dtSplitConcept: {
                o.print(" (");
                o.print(type.getName());
                for (int q : v.begin()) {
                    this.printDagEntry(o, q);
                }
                o.print(")");
                return;
            }
            case dtForall: 
            case dtLE: {
                o.print(" (");
                o.print(type.getName());
                if (type == DagTag.dtLE) {
                    o.print(" ");
                    o.print(v.getNumberLE());
                }
                o.print(" ");
                o.print((Object)v.getRole().getName());
                this.printDagEntry(o, v.getConceptIndex());
                o.print(")");
                return;
            }
            case dtProj: {
                o.print((Object)" (", (Object)type.getName(), (Object)" ", (Object)v.getRole().getName(), (Object)")");
                this.printDagEntry(o, v.getConceptIndex());
                o.print((Object)" => ", (Object)v.getProjRole().getName(), (Object)")");
                return;
            }
            case dtNN: 
            case dtChoose: {
                throw new UnreachableSituationException();
            }
            case dtBad: {
                o.print("WRONG: printing a badtag dtBad!\n");
                break;
            }
            default: {
                throw new ReasonerInternalException("Error printing vertex of type " + type.getName() + "(" + (Object)((Object)type) + ")");
            }
        }
    }

    @PortedFrom(file="dlTBox.h", name="PrintConcept")
    public void printConcept(LogAdapter o, Concept p) {
        if (Helper.isValid(p.getpName())) {
            o.print(p.getClassTagPlain().getCTTagName());
            if (p.isSingleton()) {
                o.print(p.isNominal() ? (char)'o' : '!');
            }
            o.print(".", p.getName(), " [", p.getTsDepth(), "] ", p.isPrimitive() ? "[=" : "=");
            if (Helper.isValid(p.getpBody())) {
                this.printDagEntry(o, p.getpBody());
            }
            if (p.getDescription() != null) {
                o.print((Object)(p.isPrimitive() ? "\n-[=" : "\n-="), (Object)p.getDescription());
            }
            o.print("\n");
        }
    }

    @PortedFrom(file="dlTBox.h", name="dump")
    private void dump(DumpInterface dump) {
        dump.prologue();
        this.dumpAllRoles(dump);
        for (Concept pc : this.concepts.getList()) {
            if (!pc.isRelevant(this.relevance)) continue;
            this.dumpConcept(dump, pc);
        }
        for (Individual pi : this.individuals.getList()) {
            if (!pi.isRelevant(this.relevance)) continue;
            this.dumpConcept(dump, pi);
        }
        if (this.internalisedGeneralAxiom != 1) {
            dump.startAx(DIOp.diImpliesC);
            dump.dumpTop();
            dump.contAx(DIOp.diImpliesC);
            this.dumpExpression(dump, this.internalisedGeneralAxiom);
            dump.finishAx(DIOp.diImpliesC);
        }
        dump.epilogue();
    }

    @PortedFrom(file="dlTBox.h", name="dumpConcept")
    public void dumpConcept(DumpInterface dump, Concept p) {
        dump.startAx(DIOp.diDefineC);
        dump.dumpConcept(p);
        dump.finishAx(DIOp.diDefineC);
        if (p.getpBody() != 1) {
            DIOp Ax = p.isPrimitive() ? DIOp.diImpliesC : DIOp.diEqualsC;
            dump.startAx(Ax);
            dump.dumpConcept(p);
            dump.contAx(Ax);
            this.dumpExpression(dump, p.getpBody());
            dump.finishAx(Ax);
        }
    }

    @PortedFrom(file="dlTBox.h", name="dumpRole")
    public void dumpRole(DumpInterface dump, Role p) {
        if (p.getId() > 0 || !p.inverse().isRelevant(this.relevance)) {
            Role q = p.getId() > 0 ? p : p.inverse();
            dump.startAx(DIOp.diDefineR);
            dump.dumpRole(q);
            dump.finishAx(DIOp.diDefineR);
            for (ClassifiableEntry i : q.getToldSubsumers()) {
                dump.startAx(DIOp.diImpliesR);
                dump.dumpRole(q);
                dump.contAx(DIOp.diImpliesR);
                dump.dumpRole((Role)i);
                dump.finishAx(DIOp.diImpliesR);
            }
        }
        if (p.isTransitive()) {
            dump.startAx(DIOp.diTransitiveR);
            dump.dumpRole(p);
            dump.finishAx(DIOp.diTransitiveR);
        }
        if (p.isTopFunc()) {
            dump.startAx(DIOp.diFunctionalR);
            dump.dumpRole(p);
            dump.finishAx(DIOp.diFunctionalR);
        }
        if (p.getBPDomain() != 1) {
            dump.startAx(DIOp.diDomainR);
            dump.dumpRole(p);
            dump.contAx(DIOp.diDomainR);
            this.dumpExpression(dump, p.getBPDomain());
            dump.finishAx(DIOp.diDomainR);
        }
        if (p.getBPRange() != 1) {
            dump.startAx(DIOp.diRangeR);
            dump.dumpRole(p);
            dump.contAx(DIOp.diRangeR);
            this.dumpExpression(dump, p.getBPRange());
            dump.finishAx(DIOp.diRangeR);
        }
    }

    @PortedFrom(file="dlTBox.h", name="dumpExpression")
    public void dumpExpression(DumpInterface dump, int p) {
        assert (Helper.isValid(p));
        if (p == 1) {
            dump.dumpTop();
            return;
        }
        if (p == -1) {
            dump.dumpBottom();
            return;
        }
        if (p < 0) {
            dump.startOp(DIOp.diNot);
            this.dumpExpression(dump, -p);
            dump.finishOp(DIOp.diNot);
            return;
        }
        DLVertex v = this.dlHeap.get(Math.abs(p));
        DagTag type = v.getType();
        switch (type) {
            case dtTop: {
                dump.dumpTop();
                return;
            }
            case dtPConcept: 
            case dtNConcept: 
            case dtPSingleton: 
            case dtNSingleton: {
                dump.dumpConcept((Concept)v.getConcept());
                return;
            }
            case dtAnd: {
                int[] begin;
                dump.startOp(DIOp.diAnd);
                for (int q : begin = v.begin()) {
                    if (q != begin[0]) {
                        dump.contOp(DIOp.diAnd);
                    }
                    this.dumpExpression(dump, q);
                }
                dump.finishOp(DIOp.diAnd);
                return;
            }
            case dtForall: {
                dump.startOp(DIOp.diForall);
                dump.dumpRole(v.getRole());
                dump.contOp(DIOp.diForall);
                this.dumpExpression(dump, v.getConceptIndex());
                dump.finishOp(DIOp.diForall);
                return;
            }
            case dtLE: {
                dump.startOp(DIOp.diLE, v.getNumberLE());
                dump.dumpRole(v.getRole());
                dump.contOp(DIOp.diLE);
                this.dumpExpression(dump, v.getConceptIndex());
                dump.finishOp(DIOp.diLE);
                return;
            }
        }
        throw new ReasonerInternalException("Error dumping vertex of type " + type.getName() + "(" + (Object)((Object)type) + ")");
    }

    @PortedFrom(file="dlTBox.h", name="dumpAllRoles")
    public void dumpAllRoles(DumpInterface dump) {
        for (Role p : this.objectRoleMaster.getRoles()) {
            if (!p.isRelevant(this.relevance)) continue;
            assert (!p.isSynonym());
            this.dumpRole(dump, p);
        }
        for (Role p : this.dataRoleMaster.getRoles()) {
            if (!p.isRelevant(this.relevance)) continue;
            assert (!p.isSynonym());
            this.dumpRole(dump, p);
        }
    }

    @PortedFrom(file="dlTBox.h", name="addSubsumeAxiom")
    public void addSubsumeAxiom(DLTree sub, DLTree sup) {
        if (DLTree.equalTrees(sub, sup)) {
            return;
        }
        if (sup.isCN() && (sup = this.applyAxiomCToCN(sub, sup)) == null) {
            return;
        }
        if (sub.isCN() && (sub = this.applyAxiomCNToC(sub, sup)) == null) {
            return;
        }
        if (!this.axiomToRangeDomain(sub, sup)) {
            this.processGCI(sub, sup);
        }
    }

    @PortedFrom(file="dlTBox.h", name="applyAxiomCToCN")
    public DLTree applyAxiomCToCN(DLTree D, DLTree CN) {
        Concept C = ClassifiableEntry.resolveSynonym(this.getCI(CN));
        assert (C != null);
        if (C.isBottom()) {
            return DLTreeFactory.createBottom();
        }
        if (!C.isTop()) {
            if (!(C.isSingleton() && D.isName() || !DLTree.equalTrees(C.getDescription(), D))) {
                this.makeNonPrimitive(C, D);
            } else {
                return CN;
            }
        }
        return null;
    }

    @PortedFrom(file="dlTBox.h", name="applyAxiomCNToC")
    public DLTree applyAxiomCNToC(DLTree CN, DLTree D) {
        Concept C = ClassifiableEntry.resolveSynonym(this.getCI(CN));
        assert (C != null);
        if (C.isTop()) {
            return DLTreeFactory.createTop();
        }
        if (!C.isBottom()) {
            if (C.isPrimitive()) {
                C.addDesc(D);
            } else {
                this.addSubsumeForDefined(C, D);
            }
        }
        return null;
    }

    @PortedFrom(file="dlTBox.h", name="addSubsumeForDefined")
    public void addSubsumeForDefined(Concept C, DLTree D) {
        if (DLTreeFactory.isSubTree(D, C.getDescription())) {
            return;
        }
        DLTree oldDesc = C.getDescription().copy();
        C.removeSelfFromDescription();
        if (DLTree.equalTrees(oldDesc, C.getDescription())) {
            this.processGCI(oldDesc, D);
            return;
        }
        C.setPrimitive(true);
        C.addDesc(D);
        this.addSubsumeAxiom(oldDesc, this.getTree(C));
    }

    @PortedFrom(file="dlTBox.h", name="axiomToRangeDomain")
    public boolean axiomToRangeDomain(DLTree sub, DLTree sup) {
        if (sub.isTOP() && sup.token() == Token.FORALL) {
            Role.resolveRole(sup.getLeft()).setRange(sup.getRight().copy());
            return true;
        }
        if (sub.token() == Token.NOT && sub.getChild().token() == Token.FORALL && sub.getChild().getRight().isBOTTOM()) {
            Role.resolveRole(sub.getChild().getLeft()).setDomain(sup);
            return true;
        }
        return false;
    }

    @PortedFrom(file="dlTBox.h", name="addEqualityAxiom")
    private void addEqualityAxiom(DLTree left, DLTree right) {
        if (this.addNonprimitiveDefinition(left, right)) {
            return;
        }
        if (this.addNonprimitiveDefinition(right, left)) {
            return;
        }
        if (this.switchToNonprimitive(left, right)) {
            return;
        }
        if (this.switchToNonprimitive(right, left)) {
            return;
        }
        this.addSubsumeAxiom(left.copy(), right.copy());
        this.addSubsumeAxiom(right, left);
    }

    @PortedFrom(file="dlTBox.h", name="addNonprimitiveDefinition")
    public boolean addNonprimitiveDefinition(DLTree left, DLTree right) {
        Concept C = ClassifiableEntry.resolveSynonym(this.getCI(left));
        if (C == null || C.isTop() || C.isBottom()) {
            return false;
        }
        Concept D = this.getCI(right);
        if (D != null && ClassifiableEntry.resolveSynonym(D).equals(C)) {
            return true;
        }
        if (C.isSingleton() && D != null && !D.isSingleton()) {
            return false;
        }
        return (D == null || C.getDescription() == null || D.isPrimitive()) && !this.initNonPrimitive(C, right);
    }

    @PortedFrom(file="dlTBox.h", name="switchToNonprimitive")
    public boolean switchToNonprimitive(DLTree left, DLTree right) {
        Concept C = ClassifiableEntry.resolveSynonym(this.getCI(left));
        if (C == null || C.isTop() || C.isBottom()) {
            return false;
        }
        Concept D = ClassifiableEntry.resolveSynonym(this.getCI(right));
        if (C.isSingleton() && D != null && !D.isSingleton()) {
            return false;
        }
        if (this.config.getalwaysPreferEquals() && C.isPrimitive()) {
            this.addSubsumeForDefined(C, this.makeNonPrimitive(C, right));
            return true;
        }
        return false;
    }

    @PortedFrom(file="dlTBox.h", name="processDisjointC")
    public void processDisjointC(Collection<DLTree> beg) {
        ArrayList<DLTree> prim = new ArrayList<DLTree>();
        ArrayList<DLTree> rest = new ArrayList<DLTree>();
        for (DLTree d : beg) {
            if (d.isName() && ((Concept)d.elem().getNE()).isPrimitive()) {
                prim.add(d);
                continue;
            }
            rest.add(d);
        }
        if (!prim.isEmpty() && !rest.isEmpty()) {
            DLTree nrest = DLTreeFactory.buildDisjAux(rest);
            for (DLTree q : prim) {
                this.addSubsumeAxiom(q.copy(), nrest.copy());
            }
        }
        if (!rest.isEmpty()) {
            this.processDisjoint(rest);
        }
        if (!prim.isEmpty()) {
            this.processDisjoint(prim);
        }
    }

    @PortedFrom(file="dlTBox.h", name="processEquivalentC")
    public void processEquivalentC(List<DLTree> l) {
        for (int i = 0; i < l.size() - 1; ++i) {
            this.addEqualityAxiom(l.get(i), l.get(i + 1).copy());
        }
    }

    @PortedFrom(file="dlTBox.h", name="processDifferent")
    public void processDifferent(List<DLTree> l) {
        ArrayList<Individual> acc = new ArrayList<Individual>();
        for (int i = 0; i < l.size(); ++i) {
            if (!this.isIndividual(l.get(i))) {
                throw new ReasonerInternalException("Only individuals allowed in processDifferent()");
            }
            acc.add((Individual)l.get(i).elem().getNE());
            l.set(i, null);
        }
        if (acc.size() > 1) {
            this.differentIndividuals.add(acc);
        }
    }

    @PortedFrom(file="dlTBox.h", name="processSame")
    public void processSame(List<DLTree> l) {
        int i;
        int size = l.size();
        for (i = 0; i < size; ++i) {
            if (this.isIndividual(l.get(i))) continue;
            throw new ReasonerInternalException("Only individuals allowed in processSame()");
        }
        for (i = 0; i < size - 1; ++i) {
            this.addEqualityAxiom(l.get(i), l.get(i + 1).copy());
        }
    }

    @PortedFrom(file="dlTBox.h", name="processDisjointR")
    public void processDisjointR(List<DLTree> l) {
        if (l.isEmpty()) {
            throw new ReasonerInternalException("Empty disjoint role axiom");
        }
        int size = l.size();
        for (int i = 0; i < size; ++i) {
            if (!DLTreeFactory.isTopRole(l.get(i))) continue;
            throw new ReasonerInternalException("Universal role in the disjoint roles axiom");
        }
        ArrayList<Role> roles = new ArrayList<Role>(size);
        for (int i = 0; i < size; ++i) {
            roles.add(Role.resolveRole(l.get(i)));
        }
        RoleMaster RM = this.getRM((Role)roles.get(0));
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i + 1; j < size; ++j) {
                RM.addDisjointRoles((Role)roles.get(i), (Role)roles.get(j));
            }
        }
    }

    @PortedFrom(file="dlTBox.h", name="processEquivalentR")
    public void processEquivalentR(List<DLTree> l) {
        if (!l.isEmpty()) {
            RoleMaster RM = this.getRM(Role.resolveRole(l.get(0)));
            for (int i = 0; i < l.size() - 1; ++i) {
                RM.addRoleSynonym(Role.resolveRole(l.get(i)), Role.resolveRole(l.get(i + 1)));
            }
            l.clear();
        }
    }

    @PortedFrom(file="dlTBox.h", name="preprocess")
    public void preprocess() {
        if (this.config.getverboseOutput()) {
            this.config.getLog().print("\nPreprocessing...\n");
        }
        Timer pt = new Timer();
        pt.start();
        this.objectRoleMaster.initAncDesc();
        this.dataRoleMaster.initAncDesc();
        if (this.config.getverboseOutput()) {
            this.config.getLog().print((Object)this.objectRoleMaster.getTaxonomy());
            this.config.getLog().print((Object)this.dataRoleMaster.getTaxonomy());
        }
        if (this.countSynonyms() > 0) {
            this.replaceAllSynonyms();
        }
        this.preprocessRelated();
        this.initToldSubsumers();
        this.transformToldCycles();
        this.transformSingletonHierarchy();
        this.absorbAxioms();
        this.setToldTop();
        this.buildDAG();
        this.buildSplitRules();
        this.fillsClassificationTag();
        this.calculateTSDepth();
        this.setAllIndexes();
        this.determineSorts();
        this.gatherRelevanceInfo();
        this.printFeatures();
        this.dlHeap.setOrderDefaults(this.isLikeGALEN ? "Fdn" : (this.isLikeWINE ? "Sdp" : "Sap"), this.isLikeGALEN ? "Ban" : (this.isLikeWINE ? "Fdn" : "Dap"));
        this.dlHeap.gatherStatistic();
        this.calculateStatistic();
        this.removeExtraDescriptions();
        pt.stop();
        this.preprocTime = pt.calcDelta();
        if (this.config.getverboseOutput()) {
            this.config.getLog().print(" done in ").print(pt.calcDelta()).print(" seconds\n\n");
        }
    }

    @PortedFrom(file="dlTBox.h", name="setAllIndexes")
    private void setAllIndexes() {
        ++this.nC;
        this.nR = 1;
        for (Role r : this.objectRoleMaster.getRoles()) {
            if (r.isSynonym()) continue;
            r.setIndex(this.nR++);
        }
        for (Role r : this.dataRoleMaster.getRoles()) {
            if (r.isSynonym()) continue;
            r.setIndex(this.nR++);
        }
    }

    @PortedFrom(file="dlTBox.h", name="replaceAllSynonyms")
    private void replaceAllSynonyms() {
        for (Role r : this.objectRoleMaster.getRoles()) {
            if (r.isSynonym()) continue;
            DLTreeFactory.replaceSynonymsFromTree(r.getTDomain());
        }
        for (Role dr : this.dataRoleMaster.getRoles()) {
            if (dr.isSynonym()) continue;
            DLTreeFactory.replaceSynonymsFromTree(dr.getTDomain());
        }
        for (Concept pc : this.concepts.getList()) {
            if (!DLTreeFactory.replaceSynonymsFromTree(pc.getDescription())) continue;
            pc.initToldSubsumers();
        }
        for (Individual pi : this.individuals.getList()) {
            if (!DLTreeFactory.replaceSynonymsFromTree(pi.getDescription())) continue;
            pi.initToldSubsumers();
        }
    }

    @PortedFrom(file="dlTBox.h", name="preprocessRelated")
    public void preprocessRelated() {
        for (Related q : this.relatedIndividuals) {
            q.simplify();
        }
    }

    @PortedFrom(file="dlTBox.h", name="transformToldCycles")
    public void transformToldCycles() {
        int nSynonyms = this.countSynonyms();
        this.clearRelevanceInfo();
        for (Concept pc : this.concepts.getList()) {
            if (pc.isSynonym()) continue;
            this.checkToldCycle(pc);
        }
        for (Individual pi : this.individuals.getList()) {
            if (pi.isSynonym()) continue;
            this.checkToldCycle(pi);
        }
        this.clearRelevanceInfo();
        nSynonyms = this.countSynonyms() - nSynonyms;
        if (nSynonyms > 0) {
            this.config.getLog().printTemplate(Templates.TRANSFORM_TOLD_CYCLES, nSynonyms);
            this.replaceAllSynonyms();
        }
    }

    @PortedFrom(file="dlTBox.h", name="checkToldCycle")
    public Concept checkToldCycle(Concept _p) {
        assert (_p != null);
        Concept p = ClassifiableEntry.resolveSynonym(_p);
        if (p.isTop()) {
            return null;
        }
        if (this.conceptInProcess.contains(p)) {
            return p;
        }
        if (p.isRelevant(this.relevance)) {
            return null;
        }
        Concept ret = null;
        this.conceptInProcess.add(p);
        boolean redo = false;
        block0: while (!redo) {
            redo = true;
            for (ClassifiableEntry r : p.getToldSubsumers()) {
                ret = this.checkToldCycle((Concept)r);
                if (ret == null) continue;
                if (ret.equals(p)) {
                    this.toldSynonyms.add(p);
                    for (Concept q : this.toldSynonyms) {
                        if (!q.isSingleton()) continue;
                        p = q;
                    }
                    HashSet<DLTree> leaves = new HashSet<DLTree>();
                    for (Concept q : this.toldSynonyms) {
                        if (q == p) continue;
                        DLTree d = this.makeNonPrimitive(q, this.getTree(p));
                        if (d.isBOTTOM()) {
                            leaves.clear();
                            leaves.add(d);
                            break;
                        }
                        leaves.add(d);
                    }
                    this.toldSynonyms.clear();
                    p.setPrimitive(true);
                    p.addLeaves(leaves);
                    p.removeSelfFromDescription();
                    if (!ret.equals(p)) {
                        this.conceptInProcess.remove(ret);
                        this.conceptInProcess.add(p);
                        ret.setRelevant(this.relevance);
                        p.dropRelevant();
                    }
                    ret = null;
                    redo = false;
                    continue block0;
                }
                this.toldSynonyms.add(p);
                redo = true;
                continue block0;
            }
        }
        this.conceptInProcess.remove(p);
        p.setRelevant(this.relevance);
        return ret;
    }

    @PortedFrom(file="dlTBox.h", name="transformSingletonHierarchy")
    public void transformSingletonHierarchy() {
        boolean changed;
        int nSynonyms = this.countSynonyms();
        do {
            changed = false;
            for (Individual pi : this.individuals.getList()) {
                if (pi.isSynonym() || !pi.isHasSP()) continue;
                Individual i = this.transformSingletonWithSP(pi);
                i.removeSelfFromDescription();
                changed = true;
            }
        } while (changed);
        nSynonyms = this.countSynonyms() - nSynonyms;
        if (nSynonyms > 0) {
            this.replaceAllSynonyms();
        }
    }

    @PortedFrom(file="dlTBox.h", name="getSPForConcept")
    public Individual getSPForConcept(Concept p) {
        for (ClassifiableEntry r : p.getToldSubsumers()) {
            Concept i = (Concept)r;
            if (i.isSingleton()) {
                return (Individual)i;
            }
            if (!i.isHasSP()) continue;
            return this.transformSingletonWithSP(i);
        }
        throw new UnreachableSituationException();
    }

    @PortedFrom(file="dlTBox.h", name="transformSingletonWithSP")
    private Individual transformSingletonWithSP(Concept p) {
        Individual i = this.getSPForConcept(p);
        if (p.isSingleton()) {
            i.addRelated((Individual)p);
        }
        this.addSubsumeAxiom(i, this.makeNonPrimitive(p, this.getTree(i)));
        return i;
    }

    @PortedFrom(file="dlTBox.h", name="determineSorts")
    public void determineSorts() {
        if (this.config.isRKG_USE_SORTED_REASONING()) {
            for (Related p : this.relatedIndividuals) {
                this.dlHeap.updateSorts(p.getA().getpName(), p.getRole(), p.getB().getpName());
            }
            for (SimpleRule q : this.simpleRules) {
                MergableLabel lab = this.dlHeap.get(q.bpHead).getSort();
                for (Concept r : q.simpleRuleBody) {
                    this.dlHeap.merge(lab, r.getpName());
                }
            }
            this.dlHeap.determineSorts(this.objectRoleMaster, this.dataRoleMaster);
        }
    }

    @PortedFrom(file="dlTBox.h", name="CalculateStatistic")
    public void calculateStatistic() {
        Concept n;
        int npFull = 0;
        int nsFull = 0;
        int nPC = 0;
        int nNC = 0;
        int nSing = 0;
        int nNoTold = 0;
        for (Concept pc : this.concepts.getList()) {
            n = pc;
            if (!Helper.isValid(n.getpName())) continue;
            if (n.isPrimitive()) {
                ++nPC;
            } else {
                ++nNC;
            }
            if (n.isSynonym()) {
                ++nsFull;
            }
            if (n.isCompletelyDefined()) {
                if (!n.isPrimitive()) continue;
                ++npFull;
                continue;
            }
            if (n.hasToldSubsumers()) continue;
            ++nNoTold;
        }
        for (Individual pi : this.individuals.getList()) {
            n = pi;
            if (!Helper.isValid(n.getpName())) continue;
            ++nSing;
            if (n.isPrimitive()) {
                ++nPC;
            } else {
                ++nNC;
            }
            if (n.isSynonym()) {
                ++nsFull;
            }
            if (n.isCompletelyDefined()) {
                if (!n.isPrimitive()) continue;
                ++npFull;
                continue;
            }
            if (n.hasToldSubsumers()) continue;
            ++nNoTold;
        }
        this.config.getLog().print("There are ").print(nPC).print(" primitive concepts used\n of which ").print(npFull).print(" completely defined\n      and ").print(nNoTold).print(" has no told subsumers\nThere are ").print(nNC).print(" non-primitive concepts used\n of which ").print(nsFull).print(" synonyms\nThere are ").print(nSing).print(" individuals or nominals used\n");
    }

    @PortedFrom(file="dlTBox.h", name="RemoveExtraDescriptions")
    public void removeExtraDescriptions() {
        for (Concept pc : this.concepts.getList()) {
            pc.removeDescription();
        }
        for (Individual pi : this.individuals.getList()) {
            pi.removeDescription();
        }
    }

    @Original
    public void setToDoPriorities() {
        this.stdReasoner.initToDoPriorities();
        if (this.nomReasoner != null) {
            this.nomReasoner.initToDoPriorities();
        }
    }

    @PortedFrom(file="dlTBox.h", name="isBlockedInd")
    public boolean isBlockedInd(Concept C) {
        return this.sameIndividuals.containsKey(C);
    }

    @PortedFrom(file="dlTBox.h", name="getBlockingInd")
    public Individual getBlockingInd(Concept C) {
        return this.sameIndividuals.get((Object)C).first;
    }

    @PortedFrom(file="dlTBox.h", name="isBlockingDet")
    public boolean isBlockingDet(Concept C) {
        return this.sameIndividuals.get((Object)C).second;
    }

    @PortedFrom(file="dlTBox.h", name="initConstCache")
    private void initConstCache(int p) {
        this.dlHeap.setCache(p, ModelCacheConst.createConstCache(p));
    }

    @PortedFrom(file="dlTBox.h", name="initSingletonCache")
    private void initSingletonCache(Concept p, boolean pos) {
        this.dlHeap.setCache(Helper.createBiPointer(p.getpName(), pos), new ModelCacheSingleton(Helper.createBiPointer(p.getIndex(), pos)));
    }

    @PortedFrom(file="dlTBox.h", name="initCache")
    public ModelCacheInterface initCache(Concept pConcept, boolean sub) {
        int bp = sub ? -pConcept.getpName() : pConcept.getpName();
        ModelCacheInterface cache = this.dlHeap.getCache(bp);
        if (cache == null) {
            if (sub) {
                this.prepareFeatures(null, pConcept);
            } else {
                this.prepareFeatures(pConcept, null);
            }
            cache = this.getReasoner().createCache(bp, FastSetFactory.create());
            this.clearFeatures();
        }
        return cache;
    }

    @PortedFrom(file="dlTBox.h", name="testCachedNonSubsumption")
    public ModelCacheState testCachedNonSubsumption(Concept p, Concept q) {
        ModelCacheInterface pCache = this.initCache(p, false);
        ModelCacheInterface nCache = this.initCache(q, true);
        return pCache.canMerge(nCache);
    }

    @PortedFrom(file="dlTBox.h", name="initReasoner")
    public void initReasoner() {
        assert (!this.reasonersInited());
        this.stdReasoner = new DlSatTester(this, this.config, this.datatypeFactory);
        if (this.nominalCloudFeatures.hasSingletons()) {
            this.nomReasoner = new NominalReasoner(this, this.config, this.datatypeFactory);
        }
        this.setToDoPriorities();
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="initTaxonomy")
    public void initTaxonomy() {
        this.pTax = new Taxonomy(this.top, this.bottom, this.config);
        this.pTaxCreator = new DLConceptTaxonomy(this.pTax, this);
    }

    @PortedFrom(file="dlTBox.h", name="setNameSigMap")
    public void setNameSigMap(Map<NamedEntity, TSignature> p) {
        this.pName2Sig = p;
    }

    @Original
    public TSignature getSignature(ClassifiableEntry c) {
        if (this.pName2Sig == null) {
            return null;
        }
        if (c.getEntity() == null) {
            return null;
        }
        return this.pName2Sig.get(c.getEntity());
    }

    @PortedFrom(file="dlTBox.h", name="setRelevant")
    private void setRelevant(int _p) {
        FastSet done = FastSetFactory.create();
        LinkedList<Integer> queue = new LinkedList<Integer>();
        queue.add(_p);
        block8: while (!queue.isEmpty()) {
            int p = (Integer)queue.remove(0);
            if (done.contains(p)) continue;
            done.add(p);
            assert (Helper.isValid(p));
            if (p == 1 || p == -1) continue;
            DLVertex v = this.realSetRelevant(p);
            DagTag type = v.getType();
            switch (type) {
                case dtDataType: 
                case dtDataValue: 
                case dtDataExpr: 
                case dtNN: {
                    break;
                }
                case dtPConcept: 
                case dtNConcept: 
                case dtPSingleton: 
                case dtNSingleton: {
                    Concept concept = (Concept)v.getConcept();
                    if (concept.isRelevant(this.relevance)) continue block8;
                    ++this.nRelevantCCalls;
                    concept.setRelevant(this.relevance);
                    this.collectLogicFeature(concept);
                    queue.add(concept.getpBody());
                    break;
                }
                case dtForall: 
                case dtLE: {
                    Role _role = v.getRole();
                    LinkedList<Role> rolesToExplore = new LinkedList<Role>();
                    rolesToExplore.add(_role);
                    while (!rolesToExplore.isEmpty()) {
                        Role roleToExplore = (Role)rolesToExplore.remove(0);
                        if (roleToExplore.getId() == 0 && !roleToExplore.isTop() || roleToExplore.isRelevant(this.relevance)) continue;
                        roleToExplore.setRelevant(this.relevance);
                        this.collectLogicFeature(roleToExplore);
                        queue.add(roleToExplore.getBPDomain());
                        queue.add(roleToExplore.getBPRange());
                        rolesToExplore.addAll(roleToExplore.getAncestor());
                    }
                    queue.add(v.getConceptIndex());
                    break;
                }
                case dtProj: 
                case dtChoose: {
                    queue.add(v.getConceptIndex());
                    break;
                }
                case dtIrr: {
                    Role __role = v.getRole();
                    LinkedList<Role> _rolesToExplore = new LinkedList<Role>();
                    _rolesToExplore.add(__role);
                    while (_rolesToExplore.size() > 0) {
                        Role roleToExplore = (Role)_rolesToExplore.remove(0);
                        if (roleToExplore.getId() == 0 || roleToExplore.isRelevant(this.relevance)) continue;
                        roleToExplore.setRelevant(this.relevance);
                        this.collectLogicFeature(roleToExplore);
                        queue.add(roleToExplore.getBPDomain());
                        queue.add(roleToExplore.getBPRange());
                        _rolesToExplore.addAll(roleToExplore.getAncestor());
                    }
                    continue block8;
                }
                case dtCollection: 
                case dtAnd: 
                case dtSplitConcept: {
                    for (int q : v.begin()) {
                        queue.add(q);
                    }
                    continue block8;
                }
                default: {
                    throw new ReasonerInternalException("Error setting relevant vertex of type " + (Object)((Object)type));
                }
            }
        }
    }

    @Original
    private DLVertex realSetRelevant(int p) {
        DLVertex v = this.dlHeap.get(p);
        boolean pos = p > 0;
        ++this.nRelevantBCalls;
        this.collectLogicFeature(v, pos);
        return v;
    }

    @PortedFrom(file="dlTBox.h", name="gatherRelevanceInfo")
    private void gatherRelevanceInfo() {
        this.nRelevantCCalls = 0L;
        this.nRelevantBCalls = 0L;
        int bSize = 0;
        this.curFeature = this.GCIFeatures;
        this.markGCIsRelevant();
        this.clearRelevanceInfo();
        this.KBFeatures.or(this.GCIFeatures);
        this.nominalCloudFeatures = new LogicFeatures(this.GCIFeatures);
        for (Individual pi : this.individuals.getList()) {
            this.setConceptRelevant(pi);
            this.nominalCloudFeatures.or(pi.getPosFeatures());
        }
        if (this.nominalCloudFeatures.hasSomeAll() && !this.relatedIndividuals.isEmpty()) {
            this.nominalCloudFeatures.setInverseRoles();
        }
        for (Concept pc : this.concepts.getList()) {
            this.setConceptRelevant(pc);
        }
        bSize = this.dlHeap.size() - 2;
        this.curFeature = null;
        double bRatio = 0.0;
        double sqBSize = 1.0;
        if (bSize > 20) {
            bRatio = (float)this.nRelevantBCalls / (float)bSize;
            sqBSize = Math.sqrt(bSize);
        }
        boolean bl = this.isLikeGALEN = bRatio > sqBSize * 20.0 && bRatio < (double)bSize;
        if (this.KBFeatures.hasTopRole()) {
            this.config.setUseSortedReasoning(false);
        }
    }

    @PortedFrom(file="dlTBox.h", name="printFeatures")
    public void printFeatures() {
        this.KBFeatures.writeState(this.config.getLog());
        this.config.getLog().print("KB contains ", this.GCIs.isGCI() ? "" : "NO ", "GCIs\nKB contains ", this.GCIs.isReflexive() ? "" : "NO ", "reflexive roles\nKB contains ", this.GCIs.isRnD() ? "" : "NO ", "range and domain restrictions\n");
    }

    @Original
    public List<List<Individual>> getDifferent() {
        return this.differentIndividuals;
    }

    @Original
    public List<Related> getRelatedI() {
        return this.relatedIndividuals;
    }

    @Original
    public DLDag getDLHeap() {
        return this.dlHeap;
    }

    @Original
    public KBFlags getGCIs() {
        return this.GCIs;
    }

    @PortedFrom(file="dlTBox.h", name="replaceForall")
    public Concept replaceForall(DLTree RC) {
        if (this.forall_R_C_Cache.containsKey(RC)) {
            return this.forall_R_C_Cache.get(RC);
        }
        Concept X = this.getAuxConcept(null);
        DLTree C = DLTreeFactory.createSNFNot(RC.getRight().copy());
        this.addSubsumeAxiom(C, DLTreeFactory.createSNFForall(DLTreeFactory.createInverse(RC.getLeft().copy()), this.getTree(X)));
        this.forall_R_C_Cache.put(RC, X);
        return X;
    }

    @PortedFrom(file="dlTBox.h", name="isCancelled")
    public AtomicBoolean isCancelled() {
        return this.interrupted;
    }

    @Original
    public List<Concept> getFairness() {
        return this.fairness;
    }

    public void addSameIndividuals(Individual p, Pair pair) {
        this.sameIndividuals.put(p, pair);
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="answerQuery")
    public void answerQuery(List<DLTree> Cs) {
        this.dlHeap.removeQuery();
        this.getConceptsForQueryAnswering().clear();
        for (DLTree q : Cs) {
            this.getConceptsForQueryAnswering().add(this.tree2dag(q));
        }
    }

    public void reclassify(Set<NamedEntity> MPlus, Set<NamedEntity> MMinus) {
        this.pTaxCreator.reclassify(MPlus, MMinus);
        this.status = KBStatus.kbRealised;
    }

    public List<Integer> getConceptsForQueryAnswering() {
        return this.conceptsForQueryAnswering;
    }

    public boolean isDuringClassification() {
        return this.duringClassification;
    }

    public TSplitRules getSplitRules() {
        return this.SplitRules;
    }

    public IterableVec<Individual> getIV() {
        return this.IV;
    }

    public int getnSkipBeforeBlock() {
        return this.nSkipBeforeBlock;
    }

    static class IterableVec<Elem>
    implements Serializable {
        private static final long serialVersionUID = 11000L;
        private final List<IterableElem<Elem>> Base = new ArrayList<IterableElem<Elem>>();

        public void clear() {
            this.Base.clear();
        }

        public boolean next(int i) {
            if (this.Base.get(i).next()) {
                return i == 0 ? true : this.next(i - 1);
            }
            return false;
        }

        IterableVec() {
        }

        void add(IterableElem<Elem> It) {
            this.Base.add(It);
        }

        boolean next() {
            return this.next(this.Base.size() - 1);
        }

        int size() {
            return this.Base.size();
        }

        Elem get(int i) {
            return this.Base.get(i).getCur();
        }
    }

    static class IterableElem<Elem>
    implements Serializable {
        private static final long serialVersionUID = 11000L;
        private final List<Elem> Elems;
        private final int pBeg;
        private final int pEnd;
        private int pCur;

        IterableElem(List<Elem> Init) {
            this.Elems = Init;
            this.pBeg = 0;
            this.pEnd = this.Elems.size();
            this.pCur = 0;
            if (this.Elems.isEmpty()) {
                throw new IllegalArgumentException("no empties allowed");
            }
        }

        public Elem getCur() {
            return this.Elems.get(this.pCur);
        }

        public boolean next() {
            if (++this.pCur >= this.pEnd) {
                this.pCur = this.pBeg;
                return true;
            }
            return false;
        }
    }
}

