/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeFactory;
import uk.ac.manchester.cs.jfact.helpers.FastSet;
import uk.ac.manchester.cs.jfact.helpers.FastSetFactory;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.Lexeme;
import uk.ac.manchester.cs.jfact.kernel.MergableLabel;
import uk.ac.manchester.cs.jfact.kernel.RATransition;
import uk.ac.manchester.cs.jfact.kernel.RoleAutomaton;
import uk.ac.manchester.cs.jfact.kernel.RoleCompare;
import uk.ac.manchester.cs.jfact.kernel.Taxonomy;
import uk.ac.manchester.cs.jfact.kernel.Token;
import uk.ac.manchester.cs.jfact.kernel.actors.AddRoleActor;

@PortedFrom(file="tRole.h", name="Role")
public class Role
extends ClassifiableEntry {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="tRole.h", name="Inverse")
    private Role inverse = null;
    @PortedFrom(file="tRole.h", name="pDomain")
    private DLTree pDomain = null;
    @PortedFrom(file="tRole.h", name="pSpecialDomain")
    private DLTree pSpecialDomain = null;
    @PortedFrom(file="tRole.h", name="bpSpecialDomain")
    private int bpSpecialDomain = 0;
    @PortedFrom(file="tRole.h", name="bpDomain")
    private int bpDomain = 0;
    @PortedFrom(file="tRole.h", name="Functional")
    private int functional = 0;
    @PortedFrom(file="tRole.h", name="rel")
    private long rel = 0L;
    @PortedFrom(file="tRole.h", name="domLabel")
    private final MergableLabel domLabel = new MergableLabel();
    @PortedFrom(file="tRole.h", name="Ancestor")
    private final List<Role> ancestorRoles = new ArrayList<Role>();
    @PortedFrom(file="tRole.h", name="Descendant")
    private final List<Role> descendantRoles = new ArrayList<Role>();
    @PortedFrom(file="tRole.h", name="TopFunc")
    private final List<Role> topFunctionalRoles = new ArrayList<Role>();
    @PortedFrom(file="tRole.h", name="Disjoint")
    private final Set<Role> disjointRoles = new HashSet<Role>();
    @PortedFrom(file="tRole.h", name="subCompositions")
    private final List<List<Role>> subCompositions = new ArrayList<List<Role>>();
    @PortedFrom(file="tRole.h", name="AncMap")
    private final FastSet ancestorMap = FastSetFactory.create();
    @PortedFrom(file="tRole.h", name="DJRoles")
    private final FastSet disjointRolesIndex = FastSetFactory.create();
    @PortedFrom(file="tRole.h", name="automaton")
    private final RoleAutomaton automaton = new RoleAutomaton();
    @PortedFrom(file="tRole.h", name="Functionality")
    private final KnownValue functionality = new KnownValue();
    @PortedFrom(file="tRole.h", name="Symmetry")
    private final KnownValue symmetry = new KnownValue();
    @PortedFrom(file="tRole.h", name="Asymmetry")
    private final KnownValue asymmetry = new KnownValue();
    @PortedFrom(file="tRole.h", name="Transitivity")
    private final KnownValue transitivity = new KnownValue();
    @PortedFrom(file="tRole.h", name="Reflexivity")
    private final KnownValue reflexivity = new KnownValue();
    @PortedFrom(file="tRole.h", name="Irreflexivity")
    private final KnownValue irreflexivity = new KnownValue();
    @PortedFrom(file="tRole.h", name="SpecialDomain")
    private boolean specialDomain = false;
    @Original
    private boolean dataRole;

    @PortedFrom(file="tRole.h", name="addSubRoleAutomaton")
    private void addSubRoleAutomaton(Role R) {
        if (!this.equals(R)) {
            this.automaton.addRA(R.getAutomaton());
        }
    }

    @PortedFrom(file="tRole.h", name="addTrivialTransition")
    private void addTrivialTransition(Role r) {
        this.automaton.addTransitionSafe(0, new RATransition(1, r));
    }

    @PortedFrom(file="tRole.h", name="completeAutomatonByRole")
    private RoleAutomaton completeAutomatonByRole(Role R, Set<Role> RInProcess) {
        assert (!R.isSynonym());
        assert (R != this);
        R.completeAutomaton(RInProcess);
        return R.automaton;
    }

    @PortedFrom(file="tRole.h", name="mergeSupersDomain")
    public void mergeSupersDomain() {
        for (int i = 0; i < this.ancestorRoles.size(); ++i) {
            this.domLabel.merge(this.ancestorRoles.get((int)i).domLabel);
        }
        if (this.isReflexive()) {
            this.domLabel.merge(this.getRangeLabel());
        }
        for (List<Role> q : this.subCompositions) {
            if (q.isEmpty()) continue;
            this.domLabel.merge(q.get((int)0).domLabel);
            this.getRangeLabel().merge(q.get(q.size() - 1).getRangeLabel());
        }
    }

    @PortedFrom(file="tRole.h", name="inverse")
    public Role inverse() {
        assert (this.inverse != null);
        return Role.resolveSynonym(this.inverse);
    }

    @PortedFrom(file="tRole.h", name="realInverse")
    public Role realInverse() {
        assert (this.inverse != null);
        return this.inverse;
    }

    @PortedFrom(file="tRole.h", name="setInverse")
    public void setInverse(Role p) {
        assert (this.inverse == null);
        this.inverse = p;
    }

    @PortedFrom(file="tRole.h", name="isSimple")
    public boolean isSimple() {
        return this.automaton.isSimple();
    }

    @PortedFrom(file="tRole.h", name="getTSpecialDomain")
    public DLTree getTSpecialDomain() {
        return this.pSpecialDomain;
    }

    @PortedFrom(file="tRole.h", name="hasSpecialDomain")
    public boolean hasSpecialDomain() {
        return this.specialDomain;
    }

    @PortedFrom(file="tRole.h", name="initSpecialDomain")
    public void initSpecialDomain() {
        if (!this.hasSpecialDomain() || this.getTRange() == null) {
            this.pSpecialDomain = DLTreeFactory.createTop();
        } else {
            this.pSpecialDomain = DLTreeFactory.createSNFForall(DLTreeFactory.createRole(this), this.getTRange().copy());
            this.pSpecialDomain = DLTreeFactory.createSNFForall(DLTreeFactory.buildTree(new Lexeme(Token.RNAME, this)), this.getTRange().copy());
        }
    }

    @PortedFrom(file="tRole.h", name="setSpecialDomain")
    public void setSpecialDomain(int bp) {
        this.bpSpecialDomain = bp;
    }

    @Original
    public boolean isDataRole() {
        return this.dataRole;
    }

    @Original
    public void setDataRole(boolean action) {
        this.dataRole = action;
    }

    @PortedFrom(file="tRole.h", name="isFunctional")
    public boolean isFunctional() {
        return this.functionality.getValue();
    }

    @PortedFrom(file="tRole.h", name="isFunctionalityKnown")
    public boolean isFunctionalityKnown() {
        return this.functionality.isKnown();
    }

    @PortedFrom(file="tRole.h", name="setFunctional")
    public void setFunctional(boolean value) {
        this.functionality.setValue(value);
    }

    @PortedFrom(file="tRole.h", name="setFunctional")
    public void setFunctional() {
        if (this.topFunctionalRoles.isEmpty()) {
            this.topFunctionalRoles.add(this);
        }
        this.setFunctional(true);
    }

    @PortedFrom(file="tRole.h", name="isTransitive")
    public boolean isTransitive() {
        return this.transitivity.getValue();
    }

    @PortedFrom(file="tRole.h", name="isTransitivityKnown")
    public boolean isTransitivityKnown() {
        return this.transitivity.isKnown();
    }

    @PortedFrom(file="tRole.h", name="setTransitive")
    public void setTransitive(boolean value) {
        this.transitivity.setValue(value);
        this.inverse().transitivity.setValue(value);
    }

    @PortedFrom(file="tRole.h", name="isSymmetric")
    public boolean isSymmetric() {
        return this.symmetry.getValue();
    }

    @PortedFrom(file="tRole.h", name="isSymmetryKnown")
    public boolean isSymmetryKnown() {
        return this.symmetry.isKnown();
    }

    @PortedFrom(file="tRole.h", name="setSymmetric")
    public void setSymmetric(boolean value) {
        this.symmetry.setValue(value);
        this.inverse().symmetry.setValue(value);
    }

    @PortedFrom(file="tRole.h", name="isAsymmetric")
    public boolean isAsymmetric() {
        return this.asymmetry.getValue();
    }

    @PortedFrom(file="tRole.h", name="isAsymmetryKnown")
    public boolean isAsymmetryKnown() {
        return this.asymmetry.isKnown();
    }

    @PortedFrom(file="tRole.h", name="setAsymmetric")
    public void setAsymmetric(boolean value) {
        this.asymmetry.setValue(value);
        this.inverse().asymmetry.setValue(value);
    }

    @PortedFrom(file="tRole.h", name="isReflexive")
    public boolean isReflexive() {
        return this.reflexivity.getValue();
    }

    @PortedFrom(file="tRole.h", name="isReflexivityKnown")
    public boolean isReflexivityKnown() {
        return this.reflexivity.isKnown();
    }

    @PortedFrom(file="tRole.h", name="setReflexive")
    public void setReflexive(boolean value) {
        this.reflexivity.setValue(value);
        this.inverse().reflexivity.setValue(value);
    }

    @PortedFrom(file="tRole.h", name="isIrreflexive")
    public boolean isIrreflexive() {
        return this.irreflexivity.getValue();
    }

    @PortedFrom(file="tRole.h", name="isIrreflexivityKnown")
    public boolean isIrreflexivityKnown() {
        return this.irreflexivity.isKnown();
    }

    @PortedFrom(file="tRole.h", name="setIrreflexive")
    public void setIrreflexive(boolean value) {
        this.irreflexivity.setValue(value);
        this.inverse().irreflexivity.setValue(value);
    }

    @PortedFrom(file="tRole.h", name="isTopFunc")
    public boolean isTopFunc() {
        return !this.topFunctionalRoles.isEmpty() && this.topFunctionalRoles.get(0).equals(this);
    }

    @PortedFrom(file="tRole.h", name="setFunctional")
    public void setFunctional(int fNode) {
        this.functional = fNode;
    }

    @PortedFrom(file="tRole.h", name="getFunctional")
    public int getFunctional() {
        return this.functional;
    }

    @PortedFrom(file="tRole.h", name="isRelevant")
    public boolean isRelevant(long lab) {
        return lab == this.rel;
    }

    @PortedFrom(file="tRole.h", name="setRelevant")
    public void setRelevant(long lab) {
        this.rel = lab;
    }

    @PortedFrom(file="tRole.h", name="getDomainLabel")
    public MergableLabel getDomainLabel() {
        return this.domLabel;
    }

    @PortedFrom(file="tRole.h", name="getRangeLabel")
    public MergableLabel getRangeLabel() {
        return this.inverse().domLabel;
    }

    @PortedFrom(file="tRole.h", name="setDomain")
    public void setDomain(DLTree p) {
        if (!DLTree.equalTrees(this.pDomain, p)) {
            if (DLTreeFactory.isFunctionalExpr(p, this)) {
                this.setFunctional();
            } else {
                this.pDomain = DLTreeFactory.createSNFAnd(Arrays.asList(this.pDomain, p));
            }
        }
    }

    @PortedFrom(file="tRole.h", name="setRange")
    public void setRange(DLTree p) {
        this.inverse().setDomain(p);
    }

    @PortedFrom(file="tRole.h", name="getTDomain")
    public DLTree getTDomain() {
        return this.pDomain;
    }

    @PortedFrom(file="tRole.h", name="getTRange")
    private DLTree getTRange() {
        return this.inverse().pDomain;
    }

    @PortedFrom(file="tRole.h", name="collectDomainFromSupers")
    public void collectDomainFromSupers() {
        for (int i = 0; i < this.ancestorRoles.size(); ++i) {
            this.setDomain(this.ancestorRoles.get((int)i).pDomain.copy());
        }
    }

    @PortedFrom(file="tRole.h", name="setBPDomain")
    public void setBPDomain(int p) {
        this.bpDomain = p;
    }

    @PortedFrom(file="tRole.h", name="getBPDomain")
    public int getBPDomain() {
        return this.bpDomain;
    }

    @PortedFrom(file="tRole.h", name="getBPRange")
    public int getBPRange() {
        return this.inverse().bpDomain;
    }

    @PortedFrom(file="tRole.h", name="addDisjointRole")
    public void addDisjointRole(Role R) {
        this.disjointRoles.add(R);
        for (Role p : R.descendantRoles) {
            this.disjointRoles.add(p);
            p.disjointRoles.add(this);
        }
    }

    @PortedFrom(file="tRole.h", name="checkHierarchicalDisjoint")
    public void checkHierarchicalDisjoint() {
        this.checkHierarchicalDisjoint(this);
        if (this.isReflexive()) {
            this.checkHierarchicalDisjoint(this.inverse());
        }
    }

    @PortedFrom(file="tRole.h", name="isDisjoint")
    public boolean isDisjoint() {
        return !this.disjointRoles.isEmpty();
    }

    @PortedFrom(file="tRole.h", name="isDisjoint")
    public boolean isDisjoint(Role r) {
        return this.disjointRolesIndex.contains(r.getAbsoluteIndex());
    }

    @PortedFrom(file="tRole.h", name="<")
    private boolean lesser(Role r) {
        return this.isDataRole() == r.isDataRole() && this.ancestorMap.contains(r.getAbsoluteIndex());
    }

    @PortedFrom(file="tRole.h", name="<=")
    public boolean lesserequal(Role r) {
        return this.equals(r) || this.lesser(r);
    }

    @PortedFrom(file="tRole.h", name="begin_anc")
    public List<Role> getAncestor() {
        return this.ancestorRoles;
    }

    @PortedFrom(file="tRole.h", name="begin_topfunc")
    public List<Role> begin_topfunc() {
        return this.topFunctionalRoles;
    }

    @PortedFrom(file="tRole.h", name="addAncestorsToBitMap")
    private void addAncestorsToBitMap(FastSet bitmap) {
        for (int i = 0; i < this.ancestorRoles.size(); ++i) {
            bitmap.add(this.ancestorRoles.get(i).getAbsoluteIndex());
        }
    }

    @PortedFrom(file="tRole.h", name="addComposition")
    public void addComposition(DLTree tree) {
        ArrayList<Role> RS = new ArrayList<Role>();
        this.fillsComposition(RS, tree);
        this.subCompositions.add(RS);
    }

    @PortedFrom(file="tRole.h", name="getAutomaton")
    public RoleAutomaton getAutomaton() {
        return this.automaton;
    }

    @PortedFrom(file="tRole.h", name="eliminateToldCycles")
    public Role eliminateToldCycles() {
        HashSet<Role> RInProcess = new HashSet<Role>();
        ArrayList<Role> ToldSynonyms = new ArrayList<Role>();
        return this.eliminateToldCycles(RInProcess, ToldSynonyms);
    }

    @PortedFrom(file="tRole.h", name="completeAutomaton")
    public void completeAutomaton(int nRoles) {
        HashSet<Role> RInProcess = new HashSet<Role>();
        this.completeAutomaton(RInProcess);
        this.automaton.setup(nRoles, this.isDataRole());
    }

    @PortedFrom(file="tRole.h", name="consistent")
    public void consistent() {
        if (this.isSimple()) {
            return;
        }
        if (this.isFunctional()) {
            throw new ReasonerInternalException("Non simple role used as simple: " + this.getName());
        }
        if (this.isDataRole()) {
            throw new ReasonerInternalException("Non simple role used as simple: " + this.getName());
        }
        if (this.isDisjoint()) {
            throw new ReasonerInternalException("Non simple role used as simple: " + this.getName());
        }
    }

    @Original
    private static Role resolveRoleHelper(DLTree t, String r) {
        if (t == null) {
            throw new ReasonerInternalException("Role expression expected: " + r);
        }
        switch (t.token()) {
            case RNAME: 
            case DNAME: {
                return (Role)t.elem().getNE();
            }
            case INV: {
                return Role.resolveRoleHelper(t.getChild(), r).inverse();
            }
        }
        throw new ReasonerInternalException("Invalid role expression: " + r + " but got: " + t);
    }

    @PortedFrom(file="tRole.h", name="resolveRole")
    public static Role resolveRole(DLTree t, String r) {
        return Role.resolveSynonym(Role.resolveRoleHelper(t, r));
    }

    @PortedFrom(file="tRole.h", name="resolveRole")
    public static Role resolveRole(DLTree t) {
        return Role.resolveSynonym(Role.resolveRoleHelper(t, ""));
    }

    protected Role(IRI name) {
        super(name);
        this.setCompletelyDefined(true);
        this.addTrivialTransition(this);
    }

    @PortedFrom(file="tRole.h", name="getIndex")
    public int getAbsoluteIndex() {
        int i = 2 * this.extId;
        return i > 0 ? i : 1 - i;
    }

    @Original
    private int buildIndex() {
        int i = 2 * this.extId;
        return i > 0 ? i : 1 - i;
    }

    @PortedFrom(file="tRole.h", name="fillsComposition")
    private void fillsComposition(List<Role> Composition, DLTree tree) {
        if (tree.token() == Token.RCOMPOSITION) {
            this.fillsComposition(Composition, tree.getLeft());
            this.fillsComposition(Composition, tree.getRight());
        } else {
            Composition.add(Role.resolveRole(tree));
        }
    }

    @PortedFrom(file="tRole.h", name="addFeaturesToSynonym")
    public void addFeaturesToSynonym() {
        if (!this.isSynonym()) {
            return;
        }
        Role syn = Role.resolveSynonym(this);
        if (this.isFunctional() && !syn.isFunctional()) {
            syn.setFunctional();
        }
        if (this.isTransitive()) {
            syn.setTransitive(true);
        }
        if (this.isReflexive()) {
            syn.setReflexive(true);
        }
        if (this.isDataRole()) {
            syn.setDataRole(true);
        }
        if (this.pDomain != null) {
            syn.setDomain(this.pDomain.copy());
        }
        if (this.isDisjoint()) {
            syn.disjointRoles.addAll(this.disjointRoles);
        }
        syn.subCompositions.addAll(this.subCompositions);
        this.toldSubsumers.clear();
        this.addParent(syn);
    }

    @PortedFrom(file="tRole.h", name="eliminateToldCycles")
    private Role eliminateToldCycles(Set<Role> RInProcess, List<Role> ToldSynonyms) {
        if (this.isSynonym()) {
            return null;
        }
        if (RInProcess.contains(this)) {
            ToldSynonyms.add(this);
            return this;
        }
        Role ret = null;
        RInProcess.add(this);
        this.removeSynonymsFromParents();
        for (ClassifiableEntry r : this.toldSubsumers) {
            ret = ((Role)r).eliminateToldCycles(RInProcess, ToldSynonyms);
            if (ret == null) continue;
            if (ret.equals(this)) {
                Collections.sort(ToldSynonyms, new RoleCompare());
                ret = ToldSynonyms.get(0);
                for (int i = 1; i < ToldSynonyms.size(); ++i) {
                    Role p = ToldSynonyms.get(i);
                    p.setSynonym(ret);
                    ret.addParents(p.getToldSubsumers());
                }
                ToldSynonyms.clear();
                RInProcess.remove(this);
                return ret.eliminateToldCycles(RInProcess, ToldSynonyms);
            }
            ToldSynonyms.add(this);
            break;
        }
        RInProcess.remove(this);
        return ret;
    }

    @Override
    public String toString() {
        return this.extName + " " + this.extId;
    }

    @PortedFrom(file="tRole.h", name="print")
    public void print(LogAdapter o) {
        int i;
        ArrayList<Object> l;
        o.print((Object)"Role \"", (Object)this.getName(), (Object)"\"(").print(this.getId()).print(")", this.isTransitive() ? "T" : "", this.isReflexive() ? "R" : "", this.isTopFunc() ? "t" : "", this.isFunctional() ? "F" : "", this.isDataRole() ? "D" : "");
        if (this.isSynonym()) {
            o.print((Object)" = \"", (Object)this.getSynonym().getName(), (Object)"\"\n");
            return;
        }
        if (!this.toldSubsumers.isEmpty()) {
            o.print(" parents={\"");
            l = new ArrayList(this.toldSubsumers);
            for (i = 0; i < l.size(); ++i) {
                if (i > 0) {
                    o.print("\", \"");
                }
                o.print((Object)((ClassifiableEntry)l.get(i)).getName());
            }
            o.print("\"}");
        }
        if (!this.disjointRoles.isEmpty()) {
            o.print(" disjoint with {\"");
            l = new ArrayList<Role>(this.disjointRoles);
            for (i = 0; i < this.disjointRoles.size(); ++i) {
                if (i > 0) {
                    o.print("\", \"");
                }
                o.print((Object)((Role)l.get(i)).getName());
            }
            o.print("\"}");
        }
        if (this.pDomain != null) {
            o.print(" Domain=(").print(this.bpDomain).print((Object)")=", (Object)this.pDomain);
        }
        if (this.getTRange() != null) {
            o.print(" Range=(").print(this.getBPRange()).print((Object)")=", (Object)this.getTRange());
        }
        o.print("\nAutomaton (size ").print(this.automaton.size()).print((Object)"): ", (Object)(this.automaton.isISafe() ? "I" : "i"), (Object)(this.automaton.isOSafe() ? "O" : "o"));
        this.automaton.print(o);
        o.print("\n");
    }

    @PortedFrom(file="tRole.h", name="initADbyTaxonomy")
    public void initADbyTaxonomy(Taxonomy pTax, int nRoles) {
        assert (this.isClassified());
        assert (this.ancestorRoles.isEmpty() && this.descendantRoles.isEmpty());
        AddRoleActor anc = new AddRoleActor(this.ancestorRoles);
        pTax.getRelativesInfo(this.getTaxVertex(), anc, false, false, true);
        AddRoleActor desc = new AddRoleActor(this.descendantRoles);
        pTax.getRelativesInfo(this.getTaxVertex(), desc, false, false, false);
        this.addAncestorsToBitMap(this.ancestorMap);
    }

    @PortedFrom(file="tRole.h", name="postProcess")
    public void postProcess() {
        this.initTopFunc();
        if (this.isDisjoint()) {
            this.initDJMap();
        }
    }

    @PortedFrom(file="tRole.h", name="isRealTopFunc")
    private boolean isRealTopFunc() {
        if (!this.isFunctional()) {
            return false;
        }
        for (int i = 0; i < this.ancestorRoles.size(); ++i) {
            if (!this.ancestorRoles.get(i).isTopFunc()) continue;
            return false;
        }
        return true;
    }

    @PortedFrom(file="tRole.h", name="initTopFunc")
    private void initTopFunc() {
        if (this.isRealTopFunc()) {
            return;
        }
        if (this.isTopFunc()) {
            this.topFunctionalRoles.clear();
        }
        for (int i = 0; i < this.ancestorRoles.size(); ++i) {
            Role p = this.ancestorRoles.get(i);
            if (!p.isRealTopFunc()) continue;
            this.topFunctionalRoles.add(p);
        }
        if (!this.topFunctionalRoles.isEmpty()) {
            this.functionality.setValue(true);
        }
    }

    @PortedFrom(file="tRole.h", name="checkHierarchicalDisjoint")
    private void checkHierarchicalDisjoint(Role R) {
        if (this.disjointRoles.contains(R)) {
            this.setDomain(DLTreeFactory.createBottom());
            this.disjointRoles.clear();
            return;
        }
        for (Role p : R.descendantRoles) {
            if (!this.disjointRoles.contains(p)) continue;
            p.setDomain(DLTreeFactory.createBottom());
            this.disjointRoles.remove(p);
            p.disjointRoles.clear();
        }
    }

    @PortedFrom(file="tRole.h", name="initDJMap")
    private void initDJMap() {
        for (Role q : this.disjointRoles) {
            this.disjointRolesIndex.add(q.getAbsoluteIndex());
        }
    }

    @PortedFrom(file="tRole.h", name="preprocessComposition")
    private void preprocessComposition(List<Role> RS) {
        boolean same = false;
        int last = RS.size() - 1;
        for (int i = 0; i < RS.size(); ++i) {
            Role p = RS.get(i);
            Role R = Role.resolveSynonym(p);
            if (R.isBottom()) {
                RS.clear();
                return;
            }
            if (R.equals(this)) {
                if (i != 0 && i != last) {
                    throw new ReasonerInternalException("Cycle in RIA " + this.getName());
                }
                if (same) {
                    if (last == 1) {
                        RS.clear();
                        this.setTransitive(true);
                        return;
                    }
                    throw new ReasonerInternalException("Cycle in RIA " + this.getName());
                }
                same = true;
            }
            RS.set(i, R);
        }
    }

    @PortedFrom(file="tRole.h", name="completeAutomaton")
    private void completeAutomaton(Set<Role> RInProcess) {
        if (this.automaton.isCompleted()) {
            return;
        }
        if (RInProcess.contains(this)) {
            throw new ReasonerInternalException("Cycle in RIA " + this.getName());
        }
        RInProcess.add(this);
        for (Role role : this.descendantRoles) {
            role.completeAutomaton(RInProcess);
        }
        for (List list : this.subCompositions) {
            this.addSubCompositionAutomaton(list, RInProcess);
        }
        if (this.isTransitive()) {
            this.automaton.addTransitionSafe(1, new RATransition(0));
        }
        this.automaton.setCompleted(true);
        if (!this.isBottom()) {
            for (ClassifiableEntry classifiableEntry : this.toldSubsumers) {
                Role R = (Role)Role.resolveSynonym(classifiableEntry);
                R.addSubRoleAutomaton(this);
                if (!this.hasSpecialDomain()) continue;
                R.specialDomain = true;
            }
        }
        RInProcess.remove(this);
    }

    @PortedFrom(file="tRole.h", name="addSubCompositionAutomaton")
    private void addSubCompositionAutomaton(List<Role> RS, Set<Role> RInProcess) {
        this.preprocessComposition(RS);
        if (RS.isEmpty()) {
            return;
        }
        this.specialDomain = true;
        int p = 0;
        int p_last = RS.size() - 1;
        int from = 0;
        int to = 1;
        if (RS.get(0).equals(this)) {
            ++p;
            from = 1;
        } else if (RS.get(p_last).equals(this)) {
            --p_last;
            to = 0;
        }
        assert (p <= p_last);
        boolean oSafe = false;
        this.automaton.initChain(from);
        while (p != p_last) {
            oSafe = this.automaton.addToChain(this.completeAutomatonByRole(RS.get(p), RInProcess), oSafe);
            ++p;
        }
        this.automaton.addToChain(this.completeAutomatonByRole(RS.get(p), RInProcess), oSafe, to);
    }

    @Original
    public Role getInverse() {
        return this.inverse;
    }

    static class KnownValue
    implements Serializable {
        private static final long serialVersionUID = 11000L;
        protected boolean value;
        protected boolean known;

        public KnownValue(boolean val) {
            this.value = val;
            this.known = false;
        }

        public KnownValue() {
            this(false);
        }

        protected boolean isKnown() {
            return this.known;
        }

        protected boolean getValue() {
            return this.value;
        }

        protected void setValue(boolean val) {
            this.value = val;
            this.known = true;
        }
    }
}

