/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.kernel.Role;

@PortedFrom(file="RAutomaton.h", name="RATransition")
public class RATransition
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="RAutomaton.h", name="label")
    private final Set<Role> label;
    @Original
    private BitSet cache = null;
    @PortedFrom(file="RAutomaton.h", name="state")
    private final int state;

    public RATransition(int st) {
        this.state = st;
        this.label = new LinkedHashSet<Role>();
    }

    public RATransition(int st, Role R) {
        this(st);
        this.label.add(R);
    }

    @PortedFrom(file="RAutomaton.h", name="add")
    public void add(RATransition trans) {
        this.label.addAll(trans.label);
        this.cache = null;
    }

    @PortedFrom(file="RAutomaton.h", name="begin")
    public Collection<Role> begin() {
        return this.label;
    }

    @PortedFrom(file="RAutomaton.h", name="final")
    public int final_state() {
        return this.state;
    }

    @PortedFrom(file="RAutomaton.h", name="applicable")
    public boolean applicable(Role R) {
        if (this.cache == null) {
            this.cache = new BitSet();
            for (Role t : this.label) {
                this.cache.set(t.getAbsoluteIndex());
            }
        }
        return this.cache.get(R.getAbsoluteIndex());
    }

    @PortedFrom(file="RAutomaton.h", name="empty")
    public boolean isEmpty() {
        return this.label.isEmpty();
    }

    @PortedFrom(file="RAutomaton.h", name="print")
    public void print(LogAdapter o, int from) {
        o.print("\n").print(from).print(" -- ");
        if (this.isEmpty()) {
            o.print("e");
        } else {
            ArrayList<Role> l = new ArrayList<Role>(this.label);
            for (int i = 0; i < l.size(); ++i) {
                if (i > 0) {
                    o.print(",");
                }
                o.print("\"");
                o.print((Object)((Role)l.get(i)).getName());
                o.print("\"");
            }
        }
        o.print(" -> ");
        o.print(this.final_state());
    }

    @PortedFrom(file="RAutomaton.h", name="isTop")
    public boolean isTop() {
        return this.label.size() == 1 && this.label.iterator().next().isTop();
    }
}

