/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.kernel.RATransition;
import uk.ac.manchester.cs.jfact.kernel.Role;

@PortedFrom(file="RAutomaton.h", name="RAStateTransitions")
public class RAStateTransitions
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="RAutomaton.h", name="Base")
    protected final List<RATransition> base = new ArrayList<RATransition>();
    @PortedFrom(file="RAutomaton.h", name="EmptyTransition")
    protected boolean emptyTransition = false;
    @PortedFrom(file="RAutomaton.h", name="ApplicableRoles")
    private final BitSet applicableRoles = new BitSet();
    @PortedFrom(file="RAutomaton.h", name="from")
    private int from;
    @PortedFrom(file="RAutomaton.h", name="DataRole")
    private boolean dataRole;
    @Original
    private int size = 0;
    @PortedFrom(file="RAutomaton.h", name="TopTransition")
    private boolean TopTransition;

    @PortedFrom(file="RAutomaton.h", name="begin")
    public List<RATransition> begin() {
        return this.base;
    }

    @PortedFrom(file="RAutomaton.h", name="add")
    public void add(RATransition trans) {
        this.base.add(trans);
        ++this.size;
        if (trans.isEmpty()) {
            this.emptyTransition = true;
        }
        if (trans.isTop()) {
            this.TopTransition = true;
        }
    }

    @PortedFrom(file="RAutomaton.h", name="hasTopTransition")
    public boolean hasTopTransition() {
        return this.TopTransition;
    }

    @PortedFrom(file="RAutomaton.h", name="empty")
    public boolean isEmpty() {
        return this.size == 0;
    }

    @PortedFrom(file="RAutomaton.h", name="hasEmptyTransition")
    public boolean hasEmptyTransition() {
        return this.emptyTransition;
    }

    @PortedFrom(file="RAutomaton.h", name="print")
    public void print(LogAdapter o) {
        for (int i = 0; i < this.size; ++i) {
            this.base.get(i).print(o, this.from);
        }
    }

    @PortedFrom(file="RAutomaton.h", name="setup")
    public void setup(int state, int nRoles, boolean data) {
        this.from = state;
        this.dataRole = data;
        for (int i = 0; i < this.size; ++i) {
            for (Role t : this.base.get(i).begin()) {
                this.applicableRoles.set(t.getAbsoluteIndex());
            }
        }
    }

    @PortedFrom(file="RAutomaton.h", name="addToExisting")
    public boolean addToExisting(RATransition trans) {
        int to = trans.final_state();
        boolean tEmpty = trans.isEmpty();
        for (int i = 0; i < this.size; ++i) {
            RATransition p = this.base.get(i);
            if (p.final_state() != to || p.isEmpty() != tEmpty) continue;
            p.add(trans);
            return true;
        }
        return false;
    }

    @PortedFrom(file="RAutomaton.h", name="recognise")
    public boolean recognise(Role R) {
        if (R == null) {
            return false;
        }
        return R.isDataRole() == this.dataRole && this.applicableRoles.get(R.getAbsoluteIndex());
    }

    @PortedFrom(file="RAutomaton.h", name="isSingleton")
    public boolean isSingleton() {
        return this.size == 1;
    }

    @PortedFrom(file="RAutomaton.h", name="getTransitionEnd")
    public int getTransitionEnd() {
        return this.base.get(0).final_state();
    }
}

