/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.NameCreator;
import uk.ac.manchester.cs.jfact.kernel.NameSet;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.ReasonerFreshEntityException;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;

public class NamedEntryCollection<T extends NamedEntry>
implements Serializable {
    private static final long serialVersionUID = 11000L;
    private final List<T> base = new ArrayList<T>();
    private final NameSet<T, IRI> nameset;
    private final String typeName;
    private boolean locked;
    @Original
    private final JFactReasonerConfiguration options;

    public void registerNew(T p) {
    }

    public T registerElem(T p) {
        ((NamedEntry)p).setId(this.base.size());
        this.base.add(p);
        this.registerNew(p);
        return p;
    }

    public NamedEntryCollection(String name, NameCreator<T, IRI> creator, JFactReasonerConfiguration options) {
        this.typeName = name;
        this.locked = false;
        this.base.add(null);
        this.nameset = new NameSet<T, IRI>(creator);
        this.options = options;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean setLocked(boolean val) {
        boolean old = this.locked;
        this.locked = val;
        return old;
    }

    public boolean isRegistered(IRI name) {
        return this.nameset.get(name) != null;
    }

    public T get(IRI name) {
        NamedEntry p = (NamedEntry)this.nameset.get(name);
        if (p != null) {
            return (T)p;
        }
        if (this.isLocked() && !this.options.isUseUndefinedNames() && this.options.getFreshEntityPolicy() == FreshEntityPolicy.DISALLOW) {
            throw new ReasonerFreshEntityException("Unable to register '" + name + "' as a " + this.typeName, name);
        }
        p = this.registerElem((NamedEntry)this.nameset.add(name));
        if (this.isLocked()) {
            p.setSystem();
            if (p instanceof ClassifiableEntry) {
                ((ClassifiableEntry)p).setNonClassifiable(true);
            }
        }
        return (T)p;
    }

    public boolean remove(T p) {
        if (!this.isRegistered(((NamedEntry)p).getName())) {
            return false;
        }
        if (((NamedEntry)p).getId() > 0 && this.base.size() > ((NamedEntry)p).getId()) {
            Helper.resize(this.base, ((NamedEntry)p).getId());
        }
        this.nameset.remove(((NamedEntry)p).getName());
        return false;
    }

    public List<T> getList() {
        return this.base.subList(1, this.base.size());
    }

    public int size() {
        return this.base.size() - 1;
    }
}

