/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.PortedFrom;
import java.io.Serializable;
import java.util.BitSet;
import uk.ac.manchester.cs.jfact.helpers.DLVertex;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.helpers.Templates;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.Role;

@PortedFrom(file="LogicFeature.h", name="LogicFeatures")
public class LogicFeatures
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="LogicFeature.h", name="flags")
    private final BitSet flags = new BitSet();
    @PortedFrom(file="LogicFeature.h", name="lfTransitiveRoles")
    private static final int lfTransitiveRoles = 1;
    @PortedFrom(file="LogicFeature.h", name="lfRolesSubsumption")
    private static final int lfRolesSubsumption = 2;
    @PortedFrom(file="LogicFeature.h", name="lfDirectRoles")
    private static final int lfDirectRoles = 3;
    @PortedFrom(file="LogicFeature.h", name="lfInverseRoles")
    private static final int lfInverseRoles = 4;
    @PortedFrom(file="LogicFeature.h", name="lfRangeAndDomain")
    private static final int lfRangeAndDomain = 5;
    @PortedFrom(file="LogicFeature.h", name="lfFunctionalRoles")
    private static final int lfFunctionalRoles = 6;
    @PortedFrom(file="LogicFeature.h", name="lfSomeConstructor")
    private static final int lfSomeConstructor = 7;
    @PortedFrom(file="LogicFeature.h", name="lfFConstructor")
    private static final int lfFConstructor = 8;
    @PortedFrom(file="LogicFeature.h", name="lfNConstructor")
    private static final int lfNConstructor = 9;
    @PortedFrom(file="LogicFeature.h", name="lfQConstructor")
    private static final int lfQConstructor = 10;
    @PortedFrom(file="LogicFeature.h", name="lfSingleton")
    private static final int lfSingleton = 11;
    @PortedFrom(file="LogicFeature.h", name="lfGeneralAxioms")
    private static final int lfGeneralAxioms = 12;
    @PortedFrom(file="LogicFeature.h", name="lfBothRoles")
    private static final int lfBothRoles = 13;
    @PortedFrom(file="LogicFeature.h", name="lfSelfRef")
    private static final int lfSelfRef = 14;
    @PortedFrom(file="LogicFeature.h", name="lfTopRole")
    private static final int lfTopRole = 15;

    @PortedFrom(file="LogicFeature.h", name="setX")
    private void setX(int val) {
        this.flags.set(val);
    }

    @PortedFrom(file="LogicFeature.h", name="getX")
    private boolean getX(int val) {
        return this.flags.get(val);
    }

    public LogicFeatures() {
    }

    public LogicFeatures(LogicFeatures lf) {
        this.flags.or(lf.flags);
    }

    @PortedFrom(file="LogicFeature.h", name="or")
    public void or(LogicFeatures lf) {
        this.flags.or(lf.flags);
    }

    @PortedFrom(file="LogicFeature.h", name="hasInverseRole")
    public boolean hasInverseRole() {
        return this.getX(13);
    }

    @PortedFrom(file="LogicFeature.h", name="hasRoleHierarchy")
    private boolean hasRoleHierarchy() {
        return this.getX(2);
    }

    @PortedFrom(file="LogicFeature.h", name="hasTransitiveRole")
    private boolean hasTransitiveRole() {
        return this.getX(1);
    }

    @PortedFrom(file="LogicFeature.h", name="hasSomeAll")
    public boolean hasSomeAll() {
        return this.getX(7);
    }

    @PortedFrom(file="LogicFeature.h", name="hasFunctionalRestriction")
    public boolean hasFunctionalRestriction() {
        return this.getX(8) || this.getX(6);
    }

    @PortedFrom(file="LogicFeature.h", name="hasNumberRestriction")
    public boolean hasNumberRestriction() {
        return this.getX(9);
    }

    @PortedFrom(file="LogicFeature.h", name="hasQNumberRestriction")
    public boolean hasQNumberRestriction() {
        return this.getX(10);
    }

    @PortedFrom(file="LogicFeature.h", name="hasSingletons")
    public boolean hasSingletons() {
        return this.getX(11);
    }

    @PortedFrom(file="LogicFeature.h", name="hasSelfRef")
    public boolean hasSelfRef() {
        return this.getX(14);
    }

    @PortedFrom(file="LogicFeature.h", name="hasTopRole")
    public boolean hasTopRole() {
        return this.getX(15);
    }

    @PortedFrom(file="LogicFeature.h", name="empty")
    public boolean isEmpty() {
        return this.flags.isEmpty();
    }

    @PortedFrom(file="LogicFeature.h", name="mergeRoles")
    public void mergeRoles() {
        if (this.getX(3) && this.getX(4)) {
            this.setX(13);
        }
    }

    @PortedFrom(file="LogicFeature.h", name="setInverseRoles")
    public void setInverseRoles() {
        this.setX(13);
    }

    @PortedFrom(file="LogicFeature.h", name="+")
    public static LogicFeatures plus(LogicFeatures f1, LogicFeatures f2) {
        LogicFeatures f = new LogicFeatures(f1);
        f.flags.or(f2.flags);
        return f;
    }

    @PortedFrom(file="LogicFeature.h", name="fillConceptData")
    public void fillConceptData(Concept p) {
        if (p.isSingleton()) {
            this.setX(11);
        }
    }

    @PortedFrom(file="LogicFeature.h", name="fillRoleData")
    public void fillRoleData(Role p, boolean both) {
        if (p.isTop()) {
            if (!p.isDataRole()) {
                this.setX(15);
            }
            return;
        }
        if (p.getId() > 0) {
            this.setX(3);
        } else {
            this.setX(4);
        }
        if (both) {
            this.setX(13);
        }
        if (p.isTransitive()) {
            this.setX(1);
        }
        if (p.hasToldSubsumers()) {
            this.setX(2);
        }
        if (p.isFunctional()) {
            this.setX(6);
        }
        if (p.getBPDomain() != 1 || p.getBPRange() != 1) {
            this.setX(5);
        }
    }

    @PortedFrom(file="LogicFeature.h", name="fillDAGData")
    public void fillDAGData(DLVertex v, boolean pos) {
        switch (v.getType()) {
            case dtForall: {
                this.setX(7);
                break;
            }
            case dtLE: {
                this.setX(9);
                if (v.getConceptIndex() == 1) break;
                this.setX(10);
                break;
            }
            case dtPSingleton: 
            case dtNSingleton: {
                this.setX(11);
                break;
            }
            case dtIrr: {
                this.setX(14);
                break;
            }
        }
    }

    @PortedFrom(file="LogicFeature.h", name="writeState")
    public void writeState(LogAdapter l) {
        String NO = "NO ";
        String Q = "qualified ";
        Object[] objectArray = new Object[8];
        objectArray[0] = this.hasInverseRole() ? "" : NO;
        objectArray[1] = this.hasRoleHierarchy() ? "" : NO;
        objectArray[2] = this.hasTransitiveRole() ? "" : NO;
        objectArray[3] = this.hasTopRole() ? "" : NO;
        objectArray[4] = this.hasSomeAll() ? "" : NO;
        Object object = objectArray[5] = this.hasFunctionalRestriction() ? "" : NO;
        objectArray[6] = this.hasNumberRestriction() ? (this.hasQNumberRestriction() ? Q : "") : NO;
        objectArray[7] = this.hasSingletons() ? "" : NO;
        l.printTemplate(Templates.WRITE_STATE, objectArray);
    }
}

