/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.PortedFrom;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.Token;

@PortedFrom(file="tAxiom.h", name="InAx")
public class InAx
implements Serializable {
    private static final long serialVersionUID = 11000L;
    private static final Map<String, Integer> created = new HashMap<String, Integer>();

    public static Concept getConcept(DLTree p) {
        return (Concept)p.elem().getNE();
    }

    public static boolean isTop(DLTree p) {
        return p.isBOTTOM();
    }

    public static boolean isBot(DLTree p) {
        return p.isTOP();
    }

    public static boolean isPosCN(DLTree p) {
        return p.isNOT() && p.getChild().isName();
    }

    public static boolean isPosNP(DLTree p) {
        return InAx.isPosCN(p) && !InAx.getConcept(p.getChild()).isPrimitive();
    }

    public static boolean isPosPC(DLTree p) {
        return InAx.isPosCN(p) && InAx.getConcept(p.getChild()).isPrimitive();
    }

    public static boolean isNegCN(DLTree p) {
        return p.isName();
    }

    public static boolean isNegNP(DLTree p) {
        return InAx.isNegCN(p) && !InAx.getConcept(p).isPrimitive();
    }

    public static boolean isNegPC(DLTree p) {
        return InAx.isNegCN(p) && InAx.getConcept(p).isPrimitive();
    }

    public static boolean isAnd(DLTree p) {
        return p.isNOT() && p.getChild().isAND();
    }

    public static boolean isOr(DLTree p) {
        return p.isAND();
    }

    public static boolean isForall(DLTree p) {
        return p.isNOT() && p.getChild().token() == Token.FORALL;
    }

    public static boolean isOForall(DLTree p) {
        return InAx.isForall(p) && !Role.resolveRole(p.getChild().getLeft()).isDataRole();
    }

    public static boolean isAbsForall(DLTree p) {
        if (!InAx.isOForall(p)) {
            return false;
        }
        DLTree C = p.getChild().getRight();
        if (InAx.isTop(C)) {
            return false;
        }
        return !C.isName() || !InAx.getConcept(C).isSystem();
    }

    private static void add(String s) {
        if (created.containsKey(s)) {
            created.put(s, created.get(s) + 1);
        } else {
            created.put(s, 1);
        }
    }

    private static int get(String s) {
        return created.containsKey(s) ? created.get(s) : 0;
    }

    public static void SAbsRepCN() {
        InAx.add("SAbsRepCN");
    }

    public static void SAbsRepForall() {
        InAx.add("SAbsRepForall");
    }

    public static void SAbsBApply() {
        InAx.add("SAbsBApply");
    }

    public static void SAbsSplit() {
        InAx.add("SAbsSplit");
    }

    public static void SAbsTApply() {
        InAx.add("SAbsTApply");
    }

    public static void SAbsCApply() {
        InAx.add("SAbsCApply");
    }

    public static void SAbsCAttempt() {
        InAx.add("SAbsCAttempt");
    }

    public static void SAbsRApply() {
        InAx.add("SAbsRApply");
    }

    public static void SAbsRAttempt() {
        InAx.add("SAbsRAttempt");
    }

    public static void SAbsInput() {
        InAx.add("SAbsInput");
    }

    public static void SAbsAction() {
        InAx.add("SAbsAction");
    }

    public static void SAbsNApply() {
        InAx.add("SAbsNApply");
    }

    public static void SAbsNAttempt() {
        InAx.add("SAbsNAttempt");
    }

    public static boolean containsSAbsRepCN() {
        return created.containsKey("SAbsRepCN");
    }

    public static boolean containsSAbsRepForall() {
        return created.containsKey("SAbsRepForall");
    }

    public static boolean containsSAbsBApply() {
        return created.containsKey("SAbsBApply");
    }

    public static boolean containsSAbsSplit() {
        return created.containsKey("SAbsSplit");
    }

    public static boolean containsSAbsTApply() {
        return created.containsKey("SAbsTApply");
    }

    public static boolean containsSAbsCApply() {
        return created.containsKey("SAbsCApply");
    }

    public static boolean containsSAbsCAttempt() {
        return created.containsKey("SAbsCAttempt");
    }

    public static boolean containsSAbsRApply() {
        return created.containsKey("SAbsRApply");
    }

    public static boolean containsSAbsRAttempt() {
        return created.containsKey("SAbsRAttempt");
    }

    public static boolean containsSAbsInput() {
        return created.containsKey("SAbsInput");
    }

    public static boolean containsSAbsAction() {
        return created.containsKey("SAbsAction");
    }

    public static boolean containsSAbsNApply() {
        return created.containsKey("SAbsNApply");
    }

    public static boolean containsSAbsNAttempt() {
        return created.containsKey("SAbsNAttempt");
    }

    public static int getSAbsRepCN() {
        return InAx.get("SAbsRepCN");
    }

    public static int getSAbsRepForall() {
        return InAx.get("SAbsRepForall");
    }

    public static int getSAbsBApply() {
        return InAx.get("SAbsBApply");
    }

    public static int getSAbsSplit() {
        return InAx.get("SAbsSplit");
    }

    public static int getSAbsTApply() {
        return InAx.get("SAbsTApply");
    }

    public static int getSAbsCApply() {
        return InAx.get("SAbsCApply");
    }

    public static int getSAbsCAttempt() {
        return InAx.get("SAbsCAttempt");
    }

    public static int getSAbsRApply() {
        return InAx.get("SAbsRApply");
    }

    public static int getSAbsRAttempt() {
        return InAx.get("SAbsRAttempt");
    }

    public static int getSAbsInput() {
        return InAx.get("SAbsInput");
    }

    public static int getSAbsAction() {
        return InAx.get("SAbsAction");
    }

    public static int getSAbsNApply() {
        return InAx.get("SAbsNApply");
    }

    public static int getSAbsNAttempt() {
        return InAx.get("SAbsNAttempt");
    }
}

