/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.semanticweb.owlapi.model.IRI;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.kernel.NameCreator;
import uk.ac.manchester.cs.jfact.kernel.NameSet;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptAnd;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataExactCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataExists;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataForall;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataMaxCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataMinCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataValue;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptName;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptNot;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectExactCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectExists;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectForall;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectMaxCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectMinCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectSelf;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectValue;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptOneOf;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptOr;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptTop;
import uk.ac.manchester.cs.jfact.kernel.dl.DataAnd;
import uk.ac.manchester.cs.jfact.kernel.dl.DataBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.DataNot;
import uk.ac.manchester.cs.jfact.kernel.dl.DataOneOf;
import uk.ac.manchester.cs.jfact.kernel.dl.DataOr;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleName;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleTop;
import uk.ac.manchester.cs.jfact.kernel.dl.DataTop;
import uk.ac.manchester.cs.jfact.kernel.dl.IndividualName;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleChain;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleInverse;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleName;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleProjectionFrom;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleProjectionInto;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleTop;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.IndividualExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleComplexExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.RoleExpression;

@PortedFrom(file="tExpressionManager.h", name="TExpressionManager")
public class ExpressionManager
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="tExpressionManager.h", name="NS_C")
    private final NameSet<ConceptName, IRI> conceptNameset = new NameSet<ConceptName, IRI>(new ConceptNameCreator());
    @PortedFrom(file="tExpressionManager.h", name="NS_I")
    private final NameSet<IndividualName, IRI> individualNameset = new NameSet<IndividualName, IRI>(new IndividualNameCreator());
    @PortedFrom(file="tExpressionManager.h", name="NS_OR")
    private final NameSet<ObjectRoleName, IRI> objectRoleNameset = new NameSet<ObjectRoleName, IRI>(new ObjectroleNameCreator());
    @PortedFrom(file="tExpressionManager.h", name="NS_DR")
    private final NameSet<DataRoleName, IRI> dataRoleNameset = new NameSet<DataRoleName, IRI>(new DataroleNameCreator());
    @PortedFrom(file="tExpressionManager.h", name="CTop")
    private final ConceptTop top = new ConceptTop();
    @PortedFrom(file="tExpressionManager.h", name="CBottom")
    private final ConceptBottom bottom = new ConceptBottom();
    @PortedFrom(file="tExpressionManager.h", name="DTop")
    private final DataTop dataTop = new DataTop();
    @PortedFrom(file="tExpressionManager.h", name="ORTop")
    private ObjectRoleExpression objectRoleTop = new ObjectRoleTop();
    @PortedFrom(file="tExpressionManager.h", name="ORBottom")
    private ObjectRoleExpression objectRoleBottom = new ObjectRoleBottom();
    @PortedFrom(file="tExpressionManager.h", name="DRTop")
    private DataRoleExpression dataRoleTop = new DataRoleTop();
    @PortedFrom(file="tExpressionManager.h", name="DRBottom")
    private DataRoleExpression dataRoleBottom = new DataRoleBottom();
    @PortedFrom(file="tExpressionManager.h", name="DBottom")
    private final DataBottom dataBottom = new DataBottom();
    @PortedFrom(file="tExpressionManager.h", name="InverseRoleCache")
    private final InverseRoleCache inverseRoleCache = new InverseRoleCache();
    @PortedFrom(file="tExpressionManager.h", name="OneOfCache")
    private final Map<IndividualExpression, ConceptExpression> OneOfCache = new HashMap<IndividualExpression, ConceptExpression>();

    @PortedFrom(file="tExpressionManager.h", name="setTopBottomRoles")
    public void setTopBottomRoles(IRI topORoleName, IRI botORoleName, IRI topDRoleName, IRI botDRoleName) {
        this.objectRoleTop = new ObjectRoleName(topORoleName);
        this.objectRoleBottom = new ObjectRoleName(botORoleName);
        this.dataRoleTop = new DataRoleName(topDRoleName);
        this.dataRoleBottom = new DataRoleName(botDRoleName);
    }

    @PortedFrom(file="tExpressionManager.h", name="clearNameCache")
    public void clearNameCache() {
        this.conceptNameset.clear();
        this.objectRoleNameset.clear();
        this.dataRoleNameset.clear();
        this.individualNameset.clear();
    }

    @PortedFrom(file="tExpressionManager.h", name="clear")
    public void clear() {
        this.clearNameCache();
        this.inverseRoleCache.clear();
        this.OneOfCache.clear();
    }

    @PortedFrom(file="tExpressionManager.h", name="isUniversalRole")
    public boolean isUniversalRole(RoleExpression R) {
        return R.equals(this.dataRoleTop) || R.equals(this.objectRoleTop);
    }

    @PortedFrom(file="tExpressionManager.h", name="isEmptyRole")
    public boolean isEmptyRole(RoleExpression R) {
        return R.equals(this.dataRoleBottom) || R.equals(this.objectRoleBottom);
    }

    @PortedFrom(file="tExpressionManager.h", name="nConcepts")
    public int nConcepts() {
        return this.conceptNameset.size();
    }

    @PortedFrom(file="tExpressionManager.h", name="nIndividuals")
    public int nIndividuals() {
        return this.individualNameset.size();
    }

    @PortedFrom(file="tExpressionManager.h", name="nORoles")
    public int nORoles() {
        return this.objectRoleNameset.size();
    }

    @PortedFrom(file="tExpressionManager.h", name="nDRoles")
    public int nDRoles() {
        return this.dataRoleNameset.size();
    }

    @PortedFrom(file="tExpressionManager.h", name="top")
    public ConceptTop top() {
        return this.top;
    }

    @PortedFrom(file="tExpressionManager.h", name="bottom")
    public ConceptBottom bottom() {
        return this.bottom;
    }

    @PortedFrom(file="tExpressionManager.h", name="concept")
    public ConceptName concept(IRI name) {
        return this.conceptNameset.insert(name);
    }

    @PortedFrom(file="tExpressionManager.h", name="Not")
    public ConceptExpression not(ConceptExpression C) {
        return new ConceptNot(C);
    }

    @PortedFrom(file="tExpressionManager.h", name="and")
    public ConceptExpression and(List<ConceptExpression> l) {
        return new ConceptAnd(l);
    }

    @PortedFrom(file="tExpressionManager.h", name="and")
    public ConceptExpression and(ConceptExpression C, ConceptExpression D) {
        if (C.equals(D)) {
            return C;
        }
        if (C instanceof ConceptTop) {
            return D;
        }
        if (D instanceof ConceptTop) {
            return C;
        }
        return this.and(Arrays.asList(C, D));
    }

    @PortedFrom(file="tExpressionManager.h", name="or")
    public ConceptExpression or(ConceptExpression C, ConceptExpression D) {
        return this.or(Arrays.asList(C, D));
    }

    @PortedFrom(file="tExpressionManager.h", name="or")
    public ConceptExpression or(List<ConceptExpression> l) {
        return new ConceptOr(l);
    }

    @PortedFrom(file="tExpressionManager.h", name="OneOf")
    public ConceptExpression oneOf(List<IndividualExpression> l) {
        if (l.size() == 1) {
            IndividualExpression i = l.get(0);
            ConceptOneOf<IndividualExpression> c = this.OneOfCache.get(i);
            if (c == null) {
                c = new ConceptOneOf<IndividualExpression>(l);
                this.OneOfCache.put(i, c);
            }
            return c;
        }
        return new ConceptOneOf<IndividualExpression>(l);
    }

    @PortedFrom(file="tExpressionManager.h", name="inverse")
    public ObjectRoleExpression inverse(ObjectRoleExpression R) {
        return this.inverseRoleCache.get(R);
    }

    @PortedFrom(file="tExpressionManager.h", name="OneOf")
    public ConceptExpression oneOf(IndividualExpression I) {
        return this.oneOf(Arrays.asList(I));
    }

    @PortedFrom(file="tExpressionManager.h", name="SelfReference")
    public ConceptExpression selfReference(ObjectRoleExpression R) {
        return new ConceptObjectSelf(R);
    }

    @PortedFrom(file="tExpressionManager.h", name="value")
    public ConceptExpression value(ObjectRoleExpression R, IndividualExpression I) {
        return new ConceptObjectValue(R, I);
    }

    @PortedFrom(file="tExpressionManager.h", name="Exists")
    public ConceptExpression exists(ObjectRoleExpression R, ConceptExpression C) {
        return new ConceptObjectExists(R, C);
    }

    @PortedFrom(file="tExpressionManager.h", name="Forall")
    public ConceptExpression forall(ObjectRoleExpression R, ConceptExpression C) {
        return new ConceptObjectForall(R, C);
    }

    @PortedFrom(file="tExpressionManager.h", name="MinCardinality")
    public ConceptExpression minCardinality(int n, ObjectRoleExpression R, ConceptExpression C) {
        return new ConceptObjectMinCardinality(n, R, C);
    }

    @PortedFrom(file="tExpressionManager.h", name="MaxCardinality")
    public ConceptExpression maxCardinality(int n, ObjectRoleExpression R, ConceptExpression C) {
        return new ConceptObjectMaxCardinality(n, R, C);
    }

    @PortedFrom(file="tExpressionManager.h", name="cardinality")
    public ConceptExpression cardinality(int n, ObjectRoleExpression R, ConceptExpression C) {
        return new ConceptObjectExactCardinality(n, R, C);
    }

    @PortedFrom(file="tExpressionManager.h", name="value")
    public ConceptExpression value(DataRoleExpression R, Literal<?> V) {
        return new ConceptDataValue(R, V);
    }

    @PortedFrom(file="tExpressionManager.h", name="Exists")
    public ConceptExpression exists(DataRoleExpression R, DataExpression E) {
        return new ConceptDataExists(R, E);
    }

    @PortedFrom(file="tExpressionManager.h", name="Forall")
    public ConceptExpression forall(DataRoleExpression R, DataExpression E) {
        return new ConceptDataForall(R, E);
    }

    @PortedFrom(file="tExpressionManager.h", name="MinCardinality")
    public ConceptExpression minCardinality(int n, DataRoleExpression R, DataExpression E) {
        return new ConceptDataMinCardinality(n, R, E);
    }

    @PortedFrom(file="tExpressionManager.h", name="MaxCardinality")
    public ConceptExpression maxCardinality(int n, DataRoleExpression R, DataExpression E) {
        return new ConceptDataMaxCardinality(n, R, E);
    }

    @PortedFrom(file="tExpressionManager.h", name="cardinality")
    public ConceptExpression cardinality(int n, DataRoleExpression R, DataExpression E) {
        return new ConceptDataExactCardinality(n, R, E);
    }

    @PortedFrom(file="tExpressionManager.h", name="individual")
    public IndividualName individual(IRI name) {
        return this.individualNameset.insert(name);
    }

    @PortedFrom(file="tExpressionManager.h", name="ObjectRoleTop")
    public ObjectRoleExpression objectRoleTop() {
        return this.objectRoleTop;
    }

    @PortedFrom(file="tExpressionManager.h", name="ObjectRoleBottom")
    public ObjectRoleExpression objectRoleBottom() {
        return this.objectRoleBottom;
    }

    @PortedFrom(file="tExpressionManager.h", name="ObjectRole")
    public ObjectRoleName objectRole(IRI name) {
        return this.objectRoleNameset.insert(name);
    }

    @PortedFrom(file="tExpressionManager.h", name="Compose")
    public ObjectRoleComplexExpression compose(List<ObjectRoleExpression> l) {
        return new ObjectRoleChain(l);
    }

    @PortedFrom(file="tExpressionManager.h", name="Compose")
    public ObjectRoleComplexExpression compose(ObjectRoleExpression e1, ObjectRoleExpression e2) {
        return new ObjectRoleChain(Arrays.asList(e1, e2));
    }

    @PortedFrom(file="tExpressionManager.h", name="ProjectFrom")
    public ObjectRoleComplexExpression projectFrom(ObjectRoleExpression R, ConceptExpression C) {
        return new ObjectRoleProjectionFrom(R, C);
    }

    @PortedFrom(file="tExpressionManager.h", name="ProjectInto")
    public ObjectRoleComplexExpression projectInto(ObjectRoleExpression R, ConceptExpression C) {
        return new ObjectRoleProjectionInto(R, C);
    }

    @PortedFrom(file="tExpressionManager.h", name="DataRoleTop")
    public DataRoleExpression dataRoleTop() {
        return this.dataRoleTop;
    }

    @PortedFrom(file="tExpressionManager.h", name="DataRoleBottom")
    public DataRoleExpression dataRoleBottom() {
        return this.dataRoleBottom;
    }

    @PortedFrom(file="tExpressionManager.h", name="DataRole")
    public DataRoleName dataRole(IRI name) {
        return this.dataRoleNameset.insert(name);
    }

    @PortedFrom(file="tExpressionManager.h", name="DataTop")
    public DataExpression dataTop() {
        return this.dataTop;
    }

    @PortedFrom(file="tExpressionManager.h", name="DataBottom")
    public DataBottom dataBottom() {
        return this.dataBottom;
    }

    @Original
    public String getDataTop() {
        return "http://www.w3.org/2000/01/rdf-schema#Literal";
    }

    @PortedFrom(file="tExpressionManager.h", name="DataNot")
    public DataExpression dataNot(DataExpression E) {
        return new DataNot(E);
    }

    @PortedFrom(file="tExpressionManager.h", name="DataAnd")
    public DataExpression dataAnd(List<DataExpression> l) {
        return new DataAnd(l);
    }

    @PortedFrom(file="tExpressionManager.h", name="DataOr")
    public DataExpression dataOr(List<DataExpression> l) {
        return new DataOr(l);
    }

    @PortedFrom(file="tExpressionManager.h", name="DataOneOf")
    public DataExpression dataOneOf(List<Literal<?>> l) {
        return new DataOneOf(l);
    }

    protected static class ConceptNameCreator
    implements NameCreator<ConceptName, IRI>,
    Serializable {
        private static final long serialVersionUID = 11000L;

        protected ConceptNameCreator() {
        }

        @Override
        public ConceptName makeEntry(IRI name) {
            return new ConceptName(name);
        }
    }

    protected static class IndividualNameCreator
    implements NameCreator<IndividualName, IRI>,
    Serializable {
        private static final long serialVersionUID = 11000L;

        protected IndividualNameCreator() {
        }

        @Override
        public IndividualName makeEntry(IRI name) {
            return new IndividualName(name);
        }
    }

    protected static class ObjectroleNameCreator
    implements NameCreator<ObjectRoleName, IRI>,
    Serializable {
        private static final long serialVersionUID = 11000L;

        protected ObjectroleNameCreator() {
        }

        @Override
        public ObjectRoleName makeEntry(IRI name) {
            return new ObjectRoleName(name);
        }
    }

    protected static class DataroleNameCreator
    implements NameCreator<DataRoleName, IRI>,
    Serializable {
        private static final long serialVersionUID = 11000L;

        protected DataroleNameCreator() {
        }

        @Override
        public DataRoleName makeEntry(IRI name) {
            return new DataRoleName(name);
        }
    }

    protected class InverseRoleCache
    implements Serializable {
        private static final long serialVersionUID = 11000L;
        private Map<ObjectRoleExpression, ObjectRoleExpression> map;

        protected InverseRoleCache() {
        }

        public ObjectRoleExpression get(ObjectRoleExpression tail) {
            if (this.map != null && this.map.containsKey(tail)) {
                return this.map.get(tail);
            }
            ObjectRoleExpression concat = this.build(tail);
            if (this.map == null) {
                this.map = new HashMap<ObjectRoleExpression, ObjectRoleExpression>();
            }
            this.map.put(tail, concat);
            return concat;
        }

        public void clear() {
            if (this.map != null) {
                this.map.clear();
            }
        }

        public ObjectRoleExpression build(ObjectRoleExpression tail) {
            return new ObjectRoleInverse(tail);
        }
    }
}

