/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.PortedFrom;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.DIOp;
import uk.ac.manchester.cs.jfact.kernel.DumpInterface;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.Role;

@PortedFrom(file="dumpLisp.h", name="dumpLisp")
class DumpLisp
extends DumpInterface {
    private static final long serialVersionUID = 11000L;

    public DumpLisp(LogAdapter oo) {
        super(oo);
    }

    @Override
    @PortedFrom(file="dumpLisp.h", name="dumpTop")
    public void dumpTop() {
        this.o.print("*TOP*");
    }

    @Override
    @PortedFrom(file="dumpLisp.h", name="dumpBottom")
    public void dumpBottom() {
        this.o.print("*BOTTOM*)");
    }

    @Override
    @PortedFrom(file="dumpLisp.h", name="dumpNumber")
    public void dumpNumber(int n) {
        this.o.print(n + " ");
    }

    @Override
    @PortedFrom(file="dumpLisp.h", name="startOp")
    public void startOp(DIOp Op, int n) {
        this.startOp(Op);
        this.dumpNumber(n);
    }

    @Override
    @PortedFrom(file="dumpLisp.h", name="contOp")
    public void contOp(DIOp Op) {
        if (Op == DIOp.diAnd || Op == DIOp.diOr) {
            this.skipIndent();
        } else {
            this.o.print(" ");
        }
    }

    @Override
    @PortedFrom(file="dumpLisp.h", name="finishOp")
    public void finishOp(DIOp Op) {
        if (Op == DIOp.diAnd || Op == DIOp.diOr) {
            this.decIndent();
        }
        this.o.print(")");
    }

    @Override
    @PortedFrom(file="dumpLisp.h", name="contAx")
    public void contAx(DIOp Ax) {
        this.o.print(" ");
    }

    @Override
    @PortedFrom(file="dumpLisp.h", name="finishAx")
    public void finishAx(DIOp Ax) {
        this.o.print(")\n");
    }

    @Override
    @PortedFrom(file="dumpLisp.h", name="dumpName")
    public void dumpName(NamedEntry p) {
        this.o.print("|" + p.getName() + "|");
    }

    @Override
    @PortedFrom(file="dumpLisp.h", name="dumpConcept")
    public void dumpConcept(Concept p) {
        this.dumpName(p);
    }

    @Override
    @PortedFrom(file="dumpLisp.h", name="dumpRole")
    public void dumpRole(Role p) {
        if (p.getId() < 0) {
            this.o.print("(inv ");
            this.dumpName(p.inverse());
            this.o.print(")");
        } else {
            this.dumpName(p);
        }
    }

    @Override
    @PortedFrom(file="dumpLisp.h", name="startOp")
    public void startOp(DIOp Op) {
        if (Op == DIOp.diAnd || Op == DIOp.diOr) {
            this.incIndent();
        }
        this.o.print("(");
        this.o.print(Op.getString());
        if (Op == DIOp.diEndOp) {
            throw new UnreachableSituationException();
        }
        this.contOp(Op);
    }

    @Override
    @PortedFrom(file="dumpLisp.h", name="startAx")
    public void startAx(DIOp Ax) {
        this.o.print("(");
        this.o.print(Ax.getString());
        if (Ax == DIOp.diEndOp) {
            throw new UnreachableSituationException();
        }
        this.contAx(Ax);
    }
}

