/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import uk.ac.manchester.cs.jfact.datatypes.DataTypeReasoner;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeEntry;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.LiteralEntry;
import uk.ac.manchester.cs.jfact.dep.DepSet;
import uk.ac.manchester.cs.jfact.helpers.DLVertex;
import uk.ac.manchester.cs.jfact.helpers.FastSet;
import uk.ac.manchester.cs.jfact.helpers.FastSetFactory;
import uk.ac.manchester.cs.jfact.helpers.FastSetSimple;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.helpers.Reference;
import uk.ac.manchester.cs.jfact.helpers.SaveStack;
import uk.ac.manchester.cs.jfact.helpers.Stats;
import uk.ac.manchester.cs.jfact.helpers.Templates;
import uk.ac.manchester.cs.jfact.helpers.Timer;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.AddConceptResult;
import uk.ac.manchester.cs.jfact.kernel.CGLabel;
import uk.ac.manchester.cs.jfact.kernel.CWDArray;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.ConceptWDep;
import uk.ac.manchester.cs.jfact.kernel.DLDag;
import uk.ac.manchester.cs.jfact.kernel.DagTag;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionGraph;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTreeArc;
import uk.ac.manchester.cs.jfact.kernel.EdgeCompare;
import uk.ac.manchester.cs.jfact.kernel.HasName;
import uk.ac.manchester.cs.jfact.kernel.Individual;
import uk.ac.manchester.cs.jfact.kernel.KBFlags;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.NodeCompare;
import uk.ac.manchester.cs.jfact.kernel.RAStateTransitions;
import uk.ac.manchester.cs.jfact.kernel.RATransition;
import uk.ac.manchester.cs.jfact.kernel.Redo;
import uk.ac.manchester.cs.jfact.kernel.Restorer;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.SimpleRule;
import uk.ac.manchester.cs.jfact.kernel.TBox;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.NamedEntity;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheConst;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheIan;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheInterface;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheState;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;
import uk.ac.manchester.cs.jfact.kernel.todolist.ToDoEntry;
import uk.ac.manchester.cs.jfact.kernel.todolist.ToDoList;
import uk.ac.manchester.cs.jfact.split.TSplitRules;

@PortedFrom(file="Reasoner.h", name="DlSatTester")
public class DlSatTester
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="Reasoner.h", name="SessionGCIs")
    private final List<Integer> SessionGCIs = new ArrayList<Integer>();
    @PortedFrom(file="Reasoner.h", name="ActiveSplits")
    private final FastSet ActiveSplits = FastSetFactory.create();
    @PortedFrom(file="Reasoner.h", name="SessionSignature")
    private final Set<NamedEntity> SessionSignature = new HashSet<NamedEntity>();
    @PortedFrom(file="Reasoner.h", name="SessionSigDepSet")
    private final Map<NamedEntity, DepSet> SessionSigDepSet = new HashMap<NamedEntity, DepSet>();
    @PortedFrom(file="Reasoner.h", name="NodesToMerge")
    private List<DlCompletionTree> NodesToMerge = new ArrayList<DlCompletionTree>();
    @PortedFrom(file="Reasoner.h", name="EdgesToMerge")
    private List<DlCompletionTreeArc> EdgesToMerge = new ArrayList<DlCompletionTreeArc>();
    @PortedFrom(file="Reasoner.h", name="tBox")
    protected final TBox tBox;
    @PortedFrom(file="Reasoner.h", name="DLHeap")
    protected final DLDag dlHeap;
    @PortedFrom(file="Reasoner.h", name="ReflexiveRoles")
    private final List<Role> reflexiveRoles = new ArrayList<Role>();
    @PortedFrom(file="Reasoner.h", name="CGraph")
    protected final DlCompletionGraph cGraph;
    @PortedFrom(file="Reasoner.h", name="TODO")
    private final ToDoList TODO;
    @Original
    private final FastSet used = new LocalFastSet();
    @PortedFrom(file="Reasoner.h", name="GCIs")
    private final KBFlags gcis;
    @PortedFrom(file="Reasoner.h", name="inProcess")
    private final FastSet inProcess = FastSetFactory.create();
    @PortedFrom(file="Reasoner.h", name="satTimer")
    private final Timer satTimer = new Timer();
    @PortedFrom(file="Reasoner.h", name="subTimer")
    private final Timer subTimer = new Timer();
    @PortedFrom(file="Reasoner.h", name="testTimer")
    private final Timer testTimer = new Timer();
    @PortedFrom(file="Reasoner.h", name="Stack")
    protected final BCStack stack = new BCStack();
    @PortedFrom(file="Reasoner.h", name="bContext")
    protected BranchingContext bContext;
    @PortedFrom(file="Reasoner.h", name="tryLevel")
    private int tryLevel;
    @PortedFrom(file="Reasoner.h", name="nonDetShift")
    protected int nonDetShift;
    @PortedFrom(file="Reasoner.h", name="splitRuleLevel")
    private int splitRuleLevel;
    @PortedFrom(file="Reasoner.h", name="curNode")
    protected DlCompletionTree curNode;
    @Original
    private DepSet curConceptDepSet;
    @Original
    private int curConceptConcept;
    @PortedFrom(file="Reasoner.h", name="dagSize")
    private int dagSize;
    @PortedFrom(file="Reasoner.h", name="OrConceptsToTest")
    private List<ConceptWDep> orConceptsToTest = new ArrayList<ConceptWDep>();
    @PortedFrom(file="Reasoner.h", name="clashSet")
    private DepSet clashSet = DepSet.create();
    @Original
    protected final JFactReasonerConfiguration options;
    @PortedFrom(file="Reasoner.h", name="encounterNominal")
    private boolean encounterNominal;
    @PortedFrom(file="Reasoner.h", name="checkDataNode")
    private boolean checkDataNode;
    @PortedFrom(file="Reasoner.h", name="newNodeCache")
    private final ModelCacheIan newNodeCache;
    @PortedFrom(file="Reasoner.h", name="newNodeEdges")
    private final ModelCacheIan newNodeEdges;
    @Original
    private final Stats stats = new Stats();
    @Original
    protected final DatatypeFactory datatypeFactory;
    @Original
    private static final EnumSet<DagTag> handlecollection = EnumSet.of(DagTag.dtAnd, DagTag.dtCollection);
    @Original
    private static final EnumSet<DagTag> handleforallle = EnumSet.of(DagTag.dtForall, DagTag.dtLE);
    @Original
    private static final EnumSet<DagTag> handlesingleton = EnumSet.of(DagTag.dtPSingleton, DagTag.dtNSingleton, DagTag.dtNConcept, DagTag.dtPConcept);

    @PortedFrom(file="Reasoner.h", name="isNodeGloballyUsed")
    private boolean isNodeGloballyUsed(DlCompletionTree node) {
        return !node.isDataNode() && !node.isIBlocked() && !node.isPBlocked();
    }

    @PortedFrom(file="Reasoner.h", name="isObjectNodeUnblocked")
    private boolean isObjectNodeUnblocked(DlCompletionTree node) {
        return this.isNodeGloballyUsed(node) && !node.isDBlocked();
    }

    @PortedFrom(file="Reasoner.h", name="updateName")
    private void updateName(DlCompletionTree node, int bp) {
        CGLabel lab = node.label();
        ConceptWDep c = lab.getConceptWithBP(bp);
        if (c == null) {
            c = lab.getConceptWithBP(-bp);
        }
        if (c != null) {
            this.addExistingToDoEntry(node, c, "sp");
        }
    }

    @PortedFrom(file="Reasoner.h", name="updateName")
    private void updateName(int bp) {
        int n = 0;
        DlCompletionTree node = this.cGraph.getNode(n++);
        while (node != null) {
            if (this.isNodeGloballyUsed(node)) {
                this.updateName(node, bp);
            }
            node = this.cGraph.getNode(n++);
        }
    }

    @PortedFrom(file="Reasoner.h", name="addExistingToDoEntry")
    private void addExistingToDoEntry(DlCompletionTree node, ConceptWDep C, String reason) {
        int bp = C.getConcept();
        this.TODO.addEntry(node, this.dlHeap.get(bp).getType(), C);
        this.logNCEntry(node, C.getConcept(), C.getDep(), "+", reason);
    }

    @PortedFrom(file="Reasoner.h", name="redoNodeLabel")
    private void redoNodeLabel(DlCompletionTree node, String reason) {
        int i;
        CGLabel lab = node.label();
        List<ConceptWDep> l = lab.get_sc();
        for (i = 0; i < l.size(); ++i) {
            this.addExistingToDoEntry(node, l.get(i), reason);
        }
        l = lab.get_cc();
        for (i = 0; i < l.size(); ++i) {
            this.addExistingToDoEntry(node, l.get(i), reason);
        }
    }

    @PortedFrom(file="Reasoner.h", name="ensureDAGSize")
    private void ensureDAGSize() {
        if (this.dagSize < this.dlHeap.size()) {
            this.dagSize = this.dlHeap.maxSize();
            this.tBox.getSplitRules().ensureDagSize(this.dagSize);
        }
    }

    @PortedFrom(file="Reasoner.h", name="createModelCache")
    protected ModelCacheInterface createModelCache(DlCompletionTree p) {
        return new ModelCacheIan(this.dlHeap, p, this.encounterNominal, this.tBox.nC, this.tBox.nR, this.options.isRKG_USE_SIMPLE_RULES());
    }

    @PortedFrom(file="Reasoner.h", name="tryCacheNode")
    private ModelCacheState tryCacheNode(DlCompletionTree node) {
        boolean val;
        ModelCacheState ret = this.canBeCached(node) ? this.reportNodeCached(node) : ModelCacheState.csFailed;
        boolean bl = val = ret == ModelCacheState.csValid;
        if (node.isCached() != val) {
            Restorer setCached = node.setCached(val);
            this.cGraph.saveRareCond(setCached);
        }
        return ret;
    }

    @PortedFrom(file="Reasoner.h", name="applyExtraRulesIf")
    private boolean applyExtraRulesIf(Concept p) {
        if (!p.hasExtraRules()) {
            return false;
        }
        assert (p.isPrimitive());
        return this.applyExtraRules(p);
    }

    @PortedFrom(file="Reasoner.h", name="hasNominals")
    public boolean hasNominals() {
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="isIBlocked")
    private boolean isIBlocked() {
        return this.curNode.isIBlocked();
    }

    @PortedFrom(file="Reasoner.h", name="isSomeExists")
    private boolean isSomeExists(Role R, int C) {
        if (!this.used.contains(C)) {
            return false;
        }
        DlCompletionTree where = this.curNode.isSomeApplicable(R, C);
        if (where != null) {
            this.options.getLog().printTemplate(Templates.E, R.getName(), where.getId(), C);
        }
        return where != null;
    }

    @PortedFrom(file="Reasoner.h", name="isFirstBranchCall")
    private boolean isFirstBranchCall() {
        return this.bContext == null;
    }

    @PortedFrom(file="Reasoner.h", name="initBC")
    protected void initBC(BranchingContext c) {
        c.node = this.curNode;
        c.concept = new ConceptWDep(this.curConceptConcept, this.curConceptDepSet);
        c.branchDep = DepSet.create(this.curConceptDepSet);
        c.SGsize = this.SessionGCIs.size();
    }

    @PortedFrom(file="Reasoner.h", name="createBCOr")
    private void createBCOr() {
        this.bContext = this.stack.pushOr();
    }

    @PortedFrom(file="Reasoner.h", name="createBCNN")
    private void createBCNN() {
        this.bContext = this.stack.pushNN();
    }

    @PortedFrom(file="Reasoner.h", name="createBCLE")
    private void createBCLE() {
        this.bContext = this.stack.pushLE();
    }

    @PortedFrom(file="Reasoner.h", name="createBCCh")
    private void createBCCh() {
        this.bContext = this.stack.pushCh();
    }

    @PortedFrom(file="Reasoner.h", name="isFunctionalVertex")
    private static boolean isFunctionalVertex(DLVertex v) {
        return v.getType() == DagTag.dtLE && v.getNumberLE() == 1 && v.getConceptIndex() == 1;
    }

    @PortedFrom(file="Reasoner.h", name="checkNRclash")
    private boolean checkNRclash(DLVertex atleast, DLVertex atmost) {
        return (atmost.getConceptIndex() == 1 || atleast.getConceptIndex() == atmost.getConceptIndex()) && atleast.getNumberGE() > atmost.getNumberLE() && atleast.getRole().lesserequal(atmost.getRole());
    }

    @PortedFrom(file="Reasoner.h", name="isQuickClashLE")
    private boolean isQuickClashLE(DLVertex atmost) {
        List<ConceptWDep> list = this.curNode.beginl_cc();
        for (int i = 0; i < list.size(); ++i) {
            ConceptWDep q = list.get(i);
            if (q.getConcept() >= 0 || !this.isNRClash(this.dlHeap.get(q.getConcept()), atmost, q)) continue;
            return true;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="isQuickClashGE")
    private boolean isQuickClashGE(DLVertex atleast) {
        List<ConceptWDep> list = this.curNode.beginl_cc();
        for (int i = 0; i < list.size(); ++i) {
            ConceptWDep q = list.get(i);
            if (q.getConcept() <= 0 || !this.isNRClash(atleast, this.dlHeap.get(q.getConcept()), q)) continue;
            return true;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="findChooseRuleConcept")
    private boolean findChooseRuleConcept(CWDArray label, int C, DepSet d) {
        if (C == 1) {
            return true;
        }
        if (this.findConceptClash(label, C, d)) {
            if (d != null) {
                d.add(this.clashSet);
            }
            return true;
        }
        if (this.findConceptClash(label, -C, d)) {
            if (d != null) {
                d.add(this.clashSet);
            }
            return false;
        }
        throw new UnreachableSituationException();
    }

    @PortedFrom(file="Reasoner.h", name="checkDisjointRoleClash")
    private boolean checkDisjointRoleClash(DlCompletionTreeArc edge, DlCompletionTree to, Role R, DepSet dep) {
        if (edge.getArcEnd().equals(to) && edge.getRole().isDisjoint(R)) {
            this.setClashSet(dep);
            this.updateClashSet(edge.getDep());
            return true;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="checkIrreflexivity")
    private boolean checkIrreflexivity(DlCompletionTreeArc edge, Role R, DepSet dep) {
        if (!edge.getArcEnd().equals(edge.getReverse().getArcEnd())) {
            return false;
        }
        if (!edge.isNeighbour(R) && !edge.isNeighbour(R.inverse())) {
            return false;
        }
        this.setClashSet(dep);
        this.updateClashSet(edge.getDep());
        return true;
    }

    @PortedFrom(file="Reasoner.h", name="logNCEntry")
    private void logNCEntry(DlCompletionTree n, int bp, DepSet dep, String action, String reason) {
        if (this.options.isLoggingActive()) {
            LogAdapter logAdapter = this.options.getLog();
            logAdapter.print(" ").print(action).print("(").print(n.logNode()).print(",").print(bp).print((Object)dep, (Object)")");
            if (reason != null) {
                logAdapter.print(reason);
            }
        }
    }

    @PortedFrom(file="Reasoner.h", name="getCurLevel")
    private int getCurLevel() {
        return this.tryLevel;
    }

    @PortedFrom(file="Reasoner.h", name="setCurLevel")
    private void setCurLevel(int level) {
        this.tryLevel = level;
    }

    @PortedFrom(file="Reasoner.h", name="noBranchingOps")
    protected boolean noBranchingOps() {
        return this.tryLevel == 1 + this.nonDetShift;
    }

    @PortedFrom(file="Reasoner.h", name="getSaveRestoreLevel")
    private int getSaveRestoreLevel(DepSet ds) {
        if (this.options.isRKG_IMPROVE_SAVE_RESTORE_DEPSET()) {
            return ds.level() + 1;
        }
        return this.getCurLevel();
    }

    @PortedFrom(file="Reasoner.h", name="restore")
    private void restore() {
        this.restore(this.getCurLevel() - 1);
    }

    @PortedFrom(file="Reasoner.h", name="updateLevel")
    private void updateLevel(DlCompletionTree n, DepSet ds) {
        this.cGraph.saveNode(n, this.getSaveRestoreLevel(ds));
    }

    @PortedFrom(file="Reasoner.h", name="determiniseBranchingOp")
    private void determiniseBranchingOp() {
        this.bContext = null;
        this.stack.pop();
    }

    @PortedFrom(file="Reasoner.h", name="setClashSet")
    private void setClashSet(DepSet d) {
        this.clashSet = d;
    }

    @PortedFrom(file="Reasoner.h", name="setClashSet")
    private void setClashSet(List<DepSet> d) {
        DepSet dep = DepSet.create();
        for (int i = 0; i < d.size(); ++i) {
            dep.add(d.get(i));
        }
        this.clashSet = dep;
    }

    @PortedFrom(file="Reasoner.h", name="updateClashSet")
    private void updateClashSet(DepSet d) {
        this.clashSet.add(d);
    }

    @PortedFrom(file="Reasoner.h", name="getCurDepSet")
    private DepSet getCurDepSet() {
        return DepSet.create(this.getCurLevel() - 1);
    }

    @PortedFrom(file="Reasoner.h", name="getBranchDep")
    private DepSet getBranchDep() {
        return this.bContext.branchDep;
    }

    @PortedFrom(file="Reasoner.h", name="updateBranchDep")
    private void updateBranchDep() {
        this.getBranchDep().add(this.clashSet);
    }

    @PortedFrom(file="Reasoner.h", name="prepareBranchDep")
    private void prepareBranchDep() {
        this.getBranchDep().restrict(this.getCurLevel());
    }

    @PortedFrom(file="Reasoner.h", name="useBranchDep")
    private void useBranchDep() {
        this.prepareBranchDep();
        this.setClashSet(this.getBranchDep());
    }

    @PortedFrom(file="Reasoner.h", name="repeatUnblockedNode")
    public void repeatUnblockedNode(DlCompletionTree node, boolean direct) {
        if (direct) {
            this.applyAllGeneratingRules(node);
        } else {
            this.redoNodeLabel(node, "ubi");
        }
    }

    @PortedFrom(file="Reasoner.h", name="getDAG")
    public DLDag getDAG() {
        return this.tBox.getDLHeap();
    }

    @PortedFrom(file="Reasoner.h", name="getRootNode")
    public DlCompletionTree getRootNode() {
        return this.cGraph.getRoot();
    }

    @Original
    public void initToDoPriorities() {
        String iaoeflg = this.options.getIAOEFLG();
        this.options.getLog().print((Object)"\nInit IAOEFLG = ", (Object)iaoeflg);
        this.TODO.initPriorities(iaoeflg);
    }

    @PortedFrom(file="Reasoner.h", name="setBlockingMethod")
    public void setBlockingMethod(boolean hasInverse, boolean hasQCR) {
        this.cGraph.setBlockingMethod(hasInverse, hasQCR);
    }

    @PortedFrom(file="Reasoner.h", name="buildCacheByCGraph")
    public ModelCacheInterface buildCacheByCGraph(boolean sat) {
        if (sat) {
            return this.createModelCache(this.getRootNode());
        }
        return ModelCacheConst.createConstCache(-1);
    }

    @PortedFrom(file="Reasoner.h", name="writeTotalStatistic")
    public void writeTotalStatistic(LogAdapter o) {
        if (this.options.isUSE_REASONING_STATISTICS()) {
            this.stats.accumulate();
            this.stats.logStatisticData(o, false, this.cGraph, this.options);
        }
        o.print("\n");
    }

    @PortedFrom(file="Reasoner.h", name="createCache")
    public ModelCacheInterface createCache(int p, FastSet f) {
        assert (Helper.isValid(p));
        ModelCacheInterface cache = this.dlHeap.getCache(p);
        if (cache != null) {
            return cache;
        }
        if (!this.tBox.testHasTopRole()) {
            this.prepareCascadedCache(p, f);
        }
        if ((cache = this.dlHeap.getCache(p)) != null) {
            return cache;
        }
        cache = this.buildCache(p);
        this.dlHeap.setCache(p, cache);
        return cache;
    }

    @PortedFrom(file="Reasoner.h", name="prepareCascadedCache")
    private void prepareCascadedCache(int p, FastSet f) {
        Role R;
        boolean pos;
        if (this.inProcess.contains(p)) {
            return;
        }
        if (f.contains(p)) {
            return;
        }
        DLVertex v = this.dlHeap.get(p);
        boolean bl = pos = p > 0;
        if (v.getCache(pos) != null) {
            return;
        }
        DagTag type = v.getType();
        if (handlecollection.contains((Object)type)) {
            for (int q : v.begin()) {
                int p2 = pos ? q : -q;
                this.inProcess.add(p2);
                this.prepareCascadedCache(p2, f);
                this.inProcess.remove(p2);
            }
        } else if (handlesingleton.contains((Object)type)) {
            if (!pos && type.isPNameTag()) {
                return;
            }
            this.inProcess.add(p);
            this.prepareCascadedCache(pos ? v.getConceptIndex() : -v.getConceptIndex(), f);
            this.inProcess.remove(p);
        } else if (handleforallle.contains((Object)type) && !(R = v.getRole()).isDataRole() && !R.isTop()) {
            int x;
            int n = x = pos ? v.getConceptIndex() : -v.getConceptIndex();
            if (x != 1) {
                this.inProcess.add(x);
                this.createCache(x, f);
                this.inProcess.remove(x);
            }
            if ((x = R.getBPRange()) != 1) {
                this.inProcess.add(x);
                this.createCache(x, f);
                this.inProcess.remove(x);
            }
        }
        f.add(p);
    }

    @PortedFrom(file="Reasoner.h", name="buildCache")
    private ModelCacheInterface buildCache(int p) {
        boolean sat;
        LogAdapter logAdapter = this.options.getLog();
        if (this.options.isLoggingActive()) {
            logAdapter.print("\nChecking satisfiability of DAG entry ").print(p);
            this.tBox.printDagEntry(logAdapter, p);
            logAdapter.print(":\n");
        }
        if (!(sat = this.runSat(p, 1))) {
            logAdapter.printTemplate(Templates.BUILD_CACHE_UNSAT, p);
        }
        return this.buildCacheByCGraph(sat);
    }

    @PortedFrom(file="Reasoner.h", name="useActiveSignature")
    private boolean useActiveSignature() {
        return !this.tBox.getSplits().empty();
    }

    @PortedFrom(file="Reasoner.h", name="resetSessionFlags")
    protected void resetSessionFlags() {
        this.ensureDAGSize();
        this.used.add(1);
        this.used.add(-1);
        this.encounterNominal = false;
        this.checkDataNode = true;
        this.splitRuleLevel = 0;
    }

    @PortedFrom(file="Reasoner.h", name="initNewNode")
    protected boolean initNewNode(DlCompletionTree node, DepSet dep, int C) {
        if (node.isDataNode()) {
            this.checkDataNode = false;
        }
        node.setInit(C);
        if (this.addToDoEntry(node, C, dep, null)) {
            return true;
        }
        if (node.isDataNode()) {
            return false;
        }
        if (this.addToDoEntry(node, this.tBox.getTG(), dep, null)) {
            return true;
        }
        if (this.gcis.isReflexive() && this.applyReflexiveRoles(node, dep)) {
            return true;
        }
        if (!this.SessionGCIs.isEmpty()) {
            for (int i : this.SessionGCIs) {
                if (!this.addToDoEntry(node, i, dep, "sg")) continue;
                return true;
            }
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="runSat")
    public boolean runSat(int p, int q) {
        this.prepareReasoner();
        if (this.initNewNode(this.cGraph.getRoot(), DepSet.create(), p) || this.addToDoEntry(this.cGraph.getRoot(), q, DepSet.create(), null)) {
            return false;
        }
        Timer timer = q == 1 ? this.satTimer : this.subTimer;
        timer.start();
        boolean result = this.runSat();
        timer.stop();
        return result;
    }

    @PortedFrom(file="Reasoner.h", name="checkDisjointRoles")
    public boolean checkDisjointRoles(Role R, Role S) {
        this.prepareReasoner();
        DepSet dummy = DepSet.create();
        if (this.initNewNode(this.cGraph.getRoot(), dummy, 1)) {
            return true;
        }
        this.curNode = this.cGraph.getRoot();
        DlCompletionTreeArc edgeR = this.createOneNeighbour(R, dummy);
        DlCompletionTreeArc edgeS = this.createOneNeighbour(S, dummy);
        if (this.initNewNode(edgeR.getArcEnd(), dummy, 1) || this.initNewNode(edgeS.getArcEnd(), dummy, 1) || this.setupEdge(edgeR, dummy, 0) || this.setupEdge(edgeS, dummy, 0) || this.merge(edgeS.getArcEnd(), edgeR.getArcEnd(), dummy)) {
            return true;
        }
        this.curNode = null;
        return !this.runSat();
    }

    @PortedFrom(file="Reasoner.h", name="checkIrreflexivity")
    public boolean checkIrreflexivity(Role R) {
        this.prepareReasoner();
        DepSet dummy = DepSet.create();
        if (this.initNewNode(this.cGraph.getRoot(), dummy, 1)) {
            return true;
        }
        this.curNode = this.cGraph.getRoot();
        DlCompletionTreeArc edgeR = this.createOneNeighbour(R, dummy);
        if (this.initNewNode(edgeR.getArcEnd(), dummy, 1) || this.setupEdge(edgeR, dummy, 0) || this.merge(edgeR.getArcEnd(), this.cGraph.getRoot(), dummy)) {
            return true;
        }
        this.curNode = null;
        return !this.runSat();
    }

    @PortedFrom(file="Reasoner.h", name="backJumpedRestore")
    private boolean backJumpedRestore() {
        if (this.clashSet == null || this.clashSet.isEmpty()) {
            return true;
        }
        this.restore(this.clashSet.level());
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="straightforwardRestore")
    private boolean straightforwardRestore() {
        if (this.noBranchingOps()) {
            return true;
        }
        this.restore();
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="tunedRestore")
    private boolean tunedRestore() {
        if (this.options.getuseBackjumping()) {
            return this.backJumpedRestore();
        }
        return this.straightforwardRestore();
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyAll")
    private boolean commonTacticBodyAll(DLVertex cur) {
        assert (this.curConceptConcept > 0 && cur.getType() == DagTag.dtForall);
        if (cur.getRole().isTop()) {
            this.stats.getnAllCalls().inc();
            return this.addSessionGCI(cur.getConceptIndex(), this.curConceptDepSet);
        }
        if (cur.getRole().isSimple()) {
            return this.commonTacticBodyAllSimple(cur);
        }
        return this.commonTacticBodyAllComplex(cur);
    }

    @PortedFrom(file="Reasoner.h", name="addSessionGCI")
    private boolean addSessionGCI(int C, DepSet dep) {
        this.SessionGCIs.add(C);
        int n = 0;
        DlCompletionTree node = this.cGraph.getNode(n++);
        while (node != null) {
            if (this.isNodeGloballyUsed(node) && this.addToDoEntry(node, C, dep, "sg")) {
                return true;
            }
            node = this.cGraph.getNode(n++);
        }
        return false;
    }

    protected DlSatTester(TBox tbox, JFactReasonerConfiguration Options, DatatypeFactory datatypeFactory) {
        this.options = Options;
        this.datatypeFactory = datatypeFactory;
        this.tBox = tbox;
        this.dlHeap = tbox.getDLHeap();
        this.cGraph = new DlCompletionGraph(1, this);
        this.TODO = new ToDoList();
        this.newNodeCache = new ModelCacheIan(true, tbox.nC, tbox.nR, this.options.isRKG_USE_SIMPLE_RULES());
        this.newNodeEdges = new ModelCacheIan(false, tbox.nC, tbox.nR, this.options.isRKG_USE_SIMPLE_RULES());
        this.gcis = tbox.getGCIs();
        this.bContext = null;
        this.tryLevel = 1;
        this.nonDetShift = 0;
        this.curNode = null;
        this.dagSize = 0;
        this.options.getLog().printTemplate(Templates.READCONFIG, this.options.getuseSemanticBranching(), this.options.getuseBackjumping(), this.options.getuseLazyBlocking(), this.options.getuseAnywhereBlocking());
        if (this.tBox.hasFC() && this.options.getuseAnywhereBlocking()) {
            this.options.setuseAnywhereBlocking(false);
            this.options.getLog().print("Fairness constraints: set useAnywhereBlocking = false\n");
        }
        this.cGraph.initContext(tbox.getnSkipBeforeBlock(), this.options.getuseLazyBlocking(), this.options.getuseAnywhereBlocking());
        tbox.getORM().fillReflexiveRoles(this.reflexiveRoles);
        this.resetSessionFlags();
    }

    @Original
    public JFactReasonerConfiguration getOptions() {
        return this.options;
    }

    @PortedFrom(file="Reasoner.h", name="prepareReasoner")
    protected void prepareReasoner() {
        this.cGraph.clear();
        this.stack.clear();
        this.TODO.clear();
        this.used.clear();
        this.SessionGCIs.clear();
        this.curNode = null;
        this.bContext = null;
        this.tryLevel = 1;
        this.resetSessionFlags();
    }

    @PortedFrom(file="Reasoner.h", name="findConcept")
    public boolean findConcept(CWDArray label, int p) {
        assert (Helper.isCorrect(p));
        assert (p != 1);
        assert (p != -1);
        this.stats.getnLookups().inc();
        return label.contains(p);
    }

    @PortedFrom(file="Reasoner.h", name="checkAddedConcept")
    private AddConceptResult checkAddedConcept(CWDArray lab, int p, DepSet dep) {
        assert (Helper.isCorrect(p));
        assert (p != 1);
        assert (p != -1);
        this.stats.getnLookups().inc();
        this.stats.getnLookups().inc();
        if (lab.contains(p)) {
            return AddConceptResult.acrExist;
        }
        int inv_p = -p;
        DepSet depset = lab.get(inv_p);
        if (depset != null) {
            this.clashSet = DepSet.plus(depset, dep);
            return AddConceptResult.acrClash;
        }
        return AddConceptResult.acrDone;
    }

    @PortedFrom(file="Reasoner.h", name="findConceptClash")
    private boolean findConceptClash(CWDArray lab, int bp, DepSet dep) {
        this.stats.getnLookups().inc();
        DepSet depset = lab.get(bp);
        if (depset != null) {
            this.clashSet = DepSet.plus(depset, dep);
            return true;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="tryAddConcept")
    private AddConceptResult tryAddConcept(CWDArray lab, int bp, DepSet dep) {
        boolean canC = this.used.contains(bp);
        boolean canNegC = this.used.contains(-bp);
        if (canC) {
            if (canNegC) {
                return this.checkAddedConcept(lab, bp, dep);
            }
            this.stats.getnLookups().inc();
            return this.findConcept(lab, bp) ? AddConceptResult.acrExist : AddConceptResult.acrDone;
        }
        if (canNegC) {
            return this.findConceptClash(lab, -bp, dep) ? AddConceptResult.acrClash : AddConceptResult.acrDone;
        }
        return AddConceptResult.acrDone;
    }

    @PortedFrom(file="Reasoner.h", name="addToDoEntry")
    protected boolean addToDoEntry(DlCompletionTree n, int bp, DepSet dep, String reason) {
        if (bp == 1) {
            return false;
        }
        if (bp == -1) {
            this.setClashSet(dep);
            this.logNCEntry(n, bp, dep, "x", this.dlHeap.get(bp).getType().getName());
            return true;
        }
        DLVertex v = this.dlHeap.get(bp);
        DagTag tag = v.getType();
        if (tag == DagTag.dtCollection) {
            if (bp < 0) {
                return false;
            }
            this.stats.getnTacticCalls().inc();
            DlCompletionTree oldNode = this.curNode;
            int oldConceptConcept = this.curConceptConcept;
            FastSetSimple oldConceptDepSetDelegate = this.curConceptDepSet.getDelegate();
            this.curNode = n;
            this.curConceptConcept = bp;
            this.curConceptDepSet = DepSet.create(this.curConceptDepSet);
            boolean ret = this.commonTacticBodyAnd(v);
            this.curNode = oldNode;
            this.curConceptConcept = oldConceptConcept;
            this.curConceptDepSet = DepSet.create(oldConceptDepSetDelegate);
            return ret;
        }
        switch (this.tryAddConcept(n.label().getLabel(tag), bp, dep)) {
            case acrClash: {
                this.logNCEntry(n, bp, dep, "x", this.dlHeap.get(bp).getType().getName());
                return true;
            }
            case acrExist: {
                return false;
            }
            case acrDone: {
                return this.insertToDoEntry(n, bp, dep, tag, reason);
            }
        }
        throw new UnreachableSituationException();
    }

    @PortedFrom(file="Reasoner.h", name="insertToDoEntry")
    private boolean insertToDoEntry(DlCompletionTree n, int bp, DepSet dep, DagTag tag, String reason) {
        ConceptWDep p = new ConceptWDep(bp, dep);
        this.updateLevel(n, dep);
        this.cGraph.addConceptToNode(n, p, tag);
        this.used.add(bp);
        if (n.isCached()) {
            return this.correctCachedEntry(n);
        }
        this.TODO.addEntry(n, tag, p);
        if (n.isDataNode()) {
            return this.checkDataNode ? this.hasDataClash(n) : false;
        }
        this.logNCEntry(n, bp, dep, "+", reason);
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="canBeCached")
    private boolean canBeCached(DlCompletionTree node) {
        ConceptWDep p;
        int i;
        boolean shallow = true;
        int size = 0;
        if (!this.options.isUseNodeCache()) {
            return false;
        }
        if (node.isNominalNode()) {
            return false;
        }
        this.stats.getnCacheTry().inc();
        List<ConceptWDep> list = node.beginl_sc();
        for (i = 0; i < list.size(); ++i) {
            p = list.get(i);
            if (this.dlHeap.getCache(p.getConcept()) == null) {
                this.stats.getnCacheFailedNoCache().inc();
                this.options.getLog().printTemplate(Templates.CAN_BE_CACHED, p.getConcept());
                return false;
            }
            shallow &= this.dlHeap.getCache(p.getConcept()).shallowCache();
            ++size;
        }
        list = node.beginl_cc();
        for (i = 0; i < list.size(); ++i) {
            p = list.get(i);
            if (this.dlHeap.getCache(p.getConcept()) == null) {
                this.stats.getnCacheFailedNoCache().inc();
                this.options.getLog().printTemplate(Templates.CAN_BE_CACHED, p.getConcept());
                return false;
            }
            shallow &= this.dlHeap.getCache(p.getConcept()).shallowCache();
            ++size;
        }
        if (shallow && size != 0) {
            this.stats.getnCacheFailedShallow().inc();
            this.options.getLog().print(" cf(s)");
            return false;
        }
        return true;
    }

    @PortedFrom(file="Reasoner.h", name="doCacheNode")
    private void doCacheNode(DlCompletionTree node) {
        ArrayList<DepSet> deps = new ArrayList<DepSet>();
        this.newNodeCache.clear();
        List<ConceptWDep> beginl_sc = node.beginl_sc();
        for (int i = 0; i < beginl_sc.size(); ++i) {
            ConceptWDep p = beginl_sc.get(i);
            deps.add(p.getDep());
            ModelCacheState merge = this.newNodeCache.merge(this.dlHeap.getCache(p.getConcept()));
            if (merge == ModelCacheState.csValid) continue;
            if (merge == ModelCacheState.csInvalid) {
                this.setClashSet(deps);
            }
            return;
        }
        List<ConceptWDep> list = node.beginl_cc();
        for (int i = 0; i < list.size(); ++i) {
            ConceptWDep p = list.get(i);
            deps.add(p.getDep());
            ModelCacheState merge = this.newNodeCache.merge(this.dlHeap.getCache(p.getConcept()));
            if (merge == ModelCacheState.csValid) continue;
            if (merge == ModelCacheState.csInvalid) {
                this.setClashSet(deps);
            }
            return;
        }
        this.newNodeEdges.clear();
        this.newNodeEdges.initRolesFromArcs(node);
        this.newNodeCache.merge(this.newNodeEdges);
    }

    @PortedFrom(file="Reasoner.h", name="reportNodeCached")
    private ModelCacheState reportNodeCached(DlCompletionTree node) {
        this.doCacheNode(node);
        ModelCacheState status = this.newNodeCache.getState();
        switch (status) {
            case csValid: {
                this.stats.getnCachedSat().inc();
                this.options.getLog().printTemplate(Templates.REPORT1, node.getId());
                break;
            }
            case csInvalid: {
                this.stats.getnCachedUnsat().inc();
                break;
            }
            case csFailed: 
            case csUnknown: {
                this.stats.getnCacheFailed().inc();
                this.options.getLog().print(" cf(c)");
                status = ModelCacheState.csFailed;
                break;
            }
            default: {
                throw new UnreachableSituationException();
            }
        }
        return status;
    }

    @PortedFrom(file="Reasoner.h", name="correctCachedEntry")
    private boolean correctCachedEntry(DlCompletionTree n) {
        assert (n.isCached());
        ModelCacheState status = this.tryCacheNode(n);
        if (status == ModelCacheState.csFailed) {
            this.redoNodeLabel(n, "uc");
        }
        return status.usageByState();
    }

    @PortedFrom(file="Reasoner.h", name="hasDataClash")
    private boolean hasDataClash(DlCompletionTree node) {
        assert (node != null && node.isDataNode());
        List<ConceptWDep> concepts = node.beginl_sc();
        int size = concepts.size();
        DataTypeReasoner datatypeReasoner = new DataTypeReasoner(this.options);
        LinkedHashSet<DataCall> calls = new LinkedHashSet<DataCall>();
        for (int i = 0; i < size; ++i) {
            boolean positive;
            ConceptWDep r = concepts.get(i);
            DagTag d = this.dlHeap.get(r.getConcept()).getType();
            NamedEntry dataEntry = this.dlHeap.get(r.getConcept()).getConcept();
            boolean bl = positive = r.getConcept() > 0;
            if (dataEntry == null) continue;
            DataCall dc = new DataCall();
            dc.d = d;
            dc.positive = positive;
            dc.dataEntry = dataEntry;
            dc.r = r;
            calls.add(dc);
        }
        for (DataCall dc : calls) {
            if (!datatypeReasoner.addDataEntry(dc.positive, dc.d, dc.dataEntry, dc.r.getDep())) continue;
            this.setClashSet(datatypeReasoner.getClashSet());
            return true;
        }
        boolean checkClash = datatypeReasoner.checkClash();
        if (checkClash) {
            this.setClashSet(datatypeReasoner.getClashSet());
        }
        return checkClash;
    }

    @PortedFrom(file="Reasoner.h", name="runSat")
    protected boolean runSat() {
        this.testTimer.start();
        boolean result = this.checkSatisfiability();
        this.testTimer.stop();
        this.options.getLog().print("\nChecking time was ").print(this.testTimer.getResultTime()).print(" milliseconds");
        this.testTimer.reset();
        this.finaliseStatistic();
        if (result) {
            this.cGraph.print(this.options.getLog());
        }
        return result;
    }

    @PortedFrom(file="Reasoner.h", name="finaliseStatistic")
    private void finaliseStatistic() {
        this.cGraph.clearStatistics();
    }

    @PortedFrom(file="Reasoner.h", name="applyReflexiveRoles")
    private boolean applyReflexiveRoles(DlCompletionTree node, DepSet dep) {
        for (Role p : this.reflexiveRoles) {
            DlCompletionTreeArc pA = this.cGraph.addRoleLabel(node, node, false, p, dep);
            if (!this.setupEdge(pA, dep, 0)) continue;
            return true;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="checkSatisfiability")
    protected boolean checkSatisfiability() {
        int loop = 0;
        while (true) {
            if (this.curNode == null) {
                if (this.TODO.isEmpty()) {
                    if (this.performAfterReasoning() && this.tunedRestore()) {
                        return false;
                    }
                    if (this.TODO.isEmpty()) {
                        return true;
                    }
                }
                ToDoEntry curTDE = this.TODO.getNextEntry();
                assert (curTDE != null);
                this.curNode = curTDE.getNode();
                this.curConceptConcept = curTDE.getOffsetConcept();
                this.curConceptDepSet = DepSet.create(curTDE.getOffsetDepSet());
            }
            if (++loop == 50) {
                loop = 0;
                if (this.tBox.isCancelled().get()) {
                    return false;
                }
                if (this.testTimer.calcDelta() >= this.options.getTimeOut()) {
                    throw new TimeOutException();
                }
            }
            if (this.commonTactic()) {
                if (!this.tunedRestore()) continue;
                return false;
            }
            this.curNode = null;
        }
    }

    @PortedFrom(file="Reasoner.h", name="performAfterReasoning")
    private boolean performAfterReasoning() {
        this.logIndentation();
        this.options.getLog().print("ub:");
        this.cGraph.retestCGBlockedStatus();
        this.options.getLog().print("]");
        if (!this.TODO.isEmpty()) {
            return false;
        }
        if (!this.tBox.getSplits().empty()) {
            this.logIndentation();
            this.options.getLog().print("split:");
            boolean clash = this.checkSplitRules();
            this.options.getLog().print("]");
            if (clash) {
                return true;
            }
            if (!this.TODO.isEmpty()) {
                return false;
            }
        }
        if (this.options.isRKG_USE_FAIRNESS() && this.tBox.hasFC()) {
            DlCompletionTree violator = null;
            for (Concept p : this.tBox.getFairness()) {
                violator = this.cGraph.getFCViolator(p.getpName());
                if (violator == null) continue;
                this.stats.getnFairnessViolations().inc();
                if (!this.addToDoEntry(violator, p.getpName(), this.getCurDepSet(), "fair")) continue;
                return true;
            }
            if (!this.TODO.isEmpty()) {
                return false;
            }
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="applySplitRule")
    private boolean applySplitRule(TSplitRules.TSplitRule rule) {
        DepSet dep = rule.fireDep(this.SessionSignature, this.SessionSigDepSet);
        int bp = rule.bp() - 1;
        this.ActiveSplits.add(bp);
        if (this.addSessionGCI(bp + 1, dep)) {
            return true;
        }
        this.updateName(bp);
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="checkSplitRules")
    private boolean checkSplitRules() {
        if (this.splitRuleLevel == 0) {
            this.ActiveSplits.clear();
            this.SessionSignature.clear();
            this.SessionSigDepSet.clear();
            this.splitRuleLevel = this.getCurLevel();
        }
        this.updateSessionSignature();
        for (TSplitRules.TSplitRule p : this.tBox.getSplitRules().getRules()) {
            if (this.ActiveSplits.contains(p.bp() - 1) || !p.canFire(this.SessionSignature) || !this.applySplitRule(p)) continue;
            return true;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="restoreBC")
    private void restoreBC() {
        this.curNode = this.bContext.node;
        if (this.bContext.concept == null) {
            this.curConceptConcept = 0;
            this.curConceptDepSet = DepSet.create();
        } else {
            this.curConceptConcept = this.bContext.concept.getConcept();
            this.curConceptDepSet = DepSet.create(this.bContext.concept.getDep());
        }
        if (!this.SessionGCIs.isEmpty()) {
            Helper.resize(this.SessionGCIs, this.bContext.SGsize);
        }
        this.updateBranchDep();
        this.bContext.nextOption();
    }

    @PortedFrom(file="Reasoner.h", name="save")
    protected void save() {
        this.cGraph.save();
        this.TODO.save();
        ++this.tryLevel;
        this.bContext = null;
        this.stats.getnStateSaves().inc();
        this.options.getLog().printTemplate(Templates.SAVE, this.getCurLevel() - 1);
        if (this.options.isDEBUG_SAVE_RESTORE()) {
            this.cGraph.print(this.options.getLog());
            this.options.getLog().print((Object)this.TODO);
        }
    }

    @PortedFrom(file="Reasoner.h", name="restore")
    protected void restore(int newTryLevel) {
        assert (!this.stack.isEmpty());
        assert (newTryLevel > 0);
        this.setCurLevel(newTryLevel);
        if (this.getCurLevel() < this.splitRuleLevel) {
            this.splitRuleLevel = 0;
        }
        this.bContext = (BranchingContext)this.stack.top(this.getCurLevel());
        this.restoreBC();
        this.cGraph.restore(this.getCurLevel());
        this.TODO.restore(this.getCurLevel());
        this.stats.getnStateRestores().inc();
        this.options.getLog().printTemplate(Templates.RESTORE, this.getCurLevel());
        if (this.options.isDEBUG_SAVE_RESTORE()) {
            this.cGraph.print(this.options.getLog());
            this.options.getLog().print((Object)this.TODO);
        }
    }

    @PortedFrom(file="Reasoner.h", name="logIndentation")
    private void logIndentation() {
        LogAdapter logAdapter = this.options.getLog();
        logAdapter.print("\n");
        for (int i = 1; i < this.getCurLevel(); ++i) {
            logAdapter.print(' ');
        }
        logAdapter.print('[');
    }

    @PortedFrom(file="Reasoner.h", name="logStartEntry")
    private void logStartEntry() {
        if (this.options.isLoggingActive()) {
            this.logIndentation();
            LogAdapter logAdapter = this.options.getLog();
            logAdapter.print("(");
            logAdapter.print(this.curNode.logNode());
            logAdapter.print(",");
            logAdapter.print(this.curConceptConcept);
            if (this.curConceptDepSet != null) {
                logAdapter.print((Object)this.curConceptDepSet);
            }
            logAdapter.print("){");
            if (this.curConceptConcept < 0) {
                logAdapter.print("~");
            }
            DLVertex v = this.dlHeap.get(this.curConceptConcept);
            logAdapter.print(v.getType().name());
            if (v.getConcept() != null) {
                logAdapter.print((Object)"(", (Object)v.getConcept().getName(), (Object)")");
            }
            logAdapter.print("}:");
            logAdapter.print("}:");
        }
    }

    @PortedFrom(file="Reasoner.h", name="logFinishEntry")
    private void logFinishEntry(boolean res) {
        if (this.options.isLoggingActive()) {
            this.options.getLog().print("]");
            if (res) {
                this.options.getLog().printTemplate(Templates.LOG_FINISH_ENTRY, this.clashSet);
            }
        }
    }

    @PortedFrom(file="Reasoner.h", name="printReasoningTime")
    public float printReasoningTime(LogAdapter o) {
        o.print((Object)"\n     SAT takes ", (Object)this.satTimer, (Object)" seconds\n     SUB takes ", (Object)this.subTimer, (Object)" seconds");
        return this.satTimer.calcDelta() + this.subTimer.calcDelta();
    }

    @PortedFrom(file="Reasoner.h", name="commonTactic")
    private boolean commonTactic() {
        if (this.curNode.isCached() || this.curNode.isPBlocked()) {
            return false;
        }
        this.logStartEntry();
        boolean ret = false;
        if (!this.isIBlocked()) {
            ret = this.commonTacticBody(this.dlHeap.get(this.curConceptConcept));
        }
        this.logFinishEntry(ret);
        return ret;
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBody")
    private boolean commonTacticBody(DLVertex cur) {
        this.stats.getnTacticCalls().inc();
        switch (cur.getType()) {
            case dtTop: {
                throw new UnreachableSituationException();
            }
            case dtDataType: 
            case dtDataValue: {
                this.stats.getnUseless().inc();
                return false;
            }
            case dtPSingleton: 
            case dtNSingleton: {
                if (this.curConceptConcept > 0) {
                    return this.commonTacticBodySingleton(cur);
                }
                return this.commonTacticBodyId(cur);
            }
            case dtNConcept: 
            case dtPConcept: {
                return this.commonTacticBodyId(cur);
            }
            case dtAnd: {
                if (this.curConceptConcept > 0) {
                    return this.commonTacticBodyAnd(cur);
                }
                return this.commonTacticBodyOr(cur);
            }
            case dtForall: {
                if (this.curConceptConcept < 0) {
                    return this.commonTacticBodySome(cur);
                }
                return this.commonTacticBodyAll(cur);
            }
            case dtIrr: {
                if (this.curConceptConcept < 0) {
                    return this.commonTacticBodySomeSelf(cur.getRole());
                }
                return this.commonTacticBodyIrrefl(cur.getRole());
            }
            case dtLE: {
                if (this.curConceptConcept < 0) {
                    return this.commonTacticBodyGE(cur);
                }
                if (DlSatTester.isFunctionalVertex(cur)) {
                    return this.commonTacticBodyFunc(cur);
                }
                return this.commonTacticBodyLE(cur);
            }
            case dtProj: {
                assert (this.curConceptConcept > 0);
                return this.commonTacticBodyProj(cur.getRole(), cur.getConceptIndex(), cur.getProjRole());
            }
            case dtSplitConcept: {
                return this.commonTacticBodySplit(cur);
            }
            case dtChoose: {
                assert (this.curConceptConcept > 0);
                return this.applyChooseRule(this.curNode, cur.getConceptIndex());
            }
        }
        throw new UnreachableSituationException();
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyId")
    private boolean commonTacticBodyId(DLVertex cur) {
        assert (cur.getType().isCNameTag());
        this.stats.getnIdCalls().inc();
        if (this.options.isRKG_USE_SIMPLE_RULES() && this.curConceptConcept > 0 && this.applyExtraRulesIf((Concept)cur.getConcept())) {
            return true;
        }
        int C = this.curConceptConcept > 0 ? cur.getConceptIndex() : -cur.getConceptIndex();
        return this.addToDoEntry(this.curNode, C, this.curConceptDepSet, null);
    }

    @PortedFrom(file="Reasoner.h", name="updateSessionSignature")
    private void updateSessionSignature(NamedEntity entity, DepSet dep) {
        if (entity != null) {
            this.SessionSignature.add(entity);
            this.SessionSigDepSet.get(entity).add(dep);
        }
    }

    @PortedFrom(file="Reasoner.h", name="updateSignatureByNode")
    private void updateSignatureByNode(DlCompletionTree node) {
        CGLabel lab = node.label();
        for (ConceptWDep p : lab.get_sc()) {
            this.updateSessionSignature(this.tBox.getSplitRules().getEntity(p.getConcept()), p.getDep());
        }
    }

    @PortedFrom(file="Reasoner.h", name="updateSessionSignature")
    private void updateSessionSignature() {
        int n = 0;
        DlCompletionTree node = this.cGraph.getNode(n++);
        while (node != null) {
            if (this.isObjectNodeUnblocked(node)) {
                this.updateSignatureByNode(node);
            }
            node = this.cGraph.getNode(n++);
        }
    }

    @PortedFrom(file="Reasoner.h", name="applicable")
    protected boolean applicable(SimpleRule rule) {
        CWDArray lab = this.curNode.label().getLabel(DagTag.dtPConcept);
        DepSet loc = DepSet.create(this.curConceptDepSet);
        for (Concept p : rule.getBody()) {
            if (p.getpName() == this.curConceptConcept) continue;
            if (this.findConceptClash(lab, p.getpName(), loc)) {
                loc.add(this.clashSet);
                continue;
            }
            return false;
        }
        this.setClashSet(loc);
        return true;
    }

    @PortedFrom(file="Reasoner.h", name="applyExtraRules")
    private boolean applyExtraRules(Concept C) {
        FastSet er_begin = C.getExtraRules();
        for (int i = 0; i < er_begin.size(); ++i) {
            SimpleRule rule = this.tBox.getSimpleRule(er_begin.get(i));
            this.stats.getnSRuleAdd().inc();
            if (!rule.applicable(this)) continue;
            this.stats.getnSRuleFire().inc();
            if (!this.addToDoEntry(this.curNode, rule.getBpHead(), this.clashSet, null)) continue;
            return true;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodySingleton")
    private boolean commonTacticBodySingleton(DLVertex cur) {
        assert (cur.getType() == DagTag.dtPSingleton || cur.getType() == DagTag.dtNSingleton);
        this.stats.getnSingletonCalls().inc();
        assert (this.hasNominals());
        this.encounterNominal = true;
        Individual C = (Individual)cur.getConcept();
        assert (C.getNode() != null);
        DepSet dep = DepSet.create(this.curConceptDepSet);
        if (C.isNonClassifiable()) {
            return true;
        }
        DlCompletionTree realNode = C.getNode().resolvePBlocker(dep);
        if (!realNode.equals(this.curNode)) {
            return this.merge(this.curNode, realNode, dep);
        }
        return this.commonTacticBodyId(cur);
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyAnd")
    private boolean commonTacticBodyAnd(DLVertex cur) {
        int[] begin;
        assert (this.curConceptConcept > 0 && cur.getType() == DagTag.dtAnd);
        this.stats.getnAndCalls().inc();
        for (int q : begin = cur.begin()) {
            if (!this.addToDoEntry(this.curNode, q, this.curConceptDepSet, null)) continue;
            return true;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyOr")
    private boolean commonTacticBodyOr(DLVertex cur) {
        assert (this.curConceptConcept < 0 && cur.getType() == DagTag.dtAnd);
        this.stats.getnOrCalls().inc();
        if (this.isFirstBranchCall()) {
            Reference<DepSet> dep = new Reference<DepSet>(DepSet.create());
            if (this.planOrProcessing(cur, dep)) {
                this.options.getLog().printTemplate(Templates.COMMON_TACTIC_BODY_OR, this.orConceptsToTest.get(this.orConceptsToTest.size() - 1));
                return false;
            }
            if (this.orConceptsToTest.isEmpty()) {
                this.setClashSet(dep.getReference());
                return true;
            }
            if (this.orConceptsToTest.size() == 1) {
                ConceptWDep C = this.orConceptsToTest.get(0);
                return this.insertToDoEntry(this.curNode, C.getConcept(), dep.getReference(), this.dlHeap.get(C.getConcept()).getType(), "bcp");
            }
            this.createBCOr();
            this.bContext.branchDep = DepSet.create(dep.getReference());
            this.orConceptsToTest = ((BCOr)this.bContext).setApplicableOrEntries(this.orConceptsToTest);
        }
        return this.processOrEntry();
    }

    @PortedFrom(file="Reasoner.h", name="planOrProcessing")
    private boolean planOrProcessing(DLVertex cur, Reference<DepSet> dep) {
        this.orConceptsToTest.clear();
        dep.setReference(DepSet.create(this.curConceptDepSet));
        CGLabel lab = this.curNode.label();
        block5: for (int q : cur.begin()) {
            int inverse = -q;
            switch (this.tryAddConcept(lab.getLabel(this.dlHeap.get(inverse).getType()), inverse, null)) {
                case acrClash: {
                    dep.getReference().add(this.clashSet);
                    continue block5;
                }
                case acrExist: {
                    this.orConceptsToTest.clear();
                    this.orConceptsToTest.add(new ConceptWDep(-q));
                    return true;
                }
                case acrDone: {
                    this.orConceptsToTest.add(new ConceptWDep(-q));
                    continue block5;
                }
                default: {
                    throw new UnreachableSituationException();
                }
            }
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="processOrEntry")
    private boolean processOrEntry() {
        DepSet dep;
        BCOr bcOr = (BCOr)this.bContext;
        String reason = null;
        if (bcOr.isLastOrEntry()) {
            this.prepareBranchDep();
            dep = this.getBranchDep();
            this.determiniseBranchingOp();
            reason = "bcp";
        } else {
            this.save();
            dep = this.getCurDepSet();
            this.stats.getnOrBrCalls().inc();
        }
        if (this.options.getuseSemanticBranching()) {
            for (int i : bcOr.getApplicableOrEntriesConcepts()) {
                if (!this.addToDoEntry(this.curNode, -i, dep, "sb")) continue;
                return true;
            }
        }
        if (this.options.isRKG_USE_DYNAMIC_BACKJUMPING()) {
            return this.addToDoEntry(this.curNode, bcOr.orCur().getConcept(), dep, reason);
        }
        return this.insertToDoEntry(this.curNode, bcOr.orCur().getConcept(), dep, this.dlHeap.get(bcOr.orCur().getConcept()).getType(), reason);
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyAllComplex")
    private boolean commonTacticBodyAllComplex(DLVertex cur) {
        RATransition q;
        int i;
        List<Serializable> list;
        int state = cur.getState();
        int C = this.curConceptConcept - state;
        RAStateTransitions RST = cur.getRole().getAutomaton().getBase().get(state);
        if (RST.hasEmptyTransition()) {
            list = RST.begin();
            for (i = 0; i < list.size(); ++i) {
                q = list.get(i);
                this.stats.getnAutoEmptyLookups().inc();
                if (!q.isEmpty() || !this.addToDoEntry(this.curNode, C + q.final_state(), this.curConceptDepSet, "e")) continue;
                return true;
            }
        }
        if (RST.hasTopTransition()) {
            list = RST.begin();
            for (i = 0; i < list.size(); ++i) {
                q = list.get(i);
                if (!q.isTop() || !this.addSessionGCI(C + q.final_state(), this.curConceptDepSet)) continue;
                return true;
            }
        }
        if (state == 1 && this.addToDoEntry(this.curNode, cur.getConceptIndex(), this.curConceptDepSet, null)) {
            return true;
        }
        this.stats.getnAllCalls().inc();
        list = this.curNode.getNeighbour();
        for (i = 0; i < list.size(); ++i) {
            DlCompletionTreeArc p = (DlCompletionTreeArc)list.get(i);
            if (!RST.recognise(p.getRole()) || !this.applyTransitions(p, RST, C, DepSet.plus(this.curConceptDepSet, p.getDep()), null)) continue;
            return true;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyAllSimple")
    private boolean commonTacticBodyAllSimple(DLVertex cur) {
        RAStateTransitions RST = cur.getRole().getAutomaton().getBase().get(0);
        int C = cur.getConceptIndex();
        this.stats.getnAllCalls().inc();
        List<DlCompletionTreeArc> neighbour = this.curNode.getNeighbour();
        int size = neighbour.size();
        for (int i = 0; i < size; ++i) {
            DlCompletionTreeArc p = neighbour.get(i);
            if (!RST.recognise(p.getRole()) || !this.addToDoEntry(p.getArcEnd(), C, DepSet.plus(this.curConceptDepSet, p.getDep()), null)) continue;
            return true;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="applyTransitions")
    private boolean applyTransitions(DlCompletionTreeArc edge, RAStateTransitions RST, int C, DepSet dep, String reason) {
        Role R = edge.getRole();
        DlCompletionTree node = edge.getArcEnd();
        if (RST.isSingleton()) {
            return this.addToDoEntry(node, C + RST.getTransitionEnd(), dep, reason);
        }
        List<RATransition> begin = RST.begin();
        int size = begin.size();
        for (int i = 0; i < size; ++i) {
            RATransition q = begin.get(i);
            this.stats.getnAutoTransLookups().inc();
            if (!q.applicable(R) || !this.addToDoEntry(node, C + q.final_state(), dep, reason)) continue;
            return true;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="applyUniversalNR")
    private boolean applyUniversalNR(DlCompletionTree Node2, DlCompletionTreeArc arcSample, DepSet dep_, int flags) {
        if (flags == 0) {
            return false;
        }
        Role R = arcSample.getRole();
        DepSet dep = DepSet.plus(dep_, arcSample.getDep());
        List<ConceptWDep> base = Node2.beginl_cc();
        int size = base.size();
        block5: for (int i = 0; i < size; ++i) {
            ConceptWDep p = base.get(i);
            if (p.getConcept() < 0) continue;
            DLVertex v = this.dlHeap.get(p.getConcept());
            Role vR = v.getRole();
            switch (v.getType()) {
                case dtIrr: {
                    if ((flags & Redo.redoIrr.getValue()) <= 0 || !this.checkIrreflexivity(arcSample, vR, dep)) continue block5;
                    return true;
                }
                case dtForall: {
                    RAStateTransitions RST;
                    if ((flags & Redo.redoForall.getValue()) == 0 || vR.isTop() || !(RST = vR.getAutomaton().getBase().get(v.getState())).recognise(R) || !(vR.isSimple() ? this.addToDoEntry(arcSample.getArcEnd(), v.getConceptIndex(), DepSet.plus(dep, p.getDep()), "ae") : this.applyTransitions(arcSample, RST, p.getConcept() - v.getState(), DepSet.plus(dep, p.getDep()), "ae"))) continue block5;
                    return true;
                }
                case dtLE: {
                    if (DlSatTester.isFunctionalVertex(v)) {
                        if ((flags & Redo.redoFunc.getValue()) <= 0 || !R.lesserequal(vR)) continue block5;
                        this.addExistingToDoEntry(Node2, p, "f");
                        continue block5;
                    }
                    if ((flags & Redo.redoAtMost.getValue()) <= 0 || !R.lesserequal(vR)) continue block5;
                    this.addExistingToDoEntry(Node2, p, "le");
                    continue block5;
                }
            }
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodySome")
    private boolean commonTacticBodySome(DLVertex cur) {
        DLVertex nom;
        Role R = cur.getRole();
        int C = -cur.getConceptIndex();
        if (R.isTop()) {
            return this.commonTacticBodySomeUniv(cur);
        }
        if (this.isSomeExists(R, C)) {
            return false;
        }
        if (C < 0 && this.dlHeap.get(C).getType() == DagTag.dtAnd) {
            for (int q : this.dlHeap.get(C).begin()) {
                if (!this.isSomeExists(R, -q)) continue;
                return false;
            }
        }
        if (C > 0 && this.tBox.testHasNominals() && ((nom = this.dlHeap.get(C)).getType() == DagTag.dtPSingleton || nom.getType() == DagTag.dtNSingleton)) {
            return this.commonTacticBodyValue(R, (Individual)nom.getConcept());
        }
        this.stats.getnSomeCalls().inc();
        if (R.isFunctional()) {
            List<Role> list = R.begin_topfunc();
            block6: for (int i = 0; i < list.size(); ++i) {
                int functional = list.get(i).getFunctional();
                switch (this.tryAddConcept(this.curNode.label().getLabel(DagTag.dtLE), functional, this.curConceptDepSet)) {
                    case acrClash: {
                        return true;
                    }
                    case acrDone: {
                        this.updateLevel(this.curNode, this.curConceptDepSet);
                        ConceptWDep rFuncRestriction1 = new ConceptWDep(functional, this.curConceptDepSet);
                        this.cGraph.addConceptToNode(this.curNode, rFuncRestriction1, DagTag.dtLE);
                        this.used.add(rFuncRestriction1.getConcept());
                        this.options.getLog().printTemplate(Templates.COMMON_TACTIC_BODY_SOME, rFuncRestriction1);
                        continue block6;
                    }
                    case acrExist: {
                        continue block6;
                    }
                    default: {
                        throw new UnreachableSituationException();
                    }
                }
            }
        }
        boolean rFunc = false;
        Role RF = R;
        ConceptWDep rFuncRestriction = null;
        List<ConceptWDep> list = this.curNode.beginl_cc();
        for (int i = 0; i < list.size(); ++i) {
            ConceptWDep LC = list.get(i);
            DLVertex ver = this.dlHeap.get(LC.getConcept());
            if (LC.getConcept() <= 0 || !DlSatTester.isFunctionalVertex(ver) || !R.lesserequal(ver.getRole()) || rFunc && !RF.lesserequal(ver.getRole())) continue;
            rFunc = true;
            RF = ver.getRole();
            rFuncRestriction = LC;
        }
        if (rFunc) {
            DlCompletionTreeArc functionalArc = null;
            DepSet newDep = DepSet.create();
            for (int i = 0; i < this.curNode.getNeighbour().size() && functionalArc == null; ++i) {
                DlCompletionTreeArc pr = this.curNode.getNeighbour().get(i);
                if (!pr.isNeighbour(RF, newDep)) continue;
                functionalArc = pr;
            }
            if (functionalArc != null) {
                this.options.getLog().printTemplate(Templates.COMMON_TACTIC_BODY_SOME2, rFuncRestriction);
                DlCompletionTree succ = functionalArc.getArcEnd();
                newDep.add(this.curConceptDepSet);
                if (R.isDisjoint() && this.checkDisjointRoleClash(this.curNode, succ, R, newDep)) {
                    return true;
                }
                functionalArc = this.cGraph.addRoleLabel(this.curNode, succ, functionalArc.isPredEdge(), R, newDep);
                if (this.addToDoEntry(succ, C, newDep, null)) {
                    return true;
                }
                if (!RF.equals(R)) {
                    if (this.initHeadOfNewEdge(this.curNode, R, newDep, "RD")) {
                        return true;
                    }
                    if (this.initHeadOfNewEdge(succ, R.inverse(), newDep, "RR")) {
                        return true;
                    }
                    if (this.applyUniversalNR(this.curNode, functionalArc, newDep, Redo.redoForall.getValue() | Redo.redoFunc.getValue())) {
                        return true;
                    }
                    if (this.applyUniversalNR(succ, functionalArc.getReverse(), newDep, Redo.redoForall.getValue() | Redo.redoFunc.getValue() | Redo.redoAtMost.getValue())) {
                        return true;
                    }
                }
                return false;
            }
        }
        return this.createNewEdge(cur.getRole(), C, Redo.redoForall.getValue() | Redo.redoAtMost.getValue());
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyValue")
    private boolean commonTacticBodyValue(Role R, Individual nom) {
        DepSet dep = DepSet.create(this.curConceptDepSet);
        if (this.isCurNodeBlocked()) {
            return false;
        }
        this.stats.getnSomeCalls().inc();
        assert (nom.getNode() != null);
        DlCompletionTree realNode = nom.getNode().resolvePBlocker(dep);
        if (R.isDisjoint() && this.checkDisjointRoleClash(this.curNode, realNode, R, dep)) {
            return true;
        }
        this.encounterNominal = true;
        DlCompletionTreeArc edge = this.cGraph.addRoleLabel(this.curNode, realNode, false, R, dep);
        return this.setupEdge(edge, dep, Redo.redoForall.getValue() | Redo.redoFunc.getValue() | Redo.redoAtMost.getValue() | Redo.redoIrr.getValue());
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodySomeUniv")
    private boolean commonTacticBodySomeUniv(DLVertex cur) {
        DlCompletionTree node;
        if (this.isCurNodeBlocked()) {
            return false;
        }
        this.stats.getnSomeCalls().inc();
        int C = -cur.getConceptIndex();
        int i = 0;
        while ((node = this.cGraph.getNode(i++)) != null) {
            if (!this.isObjectNodeUnblocked(node) || !node.label().contains(C)) continue;
            return false;
        }
        node = this.cGraph.getNewNode();
        return this.initNewNode(node, this.curConceptDepSet, C);
    }

    @PortedFrom(file="Reasoner.h", name="createNewEdge")
    private boolean createNewEdge(Role R, int C, int flags) {
        if (this.isCurNodeBlocked()) {
            this.stats.getnUseless().inc();
            return false;
        }
        DlCompletionTreeArc pA = this.createOneNeighbour(R, this.curConceptDepSet);
        return this.initNewNode(pA.getArcEnd(), this.curConceptDepSet, C) || this.setupEdge(pA, this.curConceptDepSet, flags);
    }

    @PortedFrom(file="Reasoner.h", name="createOneNeighbour")
    private DlCompletionTreeArc createOneNeighbour(Role R, DepSet dep) {
        return this.createOneNeighbour(R, dep, Integer.MAX_VALUE);
    }

    @PortedFrom(file="Reasoner.h", name="createOneNeighbour")
    private DlCompletionTreeArc createOneNeighbour(Role R, DepSet dep, int level) {
        boolean forNN = level != Integer.MAX_VALUE;
        DlCompletionTreeArc pA = this.cGraph.createNeighbour(this.curNode, forNN, R, dep);
        DlCompletionTree node = pA.getArcEnd();
        if (forNN) {
            node.setNominalLevel(level);
        }
        if (R.isDataRole()) {
            node.setDataNode();
        }
        this.options.getLog().printTemplate(R.isDataRole() ? Templates.DN : Templates.CN, node.getId(), dep);
        return pA;
    }

    @PortedFrom(file="Reasoner.h", name="isCurNodeBlocked")
    private boolean isCurNodeBlocked() {
        if (!this.options.getuseLazyBlocking()) {
            return this.curNode.isBlocked();
        }
        if (!this.curNode.isBlocked() && this.curNode.isAffected()) {
            this.updateLevel(this.curNode, this.curConceptDepSet);
            this.cGraph.detectBlockedStatus(this.curNode);
        }
        return this.curNode.isBlocked();
    }

    @PortedFrom(file="Reasoner.h", name="applyAllGeneratingRules")
    private void applyAllGeneratingRules(DlCompletionTree node) {
        List<ConceptWDep> base = node.label().get_cc();
        for (int i = 0; i < base.size(); ++i) {
            DLVertex v;
            ConceptWDep p = base.get(i);
            if (p.getConcept() > 0 || (v = this.dlHeap.get(p.getConcept())).getType() != DagTag.dtLE && v.getType() != DagTag.dtForall) continue;
            this.addExistingToDoEntry(node, p, "ubd");
        }
    }

    @PortedFrom(file="Reasoner.h", name="setupEdge")
    public boolean setupEdge(DlCompletionTreeArc pA, DepSet dep, int flags) {
        DlCompletionTree child = pA.getArcEnd();
        DlCompletionTree from = pA.getReverse().getArcEnd();
        if (this.initHeadOfNewEdge(from, pA.getRole(), dep, "RD")) {
            return true;
        }
        if (this.initHeadOfNewEdge(child, pA.getReverse().getRole(), dep, "RR")) {
            return true;
        }
        if (this.applyUniversalNR(from, pA, dep, flags)) {
            return true;
        }
        if (pA.isPredEdge() || child.isNominalNode() || child.equals(from)) {
            if (this.applyUniversalNR(child, pA.getReverse(), dep, flags)) {
                return true;
            }
        } else if (child.isDataNode()) {
            this.checkDataNode = true;
            if (this.hasDataClash(child)) {
                return true;
            }
        } else if (this.tryCacheNode(child).usageByState()) {
            return true;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="initHeadOfNewEdge")
    private boolean initHeadOfNewEdge(DlCompletionTree node, Role R, DepSet dep, String reason) {
        if (R.isFunctional()) {
            List<Role> begin_topfunc = R.begin_topfunc();
            int size = begin_topfunc.size();
            for (int i = 0; i < size; ++i) {
                if (!this.addToDoEntry(node, begin_topfunc.get(i).getFunctional(), dep, "fr")) continue;
                return true;
            }
        }
        if (this.addToDoEntry(node, R.getBPDomain(), dep, reason)) {
            return true;
        }
        if (!this.options.isRKG_UPDATE_RND_FROM_SUPERROLES()) {
            List<Role> list = R.getAncestor();
            for (int i = 0; i < list.size(); ++i) {
                Role q = list.get(i);
                if (!this.addToDoEntry(node, q.getBPDomain(), dep, reason)) continue;
                return true;
            }
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyFunc")
    private boolean commonTacticBodyFunc(DLVertex cur) {
        assert (this.curConceptConcept > 0 && DlSatTester.isFunctionalVertex(cur));
        if (cur.getRole().isTop()) {
            return this.processTopRoleFunc(cur);
        }
        if (this.isNNApplicable(cur.getRole(), 1, this.curConceptConcept + 1)) {
            return this.commonTacticBodyNN(cur);
        }
        this.stats.getnFuncCalls().inc();
        if (this.isQuickClashLE(cur)) {
            return true;
        }
        this.findNeighbours(cur.getRole(), 1, null);
        if (this.EdgesToMerge.size() < 2) {
            return false;
        }
        DlCompletionTreeArc q = this.EdgesToMerge.get(0);
        DlCompletionTree sample = q.getArcEnd();
        DepSet depF = DepSet.create(this.curConceptDepSet);
        depF.add(q.getDep());
        for (int i = 1; i < this.EdgesToMerge.size(); ++i) {
            q = this.EdgesToMerge.get(i);
            if (q.getArcEnd().isPBlocked() || !this.merge(q.getArcEnd(), sample, DepSet.plus(depF, q.getDep()))) continue;
            return true;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyLE")
    private boolean commonTacticBodyLE(DLVertex cur) {
        assert (this.curConceptConcept > 0 && cur.getType() == DagTag.dtLE);
        this.stats.getnLeCalls().inc();
        Role R = cur.getRole();
        if (R.isTop()) {
            return this.processTopRoleLE(cur);
        }
        int C = cur.getConceptIndex();
        boolean needInit = true;
        if (!this.isFirstBranchCall()) {
            if (this.bContext instanceof BCNN) {
                return this.commonTacticBodyNN(cur);
            }
            if (this.bContext instanceof BCLE) {
                needInit = false;
            } else assert (this.bContext instanceof BCChoose);
        } else if (this.isQuickClashLE(cur)) {
            return true;
        }
        if (needInit) {
            if (C != 1 && this.commonTacticBodyChoose(R, C)) {
                return true;
            }
            if (this.isNNApplicable(R, C, this.curConceptConcept + cur.getNumberLE())) {
                return this.commonTacticBodyNN(cur);
            }
        }
        while (true) {
            Reference<DepSet> dep;
            DlCompletionTree to;
            if (this.isFirstBranchCall() && this.initLEProcessing(cur)) {
                return false;
            }
            BCLE bcLE = (BCLE)this.bContext;
            if (bcLE.noMoreLEOptions()) {
                this.useBranchDep();
                return true;
            }
            DlCompletionTreeArc fromArc = (DlCompletionTreeArc)bcLE.getFrom();
            DlCompletionTreeArc toArc = (DlCompletionTreeArc)bcLE.getTo();
            DlCompletionTree from = fromArc.getArcEnd();
            if (this.cGraph.nonMergable(from, to = toArc.getArcEnd(), dep = new Reference<DepSet>(DepSet.create()))) {
                dep.getReference().add(fromArc.getDep());
                dep.getReference().add(toArc.getDep());
                if (C == 1) {
                    this.setClashSet(dep.getReference());
                } else {
                    DagTag tag = this.dlHeap.get(C).getType();
                    boolean test = this.findConceptClash(from.label().getLabel(tag), C, dep.getReference());
                    assert (test);
                    dep.getReference().add(this.clashSet);
                    test = this.findConceptClash(to.label().getLabel(tag), C, dep.getReference());
                    assert (test);
                }
                this.updateBranchDep();
                this.bContext.nextOption();
                assert (!this.isFirstBranchCall());
                continue;
            }
            this.save();
            DepSet curDep = DepSet.create(this.getCurDepSet());
            curDep.add(fromArc.getDep());
            if (this.merge(from, to, curDep)) {
                return true;
            }
            if (C != 1 && this.commonTacticBodyChoose(R, C)) break;
        }
        return true;
    }

    @PortedFrom(file="Reasoner.h", name="initLEProcessing")
    private boolean initLEProcessing(DLVertex cur) {
        DepSet dep = DepSet.create();
        this.findNeighbours(cur.getRole(), cur.getConceptIndex(), dep);
        if (this.EdgesToMerge.size() <= cur.getNumberLE()) {
            return true;
        }
        this.createBCLE();
        this.bContext.branchDep.add(dep);
        BCLE bcLE = (BCLE)this.bContext;
        this.EdgesToMerge = bcLE.swap(this.EdgesToMerge);
        bcLE.resetMCI();
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyGE")
    private boolean commonTacticBodyGE(DLVertex cur) {
        assert (this.curConceptConcept < 0 && cur.getType() == DagTag.dtLE);
        if (this.isCurNodeBlocked()) {
            return false;
        }
        Role R = cur.getRole();
        if (R.isTop()) {
            return this.processTopRoleGE(cur);
        }
        this.stats.getnGeCalls().inc();
        if (this.isQuickClashGE(cur)) {
            return true;
        }
        return this.createDifferentNeighbours(cur.getRole(), cur.getConceptIndex(), this.curConceptDepSet, cur.getNumberGE(), Integer.MAX_VALUE);
    }

    @PortedFrom(file="Reasoner.h", name="processTopRoleFunc")
    private boolean processTopRoleFunc(DLVertex cur) {
        assert (this.curConceptConcept > 0 && DlSatTester.isFunctionalVertex(cur));
        this.stats.getnFuncCalls().inc();
        if (this.isQuickClashLE(cur)) {
            return true;
        }
        DepSet dummy = DepSet.create();
        this.findCLabelledNodes(1, dummy);
        if (this.NodesToMerge.size() < 2) {
            return false;
        }
        DlCompletionTree sample = this.NodesToMerge.get(0);
        DepSet dep = DepSet.create(this.curConceptDepSet);
        for (int i = 0; i < this.NodesToMerge.size(); ++i) {
            if (this.NodesToMerge.get(i).isPBlocked() || !this.merge(this.NodesToMerge.get(i), sample, dep)) continue;
            return true;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="processTopRoleLE")
    private boolean processTopRoleLE(DLVertex cur) {
        assert (this.curConceptConcept > 0 && cur.getType() == DagTag.dtLE);
        int C = cur.getConceptIndex();
        boolean needInit = true;
        if (!this.isFirstBranchCall()) {
            if (this.bContext instanceof BCLE) {
                needInit = false;
            } else assert (this.bContext instanceof BCChoose);
        } else if (this.isQuickClashLE(cur)) {
            return true;
        }
        if (needInit && C != 1 && this.applyChooseRuleGlobally(C)) {
            return true;
        }
        while (true) {
            Reference<DepSet> dep;
            DlCompletionTree to;
            if (this.isFirstBranchCall() && this.initTopLEProcessing(cur)) {
                return false;
            }
            BCLE bcLE = (BCLE)this.bContext;
            if (bcLE.noMoreLEOptions()) {
                this.useBranchDep();
                return true;
            }
            DlCompletionTree from = (DlCompletionTree)bcLE.getFrom();
            if (this.cGraph.nonMergable(from, to = (DlCompletionTree)bcLE.getTo(), dep = new Reference<DepSet>(DepSet.create()))) {
                if (C == 1) {
                    this.setClashSet(dep.getReference());
                } else {
                    DagTag tag = this.dlHeap.get(C).getType();
                    boolean test = this.findConceptClash(from.label().getLabel(tag), C, dep.getReference());
                    assert (test);
                    dep.getReference().add(this.clashSet);
                    test = this.findConceptClash(to.label().getLabel(tag), C, dep.getReference());
                    assert (test);
                }
                this.updateBranchDep();
                this.bContext.nextOption();
                assert (!this.isFirstBranchCall());
                continue;
            }
            this.save();
            DepSet curDep = DepSet.create(this.getCurDepSet());
            if (this.merge(from, to, curDep)) break;
        }
        return true;
    }

    @PortedFrom(file="Reasoner.h", name="processTopRoleGE")
    private boolean processTopRoleGE(DLVertex cur) {
        assert (this.curConceptConcept < 0 && cur.getType() == DagTag.dtLE);
        assert (!this.isCurNodeBlocked());
        this.stats.getnGeCalls().inc();
        if (this.isQuickClashGE(cur)) {
            return true;
        }
        return this.createDifferentNeighbours(cur.getRole(), cur.getConceptIndex(), this.curConceptDepSet, cur.getNumberGE(), Integer.MAX_VALUE);
    }

    @PortedFrom(file="Reasoner.h", name="initTopLEProcessing")
    private boolean initTopLEProcessing(DLVertex cur) {
        DepSet dep = DepSet.create();
        this.findCLabelledNodes(cur.getConceptIndex(), dep);
        if (this.NodesToMerge.size() <= cur.getNumberLE()) {
            return true;
        }
        this.createBCTopLE();
        this.bContext.branchDep.add(dep);
        BCLE bcLE = (BCLE)this.bContext;
        this.NodesToMerge = bcLE.swap(this.NodesToMerge);
        bcLE.resetMCI();
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="createDifferentNeighbours")
    private boolean createDifferentNeighbours(Role R, int C, DepSet dep, int n, int level) {
        DlCompletionTreeArc pA = null;
        this.cGraph.initIR();
        for (int i = 0; i < n; ++i) {
            pA = this.createOneNeighbour(R, dep, level);
            DlCompletionTree child = pA.getArcEnd();
            this.cGraph.setCurIR(child, dep);
            if (this.initNewNode(child, dep, C)) {
                return true;
            }
            if (!this.setupEdge(pA, dep, Redo.redoForall.getValue())) continue;
            return true;
        }
        this.cGraph.finiIR();
        return this.applyUniversalNR(this.curNode, pA, dep, Redo.redoFunc.getValue() | Redo.redoAtMost.getValue());
    }

    @PortedFrom(file="Reasoner.h", name="isNRClash")
    private boolean isNRClash(DLVertex atleast, DLVertex atmost, ConceptWDep reason) {
        if (atmost.getType() != DagTag.dtLE || atleast.getType() != DagTag.dtLE) {
            return false;
        }
        if (!this.checkNRclash(atleast, atmost)) {
            return false;
        }
        this.setClashSet(DepSet.plus(this.curConceptDepSet, reason.getDep()));
        this.logNCEntry(this.curNode, reason.getConcept(), reason.getDep(), "x", this.dlHeap.get(reason.getConcept()).getType().getName());
        return true;
    }

    @PortedFrom(file="Reasoner.h", name="checkMergeClash")
    private boolean checkMergeClash(CGLabel from, CGLabel to, DepSet dep, int nodeId) {
        DepSet clashDep = DepSet.create(dep);
        boolean clash = false;
        List<ConceptWDep> list = from.get_sc();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ConceptWDep p = list.get(i);
            int inverse = -p.getConcept();
            if (!this.used.contains(inverse) || !this.findConceptClash(to.getLabel(DagTag.dtPConcept), inverse, p.getDep())) continue;
            clash = true;
            clashDep.add(this.clashSet);
            this.options.getLog().printTemplate(Templates.CHECK_MERGE_CLASH, nodeId, p.getConcept(), DepSet.plus(this.clashSet, dep));
        }
        list = from.get_cc();
        int ccsize = list.size();
        for (int i = 0; i < ccsize; ++i) {
            ConceptWDep p = list.get(i);
            int inverse = -p.getConcept();
            if (!this.used.contains(inverse) || !this.findConceptClash(to.getLabel(DagTag.dtForall), inverse, p.getDep())) continue;
            clash = true;
            clashDep.add(this.clashSet);
            this.options.getLog().printTemplate(Templates.CHECK_MERGE_CLASH, nodeId, p.getConcept(), DepSet.plus(this.clashSet, dep));
        }
        if (clash) {
            this.setClashSet(clashDep);
        }
        return clash;
    }

    @PortedFrom(file="Reasoner.h", name="mergeLabels")
    private boolean mergeLabels(CGLabel from, DlCompletionTree to, DepSet dep) {
        int index;
        int bp;
        ConceptWDep p;
        int i;
        CGLabel lab = to.label();
        CWDArray sc = lab.getLabel(DagTag.dtPConcept);
        CWDArray cc = lab.getLabel(DagTag.dtForall);
        if (!dep.isEmpty()) {
            this.cGraph.saveRareCond(sc.updateDepSet(dep));
            this.cGraph.saveRareCond(cc.updateDepSet(dep));
        }
        List<ConceptWDep> list = from.get_sc();
        for (i = 0; i < list.size(); ++i) {
            p = list.get(i);
            bp = p.getConcept();
            this.stats.getnLookups().inc();
            index = sc.index(bp);
            if (index > -1) {
                if (p.getDep().isEmpty()) continue;
                this.cGraph.saveRareCond(sc.updateDepSet(index, p.getDep()));
                continue;
            }
            if (!this.insertToDoEntry(to, bp, DepSet.plus(dep, p.getDep()), this.dlHeap.get(bp).getType(), "M")) continue;
            return true;
        }
        list = from.get_cc();
        for (i = 0; i < list.size(); ++i) {
            p = list.get(i);
            bp = p.getConcept();
            this.stats.getnLookups().inc();
            index = cc.index(bp);
            if (index > -1) {
                if (p.getDep().isEmpty()) continue;
                this.cGraph.saveRareCond(cc.updateDepSet(index, p.getDep()));
                continue;
            }
            if (!this.insertToDoEntry(to, bp, DepSet.plus(dep, p.getDep()), this.dlHeap.get(bp).getType(), "M")) continue;
            return true;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="merge")
    private boolean merge(DlCompletionTree from, DlCompletionTree to, DepSet depF) {
        assert (!from.isPBlocked());
        assert (!from.equals(to));
        assert (to.getNominalLevel() <= from.getNominalLevel());
        this.options.getLog().printTemplate(Templates.MERGE, from.getId(), to.getId());
        this.stats.getnMergeCalls().inc();
        DepSet dep = DepSet.create(depF);
        Reference<DepSet> ref = new Reference<DepSet>(dep);
        if (this.cGraph.nonMergable(from, to, ref)) {
            this.setClashSet(ref.getReference());
            return true;
        }
        if (this.checkMergeClash(from.label(), to.label(), depF, to.getId())) {
            return true;
        }
        if (this.mergeLabels(from.label(), to, depF)) {
            return true;
        }
        ArrayList<DlCompletionTreeArc> edges = new ArrayList<DlCompletionTreeArc>();
        this.cGraph.merge(from, to, depF, edges);
        int size = edges.size();
        for (int i = 0; i < size; ++i) {
            DlCompletionTreeArc q = (DlCompletionTreeArc)edges.get(i);
            if (!q.getRole().isDisjoint() || !this.checkDisjointRoleClash(q.getReverse().getArcEnd(), q.getArcEnd(), q.getRole(), depF)) continue;
            return true;
        }
        if (to.isDataNode()) {
            return this.hasDataClash(to);
        }
        for (DlCompletionTreeArc q : edges) {
            if (!this.applyUniversalNR(to, q, depF, Redo.redoForall.getValue() | Redo.redoFunc.getValue() | Redo.redoAtMost.getValue() | Redo.redoIrr.getValue())) continue;
            return true;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="checkDisjointRoleClash")
    protected boolean checkDisjointRoleClash(DlCompletionTree from, DlCompletionTree to, Role R, DepSet dep) {
        for (DlCompletionTreeArc p : from.getNeighbour()) {
            if (!this.checkDisjointRoleClash(p, to, R, dep)) continue;
            return true;
        }
        return false;
    }

    @PortedFrom(file="Tactic.cpp", name="isNewEdge")
    private boolean isNewEdge(DlCompletionTree node, List<DlCompletionTreeArc> e) {
        int size = e.size();
        for (int i = 0; i < size; ++i) {
            if (!e.get(i).getArcEnd().equals(node)) continue;
            return false;
        }
        return true;
    }

    @PortedFrom(file="Reasoner.h", name="findNeighbours")
    private void findNeighbours(Role Role2, int c, DepSet Dep) {
        this.EdgesToMerge.clear();
        DagTag tag = this.dlHeap.get(c).getType();
        List<DlCompletionTreeArc> neighbour = this.curNode.getNeighbour();
        int size = neighbour.size();
        for (int i = 0; i < size; ++i) {
            DlCompletionTreeArc p = neighbour.get(i);
            if (!p.isNeighbour(Role2) || !this.isNewEdge(p.getArcEnd(), this.EdgesToMerge) || !this.findChooseRuleConcept(p.getArcEnd().label().getLabel(tag), c, Dep)) continue;
            this.EdgesToMerge.add(p);
        }
        Collections.sort(this.EdgesToMerge, new EdgeCompare());
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyChoose")
    private boolean commonTacticBodyChoose(Role R, int C) {
        List<DlCompletionTreeArc> neighbour = this.curNode.getNeighbour();
        int size = neighbour.size();
        for (int i = 0; i < size; ++i) {
            DlCompletionTreeArc p = neighbour.get(i);
            if (!p.isNeighbour(R) || !this.applyChooseRule(p.getArcEnd(), C)) continue;
            return true;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="applyChooseRule")
    private boolean applyChooseRule(DlCompletionTree node, int C) {
        if (node.isLabelledBy(C) || node.isLabelledBy(-C)) {
            return false;
        }
        if (this.isFirstBranchCall()) {
            this.createBCCh();
            this.save();
            return this.addToDoEntry(node, -C, this.getCurDepSet(), "cr0");
        }
        this.prepareBranchDep();
        DepSet dep = DepSet.create(this.getBranchDep());
        this.determiniseBranchingOp();
        return this.addToDoEntry(node, C, dep, "cr1");
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyNN")
    private boolean commonTacticBodyNN(DLVertex cur) {
        BCNN bcNN;
        this.stats.getnNNCalls().inc();
        if (this.isFirstBranchCall()) {
            this.createBCNN();
        }
        if ((bcNN = (BCNN)this.bContext).noMoreNNOptions(cur.getNumberLE())) {
            this.useBranchDep();
            return true;
        }
        int NN = bcNN.getBranchIndex();
        this.save();
        DepSet curDep = this.getCurDepSet();
        if (this.addToDoEntry(this.curNode, this.curConceptConcept + cur.getNumberLE(), DepSet.create(), "NNs")) {
            return true;
        }
        if (this.createDifferentNeighbours(cur.getRole(), cur.getConceptIndex(), curDep, NN, this.curNode.getNominalLevel() + 1)) {
            return true;
        }
        return this.addToDoEntry(this.curNode, this.curConceptConcept + cur.getNumberLE() - NN, curDep, "NN");
    }

    @PortedFrom(file="Reasoner.h", name="isNNApplicable")
    protected boolean isNNApplicable(Role r, int C, int stopper) {
        if (!this.curNode.isNominalNode()) {
            return false;
        }
        if (this.used.contains(stopper) && this.curNode.isLabelledBy(stopper)) {
            return false;
        }
        for (DlCompletionTreeArc p : this.curNode.getNeighbour()) {
            DlCompletionTree suspect = p.getArcEnd();
            if (!p.isPredEdge() || !suspect.isBlockableNode() || !p.isNeighbour(r) || !suspect.isLabelledBy(C)) continue;
            this.options.getLog().print(" NN(").print(suspect.getId()).print(")");
            return true;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodySomeSelf")
    private boolean commonTacticBodySomeSelf(Role R) {
        if (this.isCurNodeBlocked()) {
            return false;
        }
        for (DlCompletionTreeArc p : this.curNode.getNeighbour()) {
            if (!p.getArcEnd().equals(this.curNode) || !p.isNeighbour(R)) continue;
            return false;
        }
        DepSet dep = DepSet.create(this.curConceptDepSet);
        DlCompletionTreeArc pA = this.cGraph.createLoop(this.curNode, R, dep);
        return this.setupEdge(pA, dep, Redo.redoForall.getValue() | Redo.redoFunc.getValue() | Redo.redoAtMost.getValue() | Redo.redoIrr.getValue());
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyIrrefl")
    private boolean commonTacticBodyIrrefl(Role R) {
        for (DlCompletionTreeArc p : this.curNode.getNeighbour()) {
            if (!this.checkIrreflexivity(p, R, this.curConceptDepSet)) continue;
            return true;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodyProj")
    private boolean commonTacticBodyProj(Role R, int C, Role ProjR) {
        if (this.curNode.isLabelledBy(-C)) {
            return false;
        }
        for (int i = 0; i < this.curNode.getNeighbour().size(); ++i) {
            if (!this.curNode.getNeighbour().get(i).isNeighbour(R) || !this.checkProjection(this.curNode.getNeighbour().get(i), C, ProjR)) continue;
            return true;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="checkProjection")
    private boolean checkProjection(DlCompletionTreeArc pA, int C, Role ProjR) {
        if (pA.isNeighbour(ProjR)) {
            return false;
        }
        if (this.curNode.isLabelledBy(-C)) {
            return false;
        }
        DepSet dep = DepSet.create(this.curConceptDepSet);
        dep.add(pA.getDep());
        if (!this.curNode.isLabelledBy(C)) {
            if (this.isFirstBranchCall()) {
                this.createBCCh();
                this.save();
                return this.addToDoEntry(this.curNode, -C, this.getCurDepSet(), "cr0");
            }
            this.prepareBranchDep();
            dep.add(this.getBranchDep());
            this.determiniseBranchingOp();
            if (this.addToDoEntry(this.curNode, C, dep, "cr1")) {
                return true;
            }
        }
        DlCompletionTree child = pA.getArcEnd();
        return this.setupEdge(this.cGraph.addRoleLabel(this.curNode, child, pA.isPredEdge(), ProjR, dep), dep, Redo.redoForall.getValue() | Redo.redoFunc.getValue() | Redo.redoAtMost.getValue() | Redo.redoIrr.getValue());
    }

    @PortedFrom(file="Reasoner.h", name="createBCTopLE")
    public void createBCTopLE() {
        this.bContext = this.stack.pushTopLE();
        this.initBC(this.bContext);
    }

    @PortedFrom(file="Reasoner.h", name="commonTacticBodySplit")
    private boolean commonTacticBodySplit(DLVertex cur) {
        if (this.tBox.isDuringClassification() && !this.ActiveSplits.contains(this.curConceptConcept > 0 ? this.curConceptConcept : -this.curConceptConcept)) {
            return false;
        }
        DepSet dep = this.curConceptDepSet;
        boolean pos = this.curConceptConcept > 0;
        for (int q : cur.begin()) {
            if (!this.addToDoEntry(this.curNode, Helper.createBiPointer(q, pos), dep, null)) continue;
            return true;
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="applyChooseRuleGlobally")
    private boolean applyChooseRuleGlobally(int C) {
        int i = 0;
        DlCompletionTree p = this.cGraph.getNode(i++);
        while (p != null) {
            if (this.isObjectNodeUnblocked(p) && this.applyChooseRule(p, C)) {
                return true;
            }
            p = this.cGraph.getNode(i++);
        }
        return false;
    }

    @PortedFrom(file="Reasoner.h", name="findCLabelledNodes")
    private void findCLabelledNodes(int C, DepSet Dep) {
        this.NodesToMerge.clear();
        DagTag tag = this.dlHeap.get(C).getType();
        int i = 0;
        DlCompletionTree arc = this.cGraph.getNode(i++);
        while (arc != null) {
            if (this.isNodeGloballyUsed(arc) && this.findChooseRuleConcept(arc.label().getLabel(tag), C, Dep)) {
                this.NodesToMerge.add(arc);
            }
            arc = this.cGraph.getNode(i++);
        }
        Collections.sort(this.NodesToMerge, new NodeCompare());
    }

    static class DataCall {
        DagTag d;
        NamedEntry dataEntry;
        boolean positive;
        ConceptWDep r;

        DataCall() {
        }

        public int hashCode() {
            return ((this.positive ? 1 : 2) * 37 + this.d.hashCode()) * 37 + this.dataEntry.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataCall)) {
                return false;
            }
            DataCall o = (DataCall)obj;
            return this.positive == o.positive && this.d.equals((Object)o.d) && this.dataEntry.equals(o.dataEntry);
        }

        public String toString() {
            HasName o = null;
            o = this.dataEntry instanceof DatatypeEntry ? ((DatatypeEntry)this.dataEntry).getDatatype() : (this.dataEntry instanceof LiteralEntry ? ((LiteralEntry)this.dataEntry).getLiteral() : this.dataEntry);
            return this.positive + ", " + (Object)((Object)this.d) + ", \"" + o.toString().replace("\"", "\\\"") + "\", " + this.r.getDep().toString().replace("{", "").replace("}", "");
        }
    }

    class BCOr
    extends BranchingContext {
        private static final long serialVersionUID = 11000L;
        private int branchIndex;
        private int size;
        private List<ConceptWDep> applicableOrEntries;

        BCOr() {
            this.size = 0;
            this.applicableOrEntries = new ArrayList<ConceptWDep>();
        }

        @Override
        public void init() {
            this.branchIndex = 0;
        }

        @Override
        public void nextOption() {
            ++this.branchIndex;
        }

        protected boolean isLastOrEntry() {
            return this.size == this.branchIndex + 1;
        }

        protected ConceptWDep orCur() {
            return this.applicableOrEntries.get(this.branchIndex);
        }

        protected int getBranchIndex() {
            return this.branchIndex;
        }

        protected int[] getApplicableOrEntriesConcepts() {
            int[] toReturn = new int[this.branchIndex];
            for (int i = 0; i < toReturn.length; ++i) {
                toReturn[i] = this.applicableOrEntries.get(i).getConcept();
            }
            return toReturn;
        }

        protected List<ConceptWDep> setApplicableOrEntries(List<ConceptWDep> list) {
            List<ConceptWDep> toReturn = this.applicableOrEntries;
            this.applicableOrEntries = list;
            this.size = this.applicableOrEntries.size();
            return toReturn;
        }

        @Override
        public String toString() {
            StringBuilder o = new StringBuilder();
            o.append("BCOR ");
            o.append(this.branchIndex);
            o.append(" dep ");
            o.append(this.branchDep);
            o.append(" curconcept ");
            o.append(this.concept == null ? new ConceptWDep(0) : this.concept);
            o.append(" curnode ");
            o.append(this.node);
            o.append(" orentries [");
            o.append(this.applicableOrEntries);
            o.append("]");
            return o.toString();
        }
    }

    class BCNN
    extends BranchingContext {
        private static final long serialVersionUID = 11000L;
        private int branchIndex;

        BCNN() {
        }

        @Override
        public void init() {
            this.branchIndex = 1;
        }

        @Override
        public void nextOption() {
            ++this.branchIndex;
        }

        protected boolean noMoreNNOptions(int n) {
            return this.branchIndex > n;
        }

        protected int getBranchIndex() {
            return this.branchIndex;
        }

        public void setBranchIndex(int branchIndex) {
            this.branchIndex = branchIndex;
        }
    }

    class BCLE<I>
    extends BranchingContext {
        private static final long serialVersionUID = 11000L;
        private int branchIndex;
        private int mergeCandIndex;
        private List<I> edges;

        BCLE() {
            this.edges = new ArrayList<I>();
        }

        @Override
        public void init() {
            this.branchIndex = 0;
            this.mergeCandIndex = 0;
        }

        public List<I> swap(List<I> values) {
            List<I> temp = this.edges;
            this.edges = values;
            return temp;
        }

        protected void resetMCI() {
            this.mergeCandIndex = this.edges.size() - 1;
        }

        @Override
        public void nextOption() {
            --this.mergeCandIndex;
            if (this.mergeCandIndex == this.branchIndex) {
                ++this.branchIndex;
                this.resetMCI();
            }
        }

        protected I getFrom() {
            return this.edges.get(this.mergeCandIndex);
        }

        protected I getTo() {
            return this.edges.get(this.branchIndex);
        }

        protected boolean noMoreLEOptions() {
            return this.mergeCandIndex <= this.branchIndex;
        }

        protected List<I> getEdgesToMerge() {
            return this.edges;
        }

        protected void setEdgesToMerge(List<I> edgesToMerge) {
            this.edges = edgesToMerge;
        }
    }

    class BCBarrier
    extends BranchingContext {
        private static final long serialVersionUID = 11000L;

        BCBarrier() {
        }

        @Override
        public void init() {
        }

        @Override
        public void nextOption() {
        }
    }

    class BCStack
    extends SaveStack<BranchingContext> {
        private static final long serialVersionUID = 11000L;
        private final BCBarrier bcBarrier;

        @Override
        public void push(BranchingContext p) {
            p.init();
            DlSatTester.this.initBC(p);
            super.push(p);
        }

        protected BCStack() {
            this.bcBarrier = new BCBarrier();
        }

        protected BranchingContext pushOr() {
            BCOr o = new BCOr();
            this.push(o);
            return o;
        }

        protected BranchingContext pushNN() {
            BCNN n = new BCNN();
            this.push(n);
            return n;
        }

        protected BCLE<DlCompletionTreeArc> pushLE() {
            BCLE<DlCompletionTreeArc> e = new BCLE<DlCompletionTreeArc>();
            this.push(e);
            return e;
        }

        protected BCLE<DlCompletionTree> pushTopLE() {
            BCLE<DlCompletionTree> e = new BCLE<DlCompletionTree>();
            this.push(e);
            return e;
        }

        protected BCChoose pushCh() {
            BCChoose c = new BCChoose(){
                private static final long serialVersionUID = 11000L;

                @Override
                public void nextOption() {
                }

                @Override
                public void init() {
                }
            };
            this.push(c);
            return c;
        }

        protected BCBarrier pushBarrier() {
            this.push(this.bcBarrier);
            return this.bcBarrier;
        }
    }

    abstract class BCChoose
    extends BranchingContext {
        private static final long serialVersionUID = 11000L;

        BCChoose() {
        }
    }

    abstract class BranchingContext
    implements Serializable {
        private static final long serialVersionUID = 11000L;
        protected DlCompletionTree node = null;
        protected ConceptWDep concept = null;
        protected DepSet branchDep = DepSet.create();
        protected int SGsize;

        public abstract void init();

        public abstract void nextOption();

        public String toString() {
            return this.getClass().getSimpleName() + " dep '" + this.branchDep + "' curconcept '" + (this.concept == null ? new ConceptWDep(0) : this.concept) + "' curnode '" + this.node + "'";
        }
    }

    private class LocalFastSet
    implements FastSet,
    Serializable {
        private static final long serialVersionUID = 11000L;
        private BitSet pos = new BitSet();

        @Override
        public int[] toIntArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeAt(int o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeAllValues(int ... values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeAll(int i, int end) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(int o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean intersect(FastSet f) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int get(int i) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAny(FastSet c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(FastSet c) {
            throw new UnsupportedOperationException();
        }

        private int asPositive(int p) {
            return p >= 0 ? 2 * p : 1 - 2 * p;
        }

        @Override
        public boolean contains(int o) {
            return this.pos.get(this.asPositive(o));
        }

        @Override
        public void clear() {
            this.pos.clear();
        }

        @Override
        public void addAll(FastSet c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int e) {
            this.pos.set(this.asPositive(e));
        }

        @Override
        public void completeSet(int value) {
            for (int i = 0; i <= value; ++i) {
                this.pos.set(i);
            }
        }
    }
}

