/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.manchester.cs.jfact.dep.DepSet;
import uk.ac.manchester.cs.jfact.helpers.ArrayIntMap;
import uk.ac.manchester.cs.jfact.helpers.DLVertex;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.helpers.Reference;
import uk.ac.manchester.cs.jfact.helpers.Templates;
import uk.ac.manchester.cs.jfact.kernel.CGLabel;
import uk.ac.manchester.cs.jfact.kernel.ConceptWDep;
import uk.ac.manchester.cs.jfact.kernel.DLDag;
import uk.ac.manchester.cs.jfact.kernel.DagTag;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTreeArc;
import uk.ac.manchester.cs.jfact.kernel.RAStateTransitions;
import uk.ac.manchester.cs.jfact.kernel.RATransition;
import uk.ac.manchester.cs.jfact.kernel.Restorer;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;
import uk.ac.manchester.cs.jfact.kernel.state.DLCompletionTreeSaveState;
import uk.ac.manchester.cs.jfact.kernel.state.SaveList;

@PortedFrom(file="dlCompletionTree.h", name="DlCompletionTree")
public class DlCompletionTree
implements Comparable<DlCompletionTree>,
Serializable {
    private static final long serialVersionUID = 11000L;
    private final CGLabel label = new CGLabel();
    protected final List<ConceptWDep> inequalityRelation = new ArrayList<ConceptWDep>();
    protected final Map<Integer, ConceptWDep> inequalityRelation_helper = new HashMap<Integer, ConceptWDep>();
    private final List<DlCompletionTreeArc> neighbour = new ArrayList<DlCompletionTreeArc>();
    private int neighbourSize = 0;
    private final SaveList saves = new SaveList();
    private final int id;
    private int init;
    protected DlCompletionTree blocker;
    protected DepSet pDep = DepSet.create();
    protected int curLevel;
    private boolean flagDataNode = false;
    protected boolean cached = true;
    protected boolean pBlocked = true;
    protected boolean dBlocked = true;
    private boolean affected = true;
    private int nominalLevel;
    @Original
    private final JFactReasonerConfiguration options;
    private DlCompletionTree cachedParent = null;
    public static final int BLOCKABLE_LEVEL = Integer.MAX_VALUE;

    private boolean B2(DLVertex v, int C) {
        assert (this.hasParent());
        RAStateTransitions RST = v.getRole().getAutomaton().getBase().get(v.getState());
        if (v.getRole().isSimple()) {
            return this.B2Simple(RST, v.getConceptIndex());
        }
        if (RST.isEmpty()) {
            return true;
        }
        if (RST.isSingleton()) {
            return this.B2Simple(RST, C - v.getState() + RST.getTransitionEnd());
        }
        return this.B2Complex(RST, C - v.getState());
    }

    public boolean canBlockInit(int C) {
        if (C == -1) {
            return false;
        }
        if (C == 1) {
            return true;
        }
        return this.label.contains(C);
    }

    private void logSRNode(String action) {
        this.options.getLog().printTemplate(Templates.LOG_SR_NODE, action, this.id, this.neighbour.size(), this.curLevel);
    }

    private String getBlockingStatusName() {
        return this.isPBlocked() ? "p" : (this.isDBlocked() ? "d" : (this.isIBlocked() ? "i" : "u"));
    }

    private String logNodeBStatus() {
        StringBuilder toReturn = new StringBuilder();
        if (this.blocker != null) {
            toReturn.append(this.getBlockingStatusName()).append(this.blocker.id);
        }
        if (this.isCached()) {
            toReturn.append("c");
        }
        return toReturn.toString();
    }

    public DlCompletionTree(int newId, JFactReasonerConfiguration c) {
        this.id = newId;
        this.options = c;
    }

    public void addNeighbour(DlCompletionTreeArc p) {
        this.neighbour.add(p);
        ++this.neighbourSize;
    }

    public int getId() {
        return this.id;
    }

    public boolean isCached() {
        return this.cached;
    }

    public Restorer setCached(boolean val) {
        if (this.cached == val) {
            return null;
        }
        CacheRestorer ret = new CacheRestorer(this);
        this.cached = val;
        return ret;
    }

    public boolean isDataNode() {
        return this.flagDataNode;
    }

    public void setDataNode() {
        this.flagDataNode = true;
    }

    public boolean isBlockableNode() {
        return this.nominalLevel == Integer.MAX_VALUE;
    }

    public boolean isNominalNode() {
        return this.nominalLevel != Integer.MAX_VALUE;
    }

    public void setNominalLevel() {
        this.setNominalLevel(0);
    }

    public void setNominalLevel(int newLevel) {
        this.nominalLevel = newLevel;
    }

    public int getNominalLevel() {
        return this.nominalLevel;
    }

    public void addConcept(ConceptWDep p, DagTag tag) {
        this.label.add(tag, p);
    }

    public void setInit(int p) {
        this.init = p;
    }

    public int getInit() {
        return this.init;
    }

    public List<DlCompletionTreeArc> getNeighbour() {
        return this.neighbour;
    }

    public boolean hasParent() {
        if (this.neighbourSize == 0) {
            return false;
        }
        return this.neighbour.get(0).isPredEdge();
    }

    public DlCompletionTree isSomeApplicable(Role R, int C) {
        return R.isTransitive() ? this.isTSomeApplicable(R, C) : this.isNSomeApplicable(R, C);
    }

    public CGLabel label() {
        return this.label;
    }

    public List<ConceptWDep> beginl_sc() {
        return this.label.get_sc();
    }

    public List<ConceptWDep> beginl_cc() {
        return this.label.get_cc();
    }

    public ArrayIntMap beginl_sc_concepts() {
        return this.label.get_sc_concepts();
    }

    public ArrayIntMap beginl_cc_concepts() {
        return this.label.get_cc_concepts();
    }

    public boolean isLabelledBy(int p) {
        return this.label.contains(p);
    }

    public boolean isBlockedBy_SH(DlCompletionTree p) {
        return this.label.lesserequal(p.label);
    }

    public boolean isBlockedBy_SHI(DLDag dag, DlCompletionTree p) {
        return this.isCommonlyBlockedBy(dag, p);
    }

    public boolean isBlockedBy_SHIQ(DLDag dag, DlCompletionTree p) {
        return this.isCommonlyBlockedBy(dag, p) && (this.isCBlockedBy(dag, p) || this.isABlockedBy(dag, p));
    }

    public DlCompletionTree getParentNode() {
        if (this.cachedParent == null) {
            this.cachedParent = this.neighbour.get(0).getArcEnd();
        }
        return this.cachedParent;
    }

    public boolean isAffected() {
        return this.affected;
    }

    public void setAffected() {
        if (this.isAffected() || this.isNominalNode() || this.isPBlocked()) {
            return;
        }
        this.affected = true;
        for (int i = 0; i < this.neighbourSize; ++i) {
            DlCompletionTreeArc q = this.neighbour.get(i);
            if (!q.isSuccEdge()) continue;
            q.getArcEnd().setAffected();
        }
    }

    public void clearAffected() {
        this.affected = false;
    }

    public boolean isDBlocked() {
        return this.blocker != null && !this.pBlocked && this.dBlocked;
    }

    public boolean isIBlocked() {
        return this.blocker != null && !this.pBlocked && !this.dBlocked;
    }

    public boolean isPBlocked() {
        return this.blocker != null && this.pBlocked && !this.dBlocked;
    }

    public boolean isBlockedPBlockedNominalNodeCached() {
        return this.cached || this.isNominalNode() || this.isBlocked() || this.isPBlocked();
    }

    public boolean isBlocked() {
        return this.blocker != null && !this.pBlocked;
    }

    public boolean isIllegallyDBlocked() {
        return this.isDBlocked() && this.blocker.isBlocked();
    }

    public DlCompletionTree getBlocker() {
        return this.blocker;
    }

    public DepSet getPurgeDep() {
        return this.pDep;
    }

    public DlCompletionTree resolvePBlocker() {
        if (this.isPBlocked()) {
            return this.blocker.resolvePBlocker();
        }
        return this;
    }

    public DlCompletionTree resolvePBlocker(DepSet dep) {
        if (!this.isPBlocked()) {
            return this;
        }
        dep.add(this.pDep);
        return this.blocker.resolvePBlocker(dep);
    }

    public boolean isLoopLabelled(int c) {
        assert (this.isDBlocked());
        if (this.blocker.isLabelledBy(c)) {
            return true;
        }
        int n = 1;
        DlCompletionTree p = this.getParentNode();
        while (p.hasParent() && !p.equals(this.blocker)) {
            if (p.isLabelledBy(c)) {
                return true;
            }
            ++n;
            p = p.getParentNode();
        }
        this.options.getLog().print(" loop(").print(n).print(")");
        return false;
    }

    private Restorer setBlocked(DlCompletionTree blocker, boolean permanently, boolean directly) {
        UnBlock ret = new UnBlock(this);
        this.setBlocker(blocker);
        this.pBlocked = permanently;
        this.dBlocked = directly;
        this.options.getLog().printTemplate(Templates.LOG_NODE_BLOCKED, this.getBlockingStatusName(), this.id, blocker == null ? "" : ",", blocker == null ? "" : Integer.valueOf(blocker.id));
        return ret;
    }

    public Restorer setDBlocked(DlCompletionTree blocker) {
        return this.setBlocked(blocker, false, true);
    }

    public Restorer setIBlocked(DlCompletionTree blocker) {
        return this.setBlocked(blocker, false, false);
    }

    public Restorer setUBlocked() {
        return this.setBlocked(null, true, true);
    }

    public Restorer setPBlocked(DlCompletionTree blocker, DepSet dep) {
        UnBlock ret = new UnBlock(this);
        this.setBlocker(blocker);
        if (this.isNominalNode()) {
            this.pDep = DepSet.create(dep);
        }
        this.pBlocked = true;
        this.dBlocked = false;
        this.options.getLog().printTemplate(Templates.LOG_NODE_BLOCKED, this.getBlockingStatusName(), this.id, blocker == null ? "" : ",", blocker == null ? "" : Integer.valueOf(blocker.id));
        return ret;
    }

    public DlCompletionTreeArc getEdgeLabelled(Role R, DlCompletionTree node) {
        for (int i = 0; i < this.neighbourSize; ++i) {
            DlCompletionTreeArc p = this.neighbour.get(i);
            if (!p.getArcEnd().equals(node) || !p.isNeighbour(R)) continue;
            return p;
        }
        return null;
    }

    private boolean isParentArcLabelled(Role R) {
        return this.getEdgeLabelled(R, this.getParentNode()) != null;
    }

    public boolean initIR(int level, DepSet ds) {
        Reference<DepSet> dummy = new Reference<DepSet>(DepSet.create());
        if (this.inIRwithC(level, ds, dummy)) {
            return true;
        }
        ConceptWDep conceptWDep = new ConceptWDep(level, ds);
        this.inequalityRelation.add(conceptWDep);
        this.inequalityRelation_helper.put(level, conceptWDep);
        return false;
    }

    private boolean inIRwithC(int level, DepSet ds, Reference<DepSet> dep) {
        if (this.inequalityRelation.isEmpty()) {
            return false;
        }
        ConceptWDep p = this.inequalityRelation_helper.get(level);
        if (p != null) {
            dep.getReference().add(p.getDep());
            dep.getReference().add(ds);
            return true;
        }
        return false;
    }

    public boolean needSave(int newLevel) {
        return this.curLevel < newLevel;
    }

    public void save(int level) {
        DLCompletionTreeSaveState node = new DLCompletionTreeSaveState();
        this.saves.push(node);
        this.save(node);
        this.curLevel = level;
    }

    public boolean needRestore(int restLevel) {
        return this.curLevel > restLevel;
    }

    public void restore(int level) {
        this.restore(this.saves.pop(level));
    }

    public String logNode() {
        return this.id + this.logNodeBStatus();
    }

    private boolean isCommonlyBlockedBy(DLDag dag, DlCompletionTree p) {
        assert (this.hasParent());
        if (!this.label.lesserequal(p.label)) {
            return false;
        }
        ArrayIntMap list = p.beginl_cc_concepts();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            DLVertex v;
            int bp = list.keySet(i);
            if (bp <= 0 || (v = dag.get(bp)).getType() != DagTag.dtForall || this.B2(v, bp)) continue;
            return false;
        }
        return true;
    }

    private boolean isABlockedBy(DLDag dag, DlCompletionTree p) {
        ArrayIntMap list = p.beginl_cc_concepts();
        for (int i = 0; i < list.size(); ++i) {
            int bp = list.keySet(i);
            DLVertex v = dag.get(bp);
            if (!(v.getType() == DagTag.dtForall && bp < 0 ? !this.B4(1, v.getRole(), -v.getConceptIndex()) : v.getType() == DagTag.dtLE && (bp > 0 ? !this.B3(p, v.getNumberLE(), v.getRole(), v.getConceptIndex()) : !this.B4(v.getNumberGE(), v.getRole(), v.getConceptIndex())))) continue;
            return false;
        }
        return true;
    }

    private boolean isCBlockedBy(DLDag dag, DlCompletionTree p) {
        DLVertex v;
        int bp;
        int i;
        List<ConceptWDep> list = p.beginl_cc();
        for (i = 0; i < list.size(); ++i) {
            bp = list.get(i).getConcept();
            if (bp <= 0 || (v = dag.get(bp)).getType() != DagTag.dtLE || this.B5(v.getRole(), v.getConceptIndex())) continue;
            return false;
        }
        list = this.getParentNode().beginl_cc();
        for (i = 0; i < list.size(); ++i) {
            bp = list.get(i).getConcept();
            if (bp >= 0 || (v = dag.get(bp)).getType() != DagTag.dtLE || this.B6(v.getRole(), v.getConceptIndex())) continue;
            return false;
        }
        return true;
    }

    private boolean B2Simple(RAStateTransitions RST, int C) {
        DlCompletionTree parent = this.getParentNode();
        CGLabel parLab = parent.label();
        if (parLab.contains(C)) {
            return true;
        }
        for (int i = 0; i < this.neighbourSize; ++i) {
            DlCompletionTreeArc p = this.neighbour.get(i);
            if (p.isIBlocked() || !p.getArcEnd().equals(parent) || !RST.recognise(p.getRole())) continue;
            return false;
        }
        return true;
    }

    private boolean B2Complex(RAStateTransitions RST, int C) {
        DlCompletionTree parent = this.getParentNode();
        CGLabel parLab = parent.label();
        for (int i = 0; i < this.neighbourSize; ++i) {
            Role R;
            DlCompletionTreeArc p = this.neighbour.get(i);
            if (p.isIBlocked() || !p.getArcEnd().equals(parent) || !RST.recognise(R = p.getRole())) continue;
            List<RATransition> list = RST.begin();
            for (int j = 0; j < list.size(); ++j) {
                RATransition q = list.get(i);
                if (!q.applicable(R) || parLab.containsCC(C + q.final_state())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean B3(DlCompletionTree p, int n, Role S, int C) {
        boolean ret;
        assert (this.hasParent());
        if (!this.isParentArcLabelled(S)) {
            ret = true;
        } else if (this.getParentNode().isLabelledBy(-C)) {
            ret = true;
        } else if (!this.getParentNode().isLabelledBy(C)) {
            ret = false;
        } else {
            int m = 0;
            for (int i = 0; i < p.neighbourSize; ++i) {
                DlCompletionTreeArc q = p.neighbour.get(i);
                if (!q.isSuccEdge() || !q.isNeighbour(S) || !q.getArcEnd().isLabelledBy(C)) continue;
                ++m;
            }
            ret = m < n;
        }
        return ret;
    }

    private boolean B4(int m, Role T, int E) {
        assert (this.hasParent());
        if (this.isParentArcLabelled(T) && m == 1 && this.getParentNode().isLabelledBy(E)) {
            return true;
        }
        int n = 0;
        for (int i = 0; i < this.neighbourSize; ++i) {
            DlCompletionTreeArc q = this.neighbour.get(i);
            if (!q.isSuccEdge() || !q.isNeighbour(T) || !q.getArcEnd().isLabelledBy(E) || ++n < m) continue;
            return true;
        }
        return false;
    }

    private boolean B5(Role T, int E) {
        assert (this.hasParent());
        if (!this.isParentArcLabelled(T)) {
            return true;
        }
        return this.getParentNode().isLabelledBy(-E);
    }

    private boolean B6(Role U, int F) {
        assert (this.hasParent());
        if (!this.isParentArcLabelled(U.inverse())) {
            return true;
        }
        return this.isLabelledBy(-F);
    }

    public void init(int level) {
        this.flagDataNode = false;
        this.nominalLevel = Integer.MAX_VALUE;
        this.curLevel = level;
        this.cached = false;
        this.affected = true;
        this.dBlocked = true;
        this.pBlocked = true;
        this.label.init();
        this.init = 1;
        this.saves.clear();
        this.inequalityRelation.clear();
        this.inequalityRelation_helper.clear();
        this.neighbour.clear();
        this.cachedParent = null;
        this.neighbourSize = 0;
        this.setBlocker(null);
        this.pDep.clear();
    }

    private DlCompletionTree isTSuccLabelled(Role R, int C) {
        if (this.isLabelledBy(C)) {
            return this;
        }
        if (this.isNominalNode()) {
            return null;
        }
        DlCompletionTree ret = null;
        for (int i = 0; i < this.neighbourSize; ++i) {
            DlCompletionTreeArc p = this.neighbour.get(i);
            if (!p.isSuccEdge() || !p.isNeighbour(R) || p.isReflexiveEdge() || (ret = p.getArcEnd().isTSuccLabelled(R, C)) == null) continue;
            return ret;
        }
        return null;
    }

    private DlCompletionTree isTPredLabelled(Role R, int C, DlCompletionTree from) {
        if (this.isLabelledBy(C)) {
            return this;
        }
        if (this.isNominalNode()) {
            return null;
        }
        DlCompletionTree ret = null;
        for (int i = 0; i < this.neighbourSize; ++i) {
            DlCompletionTreeArc p = this.neighbour.get(i);
            if (!p.isSuccEdge() || !p.isNeighbour(R) || p.getArcEnd().equals(from) || (ret = p.getArcEnd().isTSuccLabelled(R, C)) == null) continue;
            return ret;
        }
        if (this.hasParent() && this.isParentArcLabelled(R)) {
            return this.getParentNode().isTPredLabelled(R, C, this);
        }
        return null;
    }

    private DlCompletionTree isNSomeApplicable(Role R, int C) {
        for (int i = 0; i < this.neighbourSize; ++i) {
            DlCompletionTreeArc p = this.neighbour.get(i);
            if (!p.isNeighbour(R) || !p.getArcEnd().isLabelledBy(C)) continue;
            return p.getArcEnd();
        }
        return null;
    }

    private DlCompletionTree isTSomeApplicable(Role R, int C) {
        DlCompletionTree ret = null;
        for (int i = 0; i < this.neighbourSize; ++i) {
            DlCompletionTreeArc p = this.neighbour.get(i);
            if (!p.isNeighbour(R) || (ret = p.isPredEdge() ? p.getArcEnd().isTPredLabelled(R, C, this) : p.getArcEnd().isTSuccLabelled(R, C)) == null) continue;
            return ret;
        }
        return null;
    }

    private void save(DLCompletionTreeSaveState nss) {
        nss.setCurLevel(this.curLevel);
        nss.setnNeighbours(this.neighbourSize);
        this.label.save(nss.getLab());
        this.logSRNode("SaveNode");
    }

    private void restore(DLCompletionTreeSaveState nss) {
        if (nss == null) {
            return;
        }
        this.curLevel = nss.getCurLevel();
        this.label.restore(nss.getLab(), this.curLevel);
        Helper.resize(this.neighbour, nss.getnNeighbours());
        this.neighbourSize = nss.getnNeighbours();
        if (this.neighbourSize == 0) {
            this.cachedParent = null;
        }
        this.affected = true;
        this.logSRNode("RestNode");
    }

    public void printBody(LogAdapter o) {
        o.print(this.id);
        if (this.isNominalNode()) {
            o.print("o").print(this.nominalLevel);
        }
        o.print("(").print(this.curLevel).print(")");
        if (this.isDataNode()) {
            o.print("d");
        }
        o.print((Object)this.label).print(this.logNodeBStatus());
    }

    public String toString() {
        StringBuilder o = new StringBuilder();
        o.append(this.id);
        if (this.isNominalNode()) {
            o.append("o").append(this.nominalLevel);
        }
        o.append("(").append(this.curLevel).append(")");
        if (this.isDataNode()) {
            o.append("d");
        }
        o.append(this.label).append(this.logNodeBStatus());
        return o.toString();
    }

    public boolean nonMergable(DlCompletionTree node, Reference<DepSet> dep) {
        if (this.inequalityRelation.isEmpty() || node.inequalityRelation.isEmpty()) {
            return false;
        }
        for (ConceptWDep p : node.inequalityRelation) {
            if (!this.inIRwithC(p.getConcept(), p.getDep(), dep)) continue;
            return true;
        }
        return false;
    }

    public Restorer updateIR(DlCompletionTree node, DepSet toAdd) {
        if (node.inequalityRelation.isEmpty()) {
            throw new IllegalArgumentException();
        }
        IRRestorer ret = new IRRestorer();
        for (ConceptWDep p : node.inequalityRelation) {
            if (this.inequalityRelation_helper.containsKey(p.getConcept())) continue;
            ConceptWDep conceptWDep = new ConceptWDep(p.getConcept(), toAdd);
            this.inequalityRelation.add(conceptWDep);
            this.inequalityRelation_helper.put(p.getConcept(), conceptWDep);
        }
        return ret;
    }

    @Override
    public int compareTo(DlCompletionTree o) {
        if (this.nominalLevel == o.nominalLevel) {
            return this.id - o.id;
        }
        return this.nominalLevel - o.nominalLevel;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (this == arg0) {
            return true;
        }
        if (arg0 instanceof DlCompletionTree) {
            DlCompletionTree arg02 = (DlCompletionTree)arg0;
            return this.nominalLevel == arg02.nominalLevel && this.id == arg02.id;
        }
        return false;
    }

    public int hashCode() {
        return this.nominalLevel * this.id;
    }

    public void setBlocker(DlCompletionTree blocker) {
        this.blocker = blocker;
    }

    class IRRestorer
    extends Restorer {
        private static final long serialVersionUID = 11000L;
        private final int n;

        public IRRestorer() {
            this.n = DlCompletionTree.this.inequalityRelation.size();
        }

        @Override
        public void restore() {
            Helper.resize(DlCompletionTree.this.inequalityRelation, this.n);
            DlCompletionTree.this.inequalityRelation_helper.clear();
            for (int i = 0; i < DlCompletionTree.this.inequalityRelation.size(); ++i) {
                if (DlCompletionTree.this.inequalityRelation.get(i) == null) continue;
                DlCompletionTree.this.inequalityRelation_helper.put(DlCompletionTree.this.inequalityRelation.get(i).getConcept(), DlCompletionTree.this.inequalityRelation.get(i));
            }
        }
    }

    static class CacheRestorer
    extends Restorer {
        private static final long serialVersionUID = 11000L;
        private final DlCompletionTree p;
        private final boolean isCached;

        public CacheRestorer(DlCompletionTree q) {
            this.p = q;
            this.isCached = q.cached;
        }

        @Override
        public void restore() {
            this.p.cached = this.isCached;
        }
    }

    static class UnBlock
    extends Restorer {
        private static final long serialVersionUID = 11000L;
        private final DlCompletionTree p;
        private final DlCompletionTree unblockBlocker;
        private final DepSet dep;
        private final boolean pBlocked;
        private final boolean dBlocked;

        public UnBlock(DlCompletionTree q) {
            this.p = q;
            this.unblockBlocker = q.blocker;
            this.dep = DepSet.create(q.pDep);
            this.pBlocked = q.pBlocked;
            this.dBlocked = q.dBlocked;
        }

        @Override
        public void restore() {
            this.p.setBlocker(this.unblockBlocker);
            this.p.pDep = DepSet.create(this.dep);
            this.p.pBlocked = this.pBlocked;
            this.p.dBlocked = this.dBlocked;
        }
    }
}

