/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.MultiMap;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.ConjunctiveQuerySet;
import uk.ac.manchester.cs.jfact.kernel.ExpressionManager;
import uk.ac.manchester.cs.jfact.kernel.Individual;
import uk.ac.manchester.cs.jfact.kernel.QueryApproximation;
import uk.ac.manchester.cs.jfact.kernel.QueryConnectednessChecker;
import uk.ac.manchester.cs.jfact.kernel.ReasoningKernel;
import uk.ac.manchester.cs.jfact.kernel.TBox;
import uk.ac.manchester.cs.jfact.kernel.TQueryToConceptsTransformer;
import uk.ac.manchester.cs.jfact.kernel.TermAssigner;
import uk.ac.manchester.cs.jfact.kernel.actors.ActorImpl;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptName;
import uk.ac.manchester.cs.jfact.kernel.dl.IndividualName;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleName;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.queryobjects.QRAtom;
import uk.ac.manchester.cs.jfact.kernel.queryobjects.QRConceptAtom;
import uk.ac.manchester.cs.jfact.kernel.queryobjects.QRQuery;
import uk.ac.manchester.cs.jfact.kernel.queryobjects.QRRoleAtom;
import uk.ac.manchester.cs.jfact.kernel.queryobjects.QRVariable;
import uk.ac.manchester.cs.jfact.kernel.queryobjects.VariableFactory;

@PortedFrom(file="ConjunctiveQueryFolding.cpp", name="ConjunctiveQueryFolding")
public class ConjunctiveQueryFolding
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="pEM")
    private final ExpressionManager pEM;
    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="VarFact")
    private final VariableFactory VarFact = new VariableFactory();
    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="NewVarMap")
    private final Map<QRVariable, QRVariable> NewVarMap = new HashMap<QRVariable, QRVariable>();
    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="NewNominals")
    private final Set<ConceptExpression> NewNominals = new HashSet<ConceptExpression>();
    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="VarRestrictions")
    private final Map<IRI, ConceptExpression> VarRestrictions = new HashMap<IRI, ConceptExpression>();
    @PortedFrom(file="ConjunctiveQuery.cpp", name="Var2I")
    private final Map<String, Integer> Var2I = new HashMap<String, Integer>();
    @PortedFrom(file="ConjunctiveQuery.cpp", name="I2Var")
    private final List<String> I2Var = new ArrayList<String>();

    public ConjunctiveQueryFolding(ExpressionManager em) {
        this.pEM = em;
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="isNominal")
    public boolean isNominal(ConceptExpression expr) {
        return this.NewNominals.contains(expr);
    }

    @Original
    public void addNominal(ConceptExpression concept) {
        this.NewNominals.add(concept);
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="RemoveCFromQuery")
    public QRQuery RemoveCFromQuery(QRQuery query) {
        this.VarRestrictions.clear();
        QRQuery ret = new QRQuery();
        for (QRVariable v : query.getFreeVars()) {
            ret.setVarFree(v);
            this.VarRestrictions.put(v.getName(), this.pEM.top());
        }
        for (QRAtom p : query.getBody().begin()) {
            if (p instanceof QRConceptAtom) {
                QRConceptAtom atom = (QRConceptAtom)p;
                ConceptExpression C = atom.getConcept();
                if (atom.getArg() instanceof QRVariable && query.isFreeVar((QRVariable)atom.getArg())) {
                    QRVariable var = (QRVariable)atom.getArg();
                    this.VarRestrictions.put(var.getName(), this.pEM.and(C, this.VarRestrictions.get(var.getName())));
                    continue;
                }
                ret.addAtom(atom);
                continue;
            }
            ret.addAtom(p);
        }
        return ret;
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="buildQueryFigure2")
    private void buildQueryFigure2(QRQuery query) {
        QRVariable x = this.VarFact.getNewVar(IRI.create((String)"urn:test#x"));
        QRVariable y = this.VarFact.getNewVar(IRI.create((String)"urn:test#y"));
        QRVariable z = this.VarFact.getNewVar(IRI.create((String)"urn:test#z"));
        QRVariable w = this.VarFact.getNewVar(IRI.create((String)"urn:test#v"));
        query.setVarFree(x);
        query.setVarFree(y);
        ObjectRoleName R1 = this.pEM.objectRole(IRI.create((String)"urn:test#R1"));
        ObjectRoleName R2 = this.pEM.objectRole(IRI.create((String)"urn:test#R2"));
        ObjectRoleName R3 = this.pEM.objectRole(IRI.create((String)"urn:test#R3"));
        ObjectRoleName R4 = this.pEM.objectRole(IRI.create((String)"urn:test#R4"));
        ObjectRoleName R5 = this.pEM.objectRole(IRI.create((String)"urn:test#R5"));
        ObjectRoleName R6 = this.pEM.objectRole(IRI.create((String)"urn:test#R6"));
        query.addAtom(new QRRoleAtom(R1, x, z));
        query.addAtom(new QRRoleAtom(R2, x, w));
        query.addAtom(new QRRoleAtom(R3, z, y));
        query.addAtom(new QRRoleAtom(R4, y, w));
        query.addAtom(new QRRoleAtom(R5, z, w));
        query.addAtom(new QRRoleAtom(R6, y, y));
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="buildSimpleQuery")
    private void buildSimpleQuery(QRQuery query) {
        QRVariable x = this.VarFact.getNewVar(IRI.create((String)"urn:test#x"));
        QRVariable y = this.VarFact.getNewVar(IRI.create((String)"urn:test#y"));
        query.setVarFree(x);
        query.setVarFree(y);
        ObjectRoleName R1 = this.pEM.objectRole(IRI.create((String)"urn:test#R1"));
        ObjectRoleName R2 = this.pEM.objectRole(IRI.create((String)"urn:test#R2"));
        query.addAtom(new QRRoleAtom(R1, x, y));
        query.addAtom(new QRRoleAtom(R2, y, x));
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="buildVerySimpleQuery")
    private void buildVerySimpleQuery(QRQuery query) {
        QRVariable x = this.VarFact.getNewVar(IRI.create((String)"urn:test#x"));
        query.setVarFree(x);
        ObjectRoleName R1 = this.pEM.objectRole(IRI.create((String)"urn:test#R1"));
        query.addAtom(new QRRoleAtom(R1, x, x));
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="buildVerySimpleQueryLUBM1")
    private void buildVerySimpleQueryLUBM1(QRQuery query) {
        QRVariable x = this.VarFact.getNewVar(IRI.create((String)"urn:test#x"));
        query.setVarFree(x);
        QRVariable y = this.VarFact.getNewVar(IRI.create((String)"urn:test#y"));
        query.setVarFree(y);
        ObjectRoleName R1 = this.pEM.objectRole(IRI.create((String)"urn:test#R1"));
        ConceptName C1 = this.pEM.concept(IRI.create((String)"urn:test#C1"));
        query.addAtom(new QRRoleAtom(R1, x, y));
        query.addAtom(new QRConceptAtom(C1, x));
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="buildLUBM2Query")
    private void buildLUBM2Query(int n, QRQuery query) {
        if (n == 1) {
            QRVariable v0 = this.VarFact.getNewVar(IRI.create((String)"urn:test#v0"));
            QRVariable v1 = this.VarFact.getNewVar(IRI.create((String)"urn:test#v1"));
            QRVariable v2 = this.VarFact.getNewVar(IRI.create((String)"urn:test#v2"));
            QRVariable v3 = this.VarFact.getNewVar(IRI.create((String)"urn:test#v3"));
            query.setVarFree(v0);
            query.setVarFree(v2);
            ConceptName Student = this.pEM.concept(IRI.create((String)"urn:test#Student"));
            ConceptName Course = this.pEM.concept(IRI.create((String)"urn:test#Course"));
            ConceptName Faculty = this.pEM.concept(IRI.create((String)"urn:test#Faculty"));
            ConceptName Department = this.pEM.concept(IRI.create((String)"urn:test#Department"));
            ObjectRoleName takesCourse = this.pEM.objectRole(IRI.create((String)"urn:test#takesCourse"));
            ObjectRoleName teacherOf = this.pEM.objectRole(IRI.create((String)"urn:test#teacherOf"));
            ObjectRoleName worksFor = this.pEM.objectRole(IRI.create((String)"urn:test#worksFor"));
            ObjectRoleName memberOf = this.pEM.objectRole(IRI.create((String)"urn:test#memberOf"));
            query.addAtom(new QRConceptAtom(Student, v0));
            query.addAtom(new QRConceptAtom(Course, v1));
            query.addAtom(new QRConceptAtom(Faculty, v2));
            query.addAtom(new QRConceptAtom(Department, v3));
            query.addAtom(new QRRoleAtom(takesCourse, v0, v1));
            query.addAtom(new QRRoleAtom(teacherOf, v2, v1));
            query.addAtom(new QRRoleAtom(worksFor, v2, v3));
            query.addAtom(new QRRoleAtom(memberOf, v0, v3));
        }
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="createQuery")
    private QRQuery createQuery() {
        QRQuery query = new QRQuery();
        this.buildLUBM2Query(1, query);
        return query;
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="PossiblyReplaceAtom")
    private boolean PossiblyReplaceAtom(QRQuery query, int atomIterator, QRAtom newAtom, QRVariable newArg, Set<QRAtom> passedAtoms) {
        boolean ret;
        QRAtom oldAtom = query.getBody().replaceAtom(atomIterator, newAtom);
        query.setVarFree(newArg);
        QueryConnectednessChecker checker = new QueryConnectednessChecker(query);
        if (checker.isConnected()) {
            ret = true;
        } else {
            newAtom = oldAtom;
            oldAtom = query.getBody().replaceAtom(atomIterator, oldAtom);
            query.getFreeVars().remove(newArg);
            ret = false;
        }
        passedAtoms.add(newAtom);
        return ret;
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="initVarMap")
    private void initVarMap(QRQuery query) {
        this.NewVarMap.clear();
        for (QRAtom p : query.getBody().begin()) {
            if (!(p instanceof QRRoleAtom)) continue;
            QRRoleAtom atom = (QRRoleAtom)p;
            if (atom.getArg1() instanceof QRVariable) {
                this.NewVarMap.put((QRVariable)atom.getArg1(), (QRVariable)atom.getArg1());
            }
            if (!(atom.getArg2() instanceof QRVariable)) continue;
            this.NewVarMap.put((QRVariable)atom.getArg2(), (QRVariable)atom.getArg2());
        }
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="QRVariable")
    private QRVariable getNewCopyVar(QRVariable old, int suffix) {
        String buf = "_" + suffix;
        QRVariable var = this.VarFact.getNewVar(IRI.create((String)(old.getName() + buf)));
        this.NewVarMap.put(var, old);
        return var;
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="transformQueryPhase1")
    public QRQuery transformQueryPhase1(QRQuery query) {
        HashSet<QRAtom> passedAtoms = new HashSet<QRAtom>();
        int n = 0;
        query = this.RemoveCFromQuery(query);
        this.initVarMap(query);
        List<QRAtom> body = query.getBody().begin();
        for (int i = 0; i < body.size(); ++i) {
            QRVariable newArg;
            QRRoleAtom newAtom;
            QRRoleAtom atom = null;
            if (body.get(i) instanceof QRRoleAtom) {
                atom = (QRRoleAtom)body.get(i);
            }
            if (atom == null || passedAtoms.contains(atom)) continue;
            ObjectRoleExpression role = atom.getRole();
            QRVariable arg1 = (QRVariable)atom.getArg1();
            QRVariable arg2 = (QRVariable)atom.getArg2();
            if (query.getFreeVars().contains(arg2)) {
                if (!this.PossiblyReplaceAtom(query, i, newAtom = new QRRoleAtom(role, arg1, newArg = this.getNewCopyVar(arg2, ++n)), newArg, passedAtoms)) continue;
            }
            if (query.getFreeVars().contains(arg1) && !this.PossiblyReplaceAtom(query, i, newAtom = new QRRoleAtom(role, newArg = this.getNewCopyVar(arg1, ++n), arg2), newArg, passedAtoms)) continue;
        }
        return query;
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="deleteFictiveVariables")
    public void deleteFictiveVariables(QRQuery query) {
        TreeSet<QRVariable> RealFreeVars = new TreeSet<QRVariable>();
        for (QRAtom atomIterator : query.getBody().begin()) {
            if (!(atomIterator instanceof QRRoleAtom)) continue;
            QRRoleAtom atom = (QRRoleAtom)atomIterator;
            QRVariable arg1 = (QRVariable)atom.getArg1();
            QRVariable arg2 = (QRVariable)atom.getArg2();
            if (query.isFreeVar(arg1)) {
                RealFreeVars.add(arg1);
            }
            if (!query.isFreeVar(arg2)) continue;
            RealFreeVars.add(arg2);
        }
        query.setFreeVars(RealFreeVars);
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="createConceptByVar")
    public ConceptExpression createConceptByVar(QRVariable v) {
        return this.VarRestrictions.get(this.NewVarMap.get(v).getName());
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="BuildAproximation")
    public void buildApproximation(QRQuery query) {
        QueryApproximation app = new QueryApproximation(this, query);
        HashMap<QRVariable, ConceptExpression> approx = new HashMap<QRVariable, ConceptExpression>();
        for (QRVariable qRVariable : this.NewVarMap.values()) {
            approx.put(qRVariable, this.pEM.top());
        }
        for (QRVariable qRVariable : query.getFreeVars()) {
            QRVariable var = this.NewVarMap.get(qRVariable);
            approx.put(var, this.pEM.and((ConceptExpression)approx.get(var), app.Assign(query, null, qRVariable)));
        }
        for (Map.Entry entry : approx.entrySet()) {
            this.VarRestrictions.put(((QRVariable)entry.getKey()).getName(), this.pEM.and(this.VarRestrictions.get(((QRVariable)entry.getKey()).getName()), (ConceptExpression)entry.getValue()));
        }
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="transformQueryPhase2")
    public ConceptExpression transformQueryPhase2(QRQuery query) {
        this.NewNominals.clear();
        TermAssigner assigner = new TermAssigner(this, query);
        this.deleteFictiveVariables(query);
        QRVariable next = query.getFreeVars().iterator().next();
        return assigner.Assign(query, null, next);
    }

    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="doQuery")
    private void doQuery(QRQuery query, ReasoningKernel kernel, boolean artificialaBox) {
        TQueryToConceptsTransformer transformer = new TQueryToConceptsTransformer(this, query);
        transformer.Run();
        transformer.printResult();
        kernel.evaluateQuery(transformer.getResult(), artificialaBox);
    }

    private void runQueries(ConjunctiveQuerySet queries, ReasoningKernel kernel) {
        for (int i = 0; i < queries.size(); ++i) {
            this.doQuery(queries.get(i), kernel, queries.isArtificialABox());
        }
    }

    @PortedFrom(file="ConjunctiveQuery.cpp", name="fillVarIndex")
    private void fillVarIndex(MultiMap<String, ConceptExpression> query) {
        int n = 0;
        this.Var2I.clear();
        this.I2Var.clear();
        for (String p : query.keySet()) {
            if (this.Var2I.containsKey(p)) continue;
            this.Var2I.put(p, n++);
            this.I2Var.add(p);
        }
        assert (this.I2Var.size() == n);
    }

    @PortedFrom(file="ConjunctiveQuery.cpp", name="evaluateQuery")
    public void evaluateQuery(MultiMap<String, ConceptExpression> query, ReasoningKernel kernel, boolean artificialABox) {
        this.fillVarIndex(query);
        if (this.I2Var.isEmpty()) {
            return;
        }
        ArrayList<DLTree> Concepts = new ArrayList<DLTree>();
        for (int i = 0; i < this.I2Var.size(); ++i) {
            String var = this.I2Var.get(i);
            ArrayList<ConceptExpression> list = new ArrayList<ConceptExpression>(query.get((Object)var));
            Concepts.add(kernel.e(this.pEM.and(list)));
        }
        this.fillIVec(kernel, artificialABox);
        kernel.getTBox().answerQuery(Concepts);
    }

    @PortedFrom(file="ConjunctiveQuery.cpp", name="getABoxInstances")
    private void getABoxInstances(ReasoningKernel kernel, ConceptExpression C, boolean artificialABox) {
        ActorImpl a = new ActorImpl();
        ArrayList<Individual> individuals = new ArrayList<Individual>();
        if (artificialABox) {
            a.needConcepts();
            kernel.getSubConcepts(C, false, a);
            for (ClassifiableEntry p : a.getElements1D()) {
                IndividualName ind = this.pEM.individual(p.getName());
                individuals.add((Individual)ind.getEntry());
            }
        } else {
            a.needIndividuals();
            kernel.getInstances(C, a);
            for (ClassifiableEntry p : a.getElements1D()) {
                individuals.add((Individual)p);
            }
        }
        kernel.getTBox().getIV().add(new TBox.IterableElem(individuals));
    }

    @PortedFrom(file="ConjunctiveQuery.cpp", name="fillIVec")
    private void fillIVec(ReasoningKernel kernel, boolean artificialABox) {
        kernel.getTBox().getIV().clear();
        for (int i = 0; i < this.I2Var.size(); ++i) {
            ConceptExpression C = this.VarRestrictions.get(this.I2Var.get(i));
            this.getABoxInstances(kernel, C, artificialABox);
        }
    }

    public ExpressionManager getpEM() {
        return this.pEM;
    }

    public Map<QRVariable, QRVariable> getNewVarMap() {
        return this.NewVarMap;
    }
}

