/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeFactory;
import uk.ac.manchester.cs.jfact.helpers.FastSet;
import uk.ac.manchester.cs.jfact.helpers.FastSetFactory;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.LogicFeatures;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.Token;

@PortedFrom(file="ConceptWithDep.h", name="Concept")
public class Concept
extends ClassifiableEntry {
    private static final long serialVersionUID = 11000L;
    public static final IRI temp = IRI.create((String)"urn:jfact#", (String)"temp");
    public static final IRI query = IRI.create((String)"urn:jfact#", (String)"default");
    public static final IRI nothing = OWLRDFVocabulary.OWL_NOTHING.getIRI();
    public static final IRI thing = OWLRDFVocabulary.OWL_THING.getIRI();
    @PortedFrom(file="tConcept.h", name="rel")
    private long rel = 0L;
    @PortedFrom(file="tConcept.h", name="classTag")
    private CTTag classTag;
    @PortedFrom(file="tConcept.h", name="tsDepth")
    private int tsDepth = 0;
    @PortedFrom(file="tConcept.h", name="pName")
    private int pName = 0;
    @PortedFrom(file="tConcept.h", name="pBody")
    private int pBody = 0;
    @PortedFrom(file="tConcept.h", name="posFeatures")
    private final LogicFeatures posFeatures = new LogicFeatures();
    @PortedFrom(file="tConcept.h", name="negFeatures")
    private final LogicFeatures negFeatures = new LogicFeatures();
    @PortedFrom(file="tConcept.h", name="erSet")
    private final FastSet extraRules = FastSetFactory.create();
    @PortedFrom(file="tConcept.h", name="Description")
    protected DLTree description;
    @Original
    private static final EnumSet<Token> replacements = EnumSet.of(Token.CNAME, Token.INAME, Token.RNAME, Token.DNAME);
    @Original
    private boolean primitive;
    @Original
    private boolean hasSP;
    @Original
    private boolean nominal;
    @Original
    private boolean singleton;

    @Original
    public static Concept getBOTTOM() {
        Concept toReturn = new Concept(nothing);
        toReturn.setBottom();
        toReturn.setId(-1);
        toReturn.setpName(-1);
        toReturn.setpBody(-1);
        return toReturn;
    }

    @Original
    public static Concept getTOP() {
        Concept toReturn = new Concept(thing);
        toReturn.setTop();
        toReturn.setId(-1);
        toReturn.setpName(1);
        toReturn.setpBody(1);
        toReturn.setTsDepth(1);
        toReturn.setClassTag(CTTag.cttTrueCompletelyDefined);
        return toReturn;
    }

    @Original
    public static Concept getTEMP() {
        Concept TEMP = new Concept(temp);
        TEMP.setId(-1);
        TEMP.setTsDepth(1);
        TEMP.setClassTag(CTTag.cttTrueCompletelyDefined);
        return TEMP;
    }

    public static Concept getQuery() {
        Concept p = new Concept(query);
        p.setSystem();
        return p;
    }

    @PortedFrom(file="tConcept.h", name="addToldSubsumer")
    private boolean addToldSubsumer(Concept concept) {
        if (concept != this) {
            this.addParentIfNew(concept);
            if (concept.isSingleton() || concept.isHasSP()) {
                this.setHasSP(true);
            }
        }
        return concept.isPrimitive();
    }

    public Concept(IRI name) {
        super(name);
        this.classTag = CTTag.cttUnspecified;
        this.setPrimitive(true);
    }

    @PortedFrom(file="tConcept.h", name="addExtraRule")
    public void addExtraRule(int ruleIndex) {
        this.extraRules.add(ruleIndex);
        this.setCompletelyDefined(false);
    }

    @PortedFrom(file="tConcept.h", name="hasExtraRules")
    public boolean hasExtraRules() {
        return !this.extraRules.isEmpty();
    }

    @PortedFrom(file="tConcept.h", name="er_begin")
    public FastSet getExtraRules() {
        return this.extraRules;
    }

    @Original
    public CTTag getClassTagPlain() {
        return this.classTag;
    }

    @PortedFrom(file="tConcept.h", name="getClassTag")
    public CTTag getClassTag() {
        if (this.classTag == CTTag.cttUnspecified) {
            this.classTag = this.determineClassTag();
        }
        return this.classTag;
    }

    @PortedFrom(file="tConcept.h", name="removeSelfFromDescription")
    public void removeSelfFromDescription() {
        this.description = this.replaceWithConstOld(this.description);
        this.initToldSubsumers();
    }

    @PortedFrom(file="tConcept.h", name="removeDescription")
    public void removeDescription() {
        this.description = null;
    }

    @PortedFrom(file="tConcept.h", name="canInitNonPrim")
    public boolean canInitNonPrim(DLTree desc) {
        if (this.description == null) {
            return true;
        }
        return !this.isPrimitive() && this.description.equals(desc);
    }

    @PortedFrom(file="tConcept.h", name="makeNonPrimitive")
    public DLTree makeNonPrimitive(DLTree desc) {
        DLTree ret = this.description;
        this.removeDescription();
        this.addDesc(desc);
        this.setPrimitive(false);
        return ret;
    }

    @Override
    public String toString() {
        return this.extName.toString();
    }

    @PortedFrom(file="tConcept.h", name="initToldSubsumers")
    public void initToldSubsumers() {
        boolean CD;
        this.toldSubsumers.clear();
        this.setHasSP(false);
        if (this.isPrimitive() && this.description != null && this.description.isTOP()) {
            this.removeDescription();
        }
        boolean bl = CD = !this.hasExtraRules() && this.isPrimitive();
        if (this.description != null) {
            CD &= this.initToldSubsumers(this.description, new HashSet<Role>());
        }
        this.setCompletelyDefined(CD);
    }

    @PortedFrom(file="tConcept.h", name="setToldTop")
    public void setToldTop(Concept top) {
        if (this.description == null && !this.hasToldSubsumers()) {
            this.addParent(top);
        }
    }

    @PortedFrom(file="tConcept.h", name="resolveId")
    public int resolveId() {
        Concept r;
        if (this.pName == 0) {
            return this.pBody;
        }
        if (this.isSynonym() && (r = Concept.resolveSynonym(this)) != this) {
            return r.resolveId();
        }
        return this.pName;
    }

    @PortedFrom(file="tConcept.h", name="addDesc")
    public void addDesc(DLTree Desc) {
        if (Desc == null) {
            return;
        }
        if (this.description == null) {
            this.description = Desc.copy();
            return;
        }
        if (Desc.isAND()) {
            if (this.description.isAND()) {
                this.description.addFirstChildren(Desc.getChildren());
            } else {
                DLTree temp = this.description;
                this.description = Desc.copy();
                this.description.addChild(temp);
            }
        } else if (this.description.isAND()) {
            this.description.addFirstChild(Desc);
        } else {
            this.description = DLTreeFactory.createSNFAnd(Desc, this.description);
        }
    }

    @Original
    public void addLeaves(Collection<DLTree> Desc) {
        if (this.description == null) {
            this.description = DLTreeFactory.createSNFAnd(Desc);
        } else if (this.description.isAND()) {
            for (DLTree d : Desc) {
                this.description.addChild(d);
            }
        } else {
            ArrayList<DLTree> l = new ArrayList<DLTree>(Desc);
            l.add(this.description);
            this.description = DLTreeFactory.createSNFAnd(l);
        }
    }

    @PortedFrom(file="tConcept.h", name="determineClassTag")
    private CTTag determineClassTag() {
        if (this.isSynonym()) {
            return Concept.resolveSynonym(this).getClassTag();
        }
        if (!this.isPrimitive()) {
            return CTTag.cttNonPrimitive;
        }
        if (!this.hasToldSubsumers()) {
            return CTTag.cttOrphan;
        }
        boolean hasLCD = false;
        boolean hasOther = false;
        boolean hasNP = false;
        block6: for (ClassifiableEntry p : this.toldSubsumers) {
            switch (((Concept)p).getClassTag()) {
                case cttTrueCompletelyDefined: {
                    continue block6;
                }
                case cttOrphan: 
                case cttLikeCompletelyDefined: {
                    hasLCD = true;
                    continue block6;
                }
                case cttRegular: {
                    hasOther = true;
                    continue block6;
                }
                case cttHasNonPrimitiveTS: 
                case cttNonPrimitive: {
                    hasNP = true;
                    continue block6;
                }
            }
            throw new UnreachableSituationException();
        }
        if (hasNP) {
            return CTTag.cttHasNonPrimitiveTS;
        }
        if (hasOther || !this.isCompletelyDefined()) {
            return CTTag.cttRegular;
        }
        if (hasLCD) {
            return CTTag.cttLikeCompletelyDefined;
        }
        return CTTag.cttTrueCompletelyDefined;
    }

    @Original
    public void push(LinkedList<DLTree> stack, DLTree current) {
        for (DLTree t : current.getChildren()) {
            if (t == null) continue;
            stack.push(t);
        }
    }

    @PortedFrom(file="tConcept.h", name="replaceSelfWithConst")
    private DLTree replaceWithConstOld(DLTree t) {
        if (t == null) {
            return null;
        }
        Token token = t.token();
        if (replacements.contains((Object)token) && Concept.resolveSynonym((ClassifiableEntry)t.elem().getNE()).equals(this)) {
            return DLTreeFactory.createTop();
        }
        if (token == Token.AND) {
            ArrayList<DLTree> l = new ArrayList<DLTree>();
            for (DLTree d : t.getChildren()) {
                l.add(this.replaceWithConstOld(d));
            }
            return DLTreeFactory.createSNFAnd(l, t);
        }
        if (token == Token.NOT && (t.getChild().isAND() || replacements.contains((Object)t.getChild().token()))) {
            return DLTreeFactory.createSNFNot(this.replaceWithConstOld(t.getChild()));
        }
        return t;
    }

    @PortedFrom(file="tConcept.h", name="initToldSubsumers")
    public boolean initToldSubsumers(DLTree _desc, Set<Role> RolesProcessed) {
        if (_desc == null || _desc.isTOP()) {
            return true;
        }
        DLTree desc = _desc;
        Token token = desc.token();
        if (replacements.contains((Object)token)) {
            return this.addToldSubsumer((Concept)desc.elem().getNE());
        }
        if (token == Token.NOT) {
            if (desc.getChild().token() == Token.FORALL || desc.getChild().token() == Token.LE) {
                this.searchTSbyRoleAndSupers(Role.resolveRole(desc.getChild().getLeft()), RolesProcessed);
            }
            return false;
        }
        if (token == Token.SELF) {
            Role R = Role.resolveRole(desc.getChild());
            this.searchTSbyRoleAndSupers(R, RolesProcessed);
            this.searchTSbyRoleAndSupers(R.inverse(), RolesProcessed);
            return false;
        }
        if (token == Token.AND) {
            boolean toReturn = true;
            for (DLTree t : desc.getChildren()) {
                toReturn &= this.initToldSubsumers(t, RolesProcessed);
            }
            return toReturn;
        }
        return false;
    }

    @PortedFrom(file="tConcept.h", name="SearchTSbyRole")
    private void searchTSbyRole(Role R, Set<Role> rolesProcessed) {
        if (rolesProcessed.contains(R)) {
            return;
        }
        DLTree Domain = R.getTDomain();
        if (Domain == null || Domain.isConst()) {
            return;
        }
        rolesProcessed.add(R);
        this.initToldSubsumers(Domain, rolesProcessed);
    }

    @PortedFrom(file="tConcept.h", name="SearchTSbyRoleAndSupers")
    public void searchTSbyRoleAndSupers(Role r, Set<Role> RolesProcessed) {
        this.searchTSbyRole(r, RolesProcessed);
        List<Role> list = r.getAncestor();
        for (int i = 0; i < list.size(); ++i) {
            Role q = list.get(i);
            this.searchTSbyRole(q, RolesProcessed);
        }
    }

    @PortedFrom(file="tConcept.h", name="calculateTSDepth")
    public int calculateTSDepth() {
        if (this.tsDepth > 0) {
            return this.tsDepth;
        }
        int max = 0;
        for (ClassifiableEntry p : this.toldSubsumers) {
            int cur;
            if (p.getToldSubsumers().contains(this) || max >= (cur = ((Concept)p).calculateTSDepth())) continue;
            max = cur;
        }
        this.tsDepth = max + 1;
        return this.tsDepth;
    }

    @PortedFrom(file="tConcept.h", name="clear")
    public void clear() {
        this.setId(0);
        this.taxVertex = null;
        this.toldSubsumers.clear();
        this.setCompletelyDefined(false);
        this.pSynonym = null;
        this.removeDescription();
        this.setPrimitive(true);
        this.pBody = 0;
        this.pName = 0;
    }

    @Original
    public int getpName() {
        return this.pName;
    }

    @Original
    public void setpName(int pName) {
        this.pName = pName;
    }

    @Original
    public int getpBody() {
        return this.pBody;
    }

    @Original
    public void setpBody(int pBody) {
        this.pBody = pBody;
    }

    @Original
    public DLTree getDescription() {
        return this.description;
    }

    @Original
    public int getTsDepth() {
        return this.tsDepth;
    }

    @Original
    private void setTsDepth(int tsDepth) {
        this.tsDepth = tsDepth;
    }

    @Original
    public LogicFeatures getNegFeatures() {
        return this.negFeatures;
    }

    @Original
    public LogicFeatures getPosFeatures() {
        return this.posFeatures;
    }

    @Original
    @PortedFrom(file="tConcept.h", name="classTag")
    private void setClassTag(CTTag classTag) {
        this.classTag = classTag;
    }

    @Original
    public boolean isPrimitive() {
        return this.primitive;
    }

    @Original
    public void setPrimitive(boolean action) {
        this.primitive = action;
    }

    @Original
    public boolean isHasSP() {
        return this.hasSP;
    }

    @Original
    public void setHasSP(boolean action) {
        this.hasSP = action;
    }

    @Original
    public boolean isNominal() {
        return this.nominal;
    }

    @Original
    public void setNominal(boolean action) {
        this.nominal = action;
    }

    @Original
    public boolean isSingleton() {
        return this.singleton;
    }

    @Original
    public void setSingleton(boolean action) {
        this.singleton = action;
    }

    @PortedFrom(file="tConcept.h", name="isRelevant")
    public boolean isRelevant(long lab) {
        return lab == this.rel;
    }

    @PortedFrom(file="tConcept.h", name="setRelevant")
    public void setRelevant(long lab) {
        this.rel = lab;
    }

    @PortedFrom(file="tConcept.h", name="dropRelevant")
    public void dropRelevant() {
        this.rel = 0L;
    }

    public static enum CTTag {
        cttUnspecified('u'),
        cttTrueCompletelyDefined('T'),
        cttOrphan('O'),
        cttLikeCompletelyDefined('L'),
        cttHasNonPrimitiveTS('N'),
        cttRegular('r'),
        cttNonPrimitive('n');

        private final char c;

        private CTTag(char c) {
            this.c = c;
        }

        protected char getCTTagName() {
            return this.c;
        }
    }
}

