/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeFactory;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.kernel.AbsorptionActions;
import uk.ac.manchester.cs.jfact.kernel.Axiom;
import uk.ac.manchester.cs.jfact.kernel.InAx;
import uk.ac.manchester.cs.jfact.kernel.TBox;

@PortedFrom(file="tAxiomSet.h", name="TAxiomSet")
public class AxiomSet
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="tAxiomSet.h", name="Host")
    protected final TBox tboxHost;
    @PortedFrom(file="tAxiomSet.h", name="Accum")
    private List<Axiom> accumulator = new ArrayList<Axiom>();
    private final LogAdapter absorptionLog;
    @PortedFrom(file="tAxiomSet.h", name="ActionVector")
    private final List<AbsorptionActions> actions = new ArrayList<AbsorptionActions>();

    @PortedFrom(file="tAxiomSet.h", name="insertGCI")
    private void insertGCI(Axiom p) {
        this.tboxHost.getOptions().getAbsorptionLog().print("\n new axiom (").print(this.accumulator.size()).print((Object)"):", (Object)p);
        this.accumulator.add(p);
    }

    @PortedFrom(file="tAxiomSet.h", name="insertIfNew")
    private boolean insertIfNew(Axiom q) {
        if (!this.accumulator.contains(q)) {
            this.insertGCI(q);
            return false;
        }
        return true;
    }

    @PortedFrom(file="tAxiomSet.h", name="processNewAxiom")
    protected boolean processNewAxiom(Axiom q) {
        if (q == null) {
            return false;
        }
        return !this.insertIfNew(q);
    }

    public AxiomSet(TBox host) {
        this.tboxHost = host;
        this.absorptionLog = this.tboxHost.getOptions().getAbsorptionLog();
    }

    @PortedFrom(file="tAxiomSet.h", name="addAxiom")
    public void addAxiom(DLTree C, DLTree D) {
        InAx.SAbsInput();
        Axiom p = new Axiom(this.absorptionLog);
        p.add(C);
        p.add(DLTreeFactory.createSNFNot(D));
        this.insertGCI(p);
    }

    @PortedFrom(file="tAxiomSet.h", name="size")
    private int size() {
        return this.accumulator.size();
    }

    @PortedFrom(file="tAxiomSet.h", name="wasRoleAbsorptionApplied")
    public boolean wasRoleAbsorptionApplied() {
        return InAx.containsSAbsRApply();
    }

    @PortedFrom(file="tAxiomSet.h", name="getGCI")
    public DLTree getGCI() {
        ArrayList<DLTree> l = new ArrayList<DLTree>();
        for (Axiom p : this.accumulator) {
            l.add(p.createAnAxiom(null));
        }
        return DLTreeFactory.createSNFAnd(l);
    }

    @PortedFrom(file="tAxiomSet.h", name="split")
    protected boolean split(Axiom p) {
        List<Axiom> splitted = p.split();
        if (splitted.isEmpty()) {
            return false;
        }
        for (Axiom q : splitted) {
            if (!this.accumulator.contains(q)) continue;
            return false;
        }
        for (Axiom q : splitted) {
            this.insertGCI(q);
        }
        return true;
    }

    @PortedFrom(file="tAxiomSet.h", name="absorb")
    public int absorb() {
        ArrayList<Axiom> GCIs = new ArrayList<Axiom>();
        for (int i = 0; i < this.accumulator.size(); ++i) {
            Axiom ax = this.accumulator.get(i);
            this.tboxHost.getOptions().getAbsorptionLog().print("\nProcessing (").print(i).print("):");
            if (this.absorbGCI(ax)) continue;
            GCIs.add(ax);
        }
        this.accumulator = GCIs;
        this.tboxHost.getOptions().getAbsorptionLog().print("\nAbsorption done with ").print(this.accumulator.size()).print(" GCIs left\n");
        this.printStatistics();
        return this.size();
    }

    @PortedFrom(file="tAxiomSet.h", name="absorbGCI")
    private boolean absorbGCI(Axiom p) {
        InAx.SAbsAction();
        for (AbsorptionActions abs : this.actions) {
            if (!abs.execute(p, this)) continue;
            return true;
        }
        this.tboxHost.getOptions().getAbsorptionLog().print(" keep as GCI");
        return false;
    }

    @PortedFrom(file="tAxiomSet.h", name="initAbsorptionFlags")
    public boolean initAbsorptionFlags(String flags) {
        this.actions.clear();
        for (char c : flags.toCharArray()) {
            this.actions.add(AbsorptionActions.get(c));
        }
        this.tboxHost.getOptions().getAbsorptionLog().print("Init absorption order as ").print(flags).print("\n");
        return false;
    }

    @PortedFrom(file="tAxiomSet.h", name="PrintStatistics")
    private void printStatistics() {
        if (!InAx.containsSAbsAction()) {
            return;
        }
        LogAdapter log = this.tboxHost.getOptions().getAbsorptionLog();
        log.print("\nAbsorption dealt with ").print(InAx.getSAbsInput()).print(" input axioms\nThere were made ").print(InAx.getSAbsAction()).print(" absorption actions, of which:");
        if (InAx.containsSAbsRepCN()) {
            log.print("\n\t").print(InAx.getSAbsRepCN()).print(" concept name replacements");
        }
        if (InAx.containsSAbsRepForall()) {
            log.print("\n\t").print(InAx.getSAbsRepForall()).print(" universals replacements");
        }
        if (InAx.containsSAbsSplit()) {
            log.print("\n\t").print(InAx.getSAbsSplit()).print(" conjunction splits");
        }
        if (InAx.containsSAbsBApply()) {
            log.print("\n\t").print(InAx.getSAbsBApply()).print(" BOTTOM absorptions");
        }
        if (InAx.containsSAbsTApply()) {
            log.print("\n\t").print(InAx.getSAbsTApply()).print(" TOP absorptions");
        }
        if (InAx.containsSAbsCApply()) {
            log.print("\n\t").print(InAx.getSAbsCApply()).print(" concept absorption with ").print(InAx.getSAbsCAttempt()).print(" possibilities");
        }
        if (InAx.containsSAbsNApply()) {
            log.print("\n\t").print(InAx.getSAbsNApply()).print(" negated concept absorption with ").print(InAx.getSAbsNAttempt()).print(" possibilities");
        }
        if (InAx.containsSAbsRApply()) {
            log.print("\n\t").print(InAx.getSAbsRApply()).print(" role domain absorption with ").print(InAx.getSAbsRAttempt()).print(" possibilities");
        }
        if (!this.accumulator.isEmpty()) {
            log.print("\nThere are ").print(this.accumulator.size()).print(" GCIs left");
        }
    }
}

