/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.helpers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionGraph;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;

public class Stats
implements Serializable {
    private static final long serialVersionUID = 11000L;
    private final List<AccumulatedStatistic> root = new ArrayList<AccumulatedStatistic>();
    private final AccumulatedStatistic nTacticCalls = this.build(this.root);
    private final AccumulatedStatistic nUseless = this.build(this.root);
    private final AccumulatedStatistic nIdCalls = this.build(this.root);
    private final AccumulatedStatistic nSingletonCalls = this.build(this.root);
    private final AccumulatedStatistic nOrCalls = this.build(this.root);
    private final AccumulatedStatistic nOrBrCalls = this.build(this.root);
    private final AccumulatedStatistic nAndCalls = this.build(this.root);
    private final AccumulatedStatistic nSomeCalls = this.build(this.root);
    private final AccumulatedStatistic nAllCalls = this.build(this.root);
    private final AccumulatedStatistic nFuncCalls = this.build(this.root);
    private final AccumulatedStatistic nLeCalls = this.build(this.root);
    private final AccumulatedStatistic nGeCalls = this.build(this.root);
    private final AccumulatedStatistic nNNCalls = this.build(this.root);
    private final AccumulatedStatistic nMergeCalls = this.build(this.root);
    private final AccumulatedStatistic nAutoEmptyLookups = this.build(this.root);
    private final AccumulatedStatistic nAutoTransLookups = this.build(this.root);
    private final AccumulatedStatistic nSRuleAdd = this.build(this.root);
    private final AccumulatedStatistic nSRuleFire = this.build(this.root);
    private final AccumulatedStatistic nStateSaves = this.build(this.root);
    private final AccumulatedStatistic nStateRestores = this.build(this.root);
    private final AccumulatedStatistic nNodeSaves = this.build(this.root);
    private final AccumulatedStatistic nNodeRestores = this.build(this.root);
    private final AccumulatedStatistic nLookups = this.build(this.root);
    private final AccumulatedStatistic nFairnessViolations = this.build(this.root);
    private final AccumulatedStatistic nCacheTry = this.build(this.root);
    private final AccumulatedStatistic nCacheFailedNoCache = this.build(this.root);
    private final AccumulatedStatistic nCacheFailedShallow = this.build(this.root);
    private final AccumulatedStatistic nCacheFailed = this.build(this.root);
    private final AccumulatedStatistic nCachedSat = this.build(this.root);
    private final AccumulatedStatistic nCachedUnsat = this.build(this.root);

    public AccumulatedStatistic build(List<AccumulatedStatistic> list) {
        AccumulatedStatistic toReturn = new AccumulatedStatistic();
        list.add(toReturn);
        return toReturn;
    }

    public void accumulate() {
        for (AccumulatedStatistic cur : this.root) {
            cur.accumulate();
        }
    }

    public void logStatisticData(LogAdapter o, boolean needLocal, DlCompletionGraph CGraph, JFactReasonerConfiguration options) {
        if (options.isUSE_REASONING_STATISTICS()) {
            this.nTacticCalls.print(o, needLocal, "\nThere were made ", " tactic operations, of which:");
            this.nIdCalls.print(o, needLocal, "\n    CN   operations: ", "");
            this.nSingletonCalls.print(o, needLocal, "\n           including ", " singleton ones");
            this.nOrCalls.print(o, needLocal, "\n    OR   operations: ", "");
            this.nOrBrCalls.print(o, needLocal, "\n           ", " of which are branching");
            this.nAndCalls.print(o, needLocal, "\n    AND  operations: ", "");
            this.nSomeCalls.print(o, needLocal, "\n    SOME operations: ", "");
            this.nAllCalls.print(o, needLocal, "\n    ALL  operations: ", "");
            this.nFuncCalls.print(o, needLocal, "\n    Func operations: ", "");
            this.nLeCalls.print(o, needLocal, "\n    LE   operations: ", "");
            this.nGeCalls.print(o, needLocal, "\n    GE   operations: ", "");
            this.nUseless.print(o, needLocal, "\n    N/A  operations: ", "");
            this.nNNCalls.print(o, needLocal, "\nThere were made ", " NN rule application");
            this.nMergeCalls.print(o, needLocal, "\nThere were made ", " merging operations");
            this.nAutoEmptyLookups.print(o, needLocal, "\nThere were made ", " RA empty transition lookups");
            this.nAutoTransLookups.print(o, needLocal, "\nThere were made ", " RA applicable transition lookups");
            this.nSRuleAdd.print(o, needLocal, "\nThere were made ", " simple rule additions");
            this.nSRuleFire.print(o, needLocal, "\n       of which ", " simple rules fired");
            this.nStateSaves.print(o, needLocal, "\nThere were made ", " save(s) of global state");
            this.nStateRestores.print(o, needLocal, "\nThere were made ", " restore(s) of global state");
            this.nNodeSaves.print(o, needLocal, "\nThere were made ", " save(s) of tree state");
            this.nNodeRestores.print(o, needLocal, "\nThere were made ", " restore(s) of tree state");
            this.nLookups.print(o, needLocal, "\nThere were made ", " concept lookups");
            if (options.isRKG_USE_FAIRNESS()) {
                this.nFairnessViolations.print(o, needLocal, "\nThere were ", " fairness constraints violation");
            }
            this.nCacheTry.print(o, needLocal, "\nThere were made ", " tries to cache completion tree node, of which:");
            this.nCacheFailedNoCache.print(o, needLocal, "\n                ", " fails due to cache absence");
            this.nCacheFailedShallow.print(o, needLocal, "\n                ", " fails due to shallow node");
            this.nCacheFailed.print(o, needLocal, "\n                ", " fails due to cache merge failure");
            this.nCachedSat.print(o, needLocal, "\n                ", " cached satisfiable nodes");
            this.nCachedUnsat.print(o, needLocal, "\n                ", " cached unsatisfiable nodes");
        }
        if (!needLocal) {
            o.print("\nThe maximal graph size is ").print(CGraph.maxSize()).print(" nodes");
        }
    }

    public AccumulatedStatistic getnTacticCalls() {
        return this.nTacticCalls;
    }

    public AccumulatedStatistic getnUseless() {
        return this.nUseless;
    }

    public AccumulatedStatistic getnIdCalls() {
        return this.nIdCalls;
    }

    public AccumulatedStatistic getnSingletonCalls() {
        return this.nSingletonCalls;
    }

    public AccumulatedStatistic getnOrCalls() {
        return this.nOrCalls;
    }

    public AccumulatedStatistic getnOrBrCalls() {
        return this.nOrBrCalls;
    }

    public AccumulatedStatistic getnAndCalls() {
        return this.nAndCalls;
    }

    public AccumulatedStatistic getnSomeCalls() {
        return this.nSomeCalls;
    }

    public AccumulatedStatistic getnAllCalls() {
        return this.nAllCalls;
    }

    public AccumulatedStatistic getnFuncCalls() {
        return this.nFuncCalls;
    }

    public AccumulatedStatistic getnLeCalls() {
        return this.nLeCalls;
    }

    public AccumulatedStatistic getnGeCalls() {
        return this.nGeCalls;
    }

    public AccumulatedStatistic getnNNCalls() {
        return this.nNNCalls;
    }

    public AccumulatedStatistic getnMergeCalls() {
        return this.nMergeCalls;
    }

    public AccumulatedStatistic getnAutoEmptyLookups() {
        return this.nAutoEmptyLookups;
    }

    public AccumulatedStatistic getnAutoTransLookups() {
        return this.nAutoTransLookups;
    }

    public AccumulatedStatistic getnSRuleAdd() {
        return this.nSRuleAdd;
    }

    public AccumulatedStatistic getnSRuleFire() {
        return this.nSRuleFire;
    }

    public AccumulatedStatistic getnStateSaves() {
        return this.nStateSaves;
    }

    public AccumulatedStatistic getnStateRestores() {
        return this.nStateRestores;
    }

    public AccumulatedStatistic getnNodeSaves() {
        return this.nNodeSaves;
    }

    public AccumulatedStatistic getnNodeRestores() {
        return this.nNodeRestores;
    }

    public AccumulatedStatistic getnLookups() {
        return this.nLookups;
    }

    public AccumulatedStatistic getnFairnessViolations() {
        return this.nFairnessViolations;
    }

    public AccumulatedStatistic getnCacheTry() {
        return this.nCacheTry;
    }

    public AccumulatedStatistic getnCacheFailedNoCache() {
        return this.nCacheFailedNoCache;
    }

    public AccumulatedStatistic getnCacheFailedShallow() {
        return this.nCacheFailedShallow;
    }

    public AccumulatedStatistic getnCacheFailed() {
        return this.nCacheFailed;
    }

    public AccumulatedStatistic getnCachedSat() {
        return this.nCachedSat;
    }

    public AccumulatedStatistic getnCachedUnsat() {
        return this.nCachedUnsat;
    }

    public static class AccumulatedStatistic
    implements Serializable {
        private static final long serialVersionUID = 11000L;
        private int total = 0;
        private int local = 0;

        public void inc() {
            ++this.local;
        }

        public void accumulate() {
            this.total += this.local;
            this.local = 0;
        }

        public void print(LogAdapter l, boolean b, String s1, String s2) {
            l.print(s1);
            if (b) {
                l.print(this.local);
            } else {
                l.print(this.total);
            }
            l.print(s2);
        }
    }
}

