/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.helpers;

import java.util.Arrays;
import uk.ac.manchester.cs.jfact.helpers.AbstractFastSet;
import uk.ac.manchester.cs.jfact.helpers.FastSet;

public class FastSetSimple
extends AbstractFastSet {
    private static final long serialVersionUID = 11000L;
    protected int[] values;
    protected int size = 0;
    protected static final int defaultSize = 16;

    protected int insertionIndex(int key) {
        int lowerbound;
        if (key < this.values[0]) {
            return -1;
        }
        if (key > this.values[this.size - 1]) {
            return -this.size - 1;
        }
        if (this.size < 5) {
            for (lowerbound = 0; lowerbound < this.size; ++lowerbound) {
                if (this.values[lowerbound] > key) {
                    return -lowerbound - 1;
                }
                if (this.values[lowerbound] != key) continue;
                return lowerbound;
            }
            return -lowerbound - 1;
        }
        int upperbound = this.size - 1;
        while (lowerbound <= upperbound) {
            int delta = upperbound - lowerbound;
            int intermediate = lowerbound + delta / 2;
            if (this.values[intermediate] == key) {
                return intermediate;
            }
            if (this.values[intermediate] < key) {
                lowerbound = intermediate + 1;
                continue;
            }
            upperbound = intermediate - 1;
        }
        return -lowerbound - 1;
    }

    public FastSetSimple() {
    }

    public FastSetSimple(FastSetSimple c1, FastSetSimple c2) {
        this.values = new int[(c1.size + c2.size) / 16 * 16 + 16];
        int i = 0;
        int j = 0;
        int index = 0;
        while (i < c1.size && j < c2.size) {
            if (c1.values[i] < c2.values[j]) {
                this.values[index] = c1.values[i];
                ++i;
            } else if (c2.values[j] < c1.values[i]) {
                this.values[index] = c2.values[j];
                ++j;
            } else if (c1.values[i] == c2.values[j]) {
                this.values[index] = c1.values[i];
                ++i;
                ++j;
            }
            ++index;
        }
        if (i < c1.size) {
            while (i < c1.size) {
                this.values[index] = c1.values[i];
                ++i;
                ++index;
            }
            this.size = index;
        } else {
            while (j < c2.size) {
                this.values[index] = c2.values[j];
                ++j;
                ++index;
            }
            this.size = index;
        }
    }

    @Override
    public int get(int i) {
        if (this.values != null) {
            return this.values[i];
        }
        throw new IllegalArgumentException("Illegal argument " + i + ": no such element");
    }

    protected void init() {
        this.values = new int[16];
        this.size = 0;
    }

    @Override
    public void add(int e) {
        int pos = -1;
        if (this.values == null) {
            this.init();
        } else {
            pos = this.insertionIndex(e);
        }
        if (pos > -1) {
            return;
        }
        int i = -pos - 1;
        if (i >= this.values.length || this.size >= this.values.length) {
            this.values = Arrays.copyOf(this.values, 2 * this.values.length);
        }
        for (int j = this.size - 1; j >= i; --j) {
            this.values[j + 1] = this.values[j];
        }
        this.values[i] = e;
        ++this.size;
    }

    @Override
    public void addAll(FastSet c) {
        if (c.isEmpty()) {
            return;
        }
        if (this.values == null) {
            this.values = Arrays.copyOf(((FastSetSimple)c).values, c.size());
            this.size = c.size();
            return;
        }
        int newsize = this.size + c.size();
        int[] merge = new int[newsize / 16 * 16 + 16];
        int i = 0;
        int j = 0;
        int index = 0;
        while (i < this.size() && j < c.size()) {
            if (this.values[i] < c.get(j)) {
                merge[index] = this.values[i];
                ++i;
            } else if (c.get(j) < this.values[i]) {
                merge[index] = c.get(j);
                ++j;
            } else if (this.values[i] == c.get(j)) {
                merge[index] = this.values[i];
                ++i;
                ++j;
            }
            ++index;
        }
        if (i < this.size()) {
            while (i < this.size()) {
                merge[index] = this.values[i];
                ++i;
                ++index;
            }
            newsize = index;
        } else {
            while (j < c.size()) {
                merge[index] = c.get(j);
                ++j;
                ++index;
            }
            newsize = index;
        }
        this.values = merge;
        this.size = newsize;
    }

    @Override
    public void clear() {
        this.values = null;
        this.size = 0;
    }

    @Override
    public boolean contains(int o) {
        if (this.values != null) {
            int i = this.insertionIndex(o);
            return i > -1;
        }
        return false;
    }

    @Override
    public boolean containsAll(FastSet c) {
        if (c.isEmpty()) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.size() > this.size) {
            return false;
        }
        if (this.get(0) > c.get(0) || this.get(this.size - 1) < c.get(c.size() - 1)) {
            return false;
        }
        int i = 0;
        for (int j = 0; j < c.size(); ++j) {
            int currentValue = c.get(j);
            boolean found = false;
            while (i < this.size) {
                if (this.get(i) == currentValue) {
                    found = true;
                    break;
                }
                if (this.get(i) > currentValue) {
                    return false;
                }
                ++i;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.values == null;
    }

    @Override
    public boolean containsAny(FastSet c) {
        if (c.isEmpty() || this.size == 0) {
            return false;
        }
        int i = 0;
        block0: for (int j = 0; j < c.size(); ++j) {
            int currentValue = c.get(j);
            while (i < this.size) {
                if (this.get(i) == currentValue) {
                    return true;
                }
                if (this.get(i) > currentValue) continue block0;
                ++i;
            }
        }
        return false;
    }

    @Override
    public void remove(int o) {
        if (this.values == null) {
            return;
        }
        int i = this.insertionIndex(o);
        this.removeAt(i);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int[] toIntArray() {
        if (this.values == null) {
            return new int[0];
        }
        return Arrays.copyOf(this.values, this.size);
    }

    @Override
    public boolean intersect(FastSet f) {
        return this.containsAny(f);
    }

    @Override
    public int hashCode() {
        int hashcode = 0;
        for (int i = 0; i < this.size(); ++i) {
            hashcode += this.values[i];
        }
        return hashcode;
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (this == arg0) {
            return true;
        }
        if (arg0 instanceof FastSet) {
            FastSet arg = (FastSet)arg0;
            if (this.size != arg.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (arg.get(i) == this.get(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void removeAt(int i) {
        if (this.values == null) {
            return;
        }
        if (i > -1 && i < this.size) {
            if (this.size == 1) {
                this.values = null;
                this.size = 0;
                return;
            }
            for (int j = i; j < this.size - 1; ++j) {
                this.values[j] = this.values[j + 1];
            }
            --this.size;
        }
        if (this.size == 0) {
            this.values = null;
        }
    }

    @Override
    public void removeAll(int i, int end) {
        if (this.values == null) {
            return;
        }
        if (end < -1 || end < i || end > this.size || i < -1 || i > this.size) {
            throw new IllegalArgumentException("illegal arguments: " + i + " " + end + " size: " + this.size);
        }
        if (this.size == 1 || i == 0 && end == this.size) {
            this.values = null;
            this.size = 0;
            return;
        }
        if (end == this.size) {
            this.size = i;
        } else {
            int delta = end - i;
            for (int j = i; j < this.size - delta; ++j) {
                this.values[j] = this.values[j + delta];
            }
            this.size -= delta;
        }
        if (this.size == 0) {
            this.values = null;
        }
    }

    @Override
    public void removeAllValues(int ... vals) {
        if (this.values == null) {
            return;
        }
        if (vals.length == 1) {
            this.remove(vals[0]);
            return;
        }
        Arrays.sort(vals);
        int originalsize = this.size;
        int j = 0;
        for (int i = 0; i < originalsize && j < vals.length; ++i) {
            if (this.values[i] != vals[j]) continue;
            this.values[i] = Integer.MAX_VALUE;
            --this.size;
            ++j;
        }
        if (this.size == 0) {
            this.values = null;
        } else {
            Arrays.sort(this.values, 0, originalsize);
        }
    }

    @Override
    public void completeSet(int value) {
        for (int i = 0; i <= value; ++i) {
            this.add(i);
        }
    }
}

