/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeExpression;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facet;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.datatypes.NumericDatatype;
import uk.ac.manchester.cs.jfact.datatypes.NumericDatatypeWrapper;
import uk.ac.manchester.cs.jfact.datatypes.OrderedDatatype;
import uk.ac.manchester.cs.jfact.datatypes.cardinality;
import uk.ac.manchester.cs.jfact.datatypes.ordered;
import uk.ac.manchester.cs.jfact.visitors.DLExpressionVisitor;
import uk.ac.manchester.cs.jfact.visitors.DLExpressionVisitorEx;

public class DatatypeNegation<R extends Comparable<R>>
implements DatatypeExpression<R>,
Serializable {
    private static final long serialVersionUID = 11000L;
    private final Datatype<R> host;
    private final IRI uri = IRI.create((String)("urn:neg" + DatatypeFactory.getIndex()));

    public DatatypeNegation(Datatype<R> d) {
        this.host = d;
    }

    @Override
    public boolean isExpression() {
        return true;
    }

    @Override
    public DatatypeExpression<R> asExpression() {
        return this;
    }

    @Override
    public Collection<Datatype<?>> getAncestors() {
        return this.host.getAncestors();
    }

    @Override
    public boolean getBounded() {
        return this.host.getBounded();
    }

    @Override
    public cardinality getCardinality() {
        return this.host.getCardinality();
    }

    @Override
    public Set<Facet> getFacets() {
        return this.host.getFacets();
    }

    @Override
    public boolean emptyValueSpace() {
        if (this.host.emptyValueSpace()) {
            return false;
        }
        if (this.host.getCardinality() == cardinality.COUNTABLYINFINITE) {
            return false;
        }
        return false;
    }

    @Override
    public Map<Facet, Comparable> getKnownNumericFacetValues() {
        return this.host.getKnownNumericFacetValues();
    }

    @Override
    public Map<Facet, Comparable> getKnownNonNumericFacetValues() {
        return this.host.getKnownNonNumericFacetValues();
    }

    @Override
    public <O extends Comparable<O>> O getFacetValue(Facet<O> f) {
        O o = this.host.getFacetValue(f);
        return o;
    }

    @Override
    public Comparable getNumericFacetValue(Facet f) {
        return this.host.getNumericFacetValue(f);
    }

    @Override
    public boolean getNumeric() {
        return this.host.getNumeric();
    }

    @Override
    public ordered getOrdered() {
        return this.host.getOrdered();
    }

    @Override
    public boolean isCompatible(Literal<?> l) {
        return !this.host.isCompatible(l);
    }

    @Override
    public boolean isInValueSpace(R l) {
        return !this.host.isInValueSpace(l);
    }

    @Override
    public R parseValue(String s) {
        return this.host.parseValue(s);
    }

    @Override
    public Literal<R> buildLiteral(String s) {
        return this.host.buildLiteral(s);
    }

    @Override
    public boolean isSubType(Datatype<?> type) {
        return this.host.isSubType(type);
    }

    @Override
    public IRI getDatatypeIRI() {
        return this.uri;
    }

    @Override
    public boolean isCompatible(Datatype<?> type) {
        if (type instanceof DatatypeNegation) {
            return !this.host.isCompatible(((DatatypeNegation)type).host);
        }
        return !this.host.isCompatible(type);
    }

    @Override
    public boolean isContradictory(Datatype<?> type) {
        return !this.isCompatible(type);
    }

    @Override
    public void accept(DLExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(DLExpressionVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Collection<Literal<R>> listValues() {
        ArrayList<Literal<R>> toReturn = new ArrayList<Literal<R>>(this.host.listValues());
        int i = 0;
        while (i < toReturn.size()) {
            if (this.host.isCompatible((Literal)toReturn.get(i))) {
                toReturn.remove(i);
                continue;
            }
            ++i;
        }
        return toReturn;
    }

    @Override
    public boolean isNumericDatatype() {
        return this.host.isNumericDatatype();
    }

    @Override
    public NumericDatatype<R> asNumericDatatype() {
        return new NumericDatatypeWrapper(this);
    }

    @Override
    public boolean isOrderedDatatype() {
        return this.host.isOrderedDatatype();
    }

    @Override
    public OrderedDatatype<R> asOrderedDatatype() {
        return (OrderedDatatype)((Object)this);
    }

    public String toString() {
        return this.uri + "{" + this.host + "}";
    }

    @Override
    public Datatype<R> getHostType() {
        return this.host.isExpression() ? this.host.asExpression().getHostType() : this.host;
    }

    @Override
    public DatatypeExpression<R> addNumericFacet(Facet f, Comparable<?> value) {
        System.out.println("DatatypeNegation.addFacet() Cannot add a facet to a negation; modify the base type and rebuild a new negation. Returning the same object");
        return this;
    }

    @Override
    public DatatypeExpression<R> addNonNumericFacet(Facet f, Comparable<?> value) {
        System.out.println("DatatypeNegation.addFacet() Cannot add a facet to a negation; modify the base type and rebuild a new negation. Returning the same object");
        return this;
    }

    @Override
    public IRI getName() {
        return IRI.create((String)this.toString());
    }
}

