/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import conformance.Original;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilderFactory;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import uk.ac.manchester.cs.jfact.datatypes.ABSTRACT_DATATYPE;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeExpression;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeExpressionImpl;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeNumericExpressionImpl;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeOrderedExpressionImpl;
import uk.ac.manchester.cs.jfact.datatypes.Facet;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.datatypes.NumericDatatype;
import uk.ac.manchester.cs.jfact.datatypes.NumericDatatypeWrapper;
import uk.ac.manchester.cs.jfact.datatypes.OrderedDatatype;
import uk.ac.manchester.cs.jfact.datatypes.Utils;
import uk.ac.manchester.cs.jfact.datatypes.cardinality;
import uk.ac.manchester.cs.jfact.datatypes.ordered;

@Original
public class DatatypeFactory
implements Serializable {
    private static final long serialVersionUID = 11000L;
    private static final String namespace = "http://www.w3.org/2001/XMLSchema#";
    protected static final Comparable NUMBER_EXPRESSION = "[\\-+]?[0-9]+";
    protected static final Comparable WHITESPACE = Facets.whitespace.collapse;
    protected static final Facet[] minmax = new Facet[]{Facets.maxInclusive, Facets.maxExclusive, Facets.minInclusive, Facets.minExclusive};
    protected static final Facet[] pew = new Facet[]{Facets.pattern, Facets.enumeration, Facets.whiteSpace};
    protected static final Facet[] len = new Facet[]{Facets.length, Facets.minLength, Facets.maxLength};
    protected static final Facet[] digs = new Facet[]{Facets.totalDigits, Facets.fractionDigits};
    protected static final Set<Facet> StringFacets = Utils.getFacets(new Facet[][]{pew, len});
    protected static final Set<Facet> FACETS4 = Utils.getFacets(new Facet[][]{pew, minmax});
    public static final Datatype<String> LITERAL = new LITERAL_DATATYPE();
    public static final Datatype<String> ANYURI = new ANYURI_DATATYPE();
    public static final Datatype<String> BASE64BINARY = new BASE64BINARY_DATATYPE();
    public static final Datatype<Boolean> BOOLEAN = new BOOLEAN_DATATYPE();
    public static final Datatype<Calendar> DATETIME = new DATETIME_DATATYPE();
    public static final Datatype<String> HEXBINARY = new HEXBINARY_DATATYPE();
    public static final Datatype<String> STRING = new STRING_DATATYPE();
    public static final Datatype<String> PLAINLITERAL = new PLAINLITERAL_DATATYPE();
    public static final NumericDatatype<BigDecimal> REAL = new REAL_DATATYPE<BigDecimal>();
    public static final NumericDatatype<BigDecimal> RATIONAL = new RATIONAL_DATATYPE<BigDecimal>();
    public static final Datatype<Calendar> DATETIMESTAMP = new DATETIMESTAMP_DATATYPE();
    public static final NumericDatatype<BigDecimal> DECIMAL = new DECIMAL_DATATYPE<BigDecimal>();
    public static final NumericDatatype<BigInteger> INTEGER = new INTEGER_DATATYPE<BigInteger>();
    public static final NumericDatatype<Double> DOUBLE = new DOUBLE_DATATYPE();
    public static final NumericDatatype<Float> FLOAT = new FLOAT_DATATYPE();
    public static final NumericDatatype<BigInteger> NONPOSITIVEINTEGER = new NONPOSITIVEINTEGER_DATATYPE<BigInteger>();
    public static final NumericDatatype<BigInteger> NEGATIVEINTEGER = new NEGATIVEINTEGER_DATATYPE<BigInteger>();
    public static final NumericDatatype<BigInteger> NONNEGATIVEINTEGER = new NONNEGATIVEINTEGER_DATATYPE<BigInteger>();
    public static final NumericDatatype<BigInteger> POSITIVEINTEGER = new POSITIVEINTEGER_DATATYPE<BigInteger>();
    public static final NumericDatatype<Long> LONG = new LONG_DATATYPE<Long>();
    public static final NumericDatatype<Integer> INT = new INT_DATATYPE<Integer>();
    public static final NumericDatatype<Short> SHORT = new SHORT_DATATYPE<Short>();
    public static final NumericDatatype<Byte> BYTE = new BYTE_DATATYPE();
    public static final NumericDatatype<BigInteger> UNSIGNEDLONG = new UNSIGNEDLONG_DATATYPE<BigInteger>();
    public static final NumericDatatype<Long> UNSIGNEDINT = new UNSIGNEDINT_DATATYPE<Long>();
    public static final NumericDatatype<Integer> UNSIGNEDSHORT = new UNSIGNEDSHORT_DATATYPE<Integer>();
    public static final NumericDatatype<Short> UNSIGNEDBYTE = new UnsignedByteForShort();
    public static final Datatype<String> NORMALIZEDSTRING = new NORMALIZEDSTRING_DATATYPE();
    public static final Datatype<String> TOKEN = new TOKEN_DATATYPE();
    public static final Datatype<String> LANGUAGE = new LANGUAGE_DATATYPE();
    public static final Datatype<String> NAME = new NAME_DATATYPE();
    public static final Datatype<String> NCNAME = new NCNAME_DATATYPE();
    public static final Datatype<String> NMTOKEN = new NMTOKEN_DATATYPE();
    public static final Datatype<String> NMTOKENS = new NMTOKENS_DATATYPE();
    public static final Datatype<String> XMLLITERAL = new XMLLITERAL_DATATYPE();
    private static final List<Datatype<?>> values = DatatypeFactory.getList();
    private final Map<IRI, Datatype<?>> knownDatatypes = new HashMap();
    private static int uri_index = 0;

    private static List<Datatype<?>> getList() {
        ArrayList<Datatype<Object>> toReturn = new ArrayList<Datatype<Object>>();
        toReturn.add(ANYURI);
        toReturn.add(BASE64BINARY);
        toReturn.add(BOOLEAN);
        toReturn.add(DATETIME);
        toReturn.add(HEXBINARY);
        toReturn.add(LITERAL);
        toReturn.add(PLAINLITERAL);
        toReturn.add(REAL);
        toReturn.add(STRING);
        toReturn.add(DATETIMESTAMP);
        toReturn.add(DECIMAL);
        toReturn.add(DOUBLE);
        toReturn.add(FLOAT);
        toReturn.add(BYTE);
        toReturn.add(INT);
        toReturn.add(INTEGER);
        toReturn.add(LONG);
        toReturn.add(NEGATIVEINTEGER);
        toReturn.add(NONNEGATIVEINTEGER);
        toReturn.add(NONPOSITIVEINTEGER);
        toReturn.add(POSITIVEINTEGER);
        toReturn.add(SHORT);
        toReturn.add(UNSIGNEDBYTE);
        toReturn.add(UNSIGNEDINT);
        toReturn.add(UNSIGNEDLONG);
        toReturn.add(UNSIGNEDSHORT);
        toReturn.add(RATIONAL);
        toReturn.add(LANGUAGE);
        toReturn.add(NAME);
        toReturn.add(NCNAME);
        toReturn.add(NMTOKEN);
        toReturn.add(NMTOKENS);
        toReturn.add(NORMALIZEDSTRING);
        toReturn.add(TOKEN);
        toReturn.add(XMLLITERAL);
        return Collections.unmodifiableList(toReturn);
    }

    public static List<Datatype<?>> getValues() {
        return values;
    }

    public Collection<Datatype<?>> getKnownDatatypes() {
        return new ArrayList(this.knownDatatypes.values());
    }

    static int getIndex() {
        return uri_index++;
    }

    private DatatypeFactory() {
        for (Datatype<?> d : values) {
            this.knownDatatypes.put(d.getDatatypeIRI(), d);
        }
        this.knownDatatypes.put(XSDVocabulary.DATE.getIRI(), DATETIME);
    }

    public Datatype<?> getKnownDatatype(IRI key) {
        return this.knownDatatypes.get(key);
    }

    public boolean isKnownDatatype(IRI key) {
        return this.knownDatatypes.containsKey(key);
    }

    public static DatatypeFactory getInstance() {
        return new DatatypeFactory();
    }

    public static boolean nonEmptyInterval(Comparable min, Comparable max, int excluded) {
        if (min == null) {
            return false;
        }
        if (max == null) {
            return false;
        }
        int comparison = min.compareTo(max);
        if (excluded == 0) {
            return comparison <= 0;
        }
        if (excluded == 1) {
            return comparison < 0;
        }
        if (excluded == 2) {
            Comparable increased = DatatypeFactory.increase((Number)((Object)min));
            int compareTo = increased.compareTo(max);
            return compareTo < 0;
        }
        return false;
    }

    public static Comparable increase(Number v) {
        if (v instanceof Float) {
            return Float.valueOf(v.floatValue() + Float.MIN_NORMAL);
        }
        if (v instanceof BigDecimal) {
            return ((BigDecimal)v).add(((BigDecimal)v).ulp());
        }
        if (v instanceof BigInteger) {
            return ((BigInteger)v).add(BigInteger.ONE);
        }
        if (v instanceof Double) {
            return Double.valueOf(v.doubleValue() + Double.MIN_NORMAL);
        }
        if (v instanceof Byte) {
            int i = v.byteValue() + 1;
            return Byte.valueOf((byte)i);
        }
        if (v instanceof Integer) {
            return Integer.valueOf(v.intValue() + 1);
        }
        if (v instanceof Long) {
            return Long.valueOf(v.longValue() + 1L);
        }
        if (v instanceof Short) {
            int i = v.shortValue() + 1;
            return Short.valueOf((short)i);
        }
        if (v instanceof AtomicInteger) {
            return Integer.valueOf(((AtomicInteger)v).get() + 1);
        }
        if (v instanceof AtomicLong) {
            return Long.valueOf(((AtomicLong)v).get() + 1L);
        }
        return null;
    }

    public static <R extends Comparable<R>> DatatypeExpression<R> getDatatypeExpression(Datatype<R> base) {
        return new DatatypeExpressionImpl<R>(base);
    }

    public static <R extends Comparable<R>> DatatypeExpression<R> getNumericDatatypeExpression(NumericDatatype<R> base) {
        return new DatatypeNumericExpressionImpl<R>(base);
    }

    public static <R extends Comparable<R>> DatatypeExpression<R> getOrderedDatatypeExpression(Datatype<R> base) {
        return new DatatypeOrderedExpressionImpl<R>(base);
    }

    public static String getNamespace() {
        return namespace;
    }

    static class XMLLITERAL_DATATYPE
    extends ABSTRACT_DATATYPE<String> {
        private static final long serialVersionUID = 11000L;

        protected XMLLITERAL_DATATYPE() {
            super(IRI.create((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#", (String)"XMLLiteral"), Collections.emptySet());
            this.ancestors = Utils.generateAncestors(LITERAL);
            this.knownNonNumericFacetValues.putAll(LITERAL.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(LITERAL.getKnownNumericFacetValues());
        }

        @Override
        public String parseValue(String s) {
            return Facets.whitespace.collapse.normalize(s);
        }

        @Override
        public boolean isInValueSpace(String l) {
            try {
                DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(l.getBytes()));
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    static class TOKEN_DATATYPE
    extends NORMALIZEDSTRING_DATATYPE {
        private static final long serialVersionUID = 11000L;

        protected TOKEN_DATATYPE() {
            this(XSDVocabulary.TOKEN.getIRI());
        }

        protected TOKEN_DATATYPE(IRI uri) {
            super(uri);
            this.ancestors = Utils.generateAncestors(NORMALIZEDSTRING);
            this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
        }
    }

    static class NORMALIZEDSTRING_DATATYPE
    extends STRING_DATATYPE {
        private static final long serialVersionUID = 11000L;

        protected NORMALIZEDSTRING_DATATYPE() {
            this(XSDVocabulary.NORMALIZED_STRING.getIRI());
        }

        protected NORMALIZEDSTRING_DATATYPE(IRI uri) {
            super(uri);
            this.ancestors = Utils.generateAncestors(STRING);
            this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, Facets.whitespace.replace);
        }
    }

    static class NMTOKENS_DATATYPE
    extends NMTOKEN_DATATYPE {
        private static final long serialVersionUID = 11000L;

        protected NMTOKENS_DATATYPE() {
            super(IRI.create((String)DatatypeFactory.namespace, (String)"NMTOKENS"));
            this.ancestors = Utils.generateAncestors(NMTOKEN);
            this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
            this.knownNonNumericFacetValues.put(Facets.minLength, 1);
        }
    }

    static class NMTOKEN_DATATYPE
    extends TOKEN_DATATYPE {
        private static final long serialVersionUID = 11000L;

        protected NMTOKEN_DATATYPE() {
            this(XSDVocabulary.NMTOKEN.getIRI());
        }

        protected NMTOKEN_DATATYPE(IRI uri) {
            super(uri);
            this.ancestors = Utils.generateAncestors(TOKEN);
            this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
            this.knownNonNumericFacetValues.put(Facets.pattern, "\\c+");
        }

        @Override
        public IRI getDatatypeIRI() {
            return this.uri;
        }
    }

    static class NCNAME_DATATYPE
    extends NAME_DATATYPE {
        private static final long serialVersionUID = 11000L;

        protected NCNAME_DATATYPE() {
            super(XSDVocabulary.NCNAME.getIRI());
            this.ancestors = Utils.generateAncestors(NAME);
            this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
            this.knownNonNumericFacetValues.put(Facets.pattern, "[\\i-[:]][\\c-[:]]*");
        }

        @Override
        public IRI getDatatypeIRI() {
            return this.uri;
        }
    }

    static class NAME_DATATYPE
    extends TOKEN_DATATYPE {
        private static final long serialVersionUID = 11000L;

        public NAME_DATATYPE() {
            this(XSDVocabulary.NAME.getIRI());
        }

        protected NAME_DATATYPE(IRI uri) {
            super(uri);
            this.ancestors = Utils.generateAncestors(TOKEN);
            this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
            this.knownNonNumericFacetValues.put(Facets.pattern, "\\i\\c*");
        }
    }

    static class LANGUAGE_DATATYPE
    extends TOKEN_DATATYPE {
        private static final long serialVersionUID = 11000L;

        protected LANGUAGE_DATATYPE() {
            super(XSDVocabulary.LANGUAGE.getIRI());
            this.ancestors = Utils.generateAncestors(TOKEN);
            this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
            this.knownNonNumericFacetValues.put(Facets.pattern, "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*");
        }
    }

    static class RATIONAL_DATATYPE<R extends Comparable<R>>
    extends REAL_DATATYPE<R> {
        private static final long serialVersionUID = 11000L;

        protected RATIONAL_DATATYPE(IRI uri, Set<Facet> f) {
            super(uri, f);
            this.ancestors = Utils.generateAncestors(REAL);
            this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
        }

        protected RATIONAL_DATATYPE() {
            this(IRI.create((String)"http://www.w3.org/2002/07/owl#", (String)"rational"));
        }

        protected RATIONAL_DATATYPE(IRI uri) {
            super(uri);
            this.ancestors = Utils.generateAncestors(REAL);
            this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
        }

        @Override
        public R parseValue(String s) {
            return (R)new BigDecimal(s);
        }
    }

    private static class UnsignedByteForShort
    extends UNSIGNEDBYTE_DATATYPE<Short> {
        private static final long serialVersionUID = 11000L;

        @Override
        public Short parseValue(String s) {
            short parseByte = Short.parseShort(s);
            if (parseByte < 0) {
                throw new ArithmeticException("Unsigned short required, but found: " + s);
            }
            return parseByte;
        }
    }

    static class UNSIGNEDSHORT_DATATYPE<R extends Comparable<R>>
    extends UNSIGNEDINT_DATATYPE<R> {
        private static final long serialVersionUID = 11000L;

        protected UNSIGNEDSHORT_DATATYPE() {
            this(XSDVocabulary.UNSIGNED_SHORT.getIRI());
        }

        protected UNSIGNEDSHORT_DATATYPE(IRI uri) {
            super(uri);
            this.ancestors = Utils.generateAncestors(UNSIGNEDINT);
            this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
            this.knownNonNumericFacetValues.put(Facets.pattern, NUMBER_EXPRESSION);
            this.knownNumericFacetValues.put(Facets.minInclusive, BigDecimal.ZERO);
            this.knownNumericFacetValues.put(Facets.maxInclusive, new BigDecimal(65535));
        }

        @Override
        public R parseValue(String s) {
            Integer parseShort = Integer.valueOf(s);
            if (parseShort < 0) {
                throw new ArithmeticException("Unsigned short required, but found: " + s);
            }
            return (R)parseShort;
        }
    }

    static class UNSIGNEDLONG_DATATYPE<R extends Comparable<R>>
    extends NONNEGATIVEINTEGER_DATATYPE<R> {
        private static final long serialVersionUID = 11000L;

        protected UNSIGNEDLONG_DATATYPE() {
            this(XSDVocabulary.UNSIGNED_LONG.getIRI());
        }

        protected UNSIGNEDLONG_DATATYPE(IRI uri) {
            super(uri);
            this.ancestors = Utils.generateAncestors(NONNEGATIVEINTEGER);
            this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
            this.knownNonNumericFacetValues.put(Facets.pattern, NUMBER_EXPRESSION);
            this.knownNumericFacetValues.put(Facets.minInclusive, BigDecimal.ZERO);
            this.knownNumericFacetValues.put(Facets.maxInclusive, new BigDecimal("18446744073709551615"));
        }

        @Override
        public R parseValue(String s) {
            BigInteger b = new BigInteger(s);
            if (b.compareTo(BigInteger.ZERO) < 0) {
                throw new ArithmeticException("Unsigned long required, but found: " + s);
            }
            return (R)b;
        }

        @Override
        public boolean getBounded() {
            return true;
        }

        @Override
        public cardinality getCardinality() {
            return cardinality.FINITE;
        }
    }

    static class UNSIGNEDINT_DATATYPE<R extends Comparable<R>>
    extends UNSIGNEDLONG_DATATYPE<R> {
        private static final long serialVersionUID = 11000L;

        protected UNSIGNEDINT_DATATYPE() {
            this(XSDVocabulary.UNSIGNED_INT.getIRI());
        }

        protected UNSIGNEDINT_DATATYPE(IRI uri) {
            super(uri);
            this.ancestors = Utils.generateAncestors(UNSIGNEDLONG);
            this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
            this.knownNonNumericFacetValues.put(Facets.pattern, NUMBER_EXPRESSION);
            this.knownNumericFacetValues.put(Facets.minInclusive, new BigDecimal(0L));
            this.knownNumericFacetValues.put(Facets.maxInclusive, new BigDecimal(0xFFFFFFFFL));
        }

        @Override
        public R parseValue(String s) {
            Long parseInt = Long.valueOf(s);
            if (parseInt < 0L) {
                throw new ArithmeticException("Unsigned int required, but found: " + s);
            }
            return (R)parseInt;
        }
    }

    static abstract class UNSIGNEDBYTE_DATATYPE<R extends Comparable<R>>
    extends UNSIGNEDSHORT_DATATYPE<R> {
        private static final long serialVersionUID = 11000L;

        protected UNSIGNEDBYTE_DATATYPE() {
            super(XSDVocabulary.UNSIGNED_BYTE.getIRI());
            this.ancestors = Utils.generateAncestors(UNSIGNEDSHORT);
            this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
            this.knownNonNumericFacetValues.put(Facets.pattern, NUMBER_EXPRESSION);
            this.knownNumericFacetValues.put(Facets.minInclusive, new BigDecimal(0));
            this.knownNumericFacetValues.put(Facets.maxInclusive, new BigDecimal(255));
        }
    }

    static class SHORT_DATATYPE<R extends Comparable<R>>
    extends INT_DATATYPE<R> {
        private static final long serialVersionUID = 11000L;

        protected SHORT_DATATYPE() {
            this(XSDVocabulary.SHORT.getIRI());
        }

        protected SHORT_DATATYPE(IRI uri) {
            super(uri);
            this.ancestors = Utils.generateAncestors(INT);
            this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
            this.knownNonNumericFacetValues.put(Facets.pattern, NUMBER_EXPRESSION);
            this.knownNumericFacetValues.put(Facets.minInclusive, new BigDecimal(Short.MIN_VALUE));
            this.knownNumericFacetValues.put(Facets.maxInclusive, new BigDecimal(Short.MAX_VALUE));
        }

        @Override
        public R parseValue(String s) {
            return (R)Short.valueOf(s);
        }
    }

    static class POSITIVEINTEGER_DATATYPE<R extends Comparable<R>>
    extends NONNEGATIVEINTEGER_DATATYPE<R> {
        private static final long serialVersionUID = 11000L;

        protected POSITIVEINTEGER_DATATYPE() {
            super(XSDVocabulary.POSITIVE_INTEGER.getIRI());
            this.ancestors = Utils.generateAncestors(NONNEGATIVEINTEGER);
            this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
            this.knownNonNumericFacetValues.put(Facets.pattern, NUMBER_EXPRESSION);
            this.knownNumericFacetValues.put(Facets.minInclusive, new BigDecimal(1L));
        }

        @Override
        public R parseValue(String s) {
            BigInteger parseValue = new BigInteger(s);
            if (parseValue.compareTo(BigInteger.ZERO) <= 0) {
                throw new ArithmeticException("Positive integer required, but found: " + s);
            }
            return (R)parseValue;
        }
    }

    static class NONPOSITIVEINTEGER_DATATYPE<R extends Comparable<R>>
    extends INTEGER_DATATYPE<R> {
        private static final long serialVersionUID = 11000L;

        protected NONPOSITIVEINTEGER_DATATYPE() {
            this(XSDVocabulary.NON_POSITIVE_INTEGER.getIRI());
        }

        protected NONPOSITIVEINTEGER_DATATYPE(IRI uri) {
            super(uri);
            this.ancestors = Utils.generateAncestors(INTEGER);
            this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
            this.knownNonNumericFacetValues.put(Facets.pattern, NUMBER_EXPRESSION);
            this.knownNumericFacetValues.put(Facets.maxInclusive, new BigDecimal(0L));
        }

        @Override
        public R parseValue(String s) {
            BigInteger parse = new BigInteger(s);
            if (parse.compareTo(BigInteger.ZERO) > 0) {
                throw new ArithmeticException("Non positive integer required, but found: " + s);
            }
            return (R)parse;
        }
    }

    static class NONNEGATIVEINTEGER_DATATYPE<R extends Comparable<R>>
    extends INTEGER_DATATYPE<R> {
        private static final long serialVersionUID = 11000L;

        protected NONNEGATIVEINTEGER_DATATYPE() {
            this(XSDVocabulary.NON_NEGATIVE_INTEGER.getIRI());
        }

        protected NONNEGATIVEINTEGER_DATATYPE(IRI uri) {
            super(uri);
            this.ancestors = Utils.generateAncestors(INTEGER);
            this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
            this.knownNonNumericFacetValues.put(Facets.pattern, NUMBER_EXPRESSION);
            this.knownNumericFacetValues.put(Facets.minInclusive, new BigDecimal(0L));
        }

        @Override
        public R parseValue(String s) {
            BigInteger parseValue = new BigInteger(s);
            if (parseValue.compareTo(BigInteger.ZERO) < 0) {
                throw new ArithmeticException("Non negative integer required, but found: " + s);
            }
            return (R)parseValue;
        }
    }

    static class NEGATIVEINTEGER_DATATYPE<R extends Comparable<R>>
    extends NONPOSITIVEINTEGER_DATATYPE<R> {
        private static final long serialVersionUID = 11000L;

        protected NEGATIVEINTEGER_DATATYPE() {
            super(XSDVocabulary.NEGATIVE_INTEGER.getIRI());
            this.ancestors = Utils.generateAncestors(NONPOSITIVEINTEGER);
            this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
            this.knownNonNumericFacetValues.put(Facets.pattern, NUMBER_EXPRESSION);
            this.knownNumericFacetValues.put(Facets.maxInclusive, new BigDecimal(-1L));
        }

        @Override
        public R parseValue(String s) {
            BigInteger parse = new BigInteger(s);
            if (parse.compareTo(new BigInteger("-1")) > 0) {
                throw new ArithmeticException("Negative integer required, but found: " + s);
            }
            return (R)parse;
        }
    }

    static class LONG_DATATYPE<R extends Comparable<R>>
    extends INTEGER_DATATYPE<R> {
        private static final long serialVersionUID = 11000L;

        protected LONG_DATATYPE() {
            this(XSDVocabulary.LONG.getIRI());
        }

        protected LONG_DATATYPE(IRI uri) {
            super(uri);
            this.ancestors = Utils.generateAncestors(INTEGER);
            this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
            this.knownNonNumericFacetValues.put(Facets.pattern, NUMBER_EXPRESSION);
            this.knownNumericFacetValues.put(Facets.minInclusive, new BigDecimal(Long.MIN_VALUE));
            this.knownNumericFacetValues.put(Facets.maxInclusive, new BigDecimal(Long.MAX_VALUE));
        }

        @Override
        public R parseValue(String s) {
            return (R)Long.valueOf(s);
        }

        @Override
        public boolean getBounded() {
            return true;
        }

        @Override
        public cardinality getCardinality() {
            return cardinality.FINITE;
        }
    }

    static class INTEGER_DATATYPE<R extends Comparable<R>>
    extends DECIMAL_DATATYPE<R> {
        private static final long serialVersionUID = 11000L;

        protected INTEGER_DATATYPE() {
            this(XSDVocabulary.INTEGER.getIRI());
        }

        protected INTEGER_DATATYPE(IRI uri) {
            super(uri);
            this.ancestors = Utils.generateAncestors(DECIMAL);
            this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
            this.knownNonNumericFacetValues.put(Facets.pattern, NUMBER_EXPRESSION);
            this.knownNonNumericFacetValues.put(Facets.fractionDigits, 0);
        }

        @Override
        public R parseValue(String s) {
            return (R)new BigInteger(s);
        }
    }

    static class INT_DATATYPE<R extends Comparable<R>>
    extends LONG_DATATYPE<R> {
        private static final long serialVersionUID = 11000L;

        protected INT_DATATYPE() {
            this(XSDVocabulary.INT.getIRI());
        }

        protected INT_DATATYPE(IRI uri) {
            super(uri);
            this.ancestors = Utils.generateAncestors(LONG);
            this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
            this.knownNonNumericFacetValues.put(Facets.pattern, NUMBER_EXPRESSION);
            this.knownNumericFacetValues.put(Facets.minInclusive, new BigDecimal(Integer.MIN_VALUE));
            this.knownNumericFacetValues.put(Facets.maxInclusive, new BigDecimal(Integer.MAX_VALUE));
        }

        @Override
        public R parseValue(String s) {
            return (R)Integer.valueOf(s);
        }
    }

    static class BYTE_DATATYPE
    extends SHORT_DATATYPE<Byte> {
        private static final long serialVersionUID = 11000L;

        protected BYTE_DATATYPE() {
            super(XSDVocabulary.BYTE.getIRI());
            this.ancestors = Utils.generateAncestors(SHORT);
            this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
            this.knownNonNumericFacetValues.put(Facets.pattern, NUMBER_EXPRESSION);
            this.knownNumericFacetValues.put(Facets.minInclusive, new BigDecimal(-128));
            this.knownNumericFacetValues.put(Facets.maxInclusive, new BigDecimal(127));
        }

        @Override
        public Byte parseValue(String s) {
            return Byte.parseByte(s);
        }
    }

    static class FLOAT_DATATYPE
    extends ABSTRACT_NUMERIC_DATATYPE<Float> {
        private static final long serialVersionUID = 11000L;

        protected FLOAT_DATATYPE() {
            super(XSDVocabulary.FLOAT.getIRI(), FACETS4);
            this.ancestors = Utils.generateAncestors(LITERAL);
            this.knownNonNumericFacetValues.putAll(LITERAL.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(LITERAL.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
        }

        @Override
        public boolean getBounded() {
            return true;
        }

        @Override
        public cardinality getCardinality() {
            return cardinality.FINITE;
        }

        @Override
        public boolean getNumeric() {
            return true;
        }

        @Override
        public Float parseValue(String s) {
            String trim = s.trim();
            if (trim.equals("-INF")) {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
            if (trim.equals("INF")) {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
            return Float.valueOf(Float.parseFloat(s));
        }

        @Override
        public boolean isCompatible(Datatype<?> type) {
            if (type.isExpression()) {
                type = type.asExpression().getHostType();
            }
            return type.equals(this) || type.equals(LITERAL) || type.isSubType(this) || this.isSubType(type);
        }

        @Override
        public boolean emptyValueSpace() {
            if (!this.hasMin() || !this.hasMax()) {
                return false;
            }
            if (this.hasMaxExclusive() && this.hasMinExclusive()) {
                if (((Float)this.getMin()).compareTo((Float)this.getMax()) == 0) {
                    return true;
                }
                return ((Float)this.getMax()).compareTo((Float)DatatypeFactory.increase((Number)this.getMin())) < 0;
            }
            return ((Float)this.getMax()).compareTo((Float)this.getMin()) < 0;
        }
    }

    static class DOUBLE_DATATYPE
    extends ABSTRACT_NUMERIC_DATATYPE<Double> {
        private static final long serialVersionUID = 11000L;

        DOUBLE_DATATYPE() {
            super(XSDVocabulary.DOUBLE.getIRI(), Utils.getFacets(new Facet[][]{pew, minmax}));
            this.ancestors = Utils.generateAncestors(LITERAL);
            this.knownNonNumericFacetValues.putAll(LITERAL.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(LITERAL.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
        }

        @Override
        public boolean getBounded() {
            return true;
        }

        @Override
        public cardinality getCardinality() {
            return cardinality.FINITE;
        }

        @Override
        public boolean getNumeric() {
            return true;
        }

        @Override
        public Double parseValue(String s) {
            return Double.parseDouble(s);
        }

        @Override
        public boolean isCompatible(Datatype<?> type) {
            if (type.isExpression()) {
                type = type.asExpression().getHostType();
            }
            return type.equals(this) || type.equals(LITERAL) || type.isSubType(this) || this.isSubType(type);
        }
    }

    static class DECIMAL_DATATYPE<R extends Comparable<R>>
    extends RATIONAL_DATATYPE<R> {
        private static final long serialVersionUID = 11000L;

        DECIMAL_DATATYPE() {
            this(XSDVocabulary.DECIMAL.getIRI());
        }

        DECIMAL_DATATYPE(IRI uri) {
            super(uri, Utils.getFacets(new Facet[][]{digs, pew, minmax}));
            this.ancestors = Utils.generateAncestors(RATIONAL);
            this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
        }

        @Override
        public R parseValue(String s) {
            return (R)new BigDecimal(s);
        }

        @Override
        public ordered getOrdered() {
            return ordered.TOTAL;
        }
    }

    static class DATETIMESTAMP_DATATYPE
    extends DATETIME_DATATYPE {
        private static final long serialVersionUID = 11000L;

        DATETIMESTAMP_DATATYPE() {
            super(XSDVocabulary.DATE_TIME_STAMP.getIRI());
            this.ancestors = Utils.generateAncestors(DATETIME);
        }
    }

    static class STRING_DATATYPE
    extends ABSTRACT_DATATYPE<String> {
        private static final long serialVersionUID = 11000L;

        public STRING_DATATYPE() {
            this(XSDVocabulary.STRING.getIRI());
        }

        STRING_DATATYPE(IRI uri) {
            super(uri, StringFacets);
            this.ancestors = Utils.generateAncestors(LITERAL);
            this.knownNonNumericFacetValues.putAll(LITERAL.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(LITERAL.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, Facets.whitespace.preserve);
        }

        @Override
        public String parseValue(String s) {
            return s;
        }
    }

    static class REAL_DATATYPE<R extends Comparable<R>>
    extends ABSTRACT_NUMERIC_DATATYPE<R> {
        private static final long serialVersionUID = 11000L;

        public REAL_DATATYPE() {
            this(IRI.create((String)"http://www.w3.org/2002/07/owl#", (String)"real"));
        }

        REAL_DATATYPE(IRI uri) {
            this(uri, Utils.getFacets(minmax));
        }

        REAL_DATATYPE(IRI uri, Set<Facet> f) {
            super(uri, f);
            this.ancestors = Utils.generateAncestors(LITERAL);
            this.knownNonNumericFacetValues.putAll(LITERAL.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(LITERAL.getKnownNumericFacetValues());
        }

        @Override
        public R parseValue(String s) {
            return (R)new BigDecimal(s);
        }

        @Override
        public boolean isInValueSpace(R l) {
            Comparable input;
            Comparable v;
            if (this.knownNumericFacetValues.containsKey(Facets.minExclusive)) {
                v = this.getNumericFacetValue(Facets.minExclusive);
                input = Facets.minExclusive.parseNumber(l);
                if (input.compareTo((Comparable)v) <= 0) {
                    return false;
                }
            }
            if (this.knownNumericFacetValues.containsKey(Facets.minInclusive)) {
                v = this.getNumericFacetValue(Facets.minInclusive);
                input = Facets.minInclusive.parseNumber(l);
                if (input.compareTo((Comparable)v) < 0) {
                    return false;
                }
            }
            if (this.knownNumericFacetValues.containsKey(Facets.maxInclusive)) {
                v = this.getNumericFacetValue(Facets.maxInclusive);
                input = Facets.maxInclusive.parseNumber(l);
                if (input.compareTo((Comparable)v) > 0) {
                    return false;
                }
            }
            if (this.knownNumericFacetValues.containsKey(Facets.maxExclusive)) {
                v = this.getNumericFacetValue(Facets.maxExclusive);
                input = Facets.maxExclusive.parseNumber(l);
                if (input.compareTo((Comparable)v) >= 0) {
                    return false;
                }
            }
            return true;
        }
    }

    static class PLAINLITERAL_DATATYPE
    extends ABSTRACT_DATATYPE<String> {
        private static final long serialVersionUID = 11000L;

        PLAINLITERAL_DATATYPE() {
            super(OWLRDFVocabulary.RDF_PLAIN_LITERAL.getIRI(), Utils.getFacets(Facets.length, Facets.minLength, Facets.maxLength, Facets.pattern, Facets.enumeration));
            this.ancestors = Utils.generateAncestors(LITERAL);
            this.knownNonNumericFacetValues.putAll(LITERAL.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(LITERAL.getKnownNumericFacetValues());
        }

        @Override
        public String parseValue(String s) {
            return s;
        }
    }

    static class LITERAL_DATATYPE
    extends ABSTRACT_DATATYPE<String> {
        private static final long serialVersionUID = 11000L;

        LITERAL_DATATYPE() {
            super(OWLRDFVocabulary.RDFS_LITERAL.getIRI(), Collections.emptySet());
            this.ancestors = Collections.emptySet();
        }

        @Override
        public String parseValue(String s) {
            return s;
        }
    }

    static class HEXBINARY_DATATYPE
    extends ABSTRACT_DATATYPE<String> {
        private static final long serialVersionUID = 11000L;

        HEXBINARY_DATATYPE() {
            super(XSDVocabulary.HEX_BINARY.getIRI(), StringFacets);
            this.ancestors = Utils.generateAncestors(LITERAL);
            this.knownNonNumericFacetValues.putAll(LITERAL.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(LITERAL.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
        }

        @Override
        public String parseValue(String s) {
            return Facets.whitespace.collapse.normalize(s);
        }

        @Override
        public boolean isInValueSpace(String s) {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (Character.isDigit(c) || "ABCDEF".indexOf(c) != -1) continue;
                return false;
            }
            return true;
        }
    }

    static class DATETIME_DATATYPE
    extends ABSTRACT_DATATYPE<Calendar>
    implements OrderedDatatype<Calendar> {
        private static final long serialVersionUID = 11000L;

        DATETIME_DATATYPE() {
            this(XSDVocabulary.DATE_TIME.getIRI());
        }

        DATETIME_DATATYPE(IRI u) {
            super(u, FACETS4);
            this.ancestors = Utils.generateAncestors(LITERAL);
            this.knownNonNumericFacetValues.putAll(LITERAL.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(LITERAL.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
        }

        @Override
        public ordered getOrdered() {
            return ordered.PARTIAL;
        }

        @Override
        public boolean isOrderedDatatype() {
            return true;
        }

        @Override
        public OrderedDatatype<Calendar> asOrderedDatatype() {
            return this;
        }

        @Override
        public Calendar parseValue(String s) {
            try {
                XMLGregorianCalendar cal = javax.xml.datatype.DatatypeFactory.newInstance().newXMLGregorianCalendar(s);
                return cal.normalize().toGregorianCalendar();
            }
            catch (DatatypeConfigurationException e) {
                throw new ReasonerInternalException((Throwable)e);
            }
        }

        @Override
        public boolean isInValueSpace(Calendar l) {
            if (this.hasMinExclusive() && this.getMin().compareTo(l) <= 0) {
                return false;
            }
            if (this.hasMinInclusive() && this.getMin().compareTo(l) < 0) {
                return false;
            }
            if (this.hasMaxExclusive() && this.getMax().compareTo(l) >= 0) {
                return false;
            }
            return !this.hasMaxInclusive() || this.getMax().compareTo(l) <= 0;
        }

        @Override
        public boolean isCompatible(Datatype<?> type) {
            if (super.isCompatible(type)) {
                return true;
            }
            if (type.isSubType(this)) {
                OrderedDatatype wrapper = (OrderedDatatype)((Object)type);
                if (!this.hasMax() && !this.hasMin()) {
                    return true;
                }
                if (!wrapper.hasMax() && !wrapper.hasMin()) {
                    return true;
                }
                if (!this.hasMax() && !wrapper.hasMax()) {
                    return true;
                }
                if (!this.hasMin() && !wrapper.hasMin()) {
                    return true;
                }
                if (!this.hasMin()) {
                    return this.overlapping(this, wrapper);
                }
                if (!this.hasMax()) {
                    return this.overlapping(wrapper, this);
                }
                if (!wrapper.hasMin()) {
                    return this.overlapping(wrapper, this);
                }
                if (!wrapper.hasMax()) {
                    return this.overlapping(this, wrapper);
                }
                return this.overlapping(this, wrapper) || this.overlapping(wrapper, this);
            }
            return false;
        }

        @Override
        public boolean hasMinExclusive() {
            return this.knownNumericFacetValues.containsKey(Facets.minExclusive);
        }

        @Override
        public boolean hasMinInclusive() {
            return this.knownNumericFacetValues.containsKey(Facets.minInclusive);
        }

        @Override
        public boolean hasMaxExclusive() {
            return this.knownNumericFacetValues.containsKey(Facets.maxExclusive);
        }

        @Override
        public boolean hasMaxInclusive() {
            return this.knownNumericFacetValues.containsKey(Facets.maxInclusive);
        }

        @Override
        public boolean hasMin() {
            return this.hasMinInclusive() || this.hasMinExclusive();
        }

        @Override
        public boolean hasMax() {
            return this.hasMaxInclusive() || this.hasMaxExclusive();
        }

        @Override
        public Calendar getMin() {
            if (this.hasMinExclusive()) {
                return (Calendar)this.getFacetValue(Facets.minExclusive);
            }
            if (this.hasMinInclusive()) {
                return (Calendar)this.getFacetValue(Facets.minInclusive);
            }
            return null;
        }

        @Override
        public Calendar getMax() {
            if (this.hasMaxExclusive()) {
                return (Calendar)this.getFacetValue(Facets.maxExclusive);
            }
            if (this.hasMaxInclusive()) {
                return (Calendar)this.getFacetValue(Facets.maxInclusive);
            }
            return null;
        }
    }

    static class BOOLEAN_DATATYPE
    extends ABSTRACT_DATATYPE<Boolean> {
        private static final long serialVersionUID = 11000L;

        BOOLEAN_DATATYPE() {
            super(XSDVocabulary.BOOLEAN.getIRI(), Utils.getFacets(Facets.pattern, Facets.whiteSpace));
            this.ancestors = Utils.generateAncestors(LITERAL);
            this.knownNonNumericFacetValues.putAll(LITERAL.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(LITERAL.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
        }

        @Override
        public cardinality getCardinality() {
            return cardinality.FINITE;
        }

        @Override
        public Collection<Literal<Boolean>> listValues() {
            ArrayList<Literal<Boolean>> toReturn = new ArrayList<Literal<Boolean>>(2);
            toReturn.add(this.buildLiteral(Boolean.toString(true)));
            toReturn.add(this.buildLiteral(Boolean.toString(false)));
            return toReturn;
        }

        @Override
        public Boolean parseValue(String s) {
            Facets.whitespace facet = (Facets.whitespace)((Object)Facets.whiteSpace.parse(this.knownNonNumericFacetValues.get(Facets.whiteSpace)));
            return Boolean.parseBoolean(facet.normalize(s));
        }
    }

    static class BASE64BINARY_DATATYPE
    extends ABSTRACT_DATATYPE<String> {
        private static final long serialVersionUID = 11000L;

        BASE64BINARY_DATATYPE() {
            super(XSDVocabulary.BASE_64_BINARY.getIRI(), StringFacets);
            this.ancestors = Utils.generateAncestors(LITERAL);
            this.knownNonNumericFacetValues.putAll(LITERAL.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(LITERAL.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, Facets.whitespace.collapse);
        }

        @Override
        public String parseValue(String s) {
            return Facets.whitespace.collapse.normalize(s);
        }

        @Override
        public boolean isInValueSpace(String s) {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (Character.isLetter(c) || Character.isDigit(c) || "+/=".indexOf(c) != -1) continue;
                return false;
            }
            return true;
        }
    }

    static class ANYURI_DATATYPE
    extends ABSTRACT_DATATYPE<String> {
        private static final long serialVersionUID = 11000L;

        ANYURI_DATATYPE() {
            super(XSDVocabulary.ANY_URI.getIRI(), StringFacets);
            this.ancestors = Utils.generateAncestors(LITERAL);
            this.knownNonNumericFacetValues.putAll(LITERAL.getKnownNonNumericFacetValues());
            this.knownNumericFacetValues.putAll(LITERAL.getKnownNumericFacetValues());
            this.knownNonNumericFacetValues.put(Facets.whiteSpace, WHITESPACE);
        }

        @Override
        public String parseValue(String s) {
            return Facets.whitespace.collapse.normalize(s);
        }

        @Override
        public boolean isInValueSpace(String l) {
            try {
                URI.create(l);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
    }

    static abstract class ABSTRACT_NUMERIC_DATATYPE<R extends Comparable<R>>
    extends ABSTRACT_DATATYPE<R>
    implements NumericDatatype<R> {
        private static final long serialVersionUID = 11000L;

        public ABSTRACT_NUMERIC_DATATYPE(IRI uri, Set<Facet> f) {
            super(uri, f);
        }

        @Override
        public boolean getNumeric() {
            return true;
        }

        @Override
        public boolean isNumericDatatype() {
            return true;
        }

        @Override
        public NumericDatatype<R> asNumericDatatype() {
            return this;
        }

        @Override
        public boolean isOrderedDatatype() {
            return true;
        }

        @Override
        public OrderedDatatype<R> asOrderedDatatype() {
            return this;
        }

        @Override
        public ordered getOrdered() {
            return ordered.PARTIAL;
        }

        @Override
        public boolean isInValueSpace(R _l) {
            R l;
            if (this.hasMinExclusive() && (l = Facets.minExclusive.parseNumber(_l)).compareTo(this.getMin()) <= 0) {
                return false;
            }
            if (this.hasMinInclusive() && (l = Facets.minExclusive.parseNumber(_l)).compareTo(this.getMin()) < 0) {
                return false;
            }
            if (this.hasMaxExclusive() && (l = Facets.minExclusive.parseNumber(_l)).compareTo(this.getMax()) >= 0) {
                return false;
            }
            return !this.hasMaxInclusive() || (l = Facets.minExclusive.parseNumber(_l)).compareTo(this.getMax()) <= 0;
        }

        @Override
        public boolean isCompatible(Datatype<?> type) {
            if (type.equals(LITERAL)) {
                return true;
            }
            if (type.getNumeric()) {
                if (type.equals(FLOAT) || type.equals(DOUBLE)) {
                    return super.isCompatible(type);
                }
                NumericDatatype<?> wrapper = type instanceof NumericDatatype ? (NumericDatatype<?>)type : this.wrap(type);
                if (!this.hasMax() && !this.hasMin()) {
                    return true;
                }
                if (!wrapper.hasMax() && !wrapper.hasMin()) {
                    return true;
                }
                if (!this.hasMax() && !wrapper.hasMax()) {
                    return true;
                }
                if (!this.hasMin() && !wrapper.hasMin()) {
                    return true;
                }
                if (!this.hasMin()) {
                    return this.overlapping(this, wrapper);
                }
                if (!this.hasMax()) {
                    return this.overlapping(wrapper, this);
                }
                if (!wrapper.hasMin()) {
                    return this.overlapping(wrapper, this);
                }
                if (!wrapper.hasMax()) {
                    return this.overlapping(this, wrapper);
                }
                return this.overlapping(this, wrapper) || this.overlapping(wrapper, this);
            }
            return false;
        }

        @Override
        public boolean emptyValueSpace() {
            if (!this.hasMin() || !this.hasMax()) {
                return false;
            }
            if (this.hasMaxExclusive() && this.hasMinExclusive()) {
                return this.getMax().compareTo((Comparable)DatatypeFactory.increase((Number)this.getMin())) < 0;
            }
            return this.getMax().compareTo(this.getMin()) < 0;
        }

        private <O extends Comparable<O>> NumericDatatype<O> wrap(Datatype<O> d) {
            return new NumericDatatypeWrapper<O>(d);
        }

        @Override
        public boolean hasMinExclusive() {
            return this.knownNumericFacetValues.containsKey(Facets.minExclusive);
        }

        @Override
        public boolean hasMinInclusive() {
            return this.knownNumericFacetValues.containsKey(Facets.minInclusive);
        }

        @Override
        public boolean hasMaxExclusive() {
            return this.knownNumericFacetValues.containsKey(Facets.maxExclusive);
        }

        @Override
        public boolean hasMaxInclusive() {
            return this.knownNumericFacetValues.containsKey(Facets.maxInclusive);
        }

        @Override
        public boolean hasMin() {
            return this.hasMinInclusive() || this.hasMinExclusive();
        }

        @Override
        public boolean hasMax() {
            return this.hasMaxInclusive() || this.hasMaxExclusive();
        }

        @Override
        public R getMin() {
            if (this.hasMinExclusive()) {
                return (R)((Comparable)this.knownNumericFacetValues.get(Facets.minExclusive));
            }
            if (this.hasMinInclusive()) {
                return (R)((Comparable)this.knownNumericFacetValues.get(Facets.minInclusive));
            }
            return null;
        }

        @Override
        public R getMax() {
            if (this.hasMaxExclusive()) {
                return (R)((Comparable)this.knownNumericFacetValues.get(Facets.maxExclusive));
            }
            if (this.hasMaxInclusive()) {
                return (R)((Comparable)this.knownNumericFacetValues.get(Facets.maxInclusive));
            }
            return null;
        }
    }
}

