/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataRangeVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLLogicalEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import uk.ac.manchester.cs.jfact.AxiomTranslator;
import uk.ac.manchester.cs.jfact.ClassExpressionTranslator;
import uk.ac.manchester.cs.jfact.DataPropertyTranslator;
import uk.ac.manchester.cs.jfact.DataRangeTranslator;
import uk.ac.manchester.cs.jfact.EntailmentChecker;
import uk.ac.manchester.cs.jfact.EntityVisitorEx;
import uk.ac.manchester.cs.jfact.IndividualTranslator;
import uk.ac.manchester.cs.jfact.ObjectPropertyTranslator;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.kernel.ExpressionManager;
import uk.ac.manchester.cs.jfact.kernel.ReasoningKernel;
import uk.ac.manchester.cs.jfact.kernel.dl.IndividualName;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.AxiomInterface;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.IndividualExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;

public class TranslationMachinery
implements Serializable {
    private static final long serialVersionUID = 11000L;
    private final AxiomTranslator axiomTranslator;
    private final ClassExpressionTranslator classExpressionTranslator;
    private final DataRangeTranslator dataRangeTranslator;
    private final ObjectPropertyTranslator objectPropertyTranslator;
    private final DataPropertyTranslator dataPropertyTranslator;
    private final IndividualTranslator individualTranslator;
    private final EntailmentChecker entailmentChecker;
    private final Map<OWLAxiom, AxiomInterface> axiom2PtrMap = new HashMap<OWLAxiom, AxiomInterface>();
    private final Map<AxiomInterface, OWLAxiom> ptr2AxiomMap = new HashMap<AxiomInterface, OWLAxiom>();
    protected final ReasoningKernel kernel;
    protected final ExpressionManager em;
    protected final OWLDataFactory df;
    protected final DatatypeFactory datatypefactory;

    public TranslationMachinery(ReasoningKernel kernel, OWLDataFactory df, DatatypeFactory factory) {
        this.kernel = kernel;
        this.datatypefactory = factory;
        this.em = kernel.getExpressionManager();
        this.df = df;
        this.axiomTranslator = new AxiomTranslator(kernel.getOntology(), df, this, this.em);
        this.classExpressionTranslator = new ClassExpressionTranslator(this.em, df, this);
        this.dataRangeTranslator = new DataRangeTranslator(this.em, df, this, this.datatypefactory);
        this.objectPropertyTranslator = new ObjectPropertyTranslator(this.em, df, this);
        this.dataPropertyTranslator = new DataPropertyTranslator(this.em, df, this);
        this.individualTranslator = new IndividualTranslator(this.em, df, this);
        this.entailmentChecker = new EntailmentChecker(kernel, df, this);
    }

    public List<Expression> translateExpressions(Set<OWLEntity> signature) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (OWLEntity entity : signature) {
            Expression ex;
            if (!(entity instanceof OWLLogicalEntity) || (ex = (Expression)entity.accept((OWLEntityVisitorEx)new EntityVisitorEx(this))) == null) continue;
            list.add(ex);
        }
        return list;
    }

    public void loadAxioms(Collection<OWLAxiom> axioms) {
        for (OWLAxiom axiom : axioms) {
            AxiomInterface axiomPointer;
            if (this.axiom2PtrMap.containsKey(axiom) || (axiomPointer = (AxiomInterface)axiom.accept((OWLAxiomVisitorEx)this.axiomTranslator)) == null) continue;
            this.axiom2PtrMap.put(axiom, axiomPointer);
        }
    }

    public void retractAxiom(OWLAxiom axiom) {
        AxiomInterface ptr = this.axiom2PtrMap.get(axiom);
        if (ptr != null) {
            this.kernel.getOntology().retract(ptr);
            this.axiom2PtrMap.remove(axiom);
        }
    }

    protected ConceptExpression pointer(OWLClassExpression classExpression) {
        return (ConceptExpression)classExpression.accept((OWLClassExpressionVisitorEx)this.classExpressionTranslator);
    }

    protected DataExpression pointer(OWLDataRange dataRange) {
        return (DataExpression)dataRange.accept((OWLDataRangeVisitorEx)this.dataRangeTranslator);
    }

    protected ObjectRoleExpression pointer(OWLObjectPropertyExpression propertyExpression) {
        OWLObjectPropertyExpression simp = propertyExpression.getSimplified();
        if (simp.isAnonymous()) {
            OWLObjectInverseOf inv = (OWLObjectInverseOf)simp;
            return this.em.inverse((ObjectRoleExpression)this.objectPropertyTranslator.getPointerFromEntity(inv.getInverse().asOWLObjectProperty()));
        }
        return (ObjectRoleExpression)this.objectPropertyTranslator.getPointerFromEntity(simp.asOWLObjectProperty());
    }

    protected DataRoleExpression pointer(OWLDataPropertyExpression propertyExpression) {
        return (DataRoleExpression)this.dataPropertyTranslator.getPointerFromEntity(propertyExpression.asOWLDataProperty());
    }

    protected synchronized IndividualName pointer(OWLIndividual individual) {
        if (!individual.isAnonymous()) {
            return (IndividualName)this.individualTranslator.getPointerFromEntity(individual.asOWLNamedIndividual());
        }
        return this.em.individual(IRI.create((String)individual.toStringID()));
    }

    protected synchronized Datatype<?> pointer(OWLDatatype datatype) {
        if (datatype == null) {
            throw new IllegalArgumentException("datatype cannot be null");
        }
        return this.datatypefactory.getKnownDatatype(datatype.getIRI());
    }

    protected synchronized Literal<?> pointer(OWLLiteral literal) {
        String value = literal.getLiteral();
        if (literal.isRDFPlainLiteral()) {
            value = value + "@" + literal.getLang();
        }
        IRI string = literal.getDatatype().getIRI();
        Datatype<?> knownDatatype = this.datatypefactory.getKnownDatatype(string);
        return knownDatatype.buildLiteral(value);
    }

    protected NodeSet<OWLNamedIndividual> translateNodeSet(Iterable<IndividualExpression> pointers) {
        OWLNamedIndividualNodeSet ns = new OWLNamedIndividualNodeSet();
        for (IndividualExpression pointer : pointers) {
            OWLNamedIndividual ind;
            if (!(pointer instanceof IndividualName) || (ind = (OWLNamedIndividual)this.individualTranslator.getEntityFromPointer((IndividualName)pointer)) == null) continue;
            ns.addEntity((OWLObject)ind);
        }
        return ns;
    }

    public List<IndividualExpression> translate(Set<OWLIndividual> inds) {
        ArrayList<IndividualExpression> l = new ArrayList<IndividualExpression>();
        for (OWLIndividual ind : inds) {
            l.add(this.pointer(ind));
        }
        return l;
    }

    public ClassExpressionTranslator getClassExpressionTranslator() {
        return this.classExpressionTranslator;
    }

    public DataRangeTranslator getDataRangeTranslator() {
        return this.dataRangeTranslator;
    }

    public ObjectPropertyTranslator getObjectPropertyTranslator() {
        return this.objectPropertyTranslator;
    }

    public DataPropertyTranslator getDataPropertyTranslator() {
        return this.dataPropertyTranslator;
    }

    public IndividualTranslator getIndividualTranslator() {
        return this.individualTranslator;
    }

    public EntailmentChecker getEntailmentChecker() {
        return this.entailmentChecker;
    }

    public Set<OWLAxiom> translateTAxiomSet(Collection<AxiomInterface> trace) {
        HashSet<OWLAxiom> ret = new HashSet<OWLAxiom>();
        for (AxiomInterface ap : trace) {
            ret.add(this.ptr2AxiomMap.get(ap));
        }
        return ret;
    }
}

