/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.magnoliastripes;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.core.NodeData;
import info.magnolia.context.MgnlContext;
import info.magnolia.context.WebContext;
import info.magnolia.module.templating.Paragraph;
import info.magnolia.module.templating.ParagraphRenderer;
import info.magnolia.module.templating.RenderException;
import info.magnolia.module.templating.RenderableDefinition;
import info.magnolia.module.templating.renderers.JspTemplateRenderer;
import it.openutils.magnoliastripes.MgnlStripesRequestWrapper;
import it.openutils.magnoliastripes.MgnlStripesResponseWrapper;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.DispatcherServlet;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.controller.StripesRequestWrapper;
import net.sourceforge.stripes.exception.StripesServletException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StripesRenderer
extends JspTemplateRenderer
implements ParagraphRenderer {
    private StripesDispatcherServlet stripesDispatcherServlet = new StripesDispatcherServlet();
    private Logger log = LoggerFactory.getLogger(StripesRenderer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Content content, Paragraph paragraph, Writer out) throws RenderException, IOException {
        try {
            this.render(content, (RenderableDefinition)paragraph, out);
        }
        finally {
            out.flush();
        }
    }

    protected void onRender(Content content, RenderableDefinition definition, Writer out, Map ctx, String templatePath) throws RenderException {
        HttpServletResponse response = ((WebContext)MgnlContext.getInstance()).getResponse();
        if (response.isCommitted()) {
            this.log.warn("Attempting to forward to {}, but response is already committed.", (Object)templatePath);
        }
        Map<String, String[]> templateDataMap = this.contentToMap(this.getTemplateContent());
        Map<String, String[]> nodeDataMap = this.contentToMap(MgnlContext.getAggregationState().getCurrentContent(), templateDataMap);
        try {
            this.renderCommon(definition.getTemplatePath(), nodeDataMap, out);
        }
        catch (IOException e) {
            throw new RenderException((Throwable)e);
        }
    }

    protected Content getTemplateContent() {
        Collection ancestors = null;
        try {
            ancestors = MgnlContext.getAggregationState().getCurrentContent().getAncestors();
            for (Content ancestor : ancestors) {
                if (!ancestor.getItemType().equals((Object)ItemType.CONTENT)) continue;
                return ancestor;
            }
        }
        catch (PathNotFoundException e1) {
            return null;
        }
        catch (RepositoryException e1) {
            return null;
        }
        return null;
    }

    protected Map newContext() {
        return MgnlContext.getWebContext((String)"StripesRenderer can only be used with a WebContext");
    }

    protected void renderCommon(String templatePath, Map<String, String[]> nodeDataMap, Writer out) throws IOException {
        StripesRequestWrapperExt request;
        WebContext webContext = (WebContext)MgnlContext.getInstance();
        MgnlStripesResponseWrapper response = new MgnlStripesResponseWrapper(webContext.getResponse(), out);
        try {
            HttpServletRequest unwrappedRequest = ((WebContext)MgnlContext.getInstance()).getRequest();
            MgnlStripesRequestWrapper originalreq = new MgnlStripesRequestWrapper(unwrappedRequest, templatePath, nodeDataMap, out);
            Configuration config = StripesFilter.getConfiguration();
            Locale locale = config.getLocalePicker().pickLocale(unwrappedRequest);
            request = new StripesRequestWrapperExt((HttpServletRequest)originalreq, locale);
        }
        catch (StripesServletException e) {
            throw new RuntimeException(e);
        }
        request.setAttribute("info.magnolia.cms.filters.WebContainerResources", Boolean.TRUE);
        request.setAttribute("javax.servlet.include.servlet_path", templatePath);
        try {
            this.stripesDispatcherServlet.service((HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
    }

    protected Map<String, String[]> contentToMap(Content content, Map<String, String[]> nodeDataMap) {
        Collection paragraphsData = content.getNodeDataCollection();
        for (NodeData nodeData : paragraphsData) {
            String name = StringUtils.replaceChars((String)nodeData.getName(), (String)"{}", (String)"[]");
            String value = nodeData.getString();
            if (StringUtils.contains((String)name, (String)"multiple")) {
                nodeDataMap.put(name, StringUtils.split((String)value, (String)"\n"));
                continue;
            }
            nodeDataMap.put(name, new String[]{value});
        }
        return nodeDataMap;
    }

    protected Map<String, String[]> contentToMap(Content content) {
        HashMap<String, String[]> nodeDataMap = new HashMap<String, String[]>();
        return this.contentToMap(content, nodeDataMap);
    }

    protected class StripesRequestWrapperExt
    extends StripesRequestWrapper {
        public StripesRequestWrapperExt(HttpServletRequest request, Locale locale) throws StripesServletException {
            super(request);
            this.setLocale(locale);
        }
    }

    protected class StripesDispatcherServlet
    extends DispatcherServlet {
        private static final long serialVersionUID = 42L;

        protected StripesDispatcherServlet() {
        }

        public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException {
            super.service(request, response);
        }

        public ServletContext getServletContext() {
            return ((WebContext)MgnlContext.getInstance()).getServletContext();
        }
    }
}

