/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.magnoliastripes;

import info.magnolia.cms.filters.DispatchRule;
import info.magnolia.cms.filters.DispatchRules;
import info.magnolia.cms.filters.Mapping;
import info.magnolia.cms.filters.MgnlFilter;
import info.magnolia.cms.filters.WebContainerResources;
import info.magnolia.cms.util.RequestHeaderUtil;
import info.magnolia.cms.util.ServletUtils;
import info.magnolia.context.MgnlContext;
import info.magnolia.context.RepositoryAcquiringStrategy;
import info.magnolia.context.WebContext;
import info.magnolia.context.WebContextImpl;
import info.magnolia.objectfactory.Components;
import info.magnolia.voting.Voter;
import info.magnolia.voting.Voting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.controller.StripesRequestWrapper;
import net.sourceforge.stripes.exception.StripesServletException;
import org.apache.commons.lang.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StripesMagnoliaFilter
extends StripesFilter
implements MgnlFilter {
    private String name;
    private Voter[] bypasses = new Voter[0];
    private boolean enabled = true;
    private DispatchRules dispatchRules = new DispatchRules();
    private Mapping mapping = new Mapping();
    private WebContainerResources webContainerResources = (WebContainerResources)Components.getSingleton(WebContainerResources.class);
    private boolean initdone;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        filterConfig.getServletContext().setAttribute(Configuration.class.getName(), (Object)this.getInstanceConfiguration());
        this.initdone = true;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.initdone) {
            super.doFilter(servletRequest, servletResponse, filterChain);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    protected StripesRequestWrapper wrapRequest(HttpServletRequest servletRequest) throws StripesServletException {
        try {
            return StripesRequestWrapper.findStripesWrapper((ServletRequest)servletRequest);
        }
        catch (IllegalStateException e) {
            StripesRequestWrapper srw = new StripesRequestWrapper(servletRequest);
            if (MgnlContext.hasInstance()) {
                WebContext webContext = (WebContext)MgnlContext.getInstance();
                RepositoryAcquiringStrategy strategy = ((WebContextImpl)webContext).getRepositoryStrategy();
                webContext.init(servletRequest, webContext.getResponse(), webContext.getServletContext());
                ((WebContextImpl)webContext).setRepositoryStrategy(strategy);
            }
            return srw;
        }
    }

    public boolean matches(HttpServletRequest request) {
        return this.isEnabled() && this.matchesDispatching(request) && this.mapsTo(request) && !this.bypasses(request);
    }

    protected boolean mapsTo(HttpServletRequest request) {
        if (this.getMapping().getMappings().isEmpty()) {
            return true;
        }
        return this.getMapping().match(request).isMatching();
    }

    protected boolean matchesDispatching(HttpServletRequest request) {
        if (this.webContainerResources == null) {
            return true;
        }
        boolean toWebContainerResource = this.webContainerResources.isWebContainerResource(request);
        boolean toMagnoliaResource = !toWebContainerResource;
        DispatchRule dispatchRule = this.getDispatchRules().getDispatchRule(ServletUtils.getDispatcherType((HttpServletRequest)request));
        if (toMagnoliaResource && dispatchRule.isToMagnoliaResources()) {
            return true;
        }
        return toWebContainerResource && dispatchRule.isToWebContainerResources();
    }

    protected boolean bypasses(HttpServletRequest request) {
        Voting voting = Voting.HIGHEST_LEVEL;
        return voting.vote(this.bypasses, (Object)request) > 0;
    }

    public void destroy() {
    }

    public Voter[] getBypasses() {
        return this.bypasses;
    }

    public void addBypass(Voter voter) {
        this.bypasses = (Voter[])ArrayUtils.add((Object[])this.bypasses, (Object)voter);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public DispatchRules getDispatchRules() {
        return this.dispatchRules;
    }

    public void setDispatchRules(DispatchRules dispatching) {
        this.dispatchRules = dispatching;
    }

    public Collection<String> getMappings() {
        ArrayList<String> result = new ArrayList<String>();
        for (Pattern pattern : this.getMapping().getMappings()) {
            result.add(pattern.pattern());
        }
        return result;
    }

    protected Mapping getMapping() {
        return this.mapping;
    }

    public void addMapping(String mapping) {
        this.getMapping().addMapping(mapping);
    }

    protected boolean acceptsGzipEncoding(HttpServletRequest request) {
        return RequestHeaderUtil.acceptsGzipEncoding((HttpServletRequest)request);
    }

    protected boolean acceptsEncoding(HttpServletRequest request, String name) {
        return RequestHeaderUtil.acceptsEncoding((HttpServletRequest)request, (String)name);
    }

    protected boolean headerContains(HttpServletRequest request, String header, String value) {
        return RequestHeaderUtil.headerContains((HttpServletRequest)request, (String)header, (String)value);
    }

    protected void addAndVerifyHeader(HttpServletResponse response, String name, String value) {
        RequestHeaderUtil.addAndVerifyHeader((HttpServletResponse)response, (String)name, (String)value);
    }
}

