/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.magnoliastripes;

import info.magnolia.context.MgnlContext;
import info.magnolia.context.WebContext;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.sourceforge.stripes.exception.StripesServletException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MgnlStripesRequestWrapper
extends HttpServletRequestWrapper {
    private static final String SERVLET_PATH = "mgnlStripesServletPath";
    private static final String ALREADY_INCLUDED = "mgnlAlreadyIncluded";
    private String servletPath;
    private Map<String, String[]> parameterMap;
    private Writer out;

    public MgnlStripesRequestWrapper(HttpServletRequest request, String servletPath, Map<String, String[]> paragraphsData, Writer out) throws StripesServletException {
        super(request);
        this.servletPath = servletPath;
        this.out = out;
        this.parameterMap = new HashMap<String, String[]>();
        this.parameterMap.putAll(request.getParameterMap());
        this.parameterMap.putAll(paragraphsData);
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public Enumeration<String> getParameterNames() {
        return ((Hashtable)this.parameterMap).keys();
    }

    public String[] getParameterValues(String name) {
        return this.parameterMap.get(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new MagnoliaRequestDispatcher(path, this.out, (HttpServletRequest)this.getRequest());
    }

    private static class MagnoliaRequestDispatcher
    implements RequestDispatcher {
        private String url;
        private Writer out;
        private HttpServletRequest originalRequest;

        public MagnoliaRequestDispatcher(String url, Writer out, HttpServletRequest originalRequest) {
            this.url = url;
            this.out = out;
            this.originalRequest = originalRequest;
        }

        public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            request.setAttribute(MgnlStripesRequestWrapper.SERVLET_PATH, (Object)this.url);
            if (request.getAttribute(MgnlStripesRequestWrapper.ALREADY_INCLUDED) == null) {
                request.setAttribute(MgnlStripesRequestWrapper.ALREADY_INCLUDED, (Object)true);
                ((WebContext)MgnlContext.getInstance()).include(this.url, this.out);
            } else {
                this.originalRequest.getRequestDispatcher(this.url).include(request, response);
            }
        }

        public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            request.setAttribute(MgnlStripesRequestWrapper.SERVLET_PATH, (Object)this.url);
            if (request.getAttribute(MgnlStripesRequestWrapper.ALREADY_INCLUDED) == null) {
                request.setAttribute(MgnlStripesRequestWrapper.ALREADY_INCLUDED, (Object)true);
                ((WebContext)MgnlContext.getInstance()).include(this.url, this.out);
            } else {
                this.originalRequest.getRequestDispatcher(this.url).include(request, response);
            }
        }
    }
}

